/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPConfDto;

/**
 * CM_CONF(ݒ}X^)DAONX B
 */
public class MosPConfDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_CONF(ݒ}X^)B
	 */
	public static final String	TABLE			= "CM_CONF";
	
	/**
	 * KEY_1 = CONF_ID(ݒ敪)B
	 */
	public static final String	KEY_1			= "CONF_ID";
	/**
	 * KEY_2 = CONF_CODE(ݒR[h)B
	 */
	public static final String	KEY_2			= "CONF_CODE";
	
	// 
	/**
	 * CONF_ID(ݒ敪)B
	 */
	public static final String	COL_CONF_ID		= "CONF_ID";
	/**
	 * CONF_CODE(ݒR[h)B
	 */
	public static final String	COL_CONF_CODE	= "CONF_CODE";
	/**
	 * CONF_VALUE(ݒl)B
	 */
	public static final String	COL_CONF_VALUE	= "CONF_VALUE";
	

	/**
	 * RXgN^
	 */
	public MosPConfDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MosPConfDto> mappingAll() throws SQLException {
		List<MosPConfDto> all = new ArrayList<MosPConfDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return MosPConfDto CM_CONFR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MosPConfDto mapping() throws SQLException {
		MosPConfDto dto = new MosPConfDto();
		dto.setConfId(rs.getString(COL_CONF_ID)); //ݒ敪
		dto.setConfCode(rs.getString(COL_CONF_CODE)); //ݒR[h
		dto.setConfValue(rs.getString(COL_CONF_VALUE)); //ݒl
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MosPConfDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param confId ݒ敪(L[)
	 * @param confCode ݒR[h(L[)
	 * @return MosPConfDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MosPConfDto findForKey(String confId, String confCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, confId);
			setParam(index++, confCode);
			executeQuery();
			MosPConfDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param confId ݒ敪(L[)
	 * @param confCode ݒR[h(L[)
	 * @return MosPConfDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MosPConfDto findForUpdate(String confId, String confCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, confId);
			setParam(index++, confCode);
			executeQuery();
			MosPConfDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param confId ݒ敪
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MosPConfDto> findForCondition(String confId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(MosPDao.like(COL_CONF_ID));
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, confId);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param confId ݒ敪
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MosPConfDto findForDto(String confId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(MosPDao.like(COL_CONF_ID));
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, confId);
			executeQuery();
			MosPConfDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int insert(MosPConfDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int update(MosPConfDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getConfId());
			setParam(index++, dto.getConfCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int delete(MosPConfDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getConfId());
			setParam(index++, dto.getConfCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MosPConfDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getConfId()); //ݒ敪
		setParam(index++, dto.getConfCode()); //ݒR[h
		setParam(index++, dto.getConfValue()); //ݒl
		setCommonParams(isInsert);
	}
	
}
