/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * ʓǍǉ
 * @param 
 * @return 
 * @throws sO
 */
function onLoadExtra() {
	// ڔwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID		, COLOR_FIELD_NORMAL);
	setFieldsBgColor(ARY_ERR_FIELDS_ID	, COLOR_FIELD_ERROR);
	// ڒݒ
	setMaxLength(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR		, LEN_HOUR);
	setMaxLength(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN		, LEN_MIN);
	setMaxLength(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, LEN_HOUR);
	setMaxLength(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN	, LEN_MIN);
	// tH[JXݒ
	setFocus(PRM_PLT_ATTITUDE_STATUS);
	// o^/XV
	if (MODE == 1) {
		setObjectVisibility("btnDraft", false);
		setObjectVisibility("btnRegist", false);
		setWidth("btnDraft", 0);
		setWidth("btnRegist", 0);
	}
	changeAttitudeView();
}

/**
 * T[o[ʐM
 * @param 
 * @return 
 * @throws sO
 */
function submitForm(objForm, cmd) {
	// ̓`FbN
	if (validate()) {
		// T[o[ʐM(̓G[̏ꍇ)
		doSubmitMessage(objForm, cmd, 'QC0001', "");
	}
}

/**
 * ̓`FbN
 * @param 
 * @return `FbN(trueFOKAfalseFNG)
 * @throws sO
 */
function validate() {
	// tB[hwiFݒ
	setFieldsBgColor(ARY_FIELDS_ID, COLOR_FIELD_NORMAL);

	// ̓`FbN
	var aryMessage = new Array();

	if (getFormValue(PRM_PLT_ATTITUDE_STATUS) == 0) {
		// SĊ
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR		, 0);
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN		, 0);
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, 0);
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN	, 0);
	} else if (getFormValue(PRM_PLT_ATTITUDE_STATUS) == 1) {
		// g
		if (checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR)
				&& checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN)
		) {
			checkSubstituteTime(
					PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR,
					PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN,
					PRM_HID_CONVERTED_MONTHLY_OVER_TIME_HOUR,
					PRM_HID_CONVERTED_MONTHLY_OVER_TIME_MIN,
					NAM_PAYMENT_ACQUIRE_TIME,
					NAM_CONVERTED_MONTHLY_OVER_TIME,
					aryMessage
			);
		}
		if (checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR)
				&& checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN)
		) {
			checkSubstituteTime(
					PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR,
					PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN,
					PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_HOUR,
					PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_MIN,
					NAM_PAYMENT_ACQUIRE_HOLIDAY,
					NAM_CONVERTED_MONTHLY_OVER_TIME,
					aryMessage
			);
		}
	} else if (getFormValue(PRM_PLT_ATTITUDE_STATUS) == 2) {
		// Sđ֋x
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR		, getFormValue(PRM_HID_CONVERTED_MONTHLY_OVER_TIME_HOUR));
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN		, getFormValue(PRM_HID_CONVERTED_MONTHLY_OVER_TIME_MIN));
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, getFormValue(PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_HOUR));
		setFormValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN	, getFormValue(PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_MIN));
	}

	if (checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR)
			&& checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN)
			&& checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR)
			&& checkNumberNoMsg(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN)
	) {
		setFormValue(PRM_HID_PAYMENT_QUIT_TIME,
				getFormValue(PRM_HID_CONVERTED_MONTHLY_OVER_TIME_HOUR) * 60
				+ parseIntDecimal(getFormValue(PRM_HID_CONVERTED_MONTHLY_OVER_TIME_MIN))
				+ getFormValue(PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_HOUR) * 60
				+ parseIntDecimal(getFormValue(PRM_HID_CONVERTED_MONTHLY_WEEK_HOLIDAY_MIN))
				- getFormValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR) * 60
				- getFormValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN)
				- getFormValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR) * 60
				- getFormValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN)
		);
	}

	checkRequired(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR		, NAM_PAYMENT_ACQUIRE_TIME_HOUR		, aryMessage);
	checkRequired(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN		, NAM_PAYMENT_ACQUIRE_TIME_MIN		, aryMessage);
	checkRequired(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, aryMessage);
	checkRequired(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN	, NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN	, aryMessage);

	checkNumber(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR		, NAM_PAYMENT_ACQUIRE_TIME_HOUR		, aryMessage);
	checkNumber(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN		, NAM_PAYMENT_ACQUIRE_TIME_MIN		, aryMessage);
	checkNumber(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, NAM_PAYMENT_ACQUIRE_HOLIDAY_HOUR	, aryMessage);
	checkNumber(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN		, NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN	, aryMessage);

	checkNumberValue(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN	, 0, 59, NAM_PAYMENT_ACQUIRE_TIME_MIN	, aryMessage);
	checkNumberValue(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN, 0, 59, NAM_PAYMENT_ACQUIRE_HOLIDAY_MIN, aryMessage);

	if (aryMessage.length == 0) {
		return true;
	} else {
		showMessage(aryMessage);
		return false;
	}
}

function changeAttitudeView() {
	setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR	, true);
	setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN	, true);
	setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR, true);
	setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN	, true);
	if (getFormValue(PRM_PLT_ATTITUDE_STATUS) == 1) {
		setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_TIME_HOUR	, false);
		setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_TIME_MIN	, false);
		setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_HOUR, false);
		setReadOnly(PRM_TXT_PAYMENT_ACQUIRE_HOLIDAY_MIN	, false);
	}
}

/**
 * lmF
 * @param target		mFΏ
 * @param minValue		ől
 * @param maxValue		ŏl
 * @param rep			ϊ
 * @param aryMessage	G[bZ[Wi[z
 * @return
 */
function checkNumberValue(target, minValue, maxValue, rep, aryMessage) {
	if (checkNumberNoMsg(target)) {
		if (getFormValue(target) < minValue
				|| maxValue < getFormValue(target)
		) {
			if (aryMessage.length == 0) {
				setFocus(target);
				setMessage("WC2027", rep + "," + minValue + "," + maxValue);
			}
			setBgColor(target, COLOR_FIELD_ERROR);
			aryMessage.push(getMessage("WC2027", rep + "," + minValue + "," + maxValue));
		}
	}
}

function checkSubstituteTime(acquireHour, acquireMin, overHour, overMin, rep1, rep2, aryMessage) {
	if (getFormValue(acquireHour) * 60 + parseIntDecimal(getFormValue(acquireMin)) > getFormValue(overHour) * 60 + parseIntDecimal(getFormValue(overMin))) {
		if (aryMessage.length == 0) {
			setFocus(acquireHour);
			setMessage("WC2028", rep1 + "," + rep2);
		}
		setBgColor(acquireHour	, COLOR_FIELD_ERROR);
		setBgColor(acquireMin	, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage("WC2028", rep1 + "," + rep2));
	}
}

/**
 * 10i̐Ԃ
 * @param target Ώە
 */
function parseIntDecimal(target) {
	return parseInt(target, 10);
}
