<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.workflow.vo.OverTimeRequestListVo"
%><%
OverTimeRequestListVo vo = (OverTimeRequestListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryOverTime  		= vo.getEscAryOverTime();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="overTimeRequestList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table>
			<tr>
				<td id="kCodeTd">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKCode() %>
				</td>
				<td >
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKName() %>
				</td>
				<td >
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblSectionName() %>
				</td>
				<td id="workMonthTd">
					<span><%=vo.NAM_WORK_MONTH%><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<select id="<%= OverTimeRequestListVo.PRM_PLT_YEAR %>" name="<%= OverTimeRequestListVo.PRM_PLT_YEAR %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear())%>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= OverTimeRequestListVo.PRM_PLT_MONTH %>" name="<%= OverTimeRequestListVo.PRM_PLT_MONTH %>">
						<option></option>
						<%=HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth())%>
					</select><%= CommonConst.NAM_MONTH %>
				</td>
<!--	cƏ	-->
				<td id="overTimeTd">
					<%= CommonConst.NAM_OVER_TIME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= BaseVo.escapeHTML(vo.getLblOverTime()) %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K1411')"><%= CommonConst.NAM_RE_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thWorkDate" onclick="doSubmitKey(document.form, 'K1413', '<%= vo.KEY_WORK_DATE %>')">&nbsp;<%= vo.NAM_WORK_DATE %>&nbsp;<%= vo.getSortMark(vo.KEY_WORK_DATE ) %></th>
					<th id="thReason" 																			>&nbsp;<%= vo.NAM_REASON %>&nbsp;</th>
					<th id="thRequestTime" 																		>&nbsp;<%= vo.NAM_REQUEST_TIME %>&nbsp;</th>
					<th id="thRequestDate" onclick="doSubmitKey(document.form, 'K1413', '<%= vo.KEY_REQUEST_DATE %>')">&nbsp;<%= vo.NAM_REQUEST_DATE %>&nbsp;<%= vo.getSortMark(vo.KEY_REQUEST_DATE ) %></th>
					<th id="thStatus" onclick="doSubmitKey(document.form, 'K1413', '<%= vo.KEY_STATUS %>')">&nbsp;<%= vo.NAM_STATUS %>&nbsp;<%= vo.getSortMark(vo.KEY_STATUS ) %></th>
					<th id="thApprover" onclick="doSubmitKey(document.form, 'K1413', '<%= vo.KEY_APPROVER %>')">&nbsp;<%= vo.NAM_APPROVER %>&nbsp;<%= vo.getSortMark(vo.KEY_APPROVER ) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'K1416', '<%= aryOverTime[i][0] %>','')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td class="WorkDateTd" >	<%= aryOverTime [i][1] %></td>
					<td class="ReasonTd">		<%= aryOverTime [i][2] %></td>
					<td class="RequestTimeTd" >	<%= aryOverTime [i][3] %></td>
					<td class="RequestDateTd" >	<%= aryOverTime [i][4] %></td>
					<td class="StatusTd" >		<%= aryOverTime [i][5] %></td>
					<td class="ApproverTd" >	<%= aryOverTime [i][6] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'K1415')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
