<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.BaseVo"
import = "jp.mosp.workflow.vo.HolidayRequestListVo"
%><%
HolidayRequestListVo vo = (HolidayRequestListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryHoliday = vo.getEscAryHoliday();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="overTimeRequestList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Select">
		<table>
			<tr>
				<td id="tdKCode">
					<%= CommonConst.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKCode() %>
				</td>
				<td id="tdKName">
					<%= CommonConst.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblKName() %>
				</td>
				<td id="tdStation">
					<%= CommonConst.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %><%= vo.getEscLblSectionName() %>
				</td>
				<td id="tdPlt">
					<span><%=vo.NAM_MONTH%><%=CommonConst.STR_TITLE_SEPARATOR%></span>
					<select id="<%= HolidayRequestListVo.PRM_PLT_YEAR %>" name="<%= HolidayRequestListVo.PRM_PLT_YEAR %>">
						<%=HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear())%>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= HolidayRequestListVo.PRM_PLT_MONTH %>" name="<%= HolidayRequestListVo.PRM_PLT_MONTH %>">
						<option></option>
						<%=HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth())%>
					</select><%= CommonConst.NAM_MONTH %>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmit(document.form, 'K1421')"><%= CommonConst.NAM_RE_SEARCH %></button>
				</td>
			</tr>
		</table>
		<table>
			<tr>
				<td id="tdPaidHoliday">
					<%= CommonConst.NAM_PAID_HOLIDAY_REST %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td id="tdRemain">
					<%= BaseVo.escapeHTML(vo.getLblTotalRemainDays()) %><%= CommonConst.NAM_DAY %>
					<span id="spnHour">
						<%= BaseVo.escapeHTML(vo.getLblTotalRemainHour()) %><%= CommonConst.NAM_COMMON_TIME %>
					</span>
				</td>
				<td id="tdSubstitute">
					<div id="divSubstitute">
						<div>
							<%= CommonConst.NAM_SUB_HOLIDAY %><%= CommonConst.STR_TITLE_SEPARATOR %>
							<%= BaseVo.escapeHTML(vo.getLblSubstituteRemain()) %><%= CommonConst.NAM_DAY %>
						</div>
					</div>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thHolidayDate" onclick="doSubmitKey(document.form, 'K1423', '<%= vo.KEY_HOLIDAY_DATE %>')">&nbsp;<%= vo.NAM_HOLIDAY_DATE %>&nbsp;<%= vo.getSortMark(vo.KEY_HOLIDAY_DATE ) %></th>
					<th id="thReason"      onclick="doSubmitKey(document.form, 'K1423', '<%= vo.KEY_REASON %>')">&nbsp;<%= vo.NAM_REASON %>&nbsp;<%= vo.getSortMark(vo.KEY_REASON ) %></th>
					<th id="thStatus"      onclick="doSubmitKey(document.form, 'K1423', '<%= vo.KEY_STATUS %>')">&nbsp;<%= vo.NAM_STATUS %>&nbsp;<%= vo.getSortMark(vo.KEY_STATUS ) %></th>
					<th id="thApprover"    onclick="doSubmitKey(document.form, 'K1423', '<%= vo.KEY_APPROVER %>')">&nbsp;<%= vo.NAM_APPROVER %>&nbsp;<%= vo.getSortMark(vo.KEY_APPROVER ) %></th>
					<th id="thComment" 																			>&nbsp;<%= vo.NAM_COMMENT %>&nbsp;</th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'K1426', '<%= aryHoliday[i][0] %>','')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td class="HolidayDateTd" >	<%= aryHoliday [i][1] %></td>
					<td class="ReasonTd">		<%= aryHoliday [i][2] %></td>
					<td class="StatusTd" >		<%= aryHoliday [i][3] %></td>
					<td class="ApproverTd" >	<%= aryHoliday [i][4] %></td>
					<td class="CommentTd" >		<%= aryHoliday [i][5] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'K1425')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
