<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.payroll.vo.EmployeeSubHolidayListVo"
%><%
EmployeeSubHolidayListVo vo = (EmployeeSubHolidayListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryEmployee        = vo.getEscAryEmployee();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>

<%@page import="jp.mosp.common.common.BaseVo"%>
<div class="Body" id="employeeList">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Search">
		<table>
			<tr>
				<td id="tdKCode">
					<span class="TitleLabel"><%= vo.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="UserIdText" id="<%= EmployeeSubHolidayListVo.PRM_TXT_K_CODE %>" name="<%= EmployeeSubHolidayListVo.PRM_TXT_K_CODE %>" value="<%= BaseVo.escapeHTML(vo.getTxtKCode()) %>" />
				</td>
				<td id="tdKName">
					<span class="TitleLabel"><%= vo.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= EmployeeSubHolidayListVo.PRM_TXT_K_NAME %>" name="<%= EmployeeSubHolidayListVo.PRM_TXT_K_NAME %>" value="<%= BaseVo.escapeHTML(vo.getTxtKName()) %>" />
				</td>
				<td id="tdKYearMonth">
					<span class="TitleLabel"><%= vo.NAM_K_OCCUR_YEARMONTH %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="YearSelect" id="<%= EmployeeSubHolidayListVo.PRM_PLT_YEAR %>" name="<%= EmployeeSubHolidayListVo.PRM_PLT_YEAR %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear()) %>
					</select>
					<%= CommonConst.NAM_YEAR %>
					<select class="MonthSelect" id="<%= EmployeeSubHolidayListVo.PRM_PLT_MONTH %>" name="<%= EmployeeSubHolidayListVo.PRM_PLT_MONTH %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth()) %>
					</select>
					<%= CommonConst.NAM_MONTH %>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'P1311')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
			<tr>
				<td id="tdAttitude">
					<span class="TitleLabel"><%= vo.NAM_K_ATTITUDE_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="AttitudeSelect" id="<%= EmployeeSubHolidayListVo.PRM_PLT_ATTITUDE_STATUS %>" name="<%= EmployeeSubHolidayListVo.PRM_PLT_ATTITUDE_STATUS %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAttitudeStatus, vo.getAryPltAttitudeStatus()) %>
					</select>
				</td>
				<td id="tdAcquisition">
					<span class="TitleLabel"><%= vo.NAM_K_ACQUISITION_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="AcquisitionSelect" id="<%= EmployeeSubHolidayListVo.PRM_PLT_ACQUISITION_STATUS %>" name="<%= EmployeeSubHolidayListVo.PRM_PLT_ACQUISITION_STATUS %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltAcquisitionStatus, vo.getAryPltAcquisitionStatus()) %>
					</select>
				</td>
				<td id="tdDesicion">
					<span class="TitleLabel"><%= vo.NAM_K_DECISION_STATUS %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="DecisionSelect" id="<%= EmployeeSubHolidayListVo.PRM_PLT_DECISION_STATUS %>" name="<%= EmployeeSubHolidayListVo.PRM_PLT_DECISION_STATUS %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltDecisionStatus, vo.getAryPltDecisionStatus()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thKCode"          onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_K_CODE  %>', '')">&nbsp;<%= vo.NAM_K_CODE %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE) %></th>
					<th id="thKName"          onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_K_NAME  %>', '')">&nbsp;<%= vo.NAM_K_NAME %>&nbsp;<%= vo.getSortMark(vo.KEY_K_NAME) %></th>
					<th id="thYear"           onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_YEAR  %>', '')">&nbsp;<%= vo.NAM_YEAR %>&nbsp;<%= vo.getSortMark(vo.KEY_YEAR) %></th>
					<th id="thMonth"          onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_MONTH  %>', '')">&nbsp;<%= vo.NAM_MONTH %>&nbsp;<%= vo.getSortMark(vo.KEY_MONTH) %></th>
					<th id="thAttitude"       onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_ATTITUDE  %>', '')">&nbsp;<%= vo.NAM_ATTITUDE_STATUS %>&nbsp;<%= vo.getSortMark(vo.KEY_ATTITUDE) %></th>
					<th id="thAcquisition"    onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_ACQUISITION  %>', '')">&nbsp;<%= vo.NAM_ACQUISITION_STATUS %>&nbsp;<%= vo.getSortMark(vo.KEY_ACQUISITION) %></th>
					<th id="thDecision"       onclick="doSubmitKey(document.form, 'P1313', '<%= vo.KEY_DECISION  %>', '')">&nbsp;<%= vo.NAM_DECISION_STATUS %>&nbsp;<%= vo.getSortMark(vo.KEY_DECISION) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'P1316', '<%= aryEmployee[i][0] %>', '')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= aryEmployee[i][1] %></td>
					<td><%= aryEmployee[i][2] %></td>
					<td><%= aryEmployee[i][3] %></td>
					<td><%= aryEmployee[i][4] %></td>
					<td><%= aryEmployee[i][5] %></td>
					<td><%= aryEmployee[i][6] %></td>
					<td><%= aryEmployee[i][7] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
