/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.dto.CmUserDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmCodeDao
extends BaseDao {
    public static final String TABLE = "CM_CODE";
    public static final String KEY_01 = "T_ID";
    public static final String KEY_02 = "T_CODE";
    public static final String COL_T_ID = "T_ID";
    public static final String COL_T_CODE = "T_CODE";
    public static final String COL_T_NAME = "T_NAME";
    public static final String COL_VIEW_INDEX = "VIEW_INDEX";
    public static final String COL_DELETE_FLAG = "DELETE_FLAG";

    public CmCodeDao() {
        this.INSERT_DATE = "INSERT_DATE";
        this.INSERT_USER = "INSERT_USER";
        this.UPDATE_DATE = "UPDATE_DATE";
        this.UPDATE_USER = "UPDATE_USER";
    }

    public CmCodeDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
        this();
        this.initDao(cfg, cmd, aspUser, user, conn);
    }

    private List<CmCodeDto> mappingAll() throws SQLException {
        ArrayList<CmCodeDto> all = new ArrayList<CmCodeDto>();
        while (this.rs.next()) {
            all.add(this.mapping());
        }
        return all;
    }

    private List<CmCodeDto> mappingAllTId() throws SQLException {
        ArrayList<CmCodeDto> all = new ArrayList<CmCodeDto>();
        while (this.rs.next()) {
            CmCodeDto dto = new CmCodeDto();
            dto.setTId(this.rs.getString("T_ID"));
            all.add(dto);
        }
        return all;
    }

    private CmCodeDto mapping() throws SQLException {
        CmCodeDto dto = new CmCodeDto();
        dto.setTId(this.rs.getString("T_ID"));
        dto.setTCode(this.rs.getString("T_CODE"));
        dto.setTName(this.rs.getString(COL_T_NAME));
        dto.setViewIndex(this.rs.getInt(COL_VIEW_INDEX));
        dto.setDeleteFlag(this.rs.getInt(COL_DELETE_FLAG));
        this.mappingCommonInfo(dto);
        return dto;
    }

    public List<CmCodeDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            List<CmCodeDto> all;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getOrderForKey(this.getClass()));
            this.executeQuery();
            List<CmCodeDto> list = all = this.mappingAll();
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<CmCodeDto> findAllTId() throws SQLException {
        try {
            List<CmCodeDto> all;
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT DISTINCT ");
            sb.append("T_ID ");
            sb.append("FROM ");
            sb.append("CM_CODE ");
            this.prepareStatement(sb.toString());
            this.executeQuery();
            List<CmCodeDto> list = all = this.mappingAllTId();
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CmCodeDto findForKey(String tId, String tCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getConditionForKey(this.getClass()));
            this.setParam(this.index++, tId);
            this.setParam(this.index++, tCode);
            this.executeQuery();
            CmCodeDto CmCodeDto2 = null;
            if (this.rs.next()) {
                CmCodeDto2 = this.mapping();
            }
            CmCodeDto cmCodeDto = CmCodeDto2;
            return cmCodeDto;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public CmCodeDto findForUpdate(String tId, String tCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
        try {
            this.index = 1;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + this.getConditionForKey(this.getClass()) + this.getForUpdate());
            this.setParam(this.index++, tId);
            this.setParam(this.index++, tCode);
            this.executeQuery();
            CmCodeDto CmCodeDto2 = null;
            if (this.rs.next()) {
                CmCodeDto2 = this.mapping();
            }
            CmCodeDto cmCodeDto = CmCodeDto2;
            return cmCodeDto;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<CmCodeDto> findForCondition(String tId) throws SQLException, IllegalAccessException, NoSuchFieldException {
        this.index = 1;
        StringBuffer sb = new StringBuffer();
        sb.append("WHERE ");
        sb.append("T_ID");
        sb.append(" = ? AND ");
        sb.append(COL_DELETE_FLAG);
        sb.append(" = ? ");
        try {
            List<CmCodeDto> list;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + sb.toString() + "ORDER BY " + COL_VIEW_INDEX + ", " + "T_ID");
            this.setParam(this.index++, tId);
            this.setParam(this.index++, 0);
            this.executeQuery();
            List<CmCodeDto> list2 = list = this.mappingAll();
            return list2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<CmCodeDto> findForSearch(String tId, String tCode, String tName, String deleteFlag) throws SQLException, IllegalAccessException, NoSuchFieldException {
        this.index = 1;
        StringBuffer sb = new StringBuffer();
        sb.append("WHERE ");
        if (!tId.equals("")) {
            sb.append("T_ID");
            sb.append(" = ? AND ");
        }
        if (!tCode.equals("")) {
            sb.append("T_CODE");
            sb.append(" LIKE ? ");
            sb.append("AND ");
        }
        sb.append(COL_T_NAME);
        sb.append(" LIKE ? ");
        if (!deleteFlag.equals("")) {
            sb.append("AND ");
            sb.append(COL_DELETE_FLAG);
            sb.append(" = ? ");
        }
        try {
            List<CmCodeDto> list;
            this.prepareStatement(this.getSelectQuery(this.getClass()) + sb.toString() + this.getOrderForKey(this.getClass()));
            if (!tId.equals("")) {
                this.setParam(this.index++, tId);
            }
            if (!tCode.equals("")) {
                this.setParam(this.index++, tCode + "%");
            }
            this.setParam(this.index++, "%" + tName + "%");
            if (!deleteFlag.equals("")) {
                this.setParam(this.index++, Integer.parseInt(deleteFlag));
            }
            this.executeQuery();
            List<CmCodeDto> list2 = list = this.mappingAll();
            return list2;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int insert(CmCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getInsertQuery(this.getClass()));
            this.setParams(dto, true);
            this.executeUpdate();
            this.chkInsert(1);
            int n = this.cnt;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(CmCodeDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(dto, false);
            this.setParam(this.index++, dto.getTId());
            this.setParam(this.index++, dto.getTCode());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    private void setParams(CmCodeDto dto, boolean isInsert) throws SQLException {
        this.setParam(this.index++, dto.getTId());
        this.setParam(this.index++, dto.getTCode());
        this.setParam(this.index++, dto.getTName());
        this.setParam(this.index++, dto.getViewIndex());
        this.setParam(this.index++, dto.getDeleteFlag());
        this.setCommonParams(isInsert);
    }
}

