/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListVo
extends BaseVo {
    private static final long serialVersionUID = -3140198417848428433L;
    protected int count = 0;
    private int start = 0;
    private int end = -1;
    private boolean needFormer;
    private boolean needNext;
    protected List<?> list = new ArrayList();
    protected String formerKey = "";
    protected boolean isAscending = true;
    protected int listLength = 0;
    protected String pageCommand = "";
    protected String selectKey = "";
    protected int selectIndex = 1;
    protected int countAllData = 0;
    protected int dataPerPage = 0;

    @Override
    public void initVo(Properties cfg, Properties msg, String cmd, CmAspUserDto aspUserDto, CmUserDto userDto) {
        super.initVo(cfg, msg, cmd, aspUserDto, userDto);
        if (this.dataPerPage > 0) {
            return;
        }
        String countList = cfg.getProperty("app.list");
        if (countList != null && !countList.equals("")) {
            this.dataPerPage = Integer.parseInt(countList);
        }
    }

    public void initListInfo() throws MospException {
        try {
            this.start = 0;
            this.end = -1;
            this.setPageButton();
        }
        catch (NumberFormatException e) {
            throw new MospException(5004);
        }
    }

    public void pageNext() {
        this.start = this.end + 1;
        this.end = this.start + this.getListLength() - 1;
        this.setPageButton();
    }

    public void pageFormer() {
        this.start -= this.getListLength();
        this.end = this.start + this.getListLength() - 1;
        this.setPageButton();
    }

    public void setPageButton() {
        int appList = this.getListLength();
        if (this.start >= this.count) {
            this.start = this.count - appList;
        }
        if (this.start > 0) {
            this.needFormer = true;
        } else {
            this.start = 0;
            this.needFormer = false;
        }
        if (this.end - this.start < this.getListLength()) {
            this.end = this.start + appList - 1;
        }
        if (this.end < this.count - 1) {
            this.needNext = true;
        } else {
            this.end = this.count - 1;
            this.needNext = false;
        }
    }

    public void sortList(String key, Comparator<Object> comp) throws MospException {
        if (key.equals(this.formerKey) && this.isAscending) {
            Collections.sort(this.list, Collections.reverseOrder(comp));
            this.isAscending = false;
        } else {
            Collections.sort(this.list, comp);
            this.isAscending = true;
        }
        this.initListInfo();
        this.formerKey = key;
    }

    public void sortList(Comparator<Object> comp) {
        if (this.isAscending) {
            Collections.sort(this.list, comp);
        } else {
            Collections.sort(this.list, Collections.reverseOrder(comp));
        }
    }

    public String getSortMark(String key) {
        String sortMark = "";
        if (key.equals(this.formerKey)) {
            sortMark = this.isAscending ? "\u25b2" : "\u25bc";
        }
        return sortMark;
    }

    private int getListLength() {
        if (this.listLength == 0) {
            return Integer.parseInt(this.cfg.getProperty("app.list"));
        }
        return this.listLength;
    }

    public int getOffset() {
        return (this.selectIndex - 1) * this.dataPerPage;
    }

    public void setSortKey(String sortKey) {
        this.isAscending = sortKey.equals(this.selectKey) ? !this.isAscending : true;
        this.selectKey = sortKey;
        this.formerKey = sortKey;
    }

    public List<?> getList() {
        return this.list;
    }

    public int getCount() {
        return this.count;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean getNeedFormer() {
        return this.needFormer;
    }

    public boolean getNeedNext() {
        return this.needNext;
    }

    public boolean getIsAscending() {
        return this.isAscending;
    }

    public String getFormerKey() {
        return this.formerKey;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setFormerKey(String formerKey) {
        this.formerKey = formerKey;
    }

    public void setIsAscending(boolean isAscending) {
        this.isAscending = isAscending;
    }

    public String getPageCommand() {
        return this.pageCommand;
    }

    public String getSelectKey() {
        return this.selectKey;
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public int getCountAllData() {
        return this.countAllData;
    }

    public int getDataPerPage() {
        return this.dataPerPage;
    }

    public void setPageCommand(String pageCommand) {
        this.pageCommand = pageCommand;
    }

    public void setSelectKey(String selectKey) {
        this.selectKey = selectKey;
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
    }

    public void setCountAllData(int countAllData) {
        this.countAllData = countAllData;
    }

    public void setDataPerPage(int dataPerPage) {
        this.dataPerPage = dataPerPage;
    }
}

