/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.common.common;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadUtility {
    public static List<?> getMultipartFieldList(HttpServletRequest request) throws Exception {
        List multipartFieldList = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)factory);
            multipartFieldList = sfu.parseRequest(request);
        }
        return multipartFieldList;
    }

    public static String getMultipartField(List<?> list, String param) throws Exception {
        if (list == null) {
            return null;
        }
        for (FileItem item : list) {
            if (!item.isFormField() || !item.getFieldName().equals(param)) continue;
            return new String(item.getString().getBytes("iso-8859-1"), "Windows-31J");
        }
        return null;
    }

    public static FileItem getMultipartFile(List<?> list, String param) throws Exception {
        if (list == null) {
            return null;
        }
        for (FileItem item : list) {
            if (item.isFormField() || !item.getFieldName().equals(param)) continue;
            return item;
        }
        return null;
    }

    public static CSVParser parseCSVData(FileItem filCsv) throws Exception {
        CSVParser csvParseData = new CSVParser((Reader)new InputStreamReader(filCsv.getInputStream(), "Windows-31J"));
        return csvParseData;
    }
}

