/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.statements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Processor;
import org.jopendocument.dom.template.statements.BaseStatement;
import org.jopendocument.util.ExceptionUtils;

public class ForEach
extends BaseStatement {
    private static Logger logger = Logger.getLogger(ForEach.class.getName());

    public ForEach() {
        super("forEach");
    }

    public void prepare(Element element, Element element2) throws TemplateException {
        int n;
        int n2;
        int n3;
        String string = element2.getAttributeValue("element");
        if (string == null) {
            throw new TemplateException("missing required attribute for forEach tag: element");
        }
        String string2 = element2.getAttributeValue("items");
        if (string2 == null) {
            throw new TemplateException("missing required attribute for forEach tag: items");
        }
        String string3 = element2.getAttributeValue("var");
        if (string3 == null) {
            throw new TemplateException("missing required attribute for forEach tag: var");
        }
        String string4 = element2.getAttributeValue("alternate");
        if (string4 == null) {
            n3 = 1;
        } else {
            try {
                n3 = Integer.parseInt(string4);
            }
            catch (Throwable throwable) {
                throw new TemplateException("invalid alternate attribute for forEach tag: " + string4);
            }
        }
        String string5 = element2.getAttributeValue("multiple");
        if (string5 == null) {
            n2 = 0;
        } else {
            try {
                n2 = Integer.parseInt(string5);
            }
            catch (Throwable throwable) {
                throw new TemplateException("invalid alternate attribute for forEach tag: " + string5);
            }
        }
        if (n3 > 1 && n2 > 0) {
            throw new TemplateException("both alternate and multiple have been specified");
        }
        Element element3 = ForEach.getAncestorByName(element, string);
        if (element3 == null) {
            throw new TemplateException("no such element enclosing forEach: " + string + " for expression: " + string2);
        }
        Element element4 = element3.getParentElement();
        Element element5 = ForEach.getElement("forEach").setAttribute("items", string2).setAttribute("var", string3);
        if (n2 > 0) {
            element5.setAttribute("multiple", "yes");
            n = n2 - 1;
        } else {
            n = n3 - 1;
        }
        int n4 = element4.indexOf(element3);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(element3);
        if (n > 0) {
            List list;
            try {
                XPath xPath = XPath.newInstance("following-sibling::*");
                list = xPath.selectNodes(element3);
            }
            catch (JDOMException jDOMException) {
                throw ExceptionUtils.createExn(TemplateException.class, "xpath error", jDOMException);
            }
            if (n > list.size()) {
                throw new TemplateException("alternate or multiple is greater (" + (n + 1) + ") than actual table size (" + list.size() + ").");
            }
            for (int i = 0; i < n; ++i) {
                Element element6 = (Element)list.get(i);
                arrayList.add(element6);
                element6.detach();
            }
        }
        element3.detach();
        element4.getContent().add(n4, element5);
        for (int i = 0; i < arrayList.size(); ++i) {
            element5.addContent((Content)arrayList.get(i));
        }
        element.detach();
    }

    public void execute(Processor processor, Element element, DataModel dataModel) throws TemplateException {
        List list;
        Object object;
        Iterator iterator;
        String string = element.getAttributeValue("var");
        String string2 = element.getAttributeValue("items");
        boolean bl = "yes".equals(element.getAttributeValue("multiple"));
        Iterator iterator2 = dataModel.eval(string2);
        if (iterator2 == null) {
            logger.info("forEach items: null expression: " + string2);
            return;
        }
        List<Object> list2 = iterator2 instanceof Collection ? (List<Object>)((Object)iterator2) : (iterator2 instanceof Object[] ? Arrays.asList((Object[])iterator2) : null);
        if (list2 == null && !(iterator2 instanceof Iterator)) {
            throw new TemplateException("forEach items neither a Collection nor an Iterator: " + string2 + " => " + iterator2.getClass() + ":" + iterator2);
        }
        List list3 = element.getChildren();
        List list4 = element.getParentElement().getContent();
        int n = 0;
        int n2 = list4.indexOf(element);
        ArrayList<Object> arrayList = list2 == null ? new ArrayList<Object>() : new ArrayList(list2.size());
        ArrayList<Object> arrayList2 = list2 == null ? new ArrayList<Object>() : new ArrayList(list2.size());
        Iterator iterator3 = iterator = list2 != null ? list2.iterator() : iterator2;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (bl) {
                list = list3;
            } else {
                list = Collections.singletonList(list3.get(n % list3.size()));
                ++n;
            }
            ArrayList arrayList3 = new ArrayList(list.size());
            for (Element element2 : list) {
                Element element3 = (Element)element2.clone();
                list4.add(n2++, element3);
                arrayList3.add(element3);
            }
            arrayList.add(object);
            arrayList2.add(arrayList3);
        }
        object = arrayList.listIterator();
        while (object.hasNext()) {
            list = object.next();
            dataModel.put(string, list);
            for (Object object2 : (List)arrayList2.get(object.previousIndex())) {
                processor.transform((Element)object2);
                ForEach.removeSection((Element)object2);
            }
        }
        element.detach();
    }
}

