/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.Manifest;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.StreamUtils;
import org.jopendocument.util.StringInputStream;
import org.jopendocument.util.Zip;
import org.jopendocument.util.ZippedFilesProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private ContentTypeVersioned type = null;
    private File file = null;

    public static final boolean isStandardFile(String string) {
        return string.equals("mimetype") || subdocNames.contains(string) || string.startsWith("Thumbnails") || string.startsWith("META-INF") || string.startsWith("Configurations");
    }

    public ODPackage() {
    }

    public ODPackage(InputStream inputStream) throws IOException {
        this();
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            protected void processEntry(String string, InputStream inputStream) throws IOException {
                Object object;
                if (subdocNames.contains(string)) {
                    try {
                        object = new ODXMLDocument(OOUtils.getBuilder().build(inputStream));
                    }
                    catch (JDOMException jDOMException) {
                        throw new IllegalStateException("parse error", jDOMException);
                    }
                } else {
                    byteArrayOutputStream.reset();
                    StreamUtils.copy(inputStream, byteArrayOutputStream);
                    object = byteArrayOutputStream.toByteArray();
                }
                ODPackage.this.putFile(string, object, null);
            }
        }.process(inputStream);
        ODPackageEntry oDPackageEntry = this.files.remove("META-INF/manifest.xml");
        if (oDPackageEntry != null) {
            byte[] byArray = (byte[])oDPackageEntry.getData();
            try {
                Map<String, String> map = Manifest.parse(new ByteArrayInputStream(byArray));
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    ODPackageEntry oDPackageEntry2 = this.files.get(string);
                    if (oDPackageEntry2 == null) {
                        this.files.put(string, new ODPackageEntry(string, entry.getValue(), null));
                        continue;
                    }
                    oDPackageEntry2.setType(entry.getValue());
                }
            }
            catch (JDOMException jDOMException) {
                throw new IllegalArgumentException("bad manifest " + new String(byArray), jDOMException);
            }
        }
    }

    public ODPackage(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file), 524288));
        this.file = file;
    }

    public ODPackage(ODPackage oDPackage) {
        this();
        for (String string : oDPackage.getEntries()) {
            Object object = oDPackage.getData(string);
            Object object2 = object instanceof byte[] ? object : (object instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)object, this) : CopyUtils.copy(object));
            this.putFile(string, object2, oDPackage.getEntry(string).getType());
        }
        this.file = oDPackage.file;
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File file) {
        this.file = this.addExt(file);
    }

    private final File addExt(File file) {
        String string = '.' + this.getContentType().getExtension();
        if (!file.getName().endsWith(string)) {
            file = new File(file.getParentFile(), file.getName() + string);
        }
        return file;
    }

    public final String getVersion() {
        if (this.getContent() == null) {
            return null;
        }
        return this.getContent().getVersion();
    }

    public final ContentTypeVersioned getContentType() {
        if (this.type == null) {
            if (this.files.containsKey("mimetype")) {
                this.type = ContentTypeVersioned.fromMime(new String(this.getBinaryFile("mimetype")));
            } else if (this.getVersion().equals("OpenOffice.org")) {
                Element element = this.getContent().getDocument().getRootElement();
                String string = element.getAttributeValue("class", element.getNamespace("office"));
                this.type = ContentTypeVersioned.fromClass(string);
            } else if (this.getVersion().equals("OpenDocument")) {
                Element element = (Element)this.getContent().getChild("body").getChildren().get(0);
                this.type = ContentTypeVersioned.fromBody(element.getName());
            }
        }
        return this.type;
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String string) {
        return this.files.get(string);
    }

    protected final Object getData(String string) {
        ODPackageEntry oDPackageEntry = this.getEntry(string);
        return oDPackageEntry == null ? null : oDPackageEntry.getData();
    }

    public final byte[] getBinaryFile(String string) {
        return (byte[])this.getData(string);
    }

    public final ODXMLDocument getXMLFile(String string) {
        return (ODXMLDocument)this.getData(string);
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile("content.xml");
    }

    public final ODMeta getMeta() {
        ODMeta oDMeta = this.getEntries().contains("meta.xml") ? ODMeta.create(this.getXMLFile("meta.xml")) : ODMeta.create(this.getContent());
        return oDMeta;
    }

    public Document getDocument(String string) {
        return this.getXMLFile(string).getDocument();
    }

    public final Element getStyle(String string, String string2) {
        Element element = this.getContent().getStyle(string, string2);
        if (element != null) {
            return element;
        }
        if (this.getEntries().contains("styles.xml")) {
            return this.getXMLFile("styles.xml").getStyle(string, string2);
        }
        return null;
    }

    public void putFile(String string, Object object) {
        this.putFile(string, object, null);
    }

    public void putFile(String string, Object object, String string2) {
        Object object2;
        Object object3;
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (subdocNames.contains(string)) {
            object3 = object instanceof Document ? new ODXMLDocument((Document)object) : (ODXMLDocument)object;
            if (this.getVersion() != null && !((ODXMLDocument)object3).getVersion().equals(this.getVersion())) {
                throw new IllegalArgumentException("version mismatch " + this.getVersion() + " != " + object3);
            }
            object2 = object3;
        } else {
            if (object != null && !(object instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + string + ": " + object);
            }
            object2 = object;
        }
        object3 = string2 != null ? string2 : FileUtils.findMimeType(string);
        this.files.put(string, new ODPackageEntry(string, (String)object3, object2));
    }

    public void rmFile(String string) {
        this.files.remove(string);
    }

    public ODSingleXMLDocument toSingle() {
        if (!this.isSingle()) {
            Document document = this.removeAndGetDoc("content.xml");
            Document document2 = this.removeAndGetDoc("styles.xml");
            Document document3 = this.removeAndGetDoc("settings.xml");
            Document document4 = this.removeAndGetDoc("meta.xml");
            return ODSingleXMLDocument.createFromDocument(document, document2, document3, document4, this);
        }
        return (ODSingleXMLDocument)this.getContent();
    }

    public final boolean isSingle() {
        return this.getContent() instanceof ODSingleXMLDocument;
    }

    private Document removeAndGetDoc(String string) {
        if (!this.files.containsKey(string)) {
            return null;
        }
        ODXMLDocument oDXMLDocument = (ODXMLDocument)this.files.remove(string).getData();
        return oDXMLDocument == null ? null : oDXMLDocument.getDocument();
    }

    public final void save(OutputStream outputStream) throws IOException {
        Zip zip = new Zip(outputStream);
        zip.zipNonCompressed("mimetype", this.getMimeType().getBytes("UTF8"));
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String string : this.files.keySet()) {
            Object object;
            if (string.equals("mimetype") || string.equals("META-INF/manifest.xml")) continue;
            ODPackageEntry oDPackageEntry = this.files.get(string);
            Object object2 = oDPackageEntry.getData();
            if (object2 != null) {
                object = zip.createEntry(string);
                if (object2 instanceof ODXMLDocument) {
                    OUTPUTTER.output(((ODXMLDocument)object2).getDocument(), (OutputStream)object);
                } else {
                    StreamUtils.copy(new ByteArrayInputStream((byte[])object2), (OutputStream)object);
                }
                ((OutputStream)object).close();
            }
            manifest.addEntry(string, (String)((object = oDPackageEntry.getType()) == null ? "" : object));
        }
        zip.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        zip.close();
    }

    public File save() throws IOException {
        return this.saveAs(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAs(File file) throws IOException {
        File file2 = this.addExt(file);
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 524288);
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
        return file2;
    }

    static {
        subdocNames.add("content.xml");
        subdocNames.add("styles.xml");
        subdocNames.add("meta.xml");
        subdocNames.add("settings.xml");
    }
}

