package jp.mosp.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.TimePart;
import jp.mosp.workflow.dto.OverTimeRequestDto;

public class OverTimeRequestListVo extends MosPVo {

	private static final long serialVersionUID = -1598511432661195806L;

	// p[^
	public static final String PRM_PLT_YEAR 		= "pltYear";
	public static final String PRM_PLT_MONTH 		= "pltMonth";

	// tB[h	
	private String[][]	aryOverTime;
	private String 		pltYear;
	private String 		pltMonth;
	private String 		lblSection;

	// tB[hyѐ
	public static final String NAM_SECTION 	= CommonConst.NAM_STATION;
	public static final String NAM_K_NAME 		= CommonConst.NAM_K_NAME;
	public static final String NAM_WORK_MONTH 	= CommonConst.NAM_WORKING + CommonConst.NAM_MONTH;

	public static final String NAM_WORK_DATE 		= CommonConst.NAM_WORKING + CommonConst.NAM_DAY;
	public static final String NAM_REASON 			= CommonConst.NAM_REASON;
	public static final String NAM_REQUEST_TIME 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_REQUEST_DATE 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_DAY;
	public static final String NAM_STATUS 			= CommonConst.NAM_APPROVAL_STATE;
	public static final String NAM_APPROVER 		= CommonConst.NAM_APPROVER;

	// v_EXg
	public String[][] aryPltYear;
	public String[][] aryPltMonth;

	// \[gL[
	public final String KEY_WORK_DATE		= "keyWorkDate";
	public final String KEY_REQUEST_DATE	= "keyRequestDate";
	public final String KEY_STATUS			= "keyStatus";
	public final String KEY_APPROVER		= "keyApprover";

	/**
	 * RXgN^
	 */
	public OverTimeRequestListVo() {
		super();
		setViewPath(getClassName());
		aryOverTime = new String[0][0];
		pltYear = "";
		pltMonth = "";
		setFormerKey(KEY_WORK_DATE);
	}

	public void setSubTitle() {
		subTitle = CommonConst.NAM_OVER_TIME_REQUEST;
		aryMenu = new String[][] {
				{ CMD_MENU_INPUT, CommonConst.NAM_TO_MENU },
				MosPMenuConst.getEmployeeCmdArray()[3],
		};
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}

	/**
	 * tB[hݒ
	 * @param listRequest		Xg
	 */
	public void setFields(List listRequest) {
		// Xg̐ݒ
		list = listRequest;
		// f[^̎擾
		count = listRequest.size();
		// z̏
		aryOverTime = new String[count][7];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listRequest.iterator();
		while (it.hasNext()) {
			OverTimeRequestDto dto = (OverTimeRequestDto)it.next();
			// `[ԍ
			aryOverTime[i][0] = escapeHTML(String.valueOf(dto.getVoucher()));
			// Ζ
			aryOverTime[i][1] = escapeHTML(DatePart.convDateToFormatDateJP(dto.getWorkDate()));
			// R
			aryOverTime[i][2] = escapeHTML(dto.getReason());
			// \
			aryOverTime[i][3] = escapeHTML(TimePart.convIntegerTimeToJPHours(dto.getOverTime()));
			// \
			aryOverTime[i][4] = escapeHTML(DatePart.convDateToFormatDateJP(dto.getRequestDate()));
			// F
			aryOverTime[i][5] = escapeHTML(dto.getApprovalStatus());
			// F
			aryOverTime[i][6] = escapeHTML(dto.getApproverName());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh	
	public String[][] getEscAryOverTime() { return aryOverTime.clone(); }

	public String getPltYear() { return pltYear; }
	public String getPltMonth() { return pltMonth; }

	public String getEscPltYear() { return escapeHTML(pltYear); }
	public String getEscPltMonth() { return escapeHTML(pltMonth); }

	public void setPltYear(String pltYear) { this.pltYear = pltYear; }
	public void setPltMonth(String pltMonth) { this.pltMonth = pltMonth; }

	public String getEscLblSection() { return escapeHTML(lblSection); }
	public void setLblSection(String lblSection) { this.lblSection = lblSection; }

}
