package jp.mosp.workflow.vo;

import java.util.Properties;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.TimePart;
import jp.mosp.common.vo.MosPWorkFlowVo;

import jp.mosp.workflow.dto.CtOvertimeRequestDto;

public class OverTimeApprovalCardVo extends MosPWorkFlowVo {

	private static final long serialVersionUID = 7521192658753437599L;

	// 萔
	public static final int MODE_SELECT 		= 0;
	public static final int MODE_APPROVED 	= 1;
	public static final int MODE_VIEW 		= 2;

	// tB[h
	private String lblKCode;
	private String lblKName;
	private String lblSectionName;

	private String lblWorkDate;
	private String lblOverTime;
	private String lblReason;
	private String lblReqestDate;
	private String lblApprovalStatus;

	// tB[hyѐ
	public static final String NAM_K_CODE 		= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME 		= CommonConst.NAM_K_NAME;
	public static final String NAM_SECTION 	= CommonConst.NAM_STATION;

	public static final String NAM_WORK_DATE 		= CommonConst.NAM_WORKING + CommonConst.NAM_DAY;
	public static final String NAM_OVER_TIME 		= CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_REQUEST_DATE 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_DAY;

	public static final String NAM_REASON 			= CommonConst.NAM_REASON;
	public static final String NAM_STATUS 			= CommonConst.NAM_APPROVAL_STATE;
	public static final String NAM_COMMENT 		= CommonConst.NAM_COMMENT;

	public static final int LEN_COMMENT = 50;

	// [h(0FFE߂A1FύXs)
	private int mode;

	/**
	 * RXgN^
	 * @param cfg
	 * @param msg
	 * @param nam
	 * @param cmd
	 * @param aspUser
	 * @param user
	 */
	public OverTimeApprovalCardVo(
			Properties cfg,
			Properties msg,
			Properties nam,
			String cmd,
			CmAspUserDto aspUser,
			CmUserDto user
	) {
		super(cfg, msg, nam, cmd, aspUser, user);
		setViewPath(getClassName());
		mode = MODE_SELECT;
	}

	public void setSubTitle() {
		subTitle = CommonConst.NAM_OVER_TIME_REQUEST + CommonConst.NAM_APPROVED;
		aryMenu = new String[][] {
				{ CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU },
				MosPMenuConst.getApprovalCmdArray()[1],
		};
	}

	/**
	 * tB[hݒ
	 * @param dto ݒΏDTO
	 */
	public void setFields(CtOvertimeRequestDto dto) {
		setHidVoucher(String.valueOf(dto.getVoucher()));
		lblWorkDate 	= DatePart.convDateToFormatDateJP(dto.getWorkDate());
		lblOverTime 	= TimePart.convIntegerTimeToJPHours(dto.getOverTime());
		lblReason 		= dto.getReason();
		lblReqestDate 	= DatePart.convDateToFormatDateJP(dto.getInsertDate());
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// 񒷊mF
		checkLength(getTxtComment(), LEN_COMMENT, NAM_COMMENT, PRM_TXT_COMMENT);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getEscLblKCode() 			{ return escapeHTML(lblKCode)			; }
	public String getEscLblKName() 			{ return escapeHTML(lblKName)			; }
	public String getEscLblSectionName() 	{ return escapeHTML(lblSectionName)		; }
	public String getEscLblWorkDate() 		{ return escapeHTML(lblWorkDate)		; }
	public String getEscLblOverTime() 		{ return escapeHTML(lblOverTime)		; }
	public String getEscLblReason() 		{ return escapeHTML(lblReason)			; }
	public String getEscLblApprovalStatus()	{ return escapeHTML(lblApprovalStatus)	; }
	public String getEscLblReqestDate() 	{ return escapeHTML(lblReqestDate)		; }

	public void setLblKCode			(String lblKCode			) { this.lblKCode 			= lblKCode			; }
	public void setLblKName			(String lblKName			) { this.lblKName 			= lblKName			; }
	public void setLblSectionName		(String lblSectionName		) { this.lblSectionName 	= lblSectionName	; }	
	public void setLblWorkDate			(String lblWorkDate			) { this.lblWorkDate 		= lblWorkDate		; }	
	public void setLblOverTime			(String lblOverTime			) { this.lblOverTime 		= lblOverTime		; }	
	public void setLblReason			(String lblReason			) { this.lblReason 			= lblReason			; }	
	public void setLblApprovalStatus	(String lblApprovalStatus	) { this.lblApprovalStatus 	= lblApprovalStatus	; }	
	public void setLblReqestDate		(String lblReqestDate		) { this.lblReqestDate 		= lblReqestDate		; }	

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
