package jp.mosp.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.part.DatePart;
import jp.mosp.workflow.dto.KintaiAppicationDto;

public class ManagerApprovalListVo extends MosPVo {

	private static final long serialVersionUID = -8091981681214432086L;

	// 萔
	public static final int SEARCH_OFF 	= 0;
	public static final int SEARCH_ON  	= 1;

	// p[^
	public static final String PRM_PLT_SECTION 		= "pltSection";
	public static final String PRM_PLT_APPLICATION 	= "pltApplication";
	public static final String PRM_PLT_STATUS 			= "pltStatus";
	public static final String PRM_TXT_K_CODE 			= "txtKCode";
	public static final String PRM_TXT_K_NAME 			= "txtKName";
	public static final String PRM_PLT_YEAR 			= "pltYear";
	public static final String PRM_PLT_MONTH 			= "pltMonth";
	public static final String PRM_PLT_DAY 			= "pltDay";
	public static final String PRM_CKB_APPROVAL 		= "ckbApproval";

	// tB[h	
	private String[][]	aryApplication;
	private String 		pltSection;
	private String 		pltApplication;
	private String 		pltStatus;
	private String 		txtKCode;
	private String 		txtKName;
	private String 		pltYear;
	private String 		pltMonth;
	private String 		pltDay;
	private String[] 	ckbApproval;

	// tB[hyѐ
	public static final String NAM_SECTION 		= CommonConst.NAM_STATION;
	public static final String NAM_APPLICATION 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_CATEGORY;
	public static final String NAM_STATUS 			= CommonConst.NAM_APPROVAL_STATE;
	public static final String NAM_K_CODE 			= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME 			= CommonConst.NAM_K_NAME;
	public static final String NAM_DATE 			= CommonConst.NAM_DATE;
	public static final String NAM_REMARKS	 		= CommonConst.NAM_REMARKS;
	public static final String NAM_APPROVED		= CommonConst.NAM_APPROVED;

	// v_EXg
	public String[][] aryPltSection;
	public String[][] aryPltApplication;
	public String[][] aryPltStatus;
	public String[][] aryPltYear;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;

	// \[gL[
	public final String KEY_K_CODE			= "keyKCode";
	public final String KEY_K_NAME			= "keyKName";
	public final String KEY_SECTION		= "keySection";
	public final String KEY_DATE			= "keyDate";
	public final String KEY_APPLICATION	= "keyApplication";
	public final String KEY_STATUS			= "keyStatus";

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public ManagerApprovalListVo() {
		super();
		setViewPath(getClassName());
		aryApplication = new String[0][0];
		pltSection = "";
		pltApplication = "";
		pltStatus = "";
		txtKCode = "";
		txtKName = "";
		pltYear = "";
		pltMonth = "";
		pltDay = "";
		ckbApproval = new String[0];
		setFormerKey(KEY_K_CODE);
	}

	public void setSubTitle() {
		subTitle = CommonConst.TTL_EMPLOYEE_KINTAI_APPLICATION;
		aryMenu = new String[][] {
				{ CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU },
				MosPMenuConst.getManagerCmdArray()[1],
		};
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltSection 		= request.getParameter(PRM_PLT_SECTION);
		pltApplication 	= request.getParameter(PRM_PLT_APPLICATION);
		pltStatus 		= request.getParameter(PRM_PLT_STATUS);
		txtKCode 		= request.getParameter(PRM_TXT_K_CODE);
		txtKName 		= request.getParameter(PRM_TXT_K_NAME);
		pltYear 		= request.getParameter(PRM_PLT_YEAR);
		pltMonth 		= request.getParameter(PRM_PLT_MONTH);
		pltDay 			= request.getParameter(PRM_PLT_DAY);
		ckbApproval 	= request.getParameterValues(PRM_CKB_APPROVAL);
	}

	/**
	 * tB[hݒ
	 * @param listApplication		Xg
	 */
	public void setFields(List listApplication) {
		// Xg̐ݒ
		list = listApplication;
		// f[^̎擾
		count = listApplication.size();
		// z̏
		aryApplication = new String[count][10];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listApplication.iterator();
		while (it.hasNext()) {
			KintaiAppicationDto dto = (KintaiAppicationDto) it.next();
			// IR}h
			aryApplication[i][0] = escapeHTML(dto.getCmd());
			// IL[
			aryApplication[i][1] = escapeHTML(dto.getKey());
			// ЈR[h
			aryApplication[i][2] = escapeHTML(dto.getKCode());
			// Ј
			aryApplication[i][3] = escapeHTML(dto.getSimei());
			// 
			aryApplication[i][4] = escapeHTML(dto.getSName());
			// t
			aryApplication[i][5] = escapeHTML(DatePart.convDateToFormatDateJP(dto.getDate()));
			// \
			aryApplication[i][6] = escapeHTML(dto.getApprication());
			// F
			aryApplication[i][7] = escapeHTML(dto.getStatus());
			// l
			aryApplication[i][8] = escapeHTML(dto.getRemarks());
			// `FbN{bNX
			aryApplication[i][9] = escapeHTML(dto.getCkbValue());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getEscAryApplication() { return aryApplication.clone(); }

	public String getPltSection()  		{ return pltSection			; }
	public String getPltApplication()  	{ return pltApplication		; }
	public String getPltStatus()  		{ return pltStatus			; }
	public String getTxtKCode()  		{ return txtKCode			; }
	public String getTxtKName()  		{ return txtKName			; }
	public String getPltYear()  		{ return pltYear			; }
	public String getPltMonth()  		{ return pltMonth			; }
	public String getPltDay()  			{ return pltDay				; }

	public String getEscTxtKCode()  { return escapeHTML(txtKCode); }
	public String getEscTxtKName()  { return escapeHTML(txtKName); }

	public void setPltSection		(String pltSection		) { this.pltSection 	= pltSection		; }
	public void setPltApplication	(String pltApplication	) { this.pltApplication = pltApplication	; }
	public void setPltStatus		(String pltStatus		) { this.pltStatus 		= pltStatus			; }
	public void setTxtKCode		(String txtKCode		) { this.txtKCode 		= txtKCode			; }
	public void setTxtKName		(String txtKName		) { this.txtKName 		= txtKName			; }
	public void setPltYear			(String pltYear			) { this.pltYear 		= pltYear			; }
	public void setPltMonth		(String pltMonth		) { this.pltMonth 		= pltMonth			; }
	public void setPltDay			(String pltDay			) { this.pltDay 		= pltDay			; }

	public String[] getCkbApproval() { return ckbApproval.clone(); }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }
}
