/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;

import jp.mosp.workflow.dto.AmRouteDto;

public class AmRouteDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE		= "AM_ROUTE"			;
	public static final String KEY_1		= "RTCODE"				;	//[gR[h

	// 
	public static final String COL_RT_CODE			= "RTCODE"		;	//[gR[h
	public static final String COL_LAYER1 			= "LAYER1"		;	//PF
	public static final String COL_LAYER2			= "LAYER2"		;	//QF
	public static final String COL_LAYER3			= "LAYER3"		;	//RF
	public static final String COL_LAYER4			= "LAYER4"		;	//SF
	public static final String COL_LAYER5			= "LAYER5"		;	//TF
	public static final String COL_LAST_LAYER		= "LASTLAYER"	;	//ŏIF
	public static final String COL_DELETE_FLAG		= "DELETEFLAG"	;	//폜tO

	/**
	 * RXgN^
	 */
	public AmRouteDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<AmRouteDto> mappingAll() throws SQLException {
		List<AmRouteDto> all = new ArrayList<AmRouteDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return AmRouteDto am_routeR[h
	 * @throws SQLException
	 */
	private AmRouteDto mapping() throws SQLException {
		AmRouteDto dto = new AmRouteDto();
		dto.setRtCode		(rs.getString (COL_RT_CODE)		);	//[gR[h
		dto.setLayer1		(rs.getString (COL_LAYER1)		);	//PF
		dto.setLayer2		(rs.getString (COL_LAYER2)		);	//QF
		dto.setLayer3		(rs.getString (COL_LAYER3)		);	//RF
		dto.setLayer4		(rs.getString (COL_LAYER4)		);	//SF
		dto.setLayer5		(rs.getString (COL_LAYER5)		);	//TF
		dto.setLastLayer	(rs.getString (COL_LAST_LAYER)	);	//ŏIF
		dto.setDeleteFlag	(rs.getInt    (COL_DELETE_FLAG)	);	//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param rtcode [gR[h(L[)
	 * @return AmRouteDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public AmRouteDto findForKey(
			String rtcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, rtcode);
			executeQuery();
			AmRouteDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param rtcode [gR[h(L[)
	 * @return AmRouteDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public AmRouteDto findForUpdate(
			String rtcode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, rtcode);
			executeQuery();
			AmRouteDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param rtCode [gR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String rtCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_RT_CODE);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   rtCode  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param rtCode	[gR[h
	 * @param unitCode	jbgR[h
	 * @param kCode		ЈR[h
	 * @param kName		Ј
	 * @return	list	(DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String rtCode,
			String unitCode,
			String kCode,
			String kName
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_RT_CODE);
		sb.append(" LIKE ? ");
		if (!unitCode.equals("")) {
			sb.append(" AND ");
			sb.append(" ( ");
			sb.append(COL_LAYER1 	 + " LIKE ? ");	
			sb.append(" OR ");
			sb.append(COL_LAYER2 	 + " LIKE ? ");	
			sb.append(" OR ");
			sb.append(COL_LAYER3 	 + " LIKE ? ");	
			sb.append(" OR ");
			sb.append(COL_LAYER4 	 + " LIKE ? ");	
			sb.append(" OR ");
			sb.append(COL_LAYER5 	 + " LIKE ? ");	
			sb.append(" OR ");
			sb.append(COL_LAST_LAYER + " LIKE ? ");
			sb.append(" ) ");			
		}
		if (!kCode.equals("")) {
			sb.append(" AND ");
			sb.append(" ( ");
			sb.append(COL_LAYER1 	 + " IN (" + AmUnitDao.getSearchKCodeSubQuery() + ") ");	
			sb.append(" OR ");
			sb.append(COL_LAYER2 	 + " IN (" + AmUnitDao.getSearchKCodeSubQuery() + ") ");	
			sb.append(" OR ");
			sb.append(COL_LAYER3 	 + " IN (" + AmUnitDao.getSearchKCodeSubQuery() + ") ");	
			sb.append(" OR ");
			sb.append(COL_LAYER4 	 + " IN (" + AmUnitDao.getSearchKCodeSubQuery() + ") ");	
			sb.append(" OR ");
			sb.append(COL_LAYER5 	 + " IN (" + AmUnitDao.getSearchKCodeSubQuery() + ") ");	
			sb.append(" OR ");
			sb.append(COL_LAST_LAYER + " IN (" + AmUnitDao.getSearchKCodeSubQuery() + ") ");
			sb.append(" ) ");
		}
		if (!kName.equals("")) {
			sb.append(" AND ");
			sb.append(" ( ");
			sb.append(COL_LAYER1	 + " IN (" + AmUnitDao.getSearchKNameSubQuery() + ") ");			
			sb.append(" OR ");
			sb.append(COL_LAYER2	 + " IN (" + AmUnitDao.getSearchKNameSubQuery() + ") ");			
			sb.append(" OR ");
			sb.append(COL_LAYER3	 + " IN (" + AmUnitDao.getSearchKNameSubQuery() + ") ");			
			sb.append(" OR ");
			sb.append(COL_LAYER4	 + " IN (" + AmUnitDao.getSearchKNameSubQuery() + ") ");			
			sb.append(" OR ");
			sb.append(COL_LAYER5 	 + " IN (" + AmUnitDao.getSearchKNameSubQuery() + ") ");			
			sb.append(" OR ");
			sb.append(COL_LAST_LAYER + " IN (" + AmUnitDao.getSearchKNameSubQuery() + ") ");			
			sb.append(" ) ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   rtCode + "%");
			if (!unitCode.equals("")) {
				setParam(index++,   unitCode + "%");
				setParam(index++,   unitCode + "%");
				setParam(index++,   unitCode + "%");
				setParam(index++,   unitCode + "%");
				setParam(index++,   unitCode + "%");				
				setParam(index++,   unitCode + "%");				
			}
			if (!kCode.equals("")) {
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");
				setParam(index++,   kCode + "%");				
			}
			if (!kName.equals("")) {
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");
				setParam(index++,   "%" + kName + "%");			
			}
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param unitCode	jbgR[h
	 * @return	list	(DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AmRouteDto> findForKCodeAvailable(
			String kCode,
			String startDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + CommonConst.DEFAULT_FLAG_OFF);
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(		COL_LAYER1 		+ " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(	" OR ");
		sb.append(		COL_LAYER2 		+ " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");	
		sb.append(	" OR ");
		sb.append(		COL_LAYER3 		+ " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");	
		sb.append(	" OR ");
		sb.append(		COL_LAYER4 		+ " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");	
		sb.append(	" OR ");
		sb.append(		COL_LAYER5 		+ " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");	
		sb.append(	" OR ");
		sb.append(		COL_LAST_LAYER 	+ " IN ( " + AmUnitDao.getSearchKCodeSubQueryByStartDate() + " ) ");
		sb.append(" ) ");			
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kCode 		);
			setParam(index++,   kCode 		);
			setParam(index++,   startDate 	);		
			setParam(index++,   kCode 		);
			setParam(index++,   kCode 		);
			setParam(index++,   startDate 	);		
			setParam(index++,   kCode 		);
			setParam(index++,   kCode 		);
			setParam(index++,   startDate 	);		
			setParam(index++,   kCode 		);
			setParam(index++,   kCode 		);
			setParam(index++,   startDate 	);		
			setParam(index++,   kCode 		);
			setParam(index++,   kCode 		);
			setParam(index++,   startDate 	);		
			setParam(index++,   kCode 		);
			setParam(index++,   kCode 		);
			setParam(index++,   startDate 	);		
			executeQuery();
			List<AmRouteDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @return list (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AmRouteDto> findForAttendanceRoute(	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_LAYER1);
		sb.append(" != '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER2);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER3);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER4);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER5);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAST_LAYER);
		sb.append(" != '' ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<AmRouteDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param unitcode jbgR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<AmRouteDto> findForAttendanceRouteArray(String unitcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_LAYER2);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER3);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER4);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(COL_LAYER5);
		sb.append(" = '' ");
		sb.append(" AND ");
		sb.append(" ( ");
		sb.append(		COL_LAYER1);
		sb.append(		" = ? ");
		sb.append(		" OR ");
		sb.append(		COL_LAST_LAYER);
		sb.append(		" = ? ");
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   unitcode);
			setParam(index++,   unitcode);
			executeQuery();
			List<AmRouteDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(AmRouteDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}	

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(AmRouteDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getRtCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(AmRouteDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getRtCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(AmRouteDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getRtCode()		);	//[gR[h
		setParam(index++, dto.getLayer1()		);	//PF
		setParam(index++, dto.getLayer2()		);	//QF
		setParam(index++, dto.getLayer3()		);	//RF
		setParam(index++, dto.getLayer4()		);	//SF
		setParam(index++, dto.getLayer5()		);	//TF
		setParam(index++, dto.getLastLayer()	);	//ŏIF
		setParam(index++, dto.getDeleteFlag()	);	//폜tO
		setCommonParams(isInsert);
	}

}
