package jp.mosp.workflow.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.KintaiApprovalPart;
import jp.mosp.common.part.NumberPart;
import jp.mosp.common.part.PartManager;
import jp.mosp.common.part.StringPart;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.dto.MSyukkinboDto;

import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.dto.KintaiAppicationDto;
import jp.mosp.workflow.vo.ManagerApprovalListVo;

public class ManagerApprovalListAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_LIST_SHOW 		= "K2130";
	private static final String CMD_LIST_SEARCH 		= "K2131";
	private static final String CMD_LIST_RE_SEARCH 	= "K2132";
	private static final String CMD_LIST_SORT 		= "K2133";
	private static final String CMD_LIST_APPROVAL		= "K2134";

	// tB[h
	/**
	 * \pXg
	 */
	List<KintaiAppicationDto> listApplication;

	/**
	 * RXgN^
	 */
	public ManagerApprovalListAction() {
		super();
	}

	public void action() throws Exception {
		// VȌ
		ManagerApprovalListVo vo = (ManagerApprovalListVo) prepareVo();
		// v_E̐ݒ
		setPulldownList(vo);
		// [U̐ݒ
		getInfo(user.getUserId());
		// R}h̏
		if (cmd.equals(CMD_LIST_SHOW)) {
			Date todayDate = DatePart.getSystemDate();
			vo.setPltYear(String.valueOf(MospUtility.getYear(todayDate)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(todayDate)));
			vo.setPltDay(String.valueOf(MospUtility.getDay(todayDate)));
			vo.setPltSection(mKihon.getSCode());
		} else if (cmd.equals(CMD_LIST_SEARCH)) {
			vo.setParams(request);
			// ɂꗗ擾
			searchApplicationList(vo);
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			vo.setSearchmode(ManagerApprovalListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_LIST_RE_SEARCH)) {
			// Č
			if (vo.getSearchmode() == ManagerApprovalListVo.SEARCH_ON) {
				session.removeAttribute(MospConst.ATT_DTO);
				searchApplicationList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else if (cmd.equals(CMD_LIST_APPROVAL)) {
			vo.setParams(request);
			// ꊇF
			runApprovalProcess(vo);
			// Č
			searchApplicationList(vo);
			vo.setPageButton();
			sortList(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	protected ManagerApprovalListVo getSpecificVo() {
		return new ManagerApprovalListVo();
	}

	/**
	 * v_E̐ݒ
	 * @param vo		ΏVO
	 * @throws Exception 
	 */
	private void setPulldownList(ManagerApprovalListVo vo) throws Exception {
		vo.aryPltSection 		= StringPart.addArrayFirstRowSpace(getSectionArrayAll());
		vo.aryPltApplication 	= StringPart.addArrayFirstRowSpace(getApplicationArray());
		vo.aryPltStatus 		= StringPart.addArrayFirstRowSpace(
				PartManager.kintaiapproval(partInfo()).getApprovalReasonArray()
		);
		vo.aryPltYear 			= StringPart.getYearArray(MospUtility.getYear(DatePart.getSystemDate()));
		vo.aryPltMonth 			= StringPart.getMonthArray();
		vo.aryPltDay 			= StringPart.getDayArray();
	}

	/**
	 * ɂꗗݒ
	 * @param vo	ΏVO
	 * @throws Exception 
	 */
	private void searchApplicationList(ManagerApprovalListVo vo) throws Exception {
		// Xg̏
		listApplication = new ArrayList<KintaiAppicationDto>();
		// JnN
		Date startDate;
		// IN
		Date endDate;
		if (vo.getPltDay().length() != 0) {
			startDate = DatePart.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getPltDay());
			endDate = startDate;
		} else {
			startDate = DatePart.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
			endDate = DatePart.getLastDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		}
		// FΏێЈꗗXg
		List<MKihonDto> mKihonList = getApprovalEmployeeList(startDate);
		for (Iterator iter = mKihonList.iterator(); iter.hasNext();) {
			MKihonDto dto = (MKihonDto) iter.next();
			if (vo.getPltSection().length() != 0
					&& !vo.getPltSection().equals(dto.getSCode())
			) {
				continue;
			}
			if (vo.getTxtKCode().length() != 0
					&& !dto.getKCode().startsWith(vo.getTxtKCode())	
			) {
				continue;
			}
			if (vo.getTxtKName().length() == 0
					&& !dto.getSimei().matches(".*" + vo.getTxtKName() + ".*")
			) {
				continue;
			}
			/*			
			if (vo.getPltApplication().length() == 0
					|| vo.getPltApplication().equals(getApplicationArray()[0][0])
			) {
				// Αӏǉ
				addSyukkinboInfoToList(dto, startDate, endDate, vo.getPltStatus());
			}
			 */			
			if (vo.getPltApplication().length() == 0
					|| 	vo.getPltApplication().equals(getApplicationArray()[0][0])
			) {
				// cƐ\ǉ
				addOverTimeRequestToList(dto, startDate, endDate, vo.getPltStatus());
			}
			/*			
			if (vo.getPltApplication().length() == 0
					|| vo.getPltApplication().equals(getApplicationArray()[0][0])
			) {
				// xɐ\ǉ
			}
			 */
		}
		// ЈR[hŃ\[gB
		util.sortList(listApplication, new CompKCode());
		// VOɃZbg
		vo.setFields(listApplication);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryApplication().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * Αӏǉ
	 * @param mKihonDto		ΏێЈDTO
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @param snriyuu		ΏۏF
	 * @throws Exception
	 */
	protected void addSyukkinboInfoToList(
			MKihonDto mKihonDto,
			Date startDate,
			Date endDate,
			String snriyuu
	) throws Exception {
		// ΏۊԓΑӈꗗ擾
		List<MSyukkinboDto> listSyukkinbo = syukkinboDao().findForApprovalList(
				mKihonDto.getKCode(),
				DatePart.convDateFormatted(startDate),
				DatePart.convDateFormatted(endDate),
				snriyuu
		);
		for (Iterator iterator = listSyukkinbo.iterator(); iterator.hasNext();) {
			MSyukkinboDto dto = (MSyukkinboDto) iterator.next();
			KintaiAppicationDto appicationDto = new KintaiAppicationDto();
			// R}h
			//appicationDto.setCmd("K2126");
			// L[
			appicationDto.setKey(dto.getHizuke());
			// ЈR[h
			appicationDto.setKCode(dto.getKCode());
			// Ј
			appicationDto.setSimei(mKihonDto.getSimei());
			// 
			appicationDto.setSName(getSectionName(mKihonDto.getSCode()));
			// t
			appicationDto.setDate(DatePart.convStringDateToDate(dto.getHizuke()));
			// \
			appicationDto.setApprication(CommonConst.NAM_DAILY_APPROVAL);
			// F
			appicationDto.setStatus(PartManager.kintaiapproval(partInfo()).getApprovalName(dto));
			// `FbN{bNX
			if (KintaiApprovalPart.isRequest(dto)
					|| KintaiApprovalPart.is1stApproved(dto)
			) {
				StringBuffer sb = new StringBuffer();
				// \F
				sb.append(CommonConst.CODE_DAILY_APPROVAL);
				sb.append(CommonConst.STR_UNDER_SEPARATOR);
				appicationDto.setCkbValue(sb.toString());
			}
			listApplication.add(appicationDto);
		}
	}

	/**
	 * cƐ\ǉ
	 * @param mKihonDto		ΏێЈDTO
	 * @param startDate		JnN
	 * @param endDate		IN
	 * @param snriyuu		ΏۏF
	 * @throws Exception
	 */
	private void addOverTimeRequestToList(
			MKihonDto mKihonDto,
			Date startDate,
			Date endDate,
			String snriyuu
	) throws Exception {
		// [Nt[F󋵃R[h
		String[] targetStatus = KintaiApprovalPart.toWorkflowStatus(snriyuu);
		List<CtOvertimeRequestDto> listOverTime = overRequestDao().findForCondition(
				mKihonDto.getKCode(),
				DatePart.convDateFormattedByHyphen(startDate),
				DatePart.convDateFormattedByHyphen(endDate),
				NumberPart.getIntParam(targetStatus[0]),
				targetStatus[1]
		);
		for (Iterator iter = listOverTime.iterator(); iter.hasNext();) {
			CtOvertimeRequestDto dto = (CtOvertimeRequestDto) iter.next();
			// ȊO
			if (!isStatusDraft(dto.getWorkflow())) {
				KintaiAppicationDto appicationDto = new KintaiAppicationDto();
				// R}h
				appicationDto.setCmd(OverTimeApprovalCardAction.CMD_CARD_SELECT);
				// L[
				appicationDto.setKey(String.valueOf(dto.getVoucher()));
				// ЈR[h
				appicationDto.setKCode(dto.getKCode());
				// Ј
				appicationDto.setSimei(mKihonDto.getSimei());
				// 
				appicationDto.setSName(getSectionName(mKihonDto.getSCode()));
				// t
				appicationDto.setDate(dto.getWorkDate());
				// \
				appicationDto.setApprication(CommonConst.NAM_OVER_TIME_REQUEST);
				String statusCode = toKintaiApprovalStatus(dto.getWorkflow());
				// F
				appicationDto.setStatus(getApprovalName(statusCode));
				// `FbN{bNX
				if (KintaiApprovalPart.isRequest(statusCode)
						|| KintaiApprovalPart.is1stApproved(statusCode)	
				) {
					StringBuffer sb = new StringBuffer();
					// \F
					sb.append(CommonConst.CODE_OVER_TIME_REQUEST);
					sb.append(CommonConst.STR_UNDER_SEPARATOR);
					// \`[ԍ
					sb.append(dto.getVoucher());
					appicationDto.setCkbValue(sb.toString());
				}
				listApplication.add(appicationDto);
			}
		}
	}

	/**
	 * ꊇF
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void runApprovalProcess(ManagerApprovalListVo vo) throws Exception {
		String[] arySelectValue = vo.getCkbApproval();
		// R~bgtO
		Set<Boolean> commitSet = new HashSet<Boolean>();
		for (String selectValue : arySelectValue) {
			// XΑӏF
			// cƐ\F
			if (selectValue.indexOf(CommonConst.CODE_OVER_TIME_REQUEST) == 0) {
				// cƐ\F 
				commitSet.add(runOverTimeRequestApproved(
						getOverTimeRequest(NumberPart.getIntParam(
								selectValue.split(CommonConst.STR_UNDER_SEPARATOR)[1])
						),
						vo)
				);
			}
			// xɐ\F
		}
		// G[΃R~bgB
		if (!commitSet.contains(false)) {
			// R~bg
			commit();
			// bZ[W
			StringBuffer sb = new StringBuffer();
			sb.append(commitSet.size());
			sb.append(CommonConst.NAM_COMMON_COUNT);
			sb.append(CommonConst.NAM_APPROVED);
			vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_DONE, sb.toString()));
		}
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(ManagerApprovalListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, ManagerApprovalListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, ManagerApprovalListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_DATE)) {
			comp = new CompDate();
		} else if (key.equals(vo.KEY_APPLICATION)) {
			comp = new CompApplication();
		} else if (key.equals(vo.KEY_STATUS)) {
			comp = new CompStatus();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -6587672856397520392L;
		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}

	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 6321920436763711779L;
		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}

	/**
	 * ЈɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -6522555390412324071L;
		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getSName().compareTo(dto2.getSName());
		}
	}

	/**
	 * tɂrNX
	 */
	protected static class CompDate implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -2059568153842913234L;
		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getDate().compareTo(dto2.getDate());
		}
	}

	/**
	 * \ނɂrNX
	 */
	protected static class CompApplication implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -2395226905215857602L;
		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getApprication().compareTo(dto2.getApprication());
		}
	}

	/**
	 * F󋵂ɂrNX
	 */
	protected static class CompStatus implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -8920699379965954199L;
		public int compare(Object obj1, Object obj2) {
			KintaiAppicationDto dto1 = (KintaiAppicationDto)obj1;
			KintaiAppicationDto dto2 = (KintaiAppicationDto)obj2;
			return dto1.getStatus().compareTo(dto2.getStatus());
		}
	}

}
