/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;


import jp.mosp.workflow.dto.AmRouteDto;
import jp.mosp.workflow.dto.AmUnitDto;
import jp.mosp.workflow.vo.ApprovalRouteCardVo;

public class ApprovalRouteCardAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_ROUTE_CARD_SHOW   = "S2825";	// \(ǉ)
	private static final String CMD_ROUTE_CARD_SELECT = "S2826";	// \(I)
	private static final String CMD_ROUTE_CARD_INSERT = "S2827";	// o^
	private static final String CMD_ROUTE_CARD_UPDATE = "S2828";	// XV

	/**
	 * RXgN^
	 */
	public ApprovalRouteCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		ApprovalRouteCardVo vo = new ApprovalRouteCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		AmRouteDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof AmRouteDto ? (AmRouteDto)obj : null;
		// v_ẼZbg
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_ROUTE_CARD_SHOW)) {
			vo.setDefaultValues();
			// [hݒ
			setMode(vo);
		} else if (cmd.equals(CMD_ROUTE_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = routeDao().findForKey(key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			vo.setMode(ApprovalRouteCardVo.MODE_UPDATE);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ROUTE_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_ROUTE_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_E̐ݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPulldownList(ApprovalRouteCardVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// FjbgR[hꗗ
		vo.aryPltUnit = getUnitArrayAvailable();
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private AmRouteDto insert(ApprovalRouteCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// ݃`FbN
		chkDuplicate(routeDao().findForKey(vo.getTxtRouteCode()), vo);
		// DTȌ
		AmRouteDto dto = new AmRouteDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		// f[^̑}
		routeDao().insert(dto);
		// DTO̍Ď擾
		dto = routeDao().findForKey(dto.getRtCode());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private AmRouteDto update(ApprovalRouteCardVo vo, AmRouteDto dto) throws Exception {
		// R[h擾
		vo.setTxtRouteCode(dto.getRtCode());
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, routeDao().findForUpdate(vo.getTxtRouteCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		routeDao().update(dto);
		// DTO̍Ď擾
		AmRouteDto retDto = routeDao().findForKey(dto.getRtCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * FjbgR[h擾iAM_UNITj
	 * @return p\ȏFjbgR[hXg
	 * @throws Exception
	 */
	private String[][] getUnitArrayAvailable() throws Exception {
		// ̎擾
		String targetDate = util.convDateFormattedByHyphen(util.getSystemDate());
		List<AmUnitDto> listUnit = unitDao().findForSelectableUnitArray(targetDate);
		// z̍쐬
		String[][] aryUnit = new String[listUnit.size()][3];
		for (int i = 0; i < listUnit.size(); i++) {
			aryUnit[i][0] = listUnit.get(i).getUnitCode();
			StringBuffer sb = new StringBuffer();
			sb.append(getKName(listUnit.get(i).getMain()));
			sb.append(CommonConst.STR_2BYTE_SLASH_SEPARATOR);
			sb.append(getKName(listUnit.get(i).getAgent()));
			sb.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			sb.append(util.convHyphenDateToJPShortDate(listUnit.get(i).getStartDate()));
			sb.append(CommonConst.STR_TERM);
			aryUnit[i][1] = sb.toString();
		}
		return aryUnit;
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(ApprovalRouteCardVo vo) throws Exception {
		// [hݒ
		if (vo.aryPltUnit.length == 0) {
			vo.setMode(ApprovalRouteCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(ApprovalRouteCardVo.MODE_INSERT);
		}
	}

}
