/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MYakusyokuDto;

public class YakusyokuMasterCardVo extends MosPVo {

	private static final long serialVersionUID = -4752290351658511718L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/yakusyokuMasterCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/yakusyokuMasterCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/yakusyokuMasterCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_POSITION_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	public static final int MODE_SYSTEM = 2;		

	// p[^
	public static final String PRM_TXT_YCODE 		= "txtYCode";
	public static final String PRM_TXT_YNAME 		= "txtYName";
	public static final String PRM_PLT_TOKYU 		= "pltTokyu";
	public static final String PRM_HID_TKEKKIN 	= "hidTKekkin";
	public static final String PRM_PLT_KEKKIN 	= "pltKekkin";
	public static final String PRM_HID_SKEKKIN 	= "hidSKekkin";
	public static final String PRM_PLT_TIJI 		= "pltTiJi";
	public static final String PRM_PLT_ZAJI 		= "pltZaJi";
	public static final String PRM_PLT_KSJI 		= "pltKsJi";
	public static final String PRM_PLT_SNJI 		= "pltSnJi";
	public static final String PRM_PLT_KAIKIN 	= "pltKaikin";
	public static final String PRM_PLT_SYOKUJI 	= "pltSyokuji";
	public static final String PRM_PLT_CYOKU1 	= "pltCyoku1";
	public static final String PRM_PLT_CYOKU2 	= "pltCyoku2";
	public static final String PRM_PLT_CYOKU3 	= "pltCyoku3";
	public static final String PRM_PLT_HOKA1 		= "pltHoka1";
	public static final String PRM_PLT_HOKA2 		= "pltHoka2";
	public static final String PRM_PLT_HOKA3 		= "pltHoka3";
	public static final String PRM_PLT_HOKA4 		= "pltHoka4";
	public static final String PRM_PLT_HOKA5 		= "pltHoka5";
	public static final String PRM_HID_TKEKKINTAN = "hidTKekkinTan";
	public static final String PRM_HID_KEKKINTAN 	= "hidKekkinTan";
	public static final String PRM_HID_SKEKKINTAN = "hidSKekkinTan";
	public static final String PRM_HID_TIJITAN 	= "hidTiJiTan";
	public static final String PRM_HID_ZAJITAN 	= "hidZaJiTan";
	public static final String PRM_HID_KSJITAN 	= "hidKsJiTan";
	public static final String PRM_HID_SNJITAN 	= "hidSnJiTan";
	public static final String PRM_TXT_KAIKINTAN 	= "txtKaikinTan";
	public static final String PRM_TXT_SYOKUJITAN = "txtSyokuJiTan";
	public static final String PRM_TXT_CYOKU1TAN 	= "txtCyoku1Tan";
	public static final String PRM_TXT_CYOKU2TAN 	= "txtCyoku2Tan";
	public static final String PRM_TXT_CYOKU3TAN 	= "txtCyoku3Tan";
	public static final String PRM_TXT_HOKA1TAN 	= "txtHoka1Tan";
	public static final String PRM_TXT_HOKA2TAN 	= "txtHoka2Tan";
	public static final String PRM_TXT_HOKA3TAN 	= "txtHoka3Tan";
	public static final String PRM_TXT_HOKA4TAN 	= "txtHoka4Tan";
	public static final String PRM_TXT_HOKA5TAN 	= "txtHoka5Tan";

	// tB[h
	private String 		txtYCode ;
	private String 		txtYName ;
	private String 		pltTokyu ;
	private String 		hidTKekkin ;
	private String 		pltKekkin ;
	private String 		hidSKekkin ;
	private String 		pltTiJi ;
	private String 		pltZaJi ;
	private String 		pltKsJi ;
	private String 		pltSnJi ;
	private String 		pltKaikin ;
	private String 		pltSyokuji ;
	private String 		pltCyoku1 ;
	private String 		pltCyoku2 ;
	private String 		pltCyoku3 ;
	private String 		pltHoka1 ;
	private String 		pltHoka2 ;
	private String 		pltHoka3 ;
	private String 		pltHoka4 ;
	private String 		pltHoka5 ;
	private String 		hidTKekkinTan ;
	private String 		hidKekkinTan ;
	private String 		hidSKekkinTan ;
	private String 		hidTiJiTan ;
	private String 		hidZaJiTan ;
	private String 		hidKsJiTan ;
	private String 		hidSnJiTan ;
	private String 		txtKaikinTan ;
	private String 		txtSyokuJiTan ;
	private String 		txtCyoku1Tan ;
	private String 		txtCyoku2Tan ;
	private String 		txtCyoku3Tan ;
	private String 		txtHoka1Tan ;
	private String 		txtHoka2Tan ;
	private String 		txtHoka3Tan ;
	private String 		txtHoka4Tan ;
	private String 		txtHoka5Tan ;	

	// v_EXg
	public String[][] aryPltTokyu;
	public String[][] aryPltExistence1;		// E蓖敪v_EXgiL{^Pj
	public String[][] aryPltExistence2;		// E蓖敪v_EXgiL{ŒPj
	public String[][] aryPltExistence3;		// E蓖敪v_EXgiL{^P{ŒPj

	// 蓖̃Xg
	public String[][] aryAllowance;

	// [h(0FVKo^A1FXVA2F폜)
	private int mode;	

	// tB[hyѐ
	public static final String NAM_YCODE = CommonConst.NAM_POSITION1 + CommonConst.NAM_COMMON_CODE;
	public static final String NAM_YNAME = CommonConst.NAM_POSITION1 + CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_TOKYU = CommonConst.NAM_GRADE;

	public static final int LEN_YCODE 		= 5;
	public static final int LEN_YNAME 		= 20;
	public static final int LEN_KAIKINTAN 	= 5;
	public static final int LEN_SYOKUJITAN 	= 5;
	public static final int LEN_CYOKU1TAN 	= 5;
	public static final int LEN_CYOKU2TAN 	= 5;
	public static final int LEN_CYOKU3TAN 	= 5;
	public static final int LEN_HOKA1TAN 		= 5;
	public static final int LEN_HOKA2TAN 		= 5;
	public static final int LEN_HOKA3TAN 		= 5;
	public static final int LEN_HOKA4TAN 		= 5;
	public static final int LEN_HOKA5TAN 		= 5;

	/**
	 * RXgN^
	 */
	public YakusyokuMasterCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		aryAllowance = new String[0][0];
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtYCode("");
		setTxtYName("");
		setPltTokyu("");
		setHidTKekkin("0");
		setPltKekkin("0");
		setHidSKekkin("0");
		setPltTiJi("0");
		setPltZaJi("0");
		setPltKsJi("0");
		setPltSnJi("0");
		setPltKaikin("0");
		setPltSyokuji("0");
		setPltCyoku1("0");
		setPltCyoku2("0");
		setPltCyoku3("0");
		setPltHoka1("0");
		setPltHoka2("0");
		setPltHoka3("0");
		setPltHoka4("0");
		setPltHoka5("0");
		setHidTKekkinTan("0");
		setHidKekkinTan("0");
		setHidSKekkinTan("0");
		setHidTiJiTan("0");
		setHidZaJiTan("0");
		setHidKsJiTan("0");
		setHidSnJiTan("0");
		setTxtKaikinTan("0");
		setTxtSyokuJiTan("0");
		setTxtCyoku1Tan("0");
		setTxtCyoku2Tan("0");
		setTxtCyoku3Tan("0");
		setTxtHoka1Tan("0");
		setTxtHoka2Tan("0");
		setTxtHoka3Tan("0");
		setTxtHoka4Tan("0");
		setTxtHoka5Tan("0");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtYCode 		= request.getParameter(PRM_TXT_YCODE);
		txtYName 		= request.getParameter(PRM_TXT_YNAME);
		pltTokyu 		= request.getParameter(PRM_PLT_TOKYU);
		hidTKekkin 		= request.getParameter(PRM_HID_TKEKKIN);
		pltKekkin 		= request.getParameter(PRM_PLT_KEKKIN);
		hidSKekkin 		= request.getParameter(PRM_HID_SKEKKIN);
		pltTiJi 		= request.getParameter(PRM_PLT_TIJI);
		pltZaJi 		= request.getParameter(PRM_PLT_ZAJI);
		pltKsJi 		= request.getParameter(PRM_PLT_KSJI);
		pltSnJi 		= request.getParameter(PRM_PLT_SNJI);
		pltKaikin 		= request.getParameter(PRM_PLT_KAIKIN);
		pltSyokuji 		= request.getParameter(PRM_PLT_SYOKUJI );
		pltCyoku1 		= request.getParameter(PRM_PLT_CYOKU1);
		pltCyoku2 		= request.getParameter(PRM_PLT_CYOKU2);
		pltCyoku3 		= request.getParameter(PRM_PLT_CYOKU3);
		pltHoka1 		= request.getParameter(PRM_PLT_HOKA1);
		pltHoka2 		= request.getParameter(PRM_PLT_HOKA2);
		pltHoka3 		= request.getParameter(PRM_PLT_HOKA3);
		pltHoka4 		= request.getParameter(PRM_PLT_HOKA4);
		pltHoka5 		= request.getParameter(PRM_PLT_HOKA5);
		hidTKekkinTan 	= request.getParameter(PRM_HID_TKEKKINTAN);
		hidKekkinTan 	= request.getParameter(PRM_HID_KEKKINTAN);
		hidSKekkinTan 	= request.getParameter(PRM_HID_SKEKKINTAN);
		hidTiJiTan 		= request.getParameter(PRM_HID_TIJITAN);
		hidZaJiTan 		= request.getParameter(PRM_HID_ZAJITAN);
		hidKsJiTan 		= request.getParameter(PRM_HID_KSJITAN);
		hidSnJiTan 		= request.getParameter(PRM_HID_SNJITAN);
		txtKaikinTan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_KAIKINTAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtSyokuJiTan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_SYOKUJITAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtCyoku1Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_CYOKU1TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtCyoku2Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_CYOKU2TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtCyoku3Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_CYOKU3TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka1Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA1TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka2Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA2TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka3Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA3TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka4Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA4TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
		txtHoka5Tan 	= util.convNullToInitialValue(request.getParameter(PRM_TXT_HOKA5TAN),
				CommonConst.NAM_COMMON_INTEGER_INITIAL_VALUE);
	}

	/**
	 * tB[hݒ
	 * @param dto 
	 */
	public void setFields(MYakusyokuDto dto) {
		txtYCode 		= dto.getYCode();
		txtYName 		= dto.getYName();
		pltTokyu 		= dto.getTokyu();
		hidTKekkin 		= dto.getTKekkin();
		pltKekkin 		= dto.getKekkin();
		hidSKekkin 		= dto.getSKekkin();
		pltTiJi 		= dto.getTiJi();
		pltZaJi 		= dto.getZaJi();
		pltKsJi 		= dto.getKsJi();
		pltSnJi 		= dto.getSnJi();
		pltKaikin 		= dto.getKaikin();
		pltSyokuji 		= dto.getSyokuji();
		pltCyoku1 		= dto.getCyoku1();
		pltCyoku2 		= dto.getCyoku2();
		pltCyoku3 		= dto.getCyoku3();
		pltHoka1 		= dto.getHoka1();
		pltHoka2 		= dto.getHoka2();
		pltHoka3 		= dto.getHoka3();
		pltHoka4 		= dto.getHoka4();
		pltHoka5 		= dto.getHoka5();
		hidTKekkinTan 	= String.valueOf(dto.getTKekkinTan());
		hidKekkinTan 	= String.valueOf(dto.getKekkinTan());
		hidSKekkinTan 	= String.valueOf(dto.getSKekkinTan());
		hidTiJiTan 		= String.valueOf(dto.getTiJiTan());
		hidZaJiTan 		= String.valueOf(dto.getZaJiTan());
		hidKsJiTan 		= String.valueOf(dto.getKsJiTan());
		hidSnJiTan 		= String.valueOf(dto.getSnJiTan());
		txtKaikinTan 	= String.valueOf(dto.getKaikinTan());
		txtSyokuJiTan 	= String.valueOf(dto.getSyokuJiTan());
		txtCyoku1Tan 	= String.valueOf(dto.getCyoku1Tan());
		txtCyoku2Tan 	= String.valueOf(dto.getCyoku2Tan());
		txtCyoku3Tan 	= String.valueOf(dto.getCyoku3Tan());
		txtHoka1Tan 	= String.valueOf(dto.getHoka1Tan());
		txtHoka2Tan 	= String.valueOf(dto.getHoka2Tan());
		txtHoka3Tan 	= String.valueOf(dto.getHoka3Tan());
		txtHoka4Tan 	= String.valueOf(dto.getHoka4Tan());
		txtHoka5Tan 	= String.valueOf(dto.getHoka5Tan());
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(MYakusyokuDto dto) {
		dto.setYCode		(txtYCode);
		dto.setYName		(txtYName);
		dto.setTokyu		(pltTokyu);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*		
		dto.setTKekkin		(hidTKekkin);
		dto.setKekkin		(pltKekkin);
		dto.setSKekkin		(hidSKekkin);
		dto.setTiJi			(pltTiJi);
		dto.setZaJi			(pltZaJi);
		dto.setKsJi			(pltKsJi);
		dto.setSnJi			(pltSnJi);
		 */
		dto.setKaikin		(pltKaikin);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*
		dto.setSyokuji		(pltSyokuji);
		dto.setCyoku1		(pltCyoku1);
		dto.setCyoku2		(pltCyoku2);
		dto.setCyoku3		(pltCyoku3);
		dto.setHoka1		(pltHoka1);
		dto.setHoka2		(pltHoka2);
		dto.setHoka3		(pltHoka3);
		dto.setHoka4		(pltHoka4);
		dto.setHoka5		(pltHoka5);
		dto.setTKekkinTan	(getIntParam(hidTKekkinTan));
		dto.setKekkinTan	(getIntParam(hidKekkinTan));
		dto.setSKekkinTan	(getIntParam(hidSKekkinTan));
		dto.setTiJiTan		(getIntParam(hidTiJiTan));
		dto.setZaJiTan		(getIntParam(hidZaJiTan));
		dto.setKsJiTan		(getIntParam(hidKsJiTan));
		dto.setSnJiTan		(getIntParam(hidSnJiTan));
		dto.setKaikinTan	(getIntParam(txtKaikinTan));
		dto.setSyokuJiTan	(getIntParam(txtSyokuJiTan));
		dto.setCyoku1Tan	(getIntParam(txtCyoku1Tan));
		dto.setCyoku2Tan	(getIntParam(txtCyoku2Tan));
		dto.setCyoku3Tan	(getIntParam(txtCyoku3Tan));
		dto.setHoka1Tan		(getIntParam(txtHoka1Tan));
		dto.setHoka2Tan		(getIntParam(txtHoka2Tan));
		dto.setHoka3Tan		(getIntParam(txtHoka3Tan));
		dto.setHoka4Tan		(getIntParam(txtHoka4Tan));
		dto.setHoka5Tan		(getIntParam(txtHoka5Tan));
		 */
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtYCode, NAM_YCODE, PRM_TXT_YCODE);
		checkRequired(txtYName, NAM_YNAME, PRM_TXT_YNAME);
		// ^CvmF
		checkCode(txtYCode, NAM_YCODE, PRM_TXT_YCODE);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*
		checkNumber(txtKaikinTan	, aryAllowance[ 7][1]	, PRM_TXT_KAIKINTAN	);
		checkNumber(txtSyokuJiTan	, aryAllowance[ 8][1]	, PRM_TXT_SYOKUJITAN);
		checkNumber(txtCyoku1Tan	, aryAllowance[ 9][1]	, PRM_TXT_CYOKU1TAN	);
		checkNumber(txtCyoku2Tan	, aryAllowance[10][1]	, PRM_TXT_CYOKU2TAN	);
		checkNumber(txtCyoku3Tan	, aryAllowance[11][1]	, PRM_TXT_CYOKU3TAN	);
		checkNumber(txtHoka1Tan		, aryAllowance[12][1]	, PRM_TXT_HOKA1TAN	);
		checkNumber(txtHoka2Tan		, aryAllowance[13][1]	, PRM_TXT_HOKA2TAN	);
		checkNumber(txtHoka3Tan		, aryAllowance[14][1]	, PRM_TXT_HOKA3TAN	);
		checkNumber(txtHoka4Tan		, aryAllowance[15][1]	, PRM_TXT_HOKA4TAN	);
		checkNumber(txtHoka5Tan		, aryAllowance[16][1]	, PRM_TXT_HOKA5TAN	);
		 */		
		// 񒷊mF		
		checkLength(txtYCode		, LEN_YCODE		, NAM_YCODE				, PRM_TXT_YCODE		);
		checkLength(txtYName		, LEN_YNAME		, NAM_YNAME				, PRM_TXT_YNAME		);
		/*						
		 *  	2008/10/23	m.yoshida	VerΉ
		 */
		/*		
		checkLength(txtKaikinTan	, LEN_KAIKINTAN	, aryAllowance[ 7][1]	, PRM_TXT_KAIKINTAN	);
		checkLength(txtSyokuJiTan	, LEN_SYOKUJITAN, aryAllowance[ 8][1]	, PRM_TXT_SYOKUJITAN);
		 */		
		/*		
		checkLength(txtCyoku1Tan	, LEN_CYOKU1TAN	, aryAllowance[ 9][1]	, PRM_TXT_CYOKU1TAN	);
		checkLength(txtCyoku2Tan	, LEN_CYOKU2TAN	, aryAllowance[10][1]	, PRM_TXT_CYOKU2TAN	);
		checkLength(txtCyoku3Tan	, LEN_CYOKU3TAN	, aryAllowance[11][1]	, PRM_TXT_CYOKU3TAN	);
		checkLength(txtHoka1Tan		, LEN_HOKA1TAN	, aryAllowance[12][1]	, PRM_TXT_HOKA1TAN	);
		checkLength(txtHoka2Tan		, LEN_HOKA2TAN	, aryAllowance[13][1]	, PRM_TXT_HOKA2TAN	);
		checkLength(txtHoka3Tan		, LEN_HOKA3TAN	, aryAllowance[14][1]	, PRM_TXT_HOKA3TAN	);
		checkLength(txtHoka4Tan		, LEN_HOKA4TAN	, aryAllowance[15][1]	, PRM_TXT_HOKA4TAN	);
		checkLength(txtHoka5Tan		, LEN_HOKA5TAN	, aryAllowance[16][1]	, PRM_TXT_HOKA5TAN	);
		 */
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append(getSettingJs("ARY_ALLOWANCE"		, aryAllowance));	
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtYCode()			{ return txtYCode		; }
	public String getTxtYName()			{ return txtYName		; }
	public String getPltTokyu()			{ return pltTokyu		; }
	public String getHidTKekkin()		{ return hidTKekkin		; }
	public String getPltKekkin()		{ return pltKekkin		; }
	public String getHidSKekkin()		{ return hidSKekkin		; }
	public String getPltTiJi()			{ return pltTiJi		; }
	public String getPltZaJi()			{ return pltZaJi		; }
	public String getPltKsJi()			{ return pltKsJi		; }
	public String getPltSnJi()			{ return pltSnJi		; }
	public String getPltKaikin()		{ return pltKaikin		; }
	public String getPltSyokuji()		{ return pltSyokuji		; }
	public String getPltCyoku1()		{ return pltCyoku1		; }
	public String getPltCyoku2()		{ return pltCyoku2		; }
	public String getPltCyoku3()		{ return pltCyoku3		; }
	public String getPltHoka1()			{ return pltHoka1		; }
	public String getPltHoka2()			{ return pltHoka2		; }
	public String getPltHoka3()			{ return pltHoka3		; }
	public String getPltHoka4()			{ return pltHoka4		; }
	public String getPltHoka5()			{ return pltHoka5		; }
	public String getHidTKekkinTan()	{ return hidTKekkinTan	; }
	public String getHidKekkinTan()		{ return hidKekkinTan	; }
	public String getHidSKekkinTan()	{ return hidSKekkinTan	; }
	public String getHidTiJiTan()		{ return hidTiJiTan		; }
	public String getHidZaJiTan()		{ return hidZaJiTan		; }
	public String getHidKsJiTan()		{ return hidKsJiTan		; }
	public String getHidSnJiTan()		{ return hidSnJiTan		; }
	public String getTxtKaikinTan()		{ return txtKaikinTan	; }
	public String getTxtSyokuJiTan()	{ return txtSyokuJiTan	; }
	public String getTxtCyoku1Tan()		{ return txtCyoku1Tan	; }
	public String getTxtCyoku2Tan()		{ return txtCyoku2Tan	; }
	public String getTxtCyoku3Tan()		{ return txtCyoku3Tan	; }
	public String getTxtHoka1Tan()		{ return txtHoka1Tan	; }
	public String getTxtHoka2Tan()		{ return txtHoka2Tan	; }
	public String getTxtHoka3Tan()		{ return txtHoka3Tan	; }
	public String getTxtHoka4Tan()		{ return txtHoka4Tan	; }
	public String getTxtHoka5Tan()		{ return txtHoka5Tan	; }

	public String getEscTxtYCode()		{ return escapeHTML(txtYCode)		; }
	public String getEscTxtYName()		{ return escapeHTML(txtYName)		; }
	public String getEscPltTokyu()		{ return escapeHTML(pltTokyu)		; }
	public String getEscHidTKekkin()	{ return escapeHTML(hidTKekkin)		; }
	public String getEscPltKekkin()		{ return escapeHTML(pltKekkin)		; }
	public String getEscHidSKekkin()	{ return escapeHTML(hidSKekkin)		; }
	public String getEscPltTiJi()		{ return escapeHTML(pltTiJi)		; }
	public String getEscPltZaJi()		{ return escapeHTML(pltZaJi)		; }
	public String getEscPltKsJi()		{ return escapeHTML(pltKsJi)		; }
	public String getEscPltSnJi()		{ return escapeHTML(pltSnJi)		; }
	public String getEscPltKaikin()		{ return escapeHTML(pltKaikin)		; }
	public String getEscPltSyokuji()	{ return escapeHTML(pltSyokuji)		; }
	public String getEscPltCyoku1()		{ return escapeHTML(pltCyoku1)		; }
	public String getEscPltCyoku2()		{ return escapeHTML(pltCyoku2)		; }
	public String getEscPltCyoku3()		{ return escapeHTML(pltCyoku3)		; }
	public String getEscPltHoka1()		{ return escapeHTML(pltHoka1)		; }
	public String getEscPltHoka2()		{ return escapeHTML(pltHoka2)		; }
	public String getEscPltHoka3()		{ return escapeHTML(pltHoka3)		; }
	public String getEscPltHoka4()		{ return escapeHTML(pltHoka4)		; }
	public String getEscPltHoka5()		{ return escapeHTML(pltHoka5)		; }
	public String getEscHidTKekkinTan()	{ return escapeHTML(hidTKekkinTan)	; }
	public String getEscHidKekkinTan()	{ return escapeHTML(hidKekkinTan)	; }
	public String getEscHidSKekkinTan()	{ return escapeHTML(hidSKekkinTan)	; }
	public String getEscHidTiJiTan()	{ return escapeHTML(hidTiJiTan)		; }
	public String getEscHidZaJiTan()	{ return escapeHTML(hidZaJiTan)		; }
	public String getEscHidKsJiTan()	{ return escapeHTML(hidKsJiTan)		; }
	public String getEscHidSnJiTan()	{ return escapeHTML(hidSnJiTan)		; }
	public String getEscTxtKaikinTan()	{ return escapeHTML(txtKaikinTan)	; }
	public String getEscTxtSyokuJiTan()	{ return escapeHTML(txtSyokuJiTan)	; }
	public String getEscTxtCyoku1Tan()	{ return escapeHTML(txtCyoku1Tan)	; }
	public String getEscTxtCyoku2Tan()	{ return escapeHTML(txtCyoku2Tan)	; }
	public String getEscTxtCyoku3Tan()	{ return escapeHTML(txtCyoku3Tan)	; }
	public String getEscTxtHoka1Tan()	{ return escapeHTML(txtHoka1Tan)	; }
	public String getEscTxtHoka2Tan()	{ return escapeHTML(txtHoka2Tan)	; }
	public String getEscTxtHoka3Tan()	{ return escapeHTML(txtHoka3Tan)	; }
	public String getEscTxtHoka4Tan()	{ return escapeHTML(txtHoka4Tan)	; }
	public String getEscTxtHoka5Tan()	{ return escapeHTML(txtHoka5Tan)	; }

	public void setTxtYCode		(String txtYCode		)	{ this.txtYCode 		= txtYCode		; }
	public void setTxtYName		(String txtYName		)	{ this.txtYName 		= txtYName		; }
	public void setPltTokyu		(String pltTokyu		)	{ this.pltTokyu 		= pltTokyu		; }
	public void setHidTKekkin		(String hidTKekkin		)	{ this.hidTKekkin 		= hidTKekkin	; }
	public void setPltKekkin		(String pltKekkin		)	{ this.pltKekkin 		= pltKekkin		; }
	public void setHidSKekkin		(String hidSKekkin		)	{ this.hidSKekkin 		= hidSKekkin	; }
	public void setPltTiJi			(String pltTiJi			)	{ this.pltTiJi 			= pltTiJi		; }
	public void setPltZaJi			(String pltZaJi			)	{ this.pltZaJi 			= pltZaJi		; }
	public void setPltKsJi			(String pltKsJi			)	{ this.pltKsJi 			= pltKsJi		; }
	public void setPltSnJi			(String pltSnJi			)	{ this.pltSnJi 			= pltSnJi		; }
	public void setPltKaikin		(String pltKaikin		)	{ this.pltKaikin 		= pltKaikin		; }
	public void setPltSyokuji		(String pltSyokuji		)	{ this.pltSyokuji 		= pltSyokuji	; }
	public void setPltCyoku1		(String pltCyoku1		)	{ this.pltCyoku1 		= pltCyoku1		; }
	public void setPltCyoku2		(String pltCyoku2		)	{ this.pltCyoku2 		= pltCyoku2		; }
	public void setPltCyoku3		(String pltCyoku3		)	{ this.pltCyoku3 		= pltCyoku3		; }
	public void setPltHoka1		(String pltHoka1		)	{ this.pltHoka1 		= pltHoka1		; }
	public void setPltHoka2		(String pltHoka2		)	{ this.pltHoka2 		= pltHoka2		; }
	public void setPltHoka3		(String pltHoka3		)	{ this.pltHoka3 		= pltHoka3		; }
	public void setPltHoka4		(String pltHoka4		)	{ this.pltHoka4 		= pltHoka4		; }
	public void setPltHoka5		(String pltHoka5		)	{ this.pltHoka5 		= pltHoka5		; }
	public void setHidTKekkinTan	(String hidTKekkinTan	)	{ this.hidTKekkinTan 	= hidTKekkinTan	; }
	public void setHidKekkinTan	(String hidKekkinTan	)	{ this.hidKekkinTan 	= hidKekkinTan	; }
	public void setHidSKekkinTan	(String hidSKekkinTan	)	{ this.hidSKekkinTan 	= hidSKekkinTan	; }
	public void setHidTiJiTan		(String hidTiJiTan		)	{ this.hidTiJiTan 		= hidTiJiTan	; }
	public void setHidZaJiTan		(String hidZaJiTan		)	{ this.hidZaJiTan 		= hidZaJiTan	; }
	public void setHidKsJiTan		(String hidKsJiTan		)	{ this.hidKsJiTan 		= hidKsJiTan	; }
	public void setHidSnJiTan		(String hidSnJiTan		)	{ this.hidSnJiTan 		= hidSnJiTan	; }
	public void setTxtKaikinTan	(String txtKaikinTan	)	{ this.txtKaikinTan 	= txtKaikinTan	; }
	public void setTxtSyokuJiTan	(String txtSyokuJiTan	)	{ this.txtSyokuJiTan	= txtSyokuJiTan	; }
	public void setTxtCyoku1Tan	(String txtCyoku1Tan	)	{ this.txtCyoku1Tan 	= txtCyoku1Tan	; }
	public void setTxtCyoku2Tan	(String txtCyoku2Tan	)	{ this.txtCyoku2Tan 	= txtCyoku2Tan	; }
	public void setTxtCyoku3Tan	(String txtCyoku3Tan	)	{ this.txtCyoku3Tan 	= txtCyoku3Tan	; }
	public void setTxtHoka1Tan		(String txtHoka1Tan		)	{ this.txtHoka1Tan 		= txtHoka1Tan	; }
	public void setTxtHoka2Tan		(String txtHoka2Tan		)	{ this.txtHoka2Tan 		= txtHoka2Tan	; }
	public void setTxtHoka3Tan		(String txtHoka3Tan		)	{ this.txtHoka3Tan 		= txtHoka3Tan	; }
	public void setTxtHoka4Tan		(String txtHoka4Tan		)	{ this.txtHoka4Tan 		= txtHoka4Tan	; }
	public void setTxtHoka5Tan		(String txtHoka5Tan		)	{ this.txtHoka5Tan 		= txtHoka5Tan	; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

	public String[][] getAryAllowance() { return aryAllowance.clone(); }

}
