/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

public class CmCodeCardVo extends MosPVo {

	private static final long serialVersionUID = -1356242375010280961L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/cmcodeCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/cmcodeCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/cmcodeCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_COMMON_CODE_MASTER;

	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;

	// p[^
	public static final String PRM_PLT_T_ID       = "pltTId";
	public static final String PRM_TXT_T_CODE     = "txtTCode";
	public static final String PRM_TXT_T_NAME     = "txtTName";
	public static final String PRM_TXT_VIEW_INDEX = "txtViewIndex";
	public static final String PRM_PLT_DELETE     = "pltDelete";

	// tB[h
	private String pltTId;
	private String txtTCode;
	private String txtTName;
	private String txtViewIndex;
	private String pltDelete;

	// v_EXg
	public String[][] aryPltTId;

	// [h(0FVKo^A1FXV)
	private int mode;

	// tB[hyѐ
	public static final String NAM_CODE_ID = CommonConst.NAM_COMMON_CODE + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_CODE    = CommonConst.NAM_COMMON_CODE;
	public static final String NAM_NAME    = CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_INDEX   = CommonConst.NAM_SHOW_ORDER;
	public static final String NAM_DELETE  = CommonConst.NAM_DELETE_FLAG;
	public static final int    LEN_CODE_ID = 10;
	public static final int    LEN_CODE    = 8;
	public static final int    LEN_NAME    = 16;
	public static final int    LEN_INDEX   = 3;
	public static final String REG_DELETE  = CommonConst.REG_DELETE;

	/**
	 * RXgN^
	 */
	public CmCodeCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltTId       = request.getParameter(PRM_PLT_T_ID);
		txtTCode     = request.getParameter(PRM_TXT_T_CODE);
		txtTName     = request.getParameter(PRM_TXT_T_NAME);
		txtViewIndex = request.getParameter(PRM_TXT_VIEW_INDEX);
		pltDelete    = request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param dto [U[Xg
	 */
	public void setFields(CmCodeDto dto) {
		// f[^̐ݒ
		pltTId       = dto.getTId();
		txtTCode     = dto.getTCode();
		txtTName     = dto.getTName();
		txtViewIndex = String.valueOf(dto.getViewIndex());
		pltDelete    = String.valueOf(dto.getDeleteFlag());
	}

	/**
	 * tB[h̑ÓmF
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws MospException
	 */
	public void validate(boolean isInsert) throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltTId      , NAM_CODE_ID, PRM_PLT_T_ID  );
		checkRequired(txtTCode    , NAM_CODE   , PRM_TXT_T_CODE);
		checkRequired(txtTName    , NAM_NAME   , PRM_TXT_T_NAME);
		checkRequired(pltDelete   , NAM_DELETE , PRM_PLT_DELETE);
		// ^CvmF
		checkCode    (pltTId      , NAM_CODE_ID, PRM_PLT_T_ID              );
		checkCode    (txtTCode    , NAM_CODE   , PRM_TXT_T_CODE            );
		checkNumber  (txtViewIndex, NAM_INDEX  , PRM_TXT_VIEW_INDEX        );
		checkRegex   (pltDelete   , REG_DELETE , NAM_DELETE, PRM_PLT_DELETE);
		// 񒷊mF
		checkLength  (pltTId      , LEN_CODE_ID, NAM_CODE_ID, PRM_PLT_T_ID      );
		checkLength  (txtTCode    , LEN_CODE   , NAM_CODE   , PRM_TXT_T_CODE    );
		checkLength  (txtTName    , LEN_NAME   , NAM_NAME   , PRM_TXT_T_NAME    );
		checkLength  (txtViewIndex, LEN_INDEX  , NAM_INDEX  , PRM_TXT_VIEW_INDEX);
		// R[h敪mF
		if (isInsert && (
				pltTId.equals(CommonConst.TID_AUTHORITY    )
				/*						
				 ||
				pltTId.equals(CommonConst.TID_FIELD        ) ||
				pltTId.equals(CommonConst.TID_HOLIDAY_TYPE ) ||
				pltTId.equals(CommonConst.TID_PAYMENT_TYPE ) ||
				pltTId.equals(CommonConst.TID_OVERTIME_TYPE) ||
				pltTId.equals(CommonConst.TID_TIME         ) ||
				pltTId.equals(CommonConst.TID_TOTAL_TYPE   ) ||
				pltTId.equals(CommonConst.TID_TRAIN        ) ||
				pltTId.equals(CommonConst.TID_ACCOUNT_TYPE ) ||
				pltTId.equals(CommonConst.TID_PAYMENT_MEANS) ||
				pltTId.equals(CommonConst.TID_AMOUNT_TYPE  )
				 */				
		)
		) {
			String errMsg = MospUtility.getMessage(msg, CommonConst.MSG_DISABLE_TID, "");
			addErrMessage(errMsg);
			addErrField(PRM_PLT_T_ID);
			isValid = false;
		}
		// ÓmFI
		endValidation();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmCodeDto dto) {
		dto.setTId(pltTId);
		dto.setTCode(txtTCode);
		dto.setTName(txtTName);
		if (txtViewIndex == null || txtViewIndex.equals("")) {
			dto.setViewIndex(0);
		} else {
			dto.setViewIndex(Integer.parseInt(txtViewIndex));
		}
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public void setPltTId   (String pPltTId  	) { this.pltTId   		= pPltTId	; }
	public void setTxtTCode (String pTxtTCode	) { this.txtTCode 		= pTxtTCode	; }
	public void setTxtTName (String pTxtTName	) { this.txtTName 		= pTxtTName	; }
	public void setTxtIndex (String pTxtIndex	) { this.txtViewIndex 	= pTxtIndex	; }
	public void setPltDelete(String pPltDelete	) { this.pltDelete 		= pPltDelete; }

	public String getPltTId     () { return pltTId			; }
	public String getTxtTCode   () { return txtTCode		; }
	public String getTxtTName   () { return txtTName		; }
	public String getTxtIndex   () { return txtViewIndex	; }
	public String getPltDelete  () { return pltDelete		; }
	public String getEscPltTId  () { return escapeHTML(pltTId)			; }
	public String getEscTxtTCode() { return escapeHTML(txtTCode)		; }
	public String getEscTxtTName() { return escapeHTML(txtTName)		; }
	public String getEscTxtIndex() { return escapeHTML(txtViewIndex)	; }
	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
