/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.vo.HolidayMasterListVo;

public class HolidayMasterListAction extends MosPAction {

	// R}h
	private static final String CMD_HOLIDAY_MASTER_LIST_SHOW      = "S2710";	// \
	private static final String CMD_HOLIDAY_MASTER_LIST_SELECT    = "S2711";	// 
	private static final String CMD_HOLIDAY_MASTER_LIST_RE_SEARCH = "S2712";	// Č
	private static final String CMD_HOLIDAY_MASTER_LIST_SORT      = "S2713";	// \[g

	/**
	 * RXgN^
	 */
	public HolidayMasterListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		HolidayMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof HolidayMasterListVo) {
			vo = (HolidayMasterListVo)obj;
		} else {
			vo = new HolidayMasterListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏		
		if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_SHOW)) {
			// lɃZbg
			vo.setSearchmode(HolidayMasterListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_SELECT)) {
			// 
			vo.setParams(request);
			searchHolidayList(vo);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(HolidayMasterListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_RE_SEARCH)) {
			// Č
			if (vo.getSearchmode() == HolidayMasterListVo.SEARCH_ON) {
				session.removeAttribute(MospConst.ATT_DTO);
				searchHolidayList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_HOLIDAY_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * xXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchHolidayList(HolidayMasterListVo vo) throws Exception {
		// 
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForHoliday(CommonConst.NAM_HOLIDAY, vo.getTxtHDate(), vo.getTxtHName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryHDate().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, HolidayMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(HolidayMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, HolidayMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_H_CODE)) {
			comp = new CompHCode();
		} else if (key.equals(vo.KEY_H_NAME)) {
			comp = new CompHName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompHCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5324184931004173732L;
		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTCode().compareTo(dto2.getTCode());
		}
	}

	/**
	 * R[ĥɂrNX
	 */
	protected static class CompHName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -3122154963469415094L;
		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTName().compareTo(dto2.getTName());
		}
	}

}
