/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmCodeDto;


import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.vo.CmCodeListVo;

public class CmCodeListAction extends MosPAction {

	// R}h
	private static final String CMD_CODE_CARD_SHOW      = "S2000";	// \
	private static final String CMD_CODE_CARD_SELECT    = "S2001";	// 
	private static final String CMD_CODE_LIST_RE_SEARCH = "S2002";	// Č
	private static final String CMD_CODE_CARD_SORT      = "S2003";	// \[g

	/**
	 * RXgN^
	 */
	public CmCodeListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		CmCodeListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof CmCodeListVo) {
			vo = (CmCodeListVo)obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new CmCodeListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_CODE_CARD_SHOW)) {
			// \
			getConnection();
			// R[h敪v_EXg쐬
			vo.aryPltTId = getCodeArray();
			// 폜tÕv_EXg쐬
			vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
			// lɃZbg
			vo.setSearchmode(0);
		} else if (cmd.equals(CMD_CODE_CARD_SELECT)) {
			// 
			vo.setParams(request);
			searchCodeList(vo);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(1);
		} else if (cmd.equals(CMD_CODE_LIST_RE_SEARCH)) {
			// Č
			if(vo.getSearchmode() == 1){
				session.removeAttribute(MospConst.ATT_DTO);
				searchCodeList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_CODE_CARD_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * R[hXg
	 * @param vo CodeListVoCX^X
	 * @throws Exception
	 */
	private void searchCodeList(CmCodeListVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// 
		CmCodeDao dao = new CmCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForSearch(vo.getPltTId(),vo.getTxtTCode(),vo.getTxtTName(),vo.getPltDelete()));
		setCodeTypeName(vo);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryTCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * R[h敪̐ݒ
	 * @param vo CodeListVoCX^X
	 * @throws Exception 
	 */
	private void setCodeTypeName(CmCodeListVo vo) throws Exception {
		String[] aryCodeTypeName = new String[vo.getList().size()];
		for (int i = 0; i < vo.getList().size(); i++) {
			CmCodeDto dto = (CmCodeDto)vo.getList().get(i);
			aryCodeTypeName[i] = getCodeTypeName(dto.getTId());
		}
		vo.setAryTIdName(aryCodeTypeName);
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws Exception 
	 */
	private void sortList(String key, CmCodeListVo vo) throws Exception {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
		setCodeTypeName(vo);
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws Exception 
	 */
	private void sortList(CmCodeListVo vo) throws Exception {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
		setCodeTypeName(vo);
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, CmCodeListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_T_ID)) {
			comp = new CompTId();
		} else if (key.equals(vo.KEY_T_CODE)) {
			comp = new CompTCode();
		} else if (key.equals(vo.KEY_T_NAME)) {
			comp = new CompTName();
		} else if (key.equals(vo.KEY_VIEWINDEX)) {
			comp = new CompViewIndex();
		}else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * R[h敪ɂrNX
	 */
	protected static class CompTId implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 7210303772053153377L;
		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getTId().compareTo(dto2.getTId());
		}
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompTCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 5672044129524635759L;
		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getTCode().compareTo(dto2.getTCode());
		}
	}

	/**
	 * R[ĥɂrNX
	 */
	protected static class CompTName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -8615320106870669507L;
		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getTName().compareTo(dto2.getTName());
		}
	}

	/**
	 * \ɂrNX
	 */
	protected static class CompViewIndex implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 2787828366453888987L;
		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto1.getViewIndex() - (dto2.getViewIndex());
		}
	}

	/**
	 * 폜tOɂrNX
	 */
	static class CompDeleteFlag implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -1824284390861851592L;
		public int compare(Object obj1, Object obj2) {
			CmCodeDto dto1 = (CmCodeDto)obj1;
			CmCodeDto dto2 = (CmCodeDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}

}
