package jp.mosp.payroll.system.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.DetailDto;
import jp.mosp.payroll.system.action.DetailListAction;

/**
 * אݒꗗʂɂB<br><br>
 */
public class DetailListVo extends PayrollVo {
	
	private static final long serialVersionUID = 1654283456674729802L;
	
	// tB[h
	private String pltType  ;
	private String txtAbbr  ;
	private String pltDelete;
	
	// tB[h(ꗗ)
	private String[] aryType  ;
	private String[] aryCode  ;
	private String[] aryName  ;
	private String[] aryAbbr  ;
	private String[] aryDelete;
	
	// v_E
	private String[][] pitType;
	
	/**
	 * p[^(敪)B
	 */
	public static final String PRM_PLT_TYPE = "pltType";
	
	/**
	 * p[^()B
	 */
	public static final String PRM_TXT_ABBR = "txtAbbr";
	
	/**
	 * p[^(폜tO)B
	 */
	public static final String PRM_PLT_DELETE = "pltDelete";
	
	/**
	 * ڒ(ח)
	 */
	public static final int LEN_ABBR = PayrollConst.LEN_DETAIL_ABBR;
	
	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public DetailListVo() {
		super();
		aryType   = new String[0];
		aryCode   = new String[0];
		aryName   = new String[0];
		aryAbbr   = new String[0];
		aryDelete = new String[0];
		setPageCommand(DetailListAction.CMD_PAGE);
		setSortKey("1");
	}
	
	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		pitType = getDetailTypeArray();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_DETAIL") + getName("P_SETTING");
		addAryMenu("P1002", getName("P_PAYMENT") +
				getName("P_CALCULATE") + getName("C_MASTER") + getName("C_TO"));
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltType   = request.getParameter(PRM_PLT_TYPE  );
		txtAbbr   = request.getParameter(PRM_TXT_ABBR  );
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ肷B<br>
	 * @param list DTOXg
	 */
	public void setFields(List<?> list) {
		// f[^̎擾
		count = list.size();
		// z̏
		aryType   = new String[count];
		aryCode   = new String[count];
		aryName   = new String[count];
		aryAbbr   = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		for (int i = 0; i < list.size(); i++) {
			DetailDto dto = (DetailDto)list.get(i);
			aryType  [i] = getCodeName(pltType, pitType);
			aryCode  [i] = dto.getDetailCode();
			aryName  [i] = dto.getDetailName();
			aryAbbr  [i] = dto.getDetailAbbr();
			aryDelete[i] = getDeleteName(dto.getDeleteFlag());
		}
	}

	/**
	 * (ꗗ)擾B
	 * @param idx CfbNX
	 * @return 
	 */
	public String getAryAbbr(int idx) {
		return escapeHTML(aryAbbr[idx]);
	}
	
	/**
	 * R[h(ꗗ)擾B
	 * @param idx CfbNX
	 * @return R[h
	 */
	public String getAryCode(int idx) {
		return escapeHTML(aryCode[idx]);
	}
	
	/**
	 * 폜tO(ꗗ)擾B
	 * @param idx CfbNX
	 * @return 폜tO
	 */
	public String getAryDelete(int idx) {
		return escapeHTML(aryDelete[idx]);
	}
	
	/**
	 * (ꗗ)擾B
	 * @param idx CfbNX
	 * @return 
	 */
	public String getAryName(int idx) {
		return escapeHTML(aryName[idx]);
	}
	
	/**
	 * 敪(ꗗ)擾B
	 * @param idx CfbNX
	 * @return 敪
	 */
	public String getAryType(int idx) {
		return escapeHTML(aryType[idx]);
	}
	
	/**
	 * 敪v_EACe擾B
	 * @return 敪v_EACe
	 */
	public String[][] getPitType() {
		return getAryField(pitType);
	}

	/**
	 * 敪v_EACeݒ肷B
	 * @param pitType ݒ肷敪v_EACe
	 */
	public void setPitType(String[][] pitType) {
		this.pitType = getAryField(pitType);
	}

	/**
	 * 폜tO擾B
	 * @return 폜tO
	 */
	public String getPltDelete() {
		return pltDelete;
	}

	/**
	 * 폜tOݒ肷B
	 * @param pltDelete ݒ肷폜tO
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}

	/**
	 * 敪擾B
	 * @return 敪
	 */
	public String getPltType() {
		return pltType;
	}

	/**
	 * 敪ݒ肷B
	 * @param pltType ݒ肷敪
	 */
	public void setPltType(String pltType) {
		this.pltType = pltType;
	}

	/**
	 * ̂擾B
	 * @return 
	 */
	public String getTxtAbbr() {
		return txtAbbr;
	}

	/**
	 * ̂ݒ肷B
	 * @param txtAbbr ݒ肷闪
	 */
	public void setTxtAbbr(String txtAbbr) {
		this.txtAbbr = txtAbbr;
	}

	/**
	 * ̂擾B
	 * @return 
	 */
	public String getEscTxtAbbr() {
		return escapeHTML(txtAbbr);
	}
	
}
