package jp.mosp.payroll.report.dto;

import java.sql.SQLException;
import java.util.List;
import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.DatePart;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.CalculateAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.PhPaymentDto;

public class WithholdingListDto extends BaseDto {

	private static final long serialVersionUID = 2613587750422757053L;
	
	// tB[h
	private String adjustYear_YY;	// NNx(N̂)
	private String adjustYear  ;	// NNx
	private String stationCode ;	// R[h
	private String stationName ;	// 
	private String positionCode;	// EʃR[h
	private String positionName;	// Eʖ
	private String	touKyu;			// 

	private String kCode       ;	// ЈR[h
	private String kName       ;	// Ј
	private String fName		;   // tKi
	private String postalCode  ;	// X֔ԍ
	private String address     ;	// Z

	private String birthDate   ;	// N

	private String  paymentMonth_01       ;	// x01
	private String  paymentMonth_02       ;	// x02
	private String  paymentMonth_03       ;	// x03
	private String  paymentMonth_04       ;	// x04
	private String  paymentMonth_05       ;	// x05
	private String  paymentMonth_06       ;	// x06
	private String  paymentMonth_07       ;	// x07
	private String  paymentMonth_08       ;	// x08
	private String  paymentMonth_09       ;	// x09
	private String  paymentMonth_10       ;	// x10
	private String  paymentMonth_11       ;	// x11
	private String  paymentMonth_12       ;	// x12
	private String  paymentPayDay_01      ;	// x01
	private String  paymentPayDay_02      ;	// x02
	private String  paymentPayDay_03      ;	// x03
	private String  paymentPayDay_04      ;	// x04
	private String  paymentPayDay_05      ;	// x05
	private String  paymentPayDay_06      ;	// x06
	private String  paymentPayDay_07      ;	// x07
	private String  paymentPayDay_08      ;	// x08
	private String  paymentPayDay_09      ;	// x09
	private String  paymentPayDay_10      ;	// x10
	private String  paymentPayDay_11      ;	// x11
	private String  paymentPayDay_12      ;	// x12
	private Integer  payTotalAllowance_01  ;	// xz01 
	private Integer  payTotalAllowance_02  ;	// xz02
	private Integer  payTotalAllowance_03  ;	// xz03
	private Integer  payTotalAllowance_04  ;	// xz04
	private Integer  payTotalAllowance_05  ;	// xz05
	private Integer  payTotalAllowance_06  ;	// xz06
	private Integer  payTotalAllowance_07  ;	// xz07
	private Integer  payTotalAllowance_08  ;	// xz08
	private Integer  payTotalAllowance_09  ;	// xz09
	private Integer  payTotalAllowance_10  ;	// xz10
	private Integer  payTotalAllowance_11  ;	// xz11
	private Integer  payTotalAllowance_12  ;	// xz12
	private Integer  payTaxFree_01         ;	// ېŊz01
	private Integer  payTaxFree_02         ;	// ېŊz02
	private Integer  payTaxFree_03         ;	// ېŊz03
	private Integer  payTaxFree_04         ;	// ېŊz04
	private Integer  payTaxFree_05         ;	// ېŊz05
	private Integer  payTaxFree_06         ;	// ېŊz06
	private Integer  payTaxFree_07         ;	// ېŊz07
	private Integer  payTaxFree_08         ;	// ېŊz08
	private Integer  payTaxFree_09         ;	// ېŊz09
	private Integer  payTaxFree_10         ;	// ېŊz10
	private Integer  payTaxFree_11         ;	// ېŊz11
	private Integer  payTaxFree_12         ;	// ېŊz12
	private Integer  payTaxation_01        ;	// ېŎxz01
	private Integer  payTaxation_02        ;	// ېŎxz02
	private Integer  payTaxation_03        ;	// ېŎxz03
	private Integer  payTaxation_04        ;	// ېŎxz04
	private Integer  payTaxation_05        ;	// ېŎxz05
	private Integer  payTaxation_06        ;	// ېŎxz06
	private Integer  payTaxation_07        ;	// ېŎxz07
	private Integer  payTaxation_08        ;	// ېŎxz08
	private Integer  payTaxation_09        ;	// ېŎxz09
	private Integer  payTaxation_10        ;	// ېŎxz10
	private Integer  payTaxation_11        ;	// ېŎxz11
	private Integer  payTaxation_12        ;	// ېŎxz12
	private Integer  paySocInsDeduction_01 ;	// Љی01
	private Integer  paySocInsDeduction_02 ;	// Љی02
	private Integer  paySocInsDeduction_03 ;	// Љی03
	private Integer  paySocInsDeduction_04 ;	// Љی04
	private Integer  paySocInsDeduction_05 ;	// Љی05
	private Integer  paySocInsDeduction_06 ;	// Љی06
	private Integer  paySocInsDeduction_07 ;	// Љی07
	private Integer  paySocInsDeduction_08 ;	// Љی08
	private Integer  paySocInsDeduction_09 ;	// Љی09
	private Integer  paySocInsDeduction_10 ;	// Љی10
	private Integer  paySocInsDeduction_11 ;	// Љی11
	private Integer  paySocInsDeduction_12 ;	// Љی12
	private Integer  payPayInsDeduction_01 ;	// ЉیT̋^̋z01
	private Integer  payPayInsDeduction_02 ;	// ЉیT̋^̋z02
	private Integer  payPayInsDeduction_03 ;	// ЉیT̋^̋z03
	private Integer  payPayInsDeduction_04 ;	// ЉیT̋^̋z04
	private Integer  payPayInsDeduction_05 ;	// ЉیT̋^̋z05
	private Integer  payPayInsDeduction_06 ;	// ЉیT̋^̋z06
	private Integer  payPayInsDeduction_07 ;	// ЉیT̋^̋z07
	private Integer  payPayInsDeduction_08 ;	// ЉیT̋^̋z08
	private Integer  payPayInsDeduction_09 ;	// ЉیT̋^̋z09
	private Integer  payPayInsDeduction_10 ;	// ЉیT̋^̋z10
	private Integer  payPayInsDeduction_11 ;	// ЉیT̋^̋z11
	private Integer  payPayInsDeduction_12 ;	// ЉیT̋^̋z12
	private Integer  payDependentCount_01  ;	// }{e(^)01
	private Integer  payDependentCount_02  ;	// }{e(^)02
	private Integer  payDependentCount_03  ;	// }{e(^)03
	private Integer  payDependentCount_04  ;	// }{e(^)04
	private Integer  payDependentCount_05  ;	// }{e(^)05
	private Integer  payDependentCount_06  ;	// }{e(^)06
	private Integer  payDependentCount_07  ;	// }{e(^)07
	private Integer  payDependentCount_08  ;	// }{e(^)08
	private Integer  payDependentCount_09  ;	// }{e(^)09
	private Integer  payDependentCount_10  ;	// }{e(^)10
	private Integer  payDependentCount_11  ;	// }{e(^)11
	private Integer  payDependentCount_12  ;	// }{e(^)12
	private Integer  payIncomeTax_01       ;	// 01 
	private Integer  payIncomeTax_02       ;	// 02
	private Integer  payIncomeTax_03       ;	// 03
	private Integer  payIncomeTax_04       ;	// 04
	private Integer  payIncomeTax_05       ;	// 05
	private Integer  payIncomeTax_06       ;	// 06
	private Integer  payIncomeTax_07       ;	// 07
	private Integer  payIncomeTax_08       ;	// 08
	private Integer  payIncomeTax_09       ;	// 09
	private Integer  payIncomeTax_10       ;	// 10
	private Integer  payIncomeTax_11       ;	// 11
	private Integer  payIncomeTax_12       ;	// 12
	private Integer  payAdjCalcGap_01      ;	// Nɂߕs01
	private Integer  payAdjCalcGap_02      ;	// Nɂߕs02
	private Integer  payAdjCalcGap_03      ;	// Nɂߕs03
	private Integer  payAdjCalcGap_04      ;	// Nɂߕs04
	private Integer  payAdjCalcGap_05      ;	// Nɂߕs05
	private Integer  payAdjCalcGap_06      ;	// Nɂߕs06
	private Integer  payAdjCalcGap_07      ;	// Nɂߕs07
	private Integer  payAdjCalcGap_08      ;	// Nɂߕs08
	private Integer  payAdjCalcGap_09      ;	// Nɂߕs09
	private Integer  payAdjCalcGap_10      ;	// Nɂߕs10
	private Integer  payAdjCalcGap_11      ;	// Nɂߕs11
	private Integer  payAdjCalcGap_12      ;	// Nɂߕs12
	private Integer  payVariousDeduction_01;	// T01
	private Integer  payVariousDeduction_02;	// T02
	private Integer  payVariousDeduction_03;	// T03
	private Integer  payVariousDeduction_04;	// T04
	private Integer  payVariousDeduction_05;	// T05
	private Integer  payVariousDeduction_06;	// T06
	private Integer  payVariousDeduction_07;	// T07
	private Integer  payVariousDeduction_08;	// T08
	private Integer  payVariousDeduction_09;	// T09
	private Integer  payVariousDeduction_10;	// T10
	private Integer  payVariousDeduction_11;	// T11
	private Integer  payVariousDeduction_12;	// T12
	private Integer  payPaymentTotal_01    ;	// xz01
	private Integer  payPaymentTotal_02    ;	// xz02
	private Integer  payPaymentTotal_03    ;	// xz03
	private Integer  payPaymentTotal_04    ;	// xz04
	private Integer  payPaymentTotal_05    ;	// xz05
	private Integer  payPaymentTotal_06    ;	// xz06
	private Integer  payPaymentTotal_07    ;	// xz07
	private Integer  payPaymentTotal_08    ;	// xz08
	private Integer  payPaymentTotal_09    ;	// xz09
	private Integer  payPaymentTotal_10    ;	// xz10
	private Integer  payPaymentTotal_11    ;	// xz11
	private Integer  payPaymentTotal_12    ;	// xz12

	private Integer  payPaymentTax_01    	;	// Ŋz01
	private Integer  payPaymentTax_02    	;	// Ŋz02
	private Integer  payPaymentTax_03    	;	// Ŋz03
	private Integer  payPaymentTax_04    	;	// Ŋz04
	private Integer  payPaymentTax_05    	;	// Ŋz05
	private Integer  payPaymentTax_06    	;	// Ŋz06
	private Integer  payPaymentTax_07    	;	// Ŋz07
	private Integer  payPaymentTax_08    	;	// Ŋz08
	private Integer  payPaymentTax_09    	;	// Ŋz09
	private Integer  payPaymentTax_10    	;	// Ŋz10
	private Integer  payPaymentTax_11    	;	// Ŋz11
	private Integer  payPaymentTax_12    	;	// Ŋz12
	
	private String  bonusMonth_01         ;	// x(ܗ^)01
	private String  bonusMonth_02         ;	// x(ܗ^)02
	private String  bonusMonth_03         ;	// x(ܗ^)03
	private String  bonusMonth_04         ;	// x(ܗ^)04
	private String  bonusMonth_05         ;	// x(ܗ^)05
	private String  bonusMonth_06         ;	// x(ܗ^)06
	private String  bonusPayDay_01      ;	// x(ܗ^)01
	private String  bonusPayDay_02      ;	// x(ܗ^)02
	private String  bonusPayDay_03      ;	// x(ܗ^)03
	private String  bonusPayDay_04      ;	// x(ܗ^)04
	private String  bonusPayDay_05      ;	// x(ܗ^)05
	private String  bonusPayDay_06      ;	// x(ܗ^)06
	private Integer  bonTotalAllowance_01  ;	// xz(ܗ^01)
	private Integer  bonTotalAllowance_02  ;	// xz(ܗ^02)
	private Integer  bonTotalAllowance_03  ;	// xz(ܗ^03)
	private Integer  bonTotalAllowance_04  ;	// xz(ܗ^04)
	private Integer  bonTotalAllowance_05  ;	// xz(ܗ^05)
	private Integer  bonTotalAllowance_06  ;	// xz(ܗ^06)
	private Integer  bonTaxFree_01         ;	// ېŊz(ܗ^)01
	private Integer  bonTaxFree_02         ;	// ېŊz(ܗ^)02
	private Integer  bonTaxFree_03         ;	// ېŊz(ܗ^)03
	private Integer  bonTaxFree_04         ;	// ېŊz(ܗ^)04
	private Integer  bonTaxFree_05         ;	// ېŊz(ܗ^)05
	private Integer  bonTaxFree_06         ;	// ېŊz(ܗ^)05
	private Integer  bonTaxation_01        ;	// ېŎxz(ܗ^)01
	private Integer  bonTaxation_02        ;	// ېŎxz(ܗ^)02
	private Integer  bonTaxation_03        ;	// ېŎxz(ܗ^)03
	private Integer  bonTaxation_04        ;	// ېŎxz(ܗ^)04
	private Integer  bonTaxation_05        ;	// ېŎxz(ܗ^)05
	private Integer  bonTaxation_06        ;	// ېŎxz(ܗ^)06
	private Integer  bonSocInsDeduction_01 ;	// Љی(ܗ^)01
	private Integer  bonSocInsDeduction_02 ;	// Љی(ܗ^)02
	private Integer  bonSocInsDeduction_03 ;	// Љی(ܗ^)03
	private Integer  bonSocInsDeduction_04 ;	// Љی(ܗ^)04
	private Integer  bonSocInsDeduction_05 ;	// Љی(ܗ^)05
	private Integer  bonSocInsDeduction_06 ;	// Љی(ܗ^)06
	private Integer  bonPayInsDeduction_01 ;	// ЉیT̋^̋z(ܗ^)01
	private Integer  bonPayInsDeduction_02 ;	// ЉیT̋^̋z(ܗ^)02
	private Integer  bonPayInsDeduction_03 ;	// ЉیT̋^̋z(ܗ^)03
	private Integer  bonPayInsDeduction_04 ;	// ЉیT̋^̋z(ܗ^)04
	private Integer  bonPayInsDeduction_05 ;	// ЉیT̋^̋z(ܗ^)05
	private Integer  bonPayInsDeduction_06 ;	// ЉیT̋^̋z(ܗ^)06
	private Integer  bonDependentCount_01  ;	// }{e(ܗ^)01
	private Integer  bonDependentCount_02  ;	// }{e(ܗ^)02
	private Integer  bonDependentCount_03  ;	// }{e(ܗ^)03
	private Integer  bonDependentCount_04  ;	// }{e(ܗ^)04
	private Integer  bonDependentCount_05  ;	// }{e(ܗ^)05
	private Integer  bonDependentCount_06  ;	// }{e(ܗ^)06

	private Integer  bonIncomeTax_01       ;	// (ܗ^)01
	private Integer  bonIncomeTax_02       ;	// (ܗ^)02
	private Integer  bonIncomeTax_03       ;	// (ܗ^)03
	private Integer  bonIncomeTax_04       ;	// (ܗ^)04
	private Integer  bonIncomeTax_05       ;	// (ܗ^)05
	private Integer  bonIncomeTax_06       ;	// (ܗ^)06
	private Float  bonIncomeTaxRate_01       ;	// ŗ(ܗ^)01
	private Float  bonIncomeTaxRate_02       ;	// ŗ(ܗ^)02
	private Float  bonIncomeTaxRate_03       ;	// ŗ(ܗ^)03
	private Float  bonIncomeTaxRate_04       ;	// ŗ(ܗ^)04
	private Float  bonIncomeTaxRate_05       ;	// ŗ(ܗ^)05
	private Float  bonIncomeTaxRate_06       ;	// ŗ(ܗ^)06
	
	private Integer  bonAdjCalcGap_01      ;	// Nɂߕs(ܗ^)01
	private Integer  bonAdjCalcGap_02      ;	// Nɂߕs(ܗ^)02
	private Integer  bonAdjCalcGap_03      ;	// Nɂߕs(ܗ^)03
	private Integer  bonAdjCalcGap_04      ;	// Nɂߕs(ܗ^)04
	private Integer  bonAdjCalcGap_05      ;	// Nɂߕs(ܗ^)05
	private Integer  bonAdjCalcGap_06      ;	// Nɂߕs(ܗ^)06
	private Integer  bonVariousDeduction_01;	// T(ܗ^)01
	private Integer  bonVariousDeduction_02;	// T(ܗ^)02
	private Integer  bonVariousDeduction_03;	// T(ܗ^)03
	private Integer  bonVariousDeduction_04;	// T(ܗ^)04
	private Integer  bonVariousDeduction_05;	// T(ܗ^)05
	private Integer  bonVariousDeduction_06;	// T(ܗ^)06
	private Integer  bonPaymentTotal_01    ;	// xz(ܗ^)01
	private Integer  bonPaymentTotal_02    ;	// xz(ܗ^)02
	private Integer  bonPaymentTotal_03    ;	// xz(ܗ^)03
	private Integer  bonPaymentTotal_04    ;	// xz(ܗ^)04
	private Integer  bonPaymentTotal_05    ;	// xz(ܗ^)05
	private Integer  bonPaymentTotal_06    ;	// xz(ܗ^)06

	private Integer  bonPaymentTax_01	    ;	// (ܗ^)01
	private Integer  bonPaymentTax_02	    ;	// (ܗ^)02
	private Integer  bonPaymentTax_03	    ;	// (ܗ^)03
	private Integer  bonPaymentTax_04	    ;	// (ܗ^)04
	private Integer  bonPaymentTax_05	    ;	// (ܗ^)05
	private Integer  bonPaymentTax_06	    ;	// (ܗ^)06

	
	private Integer  totalAllowance        ;	// xzv
	private Integer  taxFree               ;	// ېŊzv
	private Integer  taxation              ;	// ېŊzv
	private Integer  socInsDeduction       ;	// Љیv 
	private Integer  totalPayInsDeduction  ;	// ЉیT̋^̋zv
	private Integer  incomeTax             ;	// ōv
	private Integer  variousDeduction      ;	// Tv
	private Integer  paymentTotal          ;	// xzv

	private Integer  midwayType            ;	// rЋ敪
	private Integer  formerIncome          ;	// OΖz
	private Integer  formerInsurance       ;	// OΖЉیz
	private Integer  formerTax             ;	// OΖ揊Ŋz
	
	private Integer  paymentAllowance      ;	// ^A蓖z
	private Integer  paymentIncomeTax      ;	// ^A蓖Ŋz
	private Integer  bonusAllowance        ;	// ܗ^z
	private Integer  bonusIncomeTax        ;	// ܗ^Ŋz
	private Integer  midwayAdjustIncome    ;	// rAz
	private Integer  midwayAdjustTax       ;	// rAŊz
	private Integer  adjTotalAllowance     ;	// xzv
	private Integer  adjTotalIncome        ;	// Ŋzv
	private Integer  afterDeductIncome        ;	// ^T̋^̋z
	private Integer  payInsDeduction          ;	// Љی^̍T
	private Integer  socialInsDeduction       ;	// ЉیTz
	private Integer  mutualAidDeduction       ;	// K͊Ƌϓ|Tz
	private Integer  lifeInsDeduction         ;	// یTz
	private Integer  damageInsDeduction       ;	// QیTz
	private Integer  spouseSpDeduction        ;	// zғʍTz
	private Integer  dependentsDeduction      ;	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	private Integer  incomeDeductSum          ;	// Tzv
	private Integer  finalIncomeTax           ;	// NŊz
	private Integer  houseLoanDeduction       ;	// ZؓʍTz
	private Integer  taxGap    		       ;	// Ŋz擾
	private Integer  calcTaxedIncome          ;	// ېŋ^z
	private Integer  spouseSumIncome          ;	// z҂̖{N̍vžϊz
	private Integer  generalLifeIns           ;	// ʂ̐ی
	private Integer  privatePension           ;	// lNی
	private Integer  earthquakeIns           ;	// nkی
	private Integer  longTermDamageIns        ;	// Qی
	private Integer  allowanceAdjustment      ;	// xz
	private Integer  taxFreeAdjustment        ;	// ېŒz
	private Integer  taxIncAdjustment         ;	// Œz
	private String withholdSlipNotes        ;	// 򒥎[Ev
	private Integer  calcIncomeTax            ;	// ZoNŊz
	private Integer  adjustedIncomeTax        ;	// NNŊz
	private Integer  deductedIncomeTax        ;	// N藦TzŊz
	private Integer  socInsAdjustment         ;	// Љیz
	
	private String incomeTaxType              ;	// ېŕ
	private String adjustmentType             ;	// N敪
	
	/* }{T{l */
	private String spHandicap               ;	// ʏQ 
	private String geHandicap               ;	// ʏQ
	private String geWidow                  ;	// ʉǕw
	private String spWidow                  ;	// ʉǕw
	private String widow                    ;	// Ǖv
	private String studentGeneral           ;	// ΘJw
	/* }{Tzҍ */
	private String lwSpHandiEl              ;	// ʏQҘVl		
	private String lwSpHandicap             ;	// ʏQ
	private String spouseEl                 ;	// Vlz
	private String spouseGe                 ;	// ʔz(̑)
	
	private String generalDependent       ;	// ʕ}{e
	private String specificDependent      ;	// }{e
	private String elderlyDependent       ;	// Vl}{e
	private String liveWithEldRel         ;	// Ve
	private String liveWithHandiGe        ;	// 
	private String liveWithHandiSp        ;	// 
	private String liveWithHandiEl        ;	// Vl
	private String liveWithHandiEr        ;	// Ve
	private String generalHandicap        ;	// ʏQ
	private String specificHandicap       ;	// ʏQ
	private String totallHandicap         ;    // QҌv
	private String totallDeduction			;	// ]鋋^TΏ۔z҂ƕ}{e̍vTΏێҐ
	private String consortFlg				;	// zҗL\("L"E"")
	
	private String companyName           ;	// Ж

	private Integer  totalPayTotalAllowance  ;	//^xzv
	private Integer  totalPayTaxFree         ;	//^ېŊzv
	private Integer  totalPayTaxation        ;	//^ېŎxzv
	private Integer  totalPayIncomeTax       ;	//^ōv
	private Integer  totalPaySocInsDeduction ;	//^Љیv
	private Integer  totalPayPayInsDeduction ;	//^ЉیT̋^̋zv
	private Integer  totalPayVariousDeduction;	//^Tv
	private Integer  totalPayPaymentTotal    ;	//^xzv
	private Integer  totalPayAdjCalcGap      ;	//^Nɂߕsv
	
	private Integer  totalBonTotalAllowance  ;	//ܗ^xzv
	private Integer  totalBonTaxFree         ;	//ܗ^ېŊzv
	private Integer  totalBonTaxation        ;	//ܗ^ېŎxzv
	private Integer  totalBonIncomeTax       ;	//ܗ^ōv
	private Integer  totalBonSocInsDeduction ;	//ܗ^Љیv
	private Integer  totalBonPayInsDeduction ;	//ܗ^ЉیT̏ܗ^̋zv
	private Integer  totalBonVariousDeduction;	//ܗ^Tv
	private Integer  totalBonPaymentTotal    ;	//ܗ^xzv
	private Integer  totalBonAdjCalcGap      ;	//ܗ^Nɂߕsv

	private String   monthType_01            ;	// 敪01
	private String   monthType_02            ;	// 敪02
	private String   monthType_03            ;	// 敪03
	private String   monthType_04            ;	// 敪04
	private String   monthType_05            ;	// 敪05
	private String   monthType_06            ;	// 敪06
	private String   monthType_07            ;	// 敪07
	private String   monthType_08            ;	// 敪08
	private String   monthType_09            ;	// 敪09
	private String   monthType_10            ;	// 敪10
	private String   monthType_11            ;	// 敪11
	private String   monthType_12            ;	// 敪12

	private String strMidwayType             ;	// rЋ敪
	
	/**
	 * 򒥎o͂ɕKvȏݒ肷B<br>
	 * @param targetAdjustYear NΏ۔N
	 * @param cdAdjustmentDto  N
	 * @param uhBasisDto       l{
	 * @param umExtraDto       lǉ
	 * @param cmIncomeTaxDto   lŏ
	 * @param cmMidwayEnterDto lrЏ
	 * @param listPaymentData  ^
	 * @param listBonusData    ܗ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @param cmCompanyDto     Џ
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	public WithholdingListDto(
			int					targetAdjustYear,
			CdAdjustmentDto		cdAdjustmentDto ,
			MKihonDto			uhBasisDto      ,
			MKojinDto			mKojinDto      ,
			CmIncomeTaxDto		cmIncomeTaxDto  ,
			CmMidwayEnterDto	cmMidwayEnterDto,
			List<PhPaymentDto>	listPaymentData ,
			List<PhBounsDto>	listBonusData   ,
			PdPayDeductionDao	pdPayDeductionDao,
			CmCompanyDto		cmCompanyDto
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		super();
		// o͔Nݒ
		adjustYear = String.valueOf(targetAdjustYear);
		adjustYear_YY = String.valueOf(targetAdjustYear);
		// Жݒ
		companyName = cmCompanyDto.getCompanyName();
		// l{AŁArЁAǉݒ
		setBasisFields(uhBasisDto, cmIncomeTaxDto, cmMidwayEnterDto, mKojinDto);
		// Nݒ
		setAdjustFields(cdAdjustmentDto);
		// ܗ^ݒ
		setPaymentFields(pdPayDeductionDao, listPaymentData, listBonusData);
	}
	
	/**
	 * tB[hݒ(Nf[^)
	 * @param uhBasisDto       tB[h擾ΏDTO
	 * @param cmIncomeTaxDto   tB[h擾ΏDTO
	 * @param cmMidwayEnterDto tB[h擾ΏDTO
	 * @param listFamily       tB[h擾ΏۃXg
	 * @throws MospException 
	 */
	private void setAdjustFields(
			CdAdjustmentDto cdAdjustmentDto
	) {
		if (cdAdjustmentDto != null) {
			// AdjustStatus = String.valueOf( getCodeName(cdAdjustmentDto.getAdjustStatus(), UnicConst.getAdjuStatusArray());
		    generalLifeIns    = new Integer(cdAdjustmentDto.getGeneralLifeIns());
		    privatePension    = new Integer(cdAdjustmentDto.getPrivatePension     ());
		    lifeInsDeduction  = new Integer(cdAdjustmentDto.getLifeInsDeduction   ());
		    earthquakeIns     = new Integer(cdAdjustmentDto.getEarthquakeIns      ());
		    longTermDamageIns = new Integer(cdAdjustmentDto.getLongTermDamageIns  ());
		    damageInsDeduction= new Integer(cdAdjustmentDto.getDamageInsDeduction ());
		    socialInsDeduction= new Integer(cdAdjustmentDto.getSocialInsDeduction ());
		    mutualAidDeduction= new Integer(cdAdjustmentDto.getMutualAidDeduction ());
		    spouseSumIncome   = new Integer(cdAdjustmentDto.getSpouseSumIncome    ());
		    spouseSpDeduction = new Integer(cdAdjustmentDto.getSpouseSpDeduction  ());
		    houseLoanDeduction= new Integer(cdAdjustmentDto.getHouseLoanDeduction ());
		    allowanceAdjustment= new Integer(cdAdjustmentDto.getAllowanceAdjustment());
		    taxFreeAdjustment = new Integer(cdAdjustmentDto.getTaxFreeAdjustment  ());
		    socInsAdjustment  = new Integer(cdAdjustmentDto.getSocInsAdjustment   ());
		    taxIncAdjustment  = new Integer(cdAdjustmentDto.getTaxIncAdjustment   ());
		    withholdSlipNotes = cdAdjustmentDto.getWithholdSlipNotes  ();
		    paymentAllowance  = new Integer(cdAdjustmentDto.getPaymentAllowance   ());
		    paymentIncomeTax  = new Integer(cdAdjustmentDto.getPaymentIncomeTax   ());
		    bonusAllowance    = new Integer(cdAdjustmentDto.getBonusAllowance     ());
		    bonusIncomeTax    = new Integer(cdAdjustmentDto.getBonusIncomeTax     ());
		    midwayAdjustIncome= new Integer(cdAdjustmentDto.getMidwayAdjustIncome ());
		    midwayAdjustTax   = new Integer(cdAdjustmentDto.getMidwayAdjustTax    ());
		    afterDeductIncome = new Integer(cdAdjustmentDto.getAfterDeductIncome  ());
		    payInsDeduction   = new Integer(cdAdjustmentDto.getPayInsDeduction    ());
		    dependentsDeduction= new Integer(cdAdjustmentDto.getDependentsDeduction());
		    calcTaxedIncome   = new Integer(cdAdjustmentDto.getCalcTaxedIncome    ());
		    calcIncomeTax     = new Integer(cdAdjustmentDto.getCalcIncomeTax      ());
		    adjustedIncomeTax = new Integer(cdAdjustmentDto.getAdjustedIncomeTax  ());
		    deductedIncomeTax = new Integer(cdAdjustmentDto.getDeductedIncomeTax  ());
		    finalIncomeTax    = new Integer(cdAdjustmentDto.getFinalIncomeTax     ());
		    incomeDeductSum    = new Integer(cdAdjustmentDto.getIncomeDeductSum    ());
		    taxGap    = new Integer(cdAdjustmentDto.getTaxGap());
		    adjTotalAllowance = new Integer(cdAdjustmentDto.getTaxedPaymentSum());
		    adjTotalIncome    = new Integer(cdAdjustmentDto.getIncomeTaxSum   ());
		} else {
			// Nf[^݂Ȃꍇ̓f[^쐬
			//AdjustStatus = String.valueOf( UnicConst.ADJU_STATUS_NON_NAME;
		}
		
	}
	
	/**
	 * tB[hݒ
	 * @param uhBasisDto       tB[h擾ΏDTO
	 * @param cmIncomeTaxDto   tB[h擾ΏDTO
	 * @param cmMidwayEnterDto tB[h擾ΏDTO
	 * @param listFamily       tB[h擾ΏۃXg
	 * @throws MospException 
	 */
	private void setBasisFields(
			MKihonDto        mKihonDto      ,
			CmIncomeTaxDto    cmIncomeTaxDto  ,
			CmMidwayEnterDto  cmMidwayEnterDto,
			MKojinDto        mKojinDto      
	)   {
		// f[^̐ݒ
		if (mKihonDto != null) {
			kCode        = mKihonDto.getKCode       ();
			kName        = mKihonDto.getSimei       ();
			fName		 = mKihonDto.getFurigana();
			stationCode  = mKihonDto.getSCode();
			positionCode = mKihonDto.getYCode();
			touKyu		 = mKihonDto.getTokyu();   // ̏

		}
		
		// {l敪ĔfAX^XNݒ		
		if (cmIncomeTaxDto != null) {
			String handicapType = cmIncomeTaxDto.getSelfHandicapType();
			String studentType  = cmIncomeTaxDto.getSelfStudentType ();

			if (handicapType.equals(LegalConst.HANDICAP_GENERAL)) {
				// ʏQ
				geHandicap = PayrollConst.ADJ_APPLICABLE;
			} else if (handicapType.equals(LegalConst.HANDICAP_SPECIAL)) {
				// ʏQ
				spHandicap = PayrollConst.ADJ_APPLICABLE;
			}
			// {l敪ΘJw
			if (studentType.equals(LegalConst.STUDENT_GENERAL)) {
				studentGeneral = PayrollConst.ADJ_APPLICABLE;
			}
			String spouseType = cmIncomeTaxDto.getSpouseIntendType();

			// zҗLݒ
			if (spouseType.equals("")) {
				consortFlg = PayrollConst.PRESENCE_OFF;
			}else{
				consortFlg = PayrollConst.PRESENCE_ON;
			}

			
			// zҋ敪ʏQҘVl
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_LWSH_EL)) {
				lwSpHandiEl = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪ʏQ
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_LWSH)) {
				lwSpHandicap = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪Vlz
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_ELDERLY)) {
				spouseEl = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪Vlz
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_GENERAL)) {
				spouseGe = PayrollConst.ADJ_APPLICABLE;
			}
			
			generalDependent  = String.valueOf( cmIncomeTaxDto.getGeneralDependent ());	// ʕ}{e
			specificDependent = String.valueOf( cmIncomeTaxDto.getSpecificDependent());	// }{e
			elderlyDependent  = String.valueOf( cmIncomeTaxDto.getElderlyDependent ());	// Vl}{e
			liveWithEldRel    = String.valueOf( cmIncomeTaxDto.getLiveWithEldRel   ());	// Ve
			liveWithHandiGe   = String.valueOf( cmIncomeTaxDto.getLiveWithHandiGe  ());	// 
			liveWithHandiSp   = String.valueOf( cmIncomeTaxDto.getLiveWithHandiSp  ());	// 
			liveWithHandiEl   = String.valueOf( cmIncomeTaxDto.getLiveWithHandiEl  ());	// Vl
			liveWithHandiEr   = String.valueOf( cmIncomeTaxDto.getLiveWithHandiEr  ());	// Vl
			generalHandicap   = String.valueOf( cmIncomeTaxDto.getGeneralHandicap  ());	// ʏQ
			specificHandicap  = String.valueOf( cmIncomeTaxDto.getSpecificHandicap ());	// ʏQ
			totallHandicap    = String.valueOf( cmIncomeTaxDto.getGeneralHandicap() + cmIncomeTaxDto.getSpecificHandicap()); // QҌv
			totallDeduction   = String.valueOf(  // TΏێҐ
						cmIncomeTaxDto.getGeneralDependent()	+	// ʕ}{e
						cmIncomeTaxDto.getSpecificDependent()	+	// }{e
						cmIncomeTaxDto.getElderlyDependent()	+	// Vl}{e
						cmIncomeTaxDto.getLiveWithEldRel()		+	// Ve
						cmIncomeTaxDto.getGeneralHandicap()		+	// ʏQ
						cmIncomeTaxDto.getSpecificHandicap());		// ʏQ

			incomeTaxType     = String.valueOf( cmIncomeTaxDto.getIncomeTaxType    ());	// ېŋ敪
			adjustmentType    = String.valueOf( cmIncomeTaxDto.getAdjustmentType   ());	// N敪
		}
		
		formerIncome    = new Integer(0);
		formerInsurance = new Integer(0);
		formerTax       = new Integer(0);
		
		if (cmMidwayEnterDto != null) {
			if (mKihonDto != null) {
				// Ώ۔NГNULLłȂΔf
				if (mKihonDto.getNyDate() != 0) {
					// Ώ۔NŒrЂ̎Ј
					if (MospUtility.getYear(DatePart.convIntegerDateToDate(mKihonDto.getNyDate())) ==
												Integer.parseInt(adjustYear)) {
						if (cmMidwayEnterDto.getMidwayType().equals(LegalConst.MIDWAY_ENTER)) {
							formerIncome    = new Integer(cmMidwayEnterDto.getFormerIncome   ());
							formerInsurance = new Integer(cmMidwayEnterDto.getFormerInsurance());
							formerTax       = new Integer(cmMidwayEnterDto.getFormerTax      ());
							strMidwayType   = LegalConst.MIDWAY_ENTER_NAME;
						} else {
							strMidwayType   = "";
						}
					}
				}
				
			}
		}
		if (mKojinDto != null) {
			address = CalculateAction.getPrefecture(mKojinDto.getPrefectures()) + mKojinDto.getJyuusyo1() + mKojinDto.getJyuusyo2() + mKojinDto.getJyuusyo3();
			postalCode = mKojinDto.getYubinban();
		}
	}
	
	/**
	 * ܗ^ݒ肷B<br>
	 * @param pdPayDeductionDao ^׏DAO
	 * @param listPaymentData ^
	 * @param listBonusData   ܗ^
	 * @param cdAdjustmentDto N
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentFields(
			PdPayDeductionDao pdPayDeductionDao,
			List<PhPaymentDto> listPaymentData,
			List<PhBounsDto>   listBonusData  
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// ^ݒ
		for (int i = 0; i < PayrollConst.CNT_ADJ_PAYMENT_MONTH; i++) {
			for (int j = 0; j < listPaymentData.size(); j++) {
				// ^擾
				PhPaymentDto phPaymentDto =	listPaymentData.get(j);
				// ^xmF
				if (i + 1 == MospUtility.getMonth(phPaymentDto.getPayDate())) {
					// e̋^f[^ݒ
					setPaymentData(i, true, phPaymentDto, pdPayDeductionDao);
					break;
				}
				if (j == listPaymentData.size() -1 ) {
					// e̋^f[^ɋݒ
					setPaymentData(i, false, null, pdPayDeductionDao);
				}
			}
		}
		// ܗ^ݒ
		for (int i = 0; i < PayrollConst.CNT_OUT_BONUS_MONTH; i++) {
			if (i < listBonusData.size()) {
				// DTOjݒ
				PhBounsDto udBonusDto =	listBonusData.get(i);
				// ȅܗ^f[^ݒ
				setBonusData(i, true, udBonusDto);
			} else {
				// ȅܗ^f[^ɋݒ
				setBonusData(i, false, null);
			}
		}
		// vlݒ
		setTotalPayment();
	}
	
	private void setTotalPayment() {
		setTotalAllowance();
		setTotalTaxFree();
		setTotalTaxation();
		setTotalSocInsDeduction();
		setTotalPayInsDeduction();
		setTotalIncomeTax();
		setTotalVariousDeduction();
		setTotalPaymentTotal();
		setTotalpayAdjCalcGapTotal();
	}
	
	private void setTotalAllowance() {
		int amount01 =payTotalAllowance_01== null ? 0 : payTotalAllowance_01.intValue();
		int amount02 =payTotalAllowance_02== null ? 0 : payTotalAllowance_02.intValue();
		int amount03 =payTotalAllowance_03== null ? 0 :payTotalAllowance_03.intValue();
		int amount04 =payTotalAllowance_04== null ? 0 :payTotalAllowance_04.intValue();
		int amount05 =payTotalAllowance_05== null ? 0 :payTotalAllowance_05.intValue();
		int amount06 =payTotalAllowance_06== null ? 0 :payTotalAllowance_06.intValue();
		int amount07 =payTotalAllowance_07== null ? 0 :payTotalAllowance_07.intValue();
		int amount08 =payTotalAllowance_08== null ? 0 :payTotalAllowance_08.intValue();
		int amount09 =payTotalAllowance_09== null ? 0 :payTotalAllowance_09.intValue();
		int amount10 =payTotalAllowance_10== null ? 0 :payTotalAllowance_10.intValue();
		int amount11 =payTotalAllowance_11== null ? 0 :payTotalAllowance_11.intValue();
		int amount12 =payTotalAllowance_12== null ? 0 :payTotalAllowance_12.intValue();
		int amountBon01 = bonTotalAllowance_01== null ? 0 :bonTotalAllowance_01.intValue();
		int amountBon02 = bonTotalAllowance_02== null ? 0 :bonTotalAllowance_02.intValue();
		int amountBon03 = bonTotalAllowance_03== null ? 0 :bonTotalAllowance_03.intValue();
		int amountBon04 = bonTotalAllowance_04== null ? 0 :bonTotalAllowance_04.intValue();
		int amountBon05 = bonTotalAllowance_05== null ? 0 :bonTotalAllowance_05.intValue();
		int amountBon06 = bonTotalAllowance_06== null ? 0 :bonTotalAllowance_06.intValue();

		totalPayTotalAllowance =  new Integer(
		amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		);

		totalBonTotalAllowance =  new Integer(
		amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
		);

		totalAllowance = new Integer(
		amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
		);


		}
			
					
	private void setTotalTaxFree() {
		int amount01 =payTaxFree_01== null ? 0 : payTaxFree_01.intValue();
		int amount02 =payTaxFree_02== null ? 0 : payTaxFree_02.intValue();
		int amount03 =payTaxFree_03== null ? 0 :payTaxFree_03.intValue();
		int amount04 =payTaxFree_04== null ? 0 :payTaxFree_04.intValue();
		int amount05 =payTaxFree_05== null ? 0 :payTaxFree_05.intValue();
		int amount06 =payTaxFree_06== null ? 0 :payTaxFree_06.intValue();
		int amount07 =payTaxFree_07== null ? 0 :payTaxFree_07.intValue();
		int amount08 =payTaxFree_08== null ? 0 :payTaxFree_08.intValue();
		int amount09 =payTaxFree_09== null ? 0 :payTaxFree_09.intValue();
		int amount10 =payTaxFree_10== null ? 0 :payTaxFree_10.intValue();
		int amount11 =payTaxFree_11== null ? 0 :payTaxFree_11.intValue();
		int amount12 =payTaxFree_12== null ? 0 :payTaxFree_12.intValue();

		int amountBon01 =bonTaxFree_01== null ? 0 :bonTaxFree_01.intValue();
		int amountBon02 =bonTaxFree_02== null ? 0 :bonTaxFree_02.intValue();
		int amountBon03 =bonTaxFree_03== null ? 0 :bonTaxFree_03.intValue();
		int amountBon04 =bonTaxFree_04== null ? 0 :bonTaxFree_04.intValue();
		int amountBon05 =bonTaxFree_05== null ? 0 :bonTaxFree_05.intValue();
		int amountBon06 =bonTaxFree_06== null ? 0 :bonTaxFree_06.intValue();


	totalPayTaxFree = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonTaxFree = new Integer(
	amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);

	taxFree = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);


	}

	private void setTotalTaxation() {
		int amount01 =payTaxation_01== null ? 0 : payTaxation_01.intValue();
		int amount02 =payTaxation_02== null ? 0 : payTaxation_02.intValue();
		int amount03 =payTaxation_03== null ? 0 :payTaxation_03.intValue();
		int amount04 =payTaxation_04== null ? 0 :payTaxation_04.intValue();
		int amount05 =payTaxation_05== null ? 0 :payTaxation_05.intValue();
		int amount06 =payTaxation_06== null ? 0 :payTaxation_06.intValue();
		int amount07 =payTaxation_07== null ? 0 :payTaxation_07.intValue();
		int amount08 =payTaxation_08== null ? 0 :payTaxation_08.intValue();
		int amount09 =payTaxation_09== null ? 0 :payTaxation_09.intValue();
		int amount10 =payTaxation_10== null ? 0 :payTaxation_10.intValue();
		int amount11 =payTaxation_11== null ? 0 :payTaxation_11.intValue();
		int amount12 =payTaxation_12== null ? 0 :payTaxation_12.intValue();

		int amountBon01 =bonTaxation_01== null ? 0 :bonTaxation_01.intValue();
		int amountBon02 =bonTaxation_02== null ? 0 :bonTaxation_02.intValue();
		int amountBon03 =bonTaxation_03== null ? 0 :bonTaxation_03.intValue();
		int amountBon04 =bonTaxation_04== null ? 0 :bonTaxation_04.intValue();
		int amountBon05 =bonTaxation_05== null ? 0 :bonTaxation_05.intValue();
		int amountBon06 =bonTaxation_06== null ? 0 :bonTaxation_06.intValue();


	totalPayTaxation =new Integer(
	amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonTaxation = new Integer(
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);


	taxation = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);


	}
	private void setTotalSocInsDeduction() {
		int amount01 =paySocInsDeduction_01== null ? 0 : paySocInsDeduction_01.intValue();
		int amount02 =paySocInsDeduction_02== null ? 0 : paySocInsDeduction_02.intValue();
		int amount03 =paySocInsDeduction_03== null ? 0 :paySocInsDeduction_03.intValue();
		int amount04 =paySocInsDeduction_04== null ? 0 :paySocInsDeduction_04.intValue();
		int amount05 =paySocInsDeduction_05== null ? 0 :paySocInsDeduction_05.intValue();
		int amount06 =paySocInsDeduction_06== null ? 0 :paySocInsDeduction_06.intValue();
		int amount07 =paySocInsDeduction_07== null ? 0 :paySocInsDeduction_07.intValue();
		int amount08 =paySocInsDeduction_08== null ? 0 :paySocInsDeduction_08.intValue();
		int amount09 =paySocInsDeduction_09== null ? 0 :paySocInsDeduction_09.intValue();
		int amount10 =paySocInsDeduction_10== null ? 0 :paySocInsDeduction_10.intValue();
		int amount11 =paySocInsDeduction_11== null ? 0 :paySocInsDeduction_11.intValue();
		int amount12 =paySocInsDeduction_12== null ? 0 :paySocInsDeduction_12.intValue();

		int amountBon01 =bonSocInsDeduction_01== null ? 0 :bonSocInsDeduction_01.intValue();
		int amountBon02 =bonSocInsDeduction_02== null ? 0 :bonSocInsDeduction_02.intValue();
		int amountBon03 =bonSocInsDeduction_03== null ? 0 :bonSocInsDeduction_03.intValue();
		int amountBon04 =bonSocInsDeduction_04== null ? 0 :bonSocInsDeduction_04.intValue();
		int amountBon05 =bonSocInsDeduction_05== null ? 0 :bonSocInsDeduction_05.intValue();
		int amountBon06 =bonSocInsDeduction_06== null ? 0 :bonSocInsDeduction_06.intValue();

	totalPaySocInsDeduction =  new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonSocInsDeduction =  new Integer(
	amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);




	socInsDeduction = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);
	
	payInsDeduction = new Integer(
			+amount01
			+amount02
			+amount03
			+amount04
			+amount05
			+amount06
			+amount07
			+amount08
			+amount09
			+amount10
			+amount11
			+amount12
			+amountBon01
			+amountBon02
			+amountBon03
			+amountBon04
			+amountBon05
			+amountBon06
		);
	}

	private void setTotalPayInsDeduction() {
		int amount01 =payPayInsDeduction_01== null ? 0 : payPayInsDeduction_01.intValue();
		int amount02 =payPayInsDeduction_02== null ? 0 : payPayInsDeduction_02.intValue();
		int amount03 =payPayInsDeduction_03== null ? 0 :payPayInsDeduction_03.intValue();
		int amount04 =payPayInsDeduction_04== null ? 0 :payPayInsDeduction_04.intValue();
		int amount05 =payPayInsDeduction_05== null ? 0 :payPayInsDeduction_05.intValue();
		int amount06 =payPayInsDeduction_06== null ? 0 :payPayInsDeduction_06.intValue();
		int amount07 =payPayInsDeduction_07== null ? 0 :payPayInsDeduction_07.intValue();
		int amount08 =payPayInsDeduction_08== null ? 0 :payPayInsDeduction_08.intValue();
		int amount09 =payPayInsDeduction_09== null ? 0 :payPayInsDeduction_09.intValue();
		int amount10 =payPayInsDeduction_10== null ? 0 :payPayInsDeduction_10.intValue();
		int amount11 =payPayInsDeduction_11== null ? 0 :payPayInsDeduction_11.intValue();
		int amount12 =payPayInsDeduction_12== null ? 0 :payPayInsDeduction_12.intValue();

		int amountBon01 =bonPayInsDeduction_01== null ? 0 :bonPayInsDeduction_01.intValue();
		int amountBon02 =bonPayInsDeduction_02== null ? 0 :bonPayInsDeduction_02.intValue();
		int amountBon03 =bonPayInsDeduction_03== null ? 0 :bonPayInsDeduction_03.intValue();
		int amountBon04 =bonPayInsDeduction_04== null ? 0 :bonPayInsDeduction_04.intValue();
		int amountBon05 =bonPayInsDeduction_05== null ? 0 :bonPayInsDeduction_05.intValue();
		int amountBon06 =bonPayInsDeduction_06== null ? 0 :bonPayInsDeduction_06.intValue();


	totalPayPayInsDeduction =  new Integer(
	amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonPayInsDeduction =  new Integer(

	amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);

	totalPayInsDeduction = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);

	}

	private void setTotalIncomeTax() {
		int amount01 =payIncomeTax_01== null ? 0 : payIncomeTax_01.intValue();
		int amount02 =payIncomeTax_02== null ? 0 : payIncomeTax_02.intValue();
		int amount03 =payIncomeTax_03== null ? 0 :payIncomeTax_03.intValue();
		int amount04 =payIncomeTax_04== null ? 0 :payIncomeTax_04.intValue();
		int amount05 =payIncomeTax_05== null ? 0 :payIncomeTax_05.intValue();
		int amount06 =payIncomeTax_06== null ? 0 :payIncomeTax_06.intValue();
		int amount07 =payIncomeTax_07== null ? 0 :payIncomeTax_07.intValue();
		int amount08 =payIncomeTax_08== null ? 0 :payIncomeTax_08.intValue();
		int amount09 =payIncomeTax_09== null ? 0 :payIncomeTax_09.intValue();
		int amount10 =payIncomeTax_10== null ? 0 :payIncomeTax_10.intValue();
		int amount11 =payIncomeTax_11== null ? 0 :payIncomeTax_11.intValue();
		int amount12 =payIncomeTax_12== null ? 0 :payIncomeTax_12.intValue();

		int amountBon01 =bonIncomeTax_01== null ? 0 :bonIncomeTax_01.intValue();
		int amountBon02 =bonIncomeTax_02== null ? 0 :bonIncomeTax_02.intValue();
		int amountBon03 =bonIncomeTax_03== null ? 0 :bonIncomeTax_03.intValue();
		int amountBon04 =bonIncomeTax_04== null ? 0 :bonIncomeTax_04.intValue();
		int amountBon05 =bonIncomeTax_05== null ? 0 :bonIncomeTax_05.intValue();
		int amountBon06 =bonIncomeTax_06== null ? 0 :bonIncomeTax_06.intValue();


	totalPayIncomeTax =  new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonIncomeTax =  new Integer(
	amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);

	incomeTax = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);



	}

	private void setTotalVariousDeduction() {
		int amount01 =payVariousDeduction_01== null ? 0 : payVariousDeduction_01.intValue();
		int amount02 =payVariousDeduction_02== null ? 0 : payVariousDeduction_02.intValue();
		int amount03 =payVariousDeduction_03== null ? 0 :payVariousDeduction_03.intValue();
		int amount04 =payVariousDeduction_04== null ? 0 :payVariousDeduction_04.intValue();
		int amount05 =payVariousDeduction_05== null ? 0 :payVariousDeduction_05.intValue();
		int amount06 =payVariousDeduction_06== null ? 0 :payVariousDeduction_06.intValue();
		int amount07 =payVariousDeduction_07== null ? 0 :payVariousDeduction_07.intValue();
		int amount08 =payVariousDeduction_08== null ? 0 :payVariousDeduction_08.intValue();
		int amount09 =payVariousDeduction_09== null ? 0 :payVariousDeduction_09.intValue();
		int amount10 =payVariousDeduction_10== null ? 0 :payVariousDeduction_10.intValue();
		int amount11 =payVariousDeduction_11== null ? 0 :payVariousDeduction_11.intValue();
		int amount12 =payVariousDeduction_12== null ? 0 :payVariousDeduction_12.intValue();

		int amountBon01 =bonVariousDeduction_01== null ? 0 :bonVariousDeduction_01.intValue();
		int amountBon02 =bonVariousDeduction_02== null ? 0 :bonVariousDeduction_02.intValue();
		int amountBon03 =bonVariousDeduction_03== null ? 0 :bonVariousDeduction_03.intValue();
		int amountBon04 =bonVariousDeduction_04== null ? 0 :bonVariousDeduction_04.intValue();
		int amountBon05 =bonVariousDeduction_05== null ? 0 :bonVariousDeduction_05.intValue();
		int amountBon06 =bonVariousDeduction_06== null ? 0 :bonVariousDeduction_06.intValue();

	totalPayVariousDeduction =  new Integer(
	amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonVariousDeduction =  new Integer(
	amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);

	variousDeduction = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);




	}

	private void setTotalPaymentTotal() {
		int amount01=payPaymentTotal_01== null ? 0 : payPaymentTotal_01.intValue();
		int amount02=payPaymentTotal_02== null ? 0 : payPaymentTotal_02.intValue();
		int amount03=payPaymentTotal_03== null ? 0 :payPaymentTotal_03.intValue();
		int amount04=payPaymentTotal_04== null ? 0 :payPaymentTotal_04.intValue();
		int amount05=payPaymentTotal_05== null ? 0 :payPaymentTotal_05.intValue();
		int amount06=payPaymentTotal_06== null ? 0 :payPaymentTotal_06.intValue();
		int amount07=payPaymentTotal_07== null ? 0 :payPaymentTotal_07.intValue();
		int amount08=payPaymentTotal_08== null ? 0 :payPaymentTotal_08.intValue();
		int amount09=payPaymentTotal_09== null ? 0 :payPaymentTotal_09.intValue();
		int amount10=payPaymentTotal_10== null ? 0 :payPaymentTotal_10.intValue();
		int amount11=payPaymentTotal_11== null ? 0 :payPaymentTotal_11.intValue();
		int amount12=payPaymentTotal_12== null ? 0 :payPaymentTotal_12.intValue();
	
	
	
		int amountBon01 =bonPaymentTotal_01== null ? 0 :bonPaymentTotal_01.intValue();
		int amountBon02 =bonPaymentTotal_02== null ? 0 :bonPaymentTotal_02.intValue();
		int amountBon03 =bonPaymentTotal_03== null ? 0 :bonPaymentTotal_03.intValue();
		int amountBon04 =bonPaymentTotal_04== null ? 0 :bonPaymentTotal_04.intValue();
		int amountBon05 =bonPaymentTotal_05== null ? 0 :bonPaymentTotal_05.intValue();
		int amountBon06 =bonPaymentTotal_06== null ? 0 :bonPaymentTotal_06.intValue();

	totalPayPaymentTotal = new Integer(
	amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
	);

	totalBonPaymentTotal = new Integer(
	amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);


	paymentTotal = new Integer(
		+amount01
		+amount02
		+amount03
		+amount04
		+amount05
		+amount06
		+amount07
		+amount08
		+amount09
		+amount10
		+amount11
		+amount12
		+amountBon01
		+amountBon02
		+amountBon03
		+amountBon04
		+amountBon05
		+amountBon06
	);

	}

	private void setTotalpayAdjCalcGapTotal(){

		int amount01 = payAdjCalcGap_01 == null ? 0 : payAdjCalcGap_01.intValue();
		int amount02 = payAdjCalcGap_02 == null ? 0 : payAdjCalcGap_02.intValue();
		int amount03 = payAdjCalcGap_03 == null ? 0 : payAdjCalcGap_03.intValue();
		int amount04 = payAdjCalcGap_04 == null ? 0 : payAdjCalcGap_04.intValue();
		int amount05 = payAdjCalcGap_05 == null ? 0 : payAdjCalcGap_05.intValue();
		int amount06 = payAdjCalcGap_06 == null ? 0 : payAdjCalcGap_06.intValue();
		int amount07 = payAdjCalcGap_07 == null ? 0 : payAdjCalcGap_07.intValue();
		int amount08 = payAdjCalcGap_08 == null ? 0 : payAdjCalcGap_08.intValue();
		int amount09 = payAdjCalcGap_09 == null ? 0 : payAdjCalcGap_09.intValue();
		int amount10 = payAdjCalcGap_10 == null ? 0 : payAdjCalcGap_10.intValue();
		int amount11 = payAdjCalcGap_11 == null ? 0 : payAdjCalcGap_11.intValue();
		int amount12 = payAdjCalcGap_12 == null ? 0 : payAdjCalcGap_12.intValue();

		int amountBon01 = bonAdjCalcGap_01 == null ? 0 : bonAdjCalcGap_01.intValue();
		int amountBon02 = bonAdjCalcGap_02 == null ? 0 : bonAdjCalcGap_02.intValue();
		int amountBon03 = bonAdjCalcGap_03 == null ? 0 : bonAdjCalcGap_03.intValue();
		int amountBon04 = bonAdjCalcGap_04 == null ? 0 : bonAdjCalcGap_04.intValue();
		int amountBon05 = bonAdjCalcGap_05 == null ? 0 : bonAdjCalcGap_05.intValue();
		int amountBon06 = bonAdjCalcGap_06 == null ? 0 : bonAdjCalcGap_06.intValue();
		
		totalPayAdjCalcGap = new Integer(
				amount01 + 
				amount02 +
				amount03 +
				amount04 +
				amount05 +
				amount06 +
				amount07 +
				amount08 +
				amount09 +
				amount10 +
				amount11 +
				amount12);
		totalBonAdjCalcGap = new Integer(
				amountBon01 + 
				amountBon02 + 
				amountBon03 + 
				amountBon04 + 
				amountBon05 + 
				amountBon06); 
	}

	/**
	 * ^ݒ肷B<br>
	 * @param idx          ݒΏی
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData(
			int idx, boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		switch (idx) {
			case 0:	
				setPaymentData01(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 1:	
				setPaymentData02(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 2:	
				setPaymentData03(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 3:	
				setPaymentData04(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 4:	
				setPaymentData05(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 5:	
				setPaymentData06(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 6:	
				setPaymentData07(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 7:	
				setPaymentData08(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 8:	
				setPaymentData09(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 9:	
				setPaymentData10(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 10:	
				setPaymentData11(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 11:	
				setPaymentData12(isSetData, phPaymentDto, pdPayDeductionDao);
		}
	}
	
	/**
	 * 1̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData01(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {	
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}
			
			paymentMonth_01        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_01       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_01   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_01          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_01         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_01        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_01  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_01  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_01   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_01 = new Integer(genaraldeduction_tmp);			// Tzݒ
			payPaymentTotal_01     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_01       = new Integer(0);
			payPaymentTax_01 		=  payIncomeTax_01 - payAdjCalcGap_01;	// Ŋz01
		} else {
			paymentMonth_01        = "";
			paymentPayDay_01       = "";
			payTotalAllowance_01   = null;
			payTaxFree_01          = null;
			payTaxation_01         = null;
			payIncomeTax_01        = null;
			paySocInsDeduction_01  = null;
			payPayInsDeduction_01  = null;
			payDependentCount_01   = null;
			payAdjCalcGap_01       = null;
			payVariousDeduction_01 = null;
			payPaymentTotal_01     = null;
			payPaymentTax_01 		=  null;	// Ŋz01
		}
	}
	
	/**
	 * 2̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData02(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 
		if (isSetData) {	
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}
			paymentMonth_02        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_02       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_02   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_02          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_02         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_02        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_02  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_02  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_02   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_02 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_02     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_02       = new Integer(0);
			payPaymentTax_02 		=  payIncomeTax_02 - payAdjCalcGap_02;	// Ŋz02
		} else {	
			paymentMonth_02        = "";
			paymentPayDay_02       = "";
			payTotalAllowance_02   = null;
			payTaxFree_02          = null;
			payTaxation_02         = null;
			payIncomeTax_02        = null;
			paySocInsDeduction_02  = null;
			payPayInsDeduction_02  = null;
			payDependentCount_02   = null;
			payAdjCalcGap_02       = null;
			payVariousDeduction_02 = null;
			payPaymentTotal_02     = null;
			payPaymentTax_02 		=  null;	// Ŋz02
		}	
	}
	
	/**
	 * 3̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData03(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 
		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_03        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_03       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_03   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_03          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_03         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_03        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_03  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_03  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_03   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_03 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_03     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_03       = null;
			payPaymentTax_03 		=  payIncomeTax_03;	// Ŋz03
		} else {
			paymentMonth_03        = "";
			paymentPayDay_03       = "";
			payTotalAllowance_03   = null;
			payTaxFree_03          = null;
			payTaxation_03         = null;
			payIncomeTax_03        = null;
			paySocInsDeduction_03  = null;
			payPayInsDeduction_03  = null;
			payDependentCount_03   = null;
			payAdjCalcGap_03       = null;
			payVariousDeduction_03 = null;
			payPaymentTotal_03     = null;
		}
	}
	
	/**
	 * 4̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData04(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_04        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_04       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_04   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_04          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_04         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_04        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_04  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_04  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_04   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_04 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_04     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_04       = null;
			payPaymentTax_04 		=  payIncomeTax_04;	// Ŋz04
		} else {
			paymentMonth_04        = "";
			paymentPayDay_04       = "";
			payTotalAllowance_04   = null;
			payTaxFree_04          = null;
			payTaxation_04         = null;
			payIncomeTax_04        = null;
			paySocInsDeduction_04  = null;
			payPayInsDeduction_04  = null;
			payDependentCount_04   = null;
			payAdjCalcGap_04       = null;
			payVariousDeduction_04 = null;
			payPaymentTotal_04     = null;
		}
	}
	
	/**
	 * 5̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData05(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_05        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_05       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_05   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_05          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_05         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_05        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_05  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_05  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_05   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_05 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_05     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_05       = null;
			payPaymentTax_05 		=  payIncomeTax_05;	// Ŋz05
		} else {
			paymentMonth_05        = "";
			paymentPayDay_05       = "";
			payTotalAllowance_05   = null;
			payTaxFree_05          = null;
			payTaxation_05         = null;
			payIncomeTax_05        = null;
			paySocInsDeduction_05  = null;
			payPayInsDeduction_05  = null;
			payDependentCount_05   = null;
			payAdjCalcGap_05       = null;
			payVariousDeduction_05 = null;
			payPaymentTotal_05     = null;
		}
	}
	
	/**
	 * 6̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData06(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_06        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_06       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_06   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_06          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_06         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_06        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_06  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_06  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_06   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_06 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_06     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_06       = null;
			payPaymentTax_06 		=  payIncomeTax_06;	// Ŋz06
		} else {
			paymentMonth_06        = "";
			paymentPayDay_06       = "";
			payTotalAllowance_06   = null;
			payTaxFree_06          = null;
			payTaxation_06         = null;
			payIncomeTax_06        = null;
			paySocInsDeduction_06  = null;
			payPayInsDeduction_06  = null;
			payDependentCount_06   = null;
			payAdjCalcGap_06       = null;
			payVariousDeduction_06 = null;
			payPaymentTotal_06     = null;
		}
	}
	
	/**
	 * 7̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData07(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_07        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_07       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_07   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_07          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_07         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_07        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_07  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_07  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_07   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_07 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_07     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_07       = null;
			payPaymentTax_07 		=  payIncomeTax_07;	// Ŋz07
		} else {
			paymentMonth_07        = "";
			paymentPayDay_07       = "";
			payTotalAllowance_07   = null;
			payTaxFree_07          = null;
			payTaxation_07         = null;
			payIncomeTax_07        = null;
			paySocInsDeduction_07  = null;
			payPayInsDeduction_07  = null;
			payDependentCount_07   = null;
			payAdjCalcGap_07       = null;
			payVariousDeduction_07 = null;
			payPaymentTotal_07     = null;
		}
	}
	
	/**
	 * 8̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData08(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_08        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_08       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_08   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_08          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_08         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_08        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_08  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_08  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_08   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_08 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_08     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_08       = null;
			payPaymentTax_08 		=  payIncomeTax_08;	// Ŋz08
		} else {
			paymentMonth_08        = "";
			paymentPayDay_08       = "";
			payTotalAllowance_08   = null;
			payTaxFree_08          = null;
			payTaxation_08         = null;
			payIncomeTax_08        = null;
			paySocInsDeduction_08  = null;
			payPayInsDeduction_08  = null;
			payDependentCount_08   = null;
			payAdjCalcGap_08       = null;
			payVariousDeduction_08 = null;
			payPaymentTotal_08     = null;
		}
	}
	
	
	/**
	 * 9̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData09(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_09        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_09       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_09   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_09          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_09         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_09        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_09  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_09  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_09   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_09 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_09     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_09       = null;
			payPaymentTax_09 		=  payIncomeTax_09;	// Ŋz09
		} else {
			paymentMonth_09        = "";
			paymentPayDay_09       = "";
			payTotalAllowance_09   = null;
			payTaxFree_09          = null;
			payTaxation_09         = null;
			payIncomeTax_09        = null;
			paySocInsDeduction_09  = null;
			payPayInsDeduction_09  = null;
			payDependentCount_09   = null;
			payAdjCalcGap_09       = null;
			payVariousDeduction_09 = null;
			payPaymentTotal_09     = null;
		}
	}
	
	/**
	 * 10̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData10(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			
			paymentMonth_10        = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_10       = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_10   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_10          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_10         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_10        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_10  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_10  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_10   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_10 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_10     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_10       = null;
			payPaymentTax_10 		=  payIncomeTax_10;	// Ŋz10
		} else {
			paymentMonth_10        = "";
			paymentPayDay_10       = "";
			payTotalAllowance_10   = null;
			payTaxFree_10          = null;
			payTaxation_10         = null;
			payIncomeTax_10        = null;
			paySocInsDeduction_10  = null;
			payPayInsDeduction_10  = null;
			payDependentCount_10   = null;
			payAdjCalcGap_10       = null;
			payVariousDeduction_10 = null;
			payPaymentTotal_10     = null;
		}
	}
	
	/**
	 * 11̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData11(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_11        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_11       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_11   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_11          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_11         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_11        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_11  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_11  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_11   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_11 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_11     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_11       = null;
			payPaymentTax_11 		=  payIncomeTax_11;	// Ŋz11
		} else {
			paymentMonth_11        = "";
			paymentPayDay_11       = "";
			payTotalAllowance_11   = null;
			payTaxFree_11          = null;
			payTaxation_11         = null;
			payIncomeTax_11        = null;
			paySocInsDeduction_11  = null;
			payPayInsDeduction_11  = null;
			payDependentCount_11   = null;
			payAdjCalcGap_11       = null;
			payVariousDeduction_11 = null;
			payPaymentTotal_11     = null;
		}
	}
	
	/**
	 * 12̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData12(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto;	// ^׃f[^pDTO
		int restax_tmp				= 0;	// ZŎ擾p
		int genaraldeduction_tmp	= 0;	// TvZp

		//ZŎ擾
		restax_tmp = 0; 

		if (isSetData) {
			pdPayDeductionDto =	pdPayDeductionDao.findForDetail(
					phPaymentDto.getKCode(),
					phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if(pdPayDeductionDto != null){
				restax_tmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeduction_tmp = 
				phPaymentDto.getDeductionTotal() - 	
				phPaymentDto.getIncomeTax() - 
				restax_tmp  - phPaymentDto.getSocInsTotal();
			if(genaraldeduction_tmp < 0){
				genaraldeduction_tmp = 0;
			}

			paymentMonth_12        = String.valueOf( MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay_12       = String.valueOf( MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance_12   = new Integer(phPaymentDto.getAllowanceTotal   ());
			payTaxFree_12          = new Integer(phPaymentDto.getTaxExempt        ());
			payTaxation_12         = new Integer(phPaymentDto.getAmountToTaxation () + phPaymentDto.getSocInsTotal ());
			payIncomeTax_12        = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction_12  = new Integer(phPaymentDto.getSocInsTotal ());
			payPayInsDeduction_12  = new Integer(phPaymentDto.getAmountToTaxation ());
			payDependentCount_12   = new Integer(phPaymentDto.getDependent   ());
			payVariousDeduction_12 = new Integer(genaraldeduction_tmp);
			payPaymentTotal_12     = new Integer(phPaymentDto.getPaymentTotal     ());
			payAdjCalcGap_12       = null;
			payPaymentTax_12 		=  payIncomeTax_12;	// Ŋz12
		} else {
			paymentMonth_12        = "";
			paymentPayDay_12       = "";
			payTotalAllowance_12   = null;
			payTaxFree_12          = null;
			payTaxation_12         = null;
			payIncomeTax_12        = null;
			paySocInsDeduction_12  = null;
			payPayInsDeduction_12  = null;
			payDependentCount_12   = null;
			payAdjCalcGap_12       = null;
			payVariousDeduction_12 = null;
			payPaymentTotal_12     = null;
		}
	}
	
	/**
	 * ܗ^ݒ肷B<br>
	 * @param idx        ݒΏۉ
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۏܗ^
	 */
	private void setBonusData(int idx, boolean isSetData,PhBounsDto udBonusDto) {
		switch (idx) {
			case 0:	
				setBonusData01(isSetData, udBonusDto);
				break;
			case 1:	
				setBonusData02(isSetData, udBonusDto);
				break;
			case 2:	
				setBonusData03(isSetData, udBonusDto);
				break;
			case 3:	
				setBonusData04(isSetData, udBonusDto);
				break;
			case 4:	
				setBonusData05(isSetData, udBonusDto);
				break;
			case 5:	
				setBonusData06(isSetData, udBonusDto);
				break;
		}
	}
	
	/**
	 * 1̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData01(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth_01         = String.valueOf( MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay_01        = String.valueOf( MospUtility.getDay  (udBonusDto.getPayDate()));
			bonTotalAllowance_01  = new Integer(udBonusDto.getAllowanceTotal             ());
			bonTaxFree_01         = null;                                          
			bonTaxation_01        = new Integer(udBonusDto.getAllowanceTotal             ());
			bonIncomeTax_01       = new Integer(udBonusDto.getIncomeTax                  ());
//			bonIncomeTaxRate_01   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate_01   = new Float(0); // ŗ
			bonSocInsDeduction_01 = new Integer(udBonusDto.getSocInsTotal      ());
			bonPayInsDeduction_01  = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount_01   = new Integer(udBonusDto.getDependent             ());
//			bonVariousDeduction_01 = new Integer(udBonusDto.calcBonusGenaralDeduction());	// Tz
			bonVariousDeduction_01 = new Integer(0);	// Tz
			bonPaymentTotal_01     = new Integer(udBonusDto.getPaymentTotal          ());
			bonAdjCalcGap_01       = null;
			bonPaymentTax_01	   = bonIncomeTax_01 ;	// (ܗ^)01
		} else {
			bonusMonth_01         = "";
			bonusPayDay_01        = "";
			bonTotalAllowance_01  = null;
			bonTaxFree_01         = null;
			bonTaxation_01        = null;
			bonIncomeTaxRate_01   = null;
			bonIncomeTax_01       = null;
			bonSocInsDeduction_01 = null;
			bonPayInsDeduction_01  = null;
			bonDependentCount_01   = null;
			bonVariousDeduction_01 = null;
			bonPaymentTotal_01     = null;
			bonAdjCalcGap_01       = null;
			bonPaymentTotal_01     = null;
		}
	}
	
	/**
	 * 2̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData02(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth_02         = String.valueOf( MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay_02        = String.valueOf( MospUtility.getDay  (udBonusDto.getPayDate()));
			bonTotalAllowance_02  = new Integer(udBonusDto.getAllowanceTotal             ());
			bonTaxFree_02         = null;
			bonTaxation_02        = new Integer(udBonusDto.getAllowanceTotal             ());
			bonIncomeTax_02       = new Integer(udBonusDto.getIncomeTax                  ());
//			bonIncomeTaxRate_02   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate_02   = new Float(0); // ŗ
			bonSocInsDeduction_02 = new Integer(udBonusDto.getSocInsTotal      ());
			bonPayInsDeduction_02  = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount_02   = new Integer(udBonusDto.getDependent             ());
//			bonVariousDeduction_02 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction_02 = new Integer(0);// Tz
			bonPaymentTotal_02     = new Integer(udBonusDto.getPaymentTotal          ());
			bonAdjCalcGap_02       = null;
			bonPaymentTax_02	   = bonIncomeTax_02 ;	// (ܗ^)02
		} else {
			bonusMonth_02         = "";
			bonusPayDay_02        = "";
			bonTotalAllowance_02  = null;
			bonTaxFree_02         = null;
			bonTaxation_02        = null;
			bonIncomeTax_02       = null;
			bonIncomeTaxRate_02   = null;
			bonSocInsDeduction_02 = null;
			bonPayInsDeduction_02  = null;
			bonDependentCount_02   = null;
			bonVariousDeduction_02 = null;
			bonPaymentTotal_02     = null;
			bonAdjCalcGap_02       = null;
			bonPaymentTax_02	   = null;	// (ܗ^)02
		}
	}
	
	/**
	 * 3̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData03(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth_03         = String.valueOf( MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay_03        = String.valueOf( MospUtility.getDay  (udBonusDto.getPayDate()));
			bonTotalAllowance_03  = new Integer(udBonusDto.getAllowanceTotal             ());
			bonTaxFree_03         = null;
			bonTaxation_03        = new Integer(udBonusDto.getAllowanceTotal             ());
			bonIncomeTax_03       = new Integer(udBonusDto.getIncomeTax                  ());
//			bonIncomeTaxRate_03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate_03   = new Float(0); // ŗ
			bonSocInsDeduction_03 = new Integer(udBonusDto.getSocInsTotal      ());
			bonPayInsDeduction_03  = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount_03   = new Integer(udBonusDto.getDependent             ());
//			bonVariousDeduction_03 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction_03 = new Integer(0); // Tz
			bonPaymentTotal_03     = new Integer(udBonusDto.getPaymentTotal          ());
			bonAdjCalcGap_03       = null;
			bonPaymentTax_03	   = bonIncomeTax_03 ;	// (ܗ^)03
		} else {
			bonusMonth_03         = "";
			bonusPayDay_03        = "";
			bonTotalAllowance_03  = null;
			bonTaxFree_03         = null;
			bonTaxation_03        = null;
			bonIncomeTax_03       = null;
			bonIncomeTaxRate_03   = null;
			bonSocInsDeduction_03 = null;
			bonPayInsDeduction_03  = null;
			bonDependentCount_03   = null;
			bonVariousDeduction_03 = null;
			bonPaymentTotal_03     = null;
			bonAdjCalcGap_03       = null;
			bonPaymentTax_03	   = null;	// (ܗ^)03
		}
	}
	
	/**
	 * 4̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData04(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth_04         = String.valueOf( MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay_04        = String.valueOf( MospUtility.getDay  (udBonusDto.getPayDate()));
			bonTotalAllowance_04  = new Integer(udBonusDto.getAllowanceTotal             ());
			bonTaxFree_04         = null;
			bonTaxation_04        = new Integer(udBonusDto.getAllowanceTotal             ());
			bonIncomeTax_04       = new Integer(udBonusDto.getIncomeTax                  ());
//			bonIncomeTaxRate_03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate_03   = new Float(0); // ŗ
			bonSocInsDeduction_04 = new Integer(udBonusDto.getSocInsTotal      ());
			bonPayInsDeduction_04  = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount_04   = new Integer(udBonusDto.getDependent             ());
//			bonVariousDeduction_04 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction_04 = new Integer(0); // Tz
			bonPaymentTotal_04     = new Integer(udBonusDto.getPaymentTotal          ());
			bonAdjCalcGap_04       = null;
			bonPaymentTax_04	   = bonIncomeTax_04 ;	// (ܗ^)04
		} else {	
			bonusMonth_04         = "";
			bonusPayDay_04        = "";
			bonTotalAllowance_04  = null;
			bonTaxFree_04         = null;
			bonTaxation_04        = null;
			bonIncomeTax_04       = null;
			bonIncomeTaxRate_04   = null;
			bonSocInsDeduction_04 = null;
			bonPayInsDeduction_04  = null;
			bonDependentCount_04   = null;
			bonVariousDeduction_04 = null;
			bonPaymentTotal_04     = null;
			bonAdjCalcGap_04       = null;
			bonPaymentTax_04	   = null;	// (ܗ^)04
		}
	}
	
	/**
	 * 5̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData05(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth_05         = String.valueOf( MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay_05        = String.valueOf( MospUtility.getDay  (udBonusDto.getPayDate()));
			bonTotalAllowance_05  = new Integer(udBonusDto.getAllowanceTotal             ());
			bonTaxFree_05         = null;
			bonTaxation_05        = new Integer(udBonusDto.getAllowanceTotal             ());
			bonIncomeTax_05       = new Integer(udBonusDto.getIncomeTax                  ());
//			bonIncomeTaxRate_03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate_03   = new Float(0); // ŗ
			bonSocInsDeduction_05 = new Integer(udBonusDto.getSocInsTotal      ());
			bonPayInsDeduction_05  = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount_05   = new Integer(udBonusDto.getDependent             ());
//			bonVariousDeduction_05 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction_05 = new Integer(0); // Tz
			bonPaymentTotal_05     = new Integer(udBonusDto.getPaymentTotal          ());
			bonAdjCalcGap_05       = null;
			bonPaymentTax_05	   = bonIncomeTax_05 ;	// (ܗ^)05
		} else {
			bonusMonth_05         = "";
			bonusPayDay_05        = "";
			bonTotalAllowance_05  = null;
			bonTaxFree_05         = null;
			bonTaxation_05        = null;
			bonIncomeTax_05       = null;
			bonIncomeTaxRate_05   = null;
			bonSocInsDeduction_05 = null;
			bonPayInsDeduction_05  = null;
			bonDependentCount_05   = null;
			bonVariousDeduction_05 = null;
			bonPaymentTotal_05     = null;
			bonAdjCalcGap_05       = null;
			bonPaymentTax_05	   = null;	// (ܗ^)05
		}
	}
	
	/**
	 * 6̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData06(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth_06         = String.valueOf( MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay_06        = String.valueOf( MospUtility.getDay  (udBonusDto.getPayDate()));
			bonTotalAllowance_06  = new Integer(udBonusDto.getAllowanceTotal             ());
			bonTaxFree_06         = null;
			bonTaxation_06        = new Integer(udBonusDto.getAllowanceTotal             ());
			bonIncomeTax_06       = new Integer(udBonusDto.getIncomeTax                  ());
//			bonIncomeTaxRate_03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate_03   = new Float(0); // ŗ
			bonSocInsDeduction_06 = new Integer(udBonusDto.getSocInsTotal      ());
			bonPayInsDeduction_06  = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount_06   = new Integer(udBonusDto.getDependent             ());
//			bonVariousDeduction_06 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction_06 = new Integer(0); // Tz
			bonPaymentTotal_06     = new Integer(udBonusDto.getPaymentTotal          ());
			bonAdjCalcGap_06       = null;
			bonPaymentTax_06	   = bonIncomeTax_06 ;	// (ܗ^)06
		} else {	
			bonusMonth_06         = "";
			bonusPayDay_06        = "";
			bonTotalAllowance_06  = null;
			bonTaxFree_06         = null;
			bonTaxation_06        = null;
			bonIncomeTax_06       = null;
			bonIncomeTaxRate_06   = null;
			bonSocInsDeduction_06 = null;
			bonPayInsDeduction_06  = null;
			bonDependentCount_06   = null;
			bonVariousDeduction_06 = null;
			bonPaymentTotal_06     = null;
			bonAdjCalcGap_06       = null;
			bonPaymentTax_06	   = null;	// (ܗ^)06
		}
	}
	
	// ANZT\bh
	public void setAdjustYear            (String adjustYear     ){ this.adjustYear  = adjustYear         ; }
	public void setAdjustYear_YY         (String adjustYear     ){ this.adjustYear_YY  = adjustYear         ; }
	public void setStationCode           (String stationCode ){ this.stationCode  = stationCode        ; }
	public void setStationName           (String stationName ){ this.stationName  = stationName        ; }
	public void setPositionCode          (String positionCode){ this.positionCode = positionCode       ; }
	public void setPositionName          (String positionName){ this.positionName = positionName       ; }
	public void settouKyu                (String toukyu)      { this.touKyu		= toukyu             ; }		
	public void setKCode                 (String kCode       ){ this.kCode        = kCode              ; }
	public void setKName                 (String kName       ){ this.kName        = kName              ; }
	public void setFName                 (String fName       ){ this.fName        = fName              ; }
	public void setPostalCode            (String postalCode  ){ this.postalCode   = postalCode         ; }
	public void setAddress               (String address     ){ this.address      = address            ; }
	public void setBirthDate             (String birthDate     ){ this.birthDate      = birthDate            ; }
	
	public void setPaymentMonth_01       (String paymentMonth_01     ){ this.paymentMonth_01         =paymentMonth_01               ;}	// x01
	public void setPaymentMonth_02       (String paymentMonth_02     ){ this.paymentMonth_02         =paymentMonth_02               ;}	// x02
	public void setPaymentMonth_03       (String paymentMonth_03     ){ this.paymentMonth_03         =paymentMonth_03               ;}	// x03
	public void setPaymentMonth_04       (String paymentMonth_04     ){ this.paymentMonth_04         =paymentMonth_04               ;}	// x04
	public void setPaymentMonth_05       (String paymentMonth_05     ){ this.paymentMonth_05         =paymentMonth_05               ;}	// x05
	public void setPaymentMonth_06       (String paymentMonth_06     ){ this.paymentMonth_06         =paymentMonth_06               ;}	// x06
	public void setPaymentMonth_07       (String paymentMonth_07     ){ this.paymentMonth_07         =paymentMonth_07               ;}	// x07
	public void setPaymentMonth_08       (String paymentMonth_08     ){ this.paymentMonth_08         =paymentMonth_08               ;}	// x08
	public void setPaymentMonth_09       (String paymentMonth_09     ){ this.paymentMonth_09         =paymentMonth_09               ;}	// x09
	public void setPaymentMonth_10       (String paymentMonth_10     ){ this.paymentMonth_10         =paymentMonth_10               ;}	// x10
	public void setPaymentMonth_11       (String paymentMonth_11     ){ this.paymentMonth_11         =paymentMonth_11               ;}	// x11
	public void setPaymentMonth_12       (String paymentMonth_12     ){ this.paymentMonth_12         =paymentMonth_12               ;}	// x12
	public void setPaymentPayDay_01      (String paymentPayDay_01    ){ this.paymentPayDay_01        =paymentPayDay_01              ;}	// x01
	public void setPaymentPayDay_02      (String paymentPayDay_02    ){ this.paymentPayDay_02        =paymentPayDay_02              ;}	// x02
	public void setPaymentPayDay_03      (String paymentPayDay_03    ){ this.paymentPayDay_03        =paymentPayDay_03              ;}	// x03
	public void setPaymentPayDay_04      (String paymentPayDay_04    ){ this.paymentPayDay_04        =paymentPayDay_04              ;}	// x04
	public void setPaymentPayDay_05      (String paymentPayDay_05    ){ this.paymentPayDay_05        =paymentPayDay_05              ;}	// x05
	public void setPaymentPayDay_06      (String paymentPayDay_06    ){ this.paymentPayDay_06        =paymentPayDay_06              ;}	// x06
	public void setPaymentPayDay_07      (String paymentPayDay_07    ){ this.paymentPayDay_07        =paymentPayDay_07              ;}	// x07
	public void setPaymentPayDay_08      (String paymentPayDay_08    ){ this.paymentPayDay_08        =paymentPayDay_08              ;}	// x08
	public void setPaymentPayDay_09      (String paymentPayDay_09    ){ this.paymentPayDay_09        =paymentPayDay_09              ;}	// x09
	public void setPaymentPayDay_10      (String paymentPayDay_10    ){ this.paymentPayDay_10        =paymentPayDay_10              ;}	// x10
	public void setPaymentPayDay_11      (String paymentPayDay_11    ){ this.paymentPayDay_11        =paymentPayDay_11              ;}	// x11
	public void setPaymentPayDay_12      (String paymentPayDay_12    ){ this.paymentPayDay_12        =paymentPayDay_12              ;}	// x12
	public void setPayTotalAllowance_01  (Integer payTotalAllowance_01){ this.payTotalAllowance_01    =payTotalAllowance_01          ;}	// xz01 
	public void setPayTotalAllowance_02  (Integer payTotalAllowance_02){ this.payTotalAllowance_02    =payTotalAllowance_02          ;}	// xz02
	public void setPayTotalAllowance_03  (Integer payTotalAllowance_03){ this.payTotalAllowance_03    =payTotalAllowance_03          ;}	// xz03
	public void setPayTotalAllowance_04  (Integer payTotalAllowance_04){ this.payTotalAllowance_04    =payTotalAllowance_04          ;}	// xz04
	public void setPayTotalAllowance_05  (Integer payTotalAllowance_05){ this.payTotalAllowance_05    =payTotalAllowance_05          ;}	// xz05
	public void setPayTotalAllowance_06  (Integer payTotalAllowance_06){ this.payTotalAllowance_06    =payTotalAllowance_06          ;}	// xz06
	public void setPayTotalAllowance_07  (Integer payTotalAllowance_07){ this.payTotalAllowance_07    =payTotalAllowance_07          ;}	// xz07
	public void setPayTotalAllowance_08  (Integer payTotalAllowance_08){ this.payTotalAllowance_08    =payTotalAllowance_08          ;}	// xz08
	public void setPayTotalAllowance_09  (Integer payTotalAllowance_09){ this.payTotalAllowance_09    =payTotalAllowance_09          ;}	// xz09
	public void setPayTotalAllowance_10  (Integer payTotalAllowance_10){ this.payTotalAllowance_10    =payTotalAllowance_10          ;}	// xz10
	public void setPayTotalAllowance_11  (Integer payTotalAllowance_11){ this.payTotalAllowance_11    =payTotalAllowance_11          ;}	// xz11
	public void setPayTotalAllowance_12  (Integer payTotalAllowance_12){ this.payTotalAllowance_12    =payTotalAllowance_12          ;}	// xz12
	public void setPayTaxFree_01         (Integer payTaxFree_01       ){ this.payTaxFree_01           =payTaxFree_01                 ;}	// ېŊz01
	public void setPayTaxFree_02         (Integer payTaxFree_02       ){ this.payTaxFree_02           =payTaxFree_02                 ;}	// ېŊz02
	public void setPayTaxFree_03         (Integer payTaxFree_03       ){ this.payTaxFree_03           =payTaxFree_03                 ;}	// ېŊz03
	public void setPayTaxFree_04         (Integer payTaxFree_04       ){ this.payTaxFree_04           =payTaxFree_04                 ;}	// ېŊz04
	public void setPayTaxFree_05         (Integer payTaxFree_05       ){ this.payTaxFree_05           =payTaxFree_05                 ;}	// ېŊz05
	public void setPayTaxFree_06         (Integer payTaxFree_06       ){ this.payTaxFree_06           =payTaxFree_06                 ;}	// ېŊz06
	public void setPayTaxFree_07         (Integer payTaxFree_07       ){ this.payTaxFree_07           =payTaxFree_07                 ;}	// ېŊz07
	public void setPayTaxFree_08         (Integer payTaxFree_08       ){ this.payTaxFree_08           =payTaxFree_08                 ;}	// ېŊz08
	public void setPayTaxFree_09         (Integer payTaxFree_09       ){ this.payTaxFree_09           =payTaxFree_09                 ;}	// ېŊz09
	public void setPayTaxFree_10         (Integer payTaxFree_10       ){ this.payTaxFree_10           =payTaxFree_10                 ;}	// ېŊz10
	public void setPayTaxFree_11         (Integer payTaxFree_11       ){ this.payTaxFree_11           =payTaxFree_11                 ;}	// ېŊz11
	public void setPayTaxFree_12         (Integer payTaxFree_12       ){ this.payTaxFree_12           =payTaxFree_12                 ;}	// ېŊz12
	public void setPayTaxation_01        (Integer payTaxation_01      ){ this.payTaxation_01          =payTaxation_01                ;}	// ېŎxz01
	public void setPayTaxation_02        (Integer payTaxation_02      ){ this.payTaxation_02          =payTaxation_02                ;}	// ېŎxz02
	public void setPayTaxation_03        (Integer payTaxation_03      ){ this.payTaxation_03          =payTaxation_03                ;}	// ېŎxz03
	public void setPayTaxation_04        (Integer payTaxation_04      ){ this.payTaxation_04          =payTaxation_04                ;}	// ېŎxz04
	public void setPayTaxation_05        (Integer payTaxation_05      ){ this.payTaxation_05          =payTaxation_05                ;}	// ېŎxz05
	public void setPayTaxation_06        (Integer payTaxation_06      ){ this.payTaxation_06          =payTaxation_06                ;}	// ېŎxz06
	public void setPayTaxation_07        (Integer payTaxation_07      ){ this.payTaxation_07          =payTaxation_07                ;}	// ېŎxz07
	public void setPayTaxation_08        (Integer payTaxation_08      ){ this.payTaxation_08          =payTaxation_08                ;}	// ېŎxz08
	public void setPayTaxation_09        (Integer payTaxation_09      ){ this.payTaxation_09          =payTaxation_09                ;}	// ېŎxz09
	public void setPayTaxation_10        (Integer payTaxation_10      ){ this.payTaxation_10          =payTaxation_10                ;}	// ېŎxz10
	public void setPayTaxation_11        (Integer payTaxation_11      ){ this.payTaxation_11          =payTaxation_11                ;}	// ېŎxz11
	public void setPayTaxation_12        (Integer payTaxation_12      ){ this.payTaxation_12          =payTaxation_12                ;}	// ېŎxz12
	public void setPaySocInsDeduction_01 (Integer paySocInsDeduction_01   ){ this.paySocInsDeduction_01   =paySocInsDeduction_01         ;}	// Љی01
	public void setPaySocInsDeduction_02 (Integer paySocInsDeduction_02   ){ this.paySocInsDeduction_02   =paySocInsDeduction_02         ;}	// Љی02
	public void setPaySocInsDeduction_03 (Integer paySocInsDeduction_03   ){ this.paySocInsDeduction_03   =paySocInsDeduction_03         ;}	// Љی03
	public void setPaySocInsDeduction_04 (Integer paySocInsDeduction_04   ){ this.paySocInsDeduction_04   =paySocInsDeduction_04         ;}	// Љی04
	public void setPaySocInsDeduction_05 (Integer paySocInsDeduction_05   ){ this.paySocInsDeduction_05   =paySocInsDeduction_05         ;}	// Љی05
	public void setPaySocInsDeduction_06 (Integer paySocInsDeduction_06   ){ this.paySocInsDeduction_06   =paySocInsDeduction_06         ;}	// Љی06
	public void setPaySocInsDeduction_07 (Integer paySocInsDeduction_07   ){ this.paySocInsDeduction_07   =paySocInsDeduction_07         ;}	// Љی07
	public void setPaySocInsDeduction_08 (Integer paySocInsDeduction_08   ){ this.paySocInsDeduction_08   =paySocInsDeduction_08         ;}	// Љی08
	public void setPaySocInsDeduction_09 (Integer paySocInsDeduction_09   ){ this.paySocInsDeduction_09   =paySocInsDeduction_09         ;}	// Љی09
	public void setPaySocInsDeduction_10 (Integer paySocInsDeduction_10   ){ this.paySocInsDeduction_10   =paySocInsDeduction_10         ;}	// Љی10
	public void setPaySocInsDeduction_11 (Integer paySocInsDeduction_11   ){ this.paySocInsDeduction_11   =paySocInsDeduction_11         ;}	// Љی11
	public void setPaySocInsDeduction_12 (Integer paySocInsDeduction_12   ){ this.paySocInsDeduction_12   =paySocInsDeduction_12         ;}	// Љی12
	public void setPayPayInsDeduction_01 (Integer payPayInsDeduction_01   ){ this.payPayInsDeduction_01   =payPayInsDeduction_01         ;}	// ЉیT̋^̋z01
	public void setPayPayInsDeduction_02 (Integer payPayInsDeduction_02   ){ this.payPayInsDeduction_02   =payPayInsDeduction_02         ;}	// ЉیT̋^̋z02
	public void setPayPayInsDeduction_03 (Integer payPayInsDeduction_03   ){ this.payPayInsDeduction_03   =payPayInsDeduction_03         ;}	// ЉیT̋^̋z03
	public void setPayPayInsDeduction_04 (Integer payPayInsDeduction_04   ){ this.payPayInsDeduction_04   =payPayInsDeduction_04         ;}	// ЉیT̋^̋z04
	public void setPayPayInsDeduction_05 (Integer payPayInsDeduction_05   ){ this.payPayInsDeduction_05   =payPayInsDeduction_05         ;}	// ЉیT̋^̋z05
	public void setPayPayInsDeduction_06 (Integer payPayInsDeduction_06   ){ this.payPayInsDeduction_06   =payPayInsDeduction_06         ;}	// ЉیT̋^̋z06
	public void setPayPayInsDeduction_07 (Integer payPayInsDeduction_07   ){ this.payPayInsDeduction_07   =payPayInsDeduction_07         ;}	// ЉیT̋^̋z07
	public void setPayPayInsDeduction_08 (Integer payPayInsDeduction_08   ){ this.payPayInsDeduction_08   =payPayInsDeduction_08         ;}	// ЉیT̋^̋z08
	public void setPayPayInsDeduction_09 (Integer payPayInsDeduction_09   ){ this.payPayInsDeduction_09   =payPayInsDeduction_09         ;}	// ЉیT̋^̋z09
	public void setPayPayInsDeduction_10 (Integer payPayInsDeduction_10   ){ this.payPayInsDeduction_10   =payPayInsDeduction_10         ;}	// ЉیT̋^̋z10
	public void setPayPayInsDeduction_11 (Integer payPayInsDeduction_11   ){ this.payPayInsDeduction_11   =payPayInsDeduction_11         ;}	// ЉیT̋^̋z11
	public void setPayPayInsDeduction_12 (Integer payPayInsDeduction_12   ){ this.payPayInsDeduction_12   =payPayInsDeduction_12         ;}	// ЉیT̋^̋z12
	public void setPayDependentCount_01  (Integer payDependentCount_01){ this.payDependentCount_01    =payDependentCount_01          ;}	// }{e(^)01
	public void setPayDependentCount_02  (Integer payDependentCount_02){ this.payDependentCount_02    =payDependentCount_02          ;}	// }{e(^)02
	public void setPayDependentCount_03  (Integer payDependentCount_03){ this.payDependentCount_03    =payDependentCount_03          ;}	// }{e(^)03
	public void setPayDependentCount_04  (Integer payDependentCount_04){ this.payDependentCount_04    =payDependentCount_04          ;}	// }{e(^)04
	public void setPayDependentCount_05  (Integer payDependentCount_05){ this.payDependentCount_05    =payDependentCount_05          ;}	// }{e(^)05
	public void setPayDependentCount_06  (Integer payDependentCount_06){ this.payDependentCount_06    =payDependentCount_06          ;}	// }{e(^)06
	public void setPayDependentCount_07  (Integer payDependentCount_07){ this.payDependentCount_07    =payDependentCount_07          ;}	// }{e(^)07
	public void setPayDependentCount_08  (Integer payDependentCount_08){ this.payDependentCount_08    =payDependentCount_08          ;}	// }{e(^)08
	public void setPayDependentCount_09  (Integer payDependentCount_09){ this.payDependentCount_09    =payDependentCount_09          ;}	// }{e(^)09
	public void setPayDependentCount_10  (Integer payDependentCount_10){ this.payDependentCount_10    =payDependentCount_10          ;}	// }{e(^)10
	public void setPayDependentCount_11  (Integer payDependentCount_11){ this.payDependentCount_11    =payDependentCount_11          ;}	// }{e(^)11
	public void setPayDependentCount_12  (Integer payDependentCount_12){ this.payDependentCount_12    =payDependentCount_12          ;}	// }{e(^)12
	public void setPayIncomeTax_01       (Integer payIncomeTax_01     ){ this.payIncomeTax_01         =payIncomeTax_01               ;}	// 01 
	public void setPayIncomeTax_02       (Integer payIncomeTax_02     ){ this.payIncomeTax_02         =payIncomeTax_02               ;}	// 02
	public void setPayIncomeTax_03       (Integer payIncomeTax_03     ){ this.payIncomeTax_03         =payIncomeTax_03               ;}	// 03
	public void setPayIncomeTax_04       (Integer payIncomeTax_04     ){ this.payIncomeTax_04         =payIncomeTax_04               ;}	// 04
	public void setPayIncomeTax_05       (Integer payIncomeTax_05     ){ this.payIncomeTax_05         =payIncomeTax_05               ;}	// 05
	public void setPayIncomeTax_06       (Integer payIncomeTax_06     ){ this.payIncomeTax_06         =payIncomeTax_06               ;}	// 06
	public void setPayIncomeTax_07       (Integer payIncomeTax_07     ){ this.payIncomeTax_07         =payIncomeTax_07               ;}	// 07
	public void setPayIncomeTax_08       (Integer payIncomeTax_08     ){ this.payIncomeTax_08         =payIncomeTax_08               ;}	// 08
	public void setPayIncomeTax_09       (Integer payIncomeTax_09     ){ this.payIncomeTax_09         =payIncomeTax_09               ;}	// 09
	public void setPayIncomeTax_10       (Integer payIncomeTax_10     ){ this.payIncomeTax_10         =payIncomeTax_10               ;}	// 10
	public void setPayIncomeTax_11       (Integer payIncomeTax_11     ){ this.payIncomeTax_11         =payIncomeTax_11               ;}	// 11
	public void setPayIncomeTax_12       (Integer payIncomeTax_12     ){ this.payIncomeTax_12         =payIncomeTax_12               ;}	// 12
	public void setPayAdjCalcGap_01      (Integer payAdjCalcGap_01    ){ this.payAdjCalcGap_01        =payAdjCalcGap_01              ;}	// Nɂߕs01
	public void setPayAdjCalcGap_02      (Integer payAdjCalcGap_02    ){ this.payAdjCalcGap_02        =payAdjCalcGap_02              ;}	// Nɂߕs02
	public void setPayAdjCalcGap_03      (Integer payAdjCalcGap_03    ){ this.payAdjCalcGap_03        =payAdjCalcGap_03              ;}	// Nɂߕs03
	public void setPayAdjCalcGap_04      (Integer payAdjCalcGap_04    ){ this.payAdjCalcGap_04        =payAdjCalcGap_04              ;}	// Nɂߕs04
	public void setPayAdjCalcGap_05      (Integer payAdjCalcGap_05    ){ this.payAdjCalcGap_05        =payAdjCalcGap_05              ;}	// Nɂߕs05
	public void setPayAdjCalcGap_06      (Integer payAdjCalcGap_06    ){ this.payAdjCalcGap_06        =payAdjCalcGap_06              ;}	// Nɂߕs06
	public void setPayAdjCalcGap_07      (Integer payAdjCalcGap_07    ){ this.payAdjCalcGap_07        =payAdjCalcGap_07              ;}	// Nɂߕs07
	public void setPayAdjCalcGap_08      (Integer payAdjCalcGap_08    ){ this.payAdjCalcGap_08        =payAdjCalcGap_08              ;}	// Nɂߕs08
	public void setPayAdjCalcGap_09      (Integer payAdjCalcGap_09    ){ this.payAdjCalcGap_09        =payAdjCalcGap_09              ;}	// Nɂߕs09
	public void setPayAdjCalcGap_10      (Integer payAdjCalcGap_10    ){ this.payAdjCalcGap_10        =payAdjCalcGap_10              ;}	// Nɂߕs10
	public void setPayAdjCalcGap_11      (Integer payAdjCalcGap_11    ){ this.payAdjCalcGap_11        =payAdjCalcGap_11              ;}	// Nɂߕs11
	public void setPayAdjCalcGap_12      (Integer payAdjCalcGap_12    ){ this.payAdjCalcGap_12        =payAdjCalcGap_12              ;}	// Nɂߕs12
	public void setPayVariousDeduction_01(Integer payVariousDeduction_01  ){ this.payVariousDeduction_01  =payVariousDeduction_01        ;}	// T01
	public void setPayVariousDeduction_02(Integer payVariousDeduction_02  ){ this.payVariousDeduction_02  =payVariousDeduction_02        ;}	// T02
	public void setPayVariousDeduction_03(Integer payVariousDeduction_03  ){ this.payVariousDeduction_03  =payVariousDeduction_03        ;}	// T03
	public void setPayVariousDeduction_04(Integer payVariousDeduction_04  ){ this.payVariousDeduction_04  =payVariousDeduction_04        ;}	// T04
	public void setPayVariousDeduction_05(Integer payVariousDeduction_05  ){ this.payVariousDeduction_05  =payVariousDeduction_05        ;}	// T05
	public void setPayVariousDeduction_06(Integer payVariousDeduction_06  ){ this.payVariousDeduction_06  =payVariousDeduction_06        ;}	// T06
	public void setPayVariousDeduction_07(Integer payVariousDeduction_07  ){ this.payVariousDeduction_07  =payVariousDeduction_07        ;}	// T07
	public void setPayVariousDeduction_08(Integer payVariousDeduction_08  ){ this.payVariousDeduction_08  =payVariousDeduction_08        ;}	// T08
	public void setPayVariousDeduction_09(Integer payVariousDeduction_09  ){ this.payVariousDeduction_09  =payVariousDeduction_09        ;}	// T09
	public void setPayVariousDeduction_10(Integer payVariousDeduction_10  ){ this.payVariousDeduction_10  =payVariousDeduction_10        ;}	// T10
	public void setPayVariousDeduction_11(Integer payVariousDeduction_11  ){ this.payVariousDeduction_11  =payVariousDeduction_11        ;}	// T11
	public void setPayVariousDeduction_12(Integer payVariousDeduction_12  ){ this.payVariousDeduction_12  =payVariousDeduction_12        ;}	// T12
	public void setPayPaymentTotal_01    (Integer payPaymentTotal_01  ){ this.payPaymentTotal_01      =payPaymentTotal_01            ;}	// xz01
	public void setPayPaymentTotal_02    (Integer payPaymentTotal_02  ){ this.payPaymentTotal_02      =payPaymentTotal_02            ;}	// xz02
	public void setPayPaymentTotal_03    (Integer payPaymentTotal_03  ){ this.payPaymentTotal_03      =payPaymentTotal_03            ;}	// xz03
	public void setPayPaymentTotal_04    (Integer payPaymentTotal_04  ){ this.payPaymentTotal_04      =payPaymentTotal_04            ;}	// xz04
	public void setPayPaymentTotal_05    (Integer payPaymentTotal_05  ){ this.payPaymentTotal_05      =payPaymentTotal_05            ;}	// xz05
	public void setPayPaymentTotal_06    (Integer payPaymentTotal_06  ){ this.payPaymentTotal_06      =payPaymentTotal_06            ;}	// xz06
	public void setPayPaymentTotal_07    (Integer payPaymentTotal_07  ){ this.payPaymentTotal_07      =payPaymentTotal_07            ;}	// xz07
	public void setPayPaymentTotal_08    (Integer payPaymentTotal_08  ){ this.payPaymentTotal_08      =payPaymentTotal_08            ;}	// xz08
	public void setPayPaymentTotal_09    (Integer payPaymentTotal_09  ){ this.payPaymentTotal_09      =payPaymentTotal_09            ;}	// xz09
	public void setPayPaymentTotal_10    (Integer payPaymentTotal_10  ){ this.payPaymentTotal_10      =payPaymentTotal_10            ;}	// xz10
	public void setPayPaymentTotal_11    (Integer payPaymentTotal_11  ){ this.payPaymentTotal_11      =payPaymentTotal_11            ;}	// xz11
	public void setPayPaymentTotal_12    (Integer payPaymentTotal_12  ){ this.payPaymentTotal_12      =payPaymentTotal_12            ;}	// xz12

	public void setPayPaymentTax_01    (Integer payPaymentTax_01  ){ this.payPaymentTax_01      = payPaymentTax_01            ;}	// Ŋz01
	public void setPayPaymentTax_02    (Integer payPaymentTax_02  ){ this.payPaymentTax_02      = payPaymentTax_02            ;}	// Ŋz02
	public void setPayPaymentTax_03    (Integer payPaymentTax_03  ){ this.payPaymentTax_03      = payPaymentTax_03            ;}	// Ŋz03
	public void setPayPaymentTax_04    (Integer payPaymentTax_04  ){ this.payPaymentTax_04      = payPaymentTax_04            ;}	// Ŋz04
	public void setPayPaymentTax_05    (Integer payPaymentTax_05  ){ this.payPaymentTax_05      = payPaymentTax_05            ;}	// Ŋz05
	public void setPayPaymentTax_06    (Integer payPaymentTax_06  ){ this.payPaymentTax_06      = payPaymentTax_06            ;}	// Ŋz06
	public void setPayPaymentTax_07    (Integer payPaymentTax_07  ){ this.payPaymentTax_07      = payPaymentTax_07            ;}	// Ŋz07
	public void setPayPaymentTax_08    (Integer payPaymentTax_08  ){ this.payPaymentTax_08      = payPaymentTax_08            ;}	// Ŋz08
	public void setPayPaymentTax_09    (Integer payPaymentTax_09  ){ this.payPaymentTax_09      = payPaymentTax_09            ;}	// Ŋz09
	public void setPayPaymentTax_10    (Integer payPaymentTax_10  ){ this.payPaymentTax_10      = payPaymentTax_10            ;}	// Ŋz10
	public void setPayPaymentTax_11    (Integer payPaymentTax_11  ){ this.payPaymentTax_11      = payPaymentTax_11            ;}	// Ŋz11
	public void setPayPaymentTax_12    (Integer payPaymentTax_12  ){ this.payPaymentTax_12      = payPaymentTax_12            ;}	// Ŋz12

	public void setBonusMonth_01         (String bonusMonth_01       ){ this.bonusMonth_01           =bonusMonth_01                 ;}	// x(ܗ^)01
	public void setBonusMonth_02         (String bonusMonth_02       ){ this.bonusMonth_02           =bonusMonth_02                 ;}	// x(ܗ^)02
	public void setBonusMonth_03         (String bonusMonth_03       ){ this.bonusMonth_03           =bonusMonth_03                 ;}	// x(ܗ^)03
	public void setBonusMonth_04         (String bonusMonth_04       ){ this.bonusMonth_04           =bonusMonth_04                 ;}	// x(ܗ^)04
	public void setBonusMonth_05         (String bonusMonth_05       ){ this.bonusMonth_05           =bonusMonth_05                 ;}	// x(ܗ^)05
	public void setBonusMonth_06         (String bonusMonth_06       ){ this.bonusMonth_06           =bonusMonth_06                 ;}	// x(ܗ^)06
	
	public void setBonusPayDay_01        (String bonusPayDay_01      ){ this.bonusPayDay_01          =bonusPayDay_01                ;}	// x(ܗ^)01
	public void setBonusPayDay_02        (String bonusPayDay_02      ){ this.bonusPayDay_02          =bonusPayDay_02                ;}	// x(ܗ^)02
	public void setBonusPayDay_03        (String bonusPayDay_03      ){ this.bonusPayDay_03          =bonusPayDay_03                ;}	// x(ܗ^)03
	public void setBonusPayDay_04        (String bonusPayDay_04      ){ this.bonusPayDay_04          =bonusPayDay_04                ;}	// x(ܗ^)04
	public void setBonusPayDay_05        (String bonusPayDay_05      ){ this.bonusPayDay_05          =bonusPayDay_05                ;}	// x(ܗ^)05
	public void setBonusPayDay_06        (String bonusPayDay_06      ){ this.bonusPayDay_06          =bonusPayDay_06                ;}	// x(ܗ^)06
	
	public void setBonTotalAllowance_01  (Integer bonTotalAllowance_01){ this.bonTotalAllowance_01    =bonTotalAllowance_01          ;}	// xz(ܗ^01)
	public void setBonTotalAllowance_02  (Integer bonTotalAllowance_02){ this.bonTotalAllowance_02    =bonTotalAllowance_02          ;}	// xz(ܗ^02)
	public void setBonTotalAllowance_03  (Integer bonTotalAllowance_03){ this.bonTotalAllowance_03    =bonTotalAllowance_03          ;}	// xz(ܗ^03)
	public void setBonTotalAllowance_04  (Integer bonTotalAllowance_04){ this.bonTotalAllowance_04    =bonTotalAllowance_04          ;}	// xz(ܗ^04)
	public void setBonTotalAllowance_05  (Integer bonTotalAllowance_05){ this.bonTotalAllowance_05    =bonTotalAllowance_05          ;}	// xz(ܗ^05)
	public void setBonTotalAllowance_06  (Integer bonTotalAllowance_06){ this.bonTotalAllowance_06    =bonTotalAllowance_06          ;}	// xz(ܗ^06)
	
	public void setBonTaxFree_01         (Integer bonTaxFree_01       ){ this.bonTaxFree_01           =bonTaxFree_01                 ;}	// ېŊz(ܗ^)01
	public void setBonTaxFree_02         (Integer bonTaxFree_02       ){ this.bonTaxFree_02           =bonTaxFree_02                 ;}	// ېŊz(ܗ^)02
	public void setBonTaxFree_03         (Integer bonTaxFree_03       ){ this.bonTaxFree_03           =bonTaxFree_03                 ;}	// ېŊz(ܗ^)03
	public void setBonTaxFree_04         (Integer bonTaxFree_04       ){ this.bonTaxFree_04           =bonTaxFree_04                 ;}	// ېŊz(ܗ^)04
	public void setBonTaxFree_05         (Integer bonTaxFree_05       ){ this.bonTaxFree_05           =bonTaxFree_05                 ;}	// ېŊz(ܗ^)05
	public void setBonTaxFree_06         (Integer bonTaxFree_06       ){ this.bonTaxFree_06           =bonTaxFree_06                 ;}	// ېŊz(ܗ^)06
	
	public void setBonTaxation_01        (Integer bonTaxation_01      ){ this.bonTaxation_01          =bonTaxation_01                ;}	// ېŎxz(ܗ^)01
	public void setBonTaxation_02        (Integer bonTaxation_02      ){ this.bonTaxation_02          =bonTaxation_02                ;}	// ېŎxz(ܗ^)02
	public void setBonTaxation_03        (Integer bonTaxation_03      ){ this.bonTaxation_03          =bonTaxation_03                ;}	// ېŎxz(ܗ^)03
	public void setBonTaxation_04        (Integer bonTaxation_04      ){ this.bonTaxation_04          =bonTaxation_04                ;}	// ېŎxz(ܗ^)04
	public void setBonTaxation_05        (Integer bonTaxation_05      ){ this.bonTaxation_05          =bonTaxation_05                ;}	// ېŎxz(ܗ^)05
	public void setBonTaxation_06        (Integer bonTaxation_06      ){ this.bonTaxation_06          =bonTaxation_06                ;}	// ېŎxz(ܗ^)06
	
	public void setBonSocInsDeduction_01 (Integer bonSocInsDeduction_01   ){ this.bonSocInsDeduction_01   =bonSocInsDeduction_01         ;}	// Љی(ܗ^)01
	public void setBonSocInsDeduction_02 (Integer bonSocInsDeduction_02   ){ this.bonSocInsDeduction_02   =bonSocInsDeduction_02         ;}	// Љی(ܗ^)02
	public void setBonSocInsDeduction_03 (Integer bonSocInsDeduction_03   ){ this.bonSocInsDeduction_03   =bonSocInsDeduction_03         ;}	// Љی(ܗ^)03
	public void setBonSocInsDeduction_04 (Integer bonSocInsDeduction_04   ){ this.bonSocInsDeduction_04   =bonSocInsDeduction_04         ;}	// Љی(ܗ^)04
	public void setBonSocInsDeduction_05 (Integer bonSocInsDeduction_05   ){ this.bonSocInsDeduction_05   =bonSocInsDeduction_05         ;}	// Љی(ܗ^)05
	public void setBonSocInsDeduction_06 (Integer bonSocInsDeduction_06   ){ this.bonSocInsDeduction_06   =bonSocInsDeduction_06         ;}	// Љی(ܗ^)06
	
	public void setBonPayInsDeduction_01 (Integer bonPayInsDeduction_01   ){ this.bonPayInsDeduction_01   =bonPayInsDeduction_01         ;}	// ЉیT̋^̋z(ܗ^)01
	public void setBonPayInsDeduction_02 (Integer bonPayInsDeduction_02   ){ this.bonPayInsDeduction_02   =bonPayInsDeduction_02         ;}	// ЉیT̋^̋z(ܗ^)02
	public void setBonPayInsDeduction_03 (Integer bonPayInsDeduction_03   ){ this.bonPayInsDeduction_03   =bonPayInsDeduction_03         ;}	// ЉیT̋^̋z(ܗ^)03
	public void setBonPayInsDeduction_04 (Integer bonPayInsDeduction_04   ){ this.bonPayInsDeduction_04   =bonPayInsDeduction_04         ;}	// ЉیT̋^̋z(ܗ^)04
	public void setBonPayInsDeduction_05 (Integer bonPayInsDeduction_05   ){ this.bonPayInsDeduction_05   =bonPayInsDeduction_05         ;}	// ЉیT̋^̋z(ܗ^)05
	public void setBonPayInsDeduction_06 (Integer bonPayInsDeduction_06   ){ this.bonPayInsDeduction_06   =bonPayInsDeduction_06         ;}	// ЉیT̋^̋z(ܗ^)06
	
	public void setBonDependentCount_01  (Integer bonDependentCount_01){ this.bonDependentCount_01    =bonDependentCount_01          ;}	// }{e(ܗ^)01
	public void setBonDependentCount_02  (Integer bonDependentCount_02){ this.bonDependentCount_02    =bonDependentCount_02          ;}	// }{e(ܗ^)02
	public void setBonDependentCount_03  (Integer bonDependentCount_03){ this.bonDependentCount_03    =bonDependentCount_03          ;}	// }{e(ܗ^)03
	public void setBonDependentCount_04  (Integer bonDependentCount_04){ this.bonDependentCount_04    =bonDependentCount_04          ;}	// }{e(ܗ^)04
	public void setBonDependentCount_05  (Integer bonDependentCount_05){ this.bonDependentCount_05    =bonDependentCount_05          ;}	// }{e(ܗ^)05
	public void setBonDependentCount_06  (Integer bonDependentCount_06){ this.bonDependentCount_06    =bonDependentCount_06          ;}	// }{e(ܗ^)06
		
	public void setBonIncomeTax_01       (Integer bonIncomeTax_01     ){ this.bonIncomeTax_01         =bonIncomeTax_01               ;}	// (ܗ^)01
	public void setBonIncomeTax_02       (Integer bonIncomeTax_02     ){ this.bonIncomeTax_02         =bonIncomeTax_02               ;}	// (ܗ^)02
	public void setBonIncomeTax_03       (Integer bonIncomeTax_03     ){ this.bonIncomeTax_03         =bonIncomeTax_03               ;}	// (ܗ^)03
	public void setBonIncomeTax_04       (Integer bonIncomeTax_04     ){ this.bonIncomeTax_04         =bonIncomeTax_04               ;}	// (ܗ^)04
	public void setBonIncomeTax_05       (Integer bonIncomeTax_05     ){ this.bonIncomeTax_05         =bonIncomeTax_05               ;}	// (ܗ^)05
	public void setBonIncomeTax_06       (Integer bonIncomeTax_06     ){ this.bonIncomeTax_06         =bonIncomeTax_06               ;}	// (ܗ^)06
	
	public void setBonIncomeTaxRate_01(Float  bonIncomeTaxRate_01) { this.bonIncomeTaxRate_01 = bonIncomeTaxRate_01    ; }// ŗ(ܗ^)01
	public void setBonIncomeTaxRate_02(Float  bonIncomeTaxRate_02) { this.bonIncomeTaxRate_02 = bonIncomeTaxRate_02    ; }// ŗ(ܗ^)02
	public void setBonIncomeTaxRate_03(Float  bonIncomeTaxRate_03) { this.bonIncomeTaxRate_03 = bonIncomeTaxRate_03    ; }// ŗ(ܗ^)03
	public void setBonIncomeTaxRate_04(Float  bonIncomeTaxRate_04) { this.bonIncomeTaxRate_04 = bonIncomeTaxRate_04    ; }// ŗ(ܗ^)04
	public void setBonIncomeTaxRate_05(Float  bonIncomeTaxRate_05) { this.bonIncomeTaxRate_05 = bonIncomeTaxRate_05    ; }// ŗ(ܗ^)05
	public void setBonIncomeTaxRate_06(Float  bonIncomeTaxRate_06) { this.bonIncomeTaxRate_06 = bonIncomeTaxRate_06    ; }// ŗ(ܗ^)06

	public void setBonAdjCalcGap_01      (Integer bonAdjCalcGap_01    ){ this.bonAdjCalcGap_01        =bonAdjCalcGap_01              ;}	// Nɂߕs(ܗ^)01
	public void setBonAdjCalcGap_02      (Integer bonAdjCalcGap_02    ){ this.bonAdjCalcGap_02        =bonAdjCalcGap_02              ;}	// Nɂߕs(ܗ^)02
	public void setBonAdjCalcGap_03      (Integer bonAdjCalcGap_03    ){ this.bonAdjCalcGap_03        =bonAdjCalcGap_03              ;}	// Nɂߕs(ܗ^)03
	public void setBonAdjCalcGap_04      (Integer bonAdjCalcGap_04    ){ this.bonAdjCalcGap_04        =bonAdjCalcGap_04              ;}	// Nɂߕs(ܗ^)04
	public void setBonAdjCalcGap_05      (Integer bonAdjCalcGap_05    ){ this.bonAdjCalcGap_05        =bonAdjCalcGap_05              ;}	// Nɂߕs(ܗ^)05
	public void setBonAdjCalcGap_06      (Integer bonAdjCalcGap_06    ){ this.bonAdjCalcGap_06        =bonAdjCalcGap_06              ;}	// Nɂߕs(ܗ^)06

	public void setBonVariousDeduction_01(Integer bonVariousDeduction_01  ){ this.bonVariousDeduction_01  =bonVariousDeduction_01        ;}	// T(ܗ^)01
	public void setBonVariousDeduction_02(Integer bonVariousDeduction_02  ){ this.bonVariousDeduction_02  =bonVariousDeduction_02        ;}	// T(ܗ^)02
	public void setBonVariousDeduction_03(Integer bonVariousDeduction_03  ){ this.bonVariousDeduction_03  =bonVariousDeduction_03        ;}	// T(ܗ^)03
	public void setBonVariousDeduction_04(Integer bonVariousDeduction_04  ){ this.bonVariousDeduction_04  =bonVariousDeduction_04        ;}	// T(ܗ^)04
	public void setBonVariousDeduction_05(Integer bonVariousDeduction_05  ){ this.bonVariousDeduction_05  =bonVariousDeduction_05        ;}	// T(ܗ^)05
	public void setBonVariousDeduction_06(Integer bonVariousDeduction_06  ){ this.bonVariousDeduction_06  =bonVariousDeduction_06        ;}	// T(ܗ^)06
	
	public void setBonPaymentTotal_01    (Integer bonPaymentTotal_01  ){ this.bonPaymentTotal_01      =bonPaymentTotal_01            ;}	// xz(ܗ^)01
	public void setBonPaymentTotal_02    (Integer bonPaymentTotal_02  ){ this.bonPaymentTotal_02      =bonPaymentTotal_02            ;}	// xz(ܗ^)02
	public void setBonPaymentTotal_03    (Integer bonPaymentTotal_03  ){ this.bonPaymentTotal_03      =bonPaymentTotal_03            ;}	// xz(ܗ^)03
	public void setBonPaymentTotal_04    (Integer bonPaymentTotal_04  ){ this.bonPaymentTotal_04      =bonPaymentTotal_04            ;}	// xz(ܗ^)04
	public void setBonPaymentTotal_05    (Integer bonPaymentTotal_05  ){ this.bonPaymentTotal_05      =bonPaymentTotal_05            ;}	// xz(ܗ^)05
	public void setBonPaymentTotal_06    (Integer bonPaymentTotal_06  ){ this.bonPaymentTotal_06      =bonPaymentTotal_06            ;}	// xz(ܗ^)06

	public void setBonPaymentTax_01    (Integer bonPaymentTax_01  ){ this.bonPaymentTax_01      = bonPaymentTax_01            ;}	// Ŋz01
	public void setBonPaymentTax_02    (Integer bonPaymentTax_02  ){ this.bonPaymentTax_02      = bonPaymentTax_02            ;}	// Ŋz02
	public void setBonPaymentTax_03    (Integer bonPaymentTax_03  ){ this.bonPaymentTax_03      = bonPaymentTax_03            ;}	// Ŋz03
	public void setBonPaymentTax_04    (Integer bonPaymentTax_04  ){ this.bonPaymentTax_04      = bonPaymentTax_04            ;}	// Ŋz04
	public void setBonPaymentTax_05    (Integer bonPaymentTax_05  ){ this.bonPaymentTax_05      = bonPaymentTax_05            ;}	// Ŋz05
	public void setBonPaymentTax_06    (Integer bonPaymentTax_06  ){ this.bonPaymentTax_06      = bonPaymentTax_06            ;}	// Ŋz06
	
	public void setTotalAllowance        (Integer totalAllowance      ){ this.totalAllowance          =totalAllowance                ;}	// xzv
	public void setTaxFree               (Integer taxFree             ){ this.taxFree                 =taxFree                       ;}	// ېŊzv
	public void setTaxation              (Integer taxation            ){ this.taxation                =taxation                      ;}	// ېŊzv
	public void setSocInsDeduction       (Integer socInsDeduction     ){ this.socInsDeduction         =socInsDeduction               ;}	// Љیv 
	public void setTotalPayInsDeduction  (Integer totalPayInsDeduction){ this.totalPayInsDeduction    =totalPayInsDeduction          ;}	// ЉیT̋^̋zv
	public void setIncomeTax             (Integer incomeTax           ){ this.incomeTax               =incomeTax                     ;}	// ōv
	public void setVariousDeduction      (Integer variousDeduction    ){ this.variousDeduction        =variousDeduction              ;}	// Tv
	public void setPaymentTotal          (Integer paymentTotal        ){ this.paymentTotal            =paymentTotal                  ;}	// xzv
	public void setMidwayType            (Integer midwayType          ){ this.midwayType              =midwayType                    ;}	// rЋ敪
	public void setFormerIncome          (Integer formerIncome        ){ this.formerIncome            =formerIncome                  ;}	// OΖz
	public void setFormerInsurance       (Integer formerInsurance     ){ this.formerInsurance         =formerInsurance               ;}	// OΖЉیz
	public void setFormerTax             (Integer formerTax           ){ this.formerTax               =formerTax                     ;}	// OΖ揊Ŋz

	public void setPaymentAllowance      (Integer paymentAllowance         ){ this.paymentAllowance         =paymentAllowance         ;}	// ^A蓖z
	public void setPaymentIncomeTax      (Integer paymentIncomeTax         ){ this.paymentIncomeTax         =paymentIncomeTax         ;}	// ^A蓖Ŋz
	public void setBonusAllowance        (Integer bonusAllowance           ){ this.bonusAllowance           =bonusAllowance           ;}	// ܗ^z
	public void setBonusIncomeTax        (Integer bonusIncomeTax           ){ this.bonusIncomeTax           =bonusIncomeTax           ;}	// ܗ^Ŋz
	public void setMidwayAdjustIncome    (Integer midwayAdjustIncome       ){ this.midwayAdjustIncome       =midwayAdjustIncome       ;}	// rAz
	public void setMidwayAdjustTax       (Integer midwayAdjustTax          ){ this.midwayAdjustTax          =midwayAdjustTax          ;}	// rAŊz
	public void setAdjTotalAllowance     (Integer adjTotalAllowance        ){ this.adjTotalAllowance        =adjTotalAllowance        ;}	// xzv
	public void setAdjTotalIncome        (Integer adjTotalIncome           ){ this.adjTotalIncome           =adjTotalIncome           ;}	// Ŋzv
	public void setAfterDeductIncome     (Integer afterDeductIncome           ){ this.afterDeductIncome           =afterDeductIncome           ;}	// ^T̋^̋z
	public void setPayInsDeduction       (Integer payInsDeduction             ){ this.payInsDeduction             =payInsDeduction             ;}	// Љی^̍T
	public void setSocialInsDeduction    (Integer socialInsDeduction          ){ this.socialInsDeduction          =socialInsDeduction          ;}	// ЉیTz
	public void setMutualAidDeduction    (Integer mutualAidDeduction          ){ this.mutualAidDeduction          =mutualAidDeduction          ;}	// K͊Ƌϓ|Tz
	public void setLifeInsDeduction      (Integer lifeInsDeduction            ){ this.lifeInsDeduction            =lifeInsDeduction            ;}	// یTz
	public void setDamageInsDeduction    (Integer damageInsDeduction          ){ this.damageInsDeduction          =damageInsDeduction          ;}	// QیTz
	public void setSpouseSpDeduction     (Integer spouseSpDeduction           ){ this.spouseSpDeduction           =spouseSpDeduction           ;}	// zғʍTz
	public void setDependentsDeduction   (Integer dependentsDeduction         ){ this.dependentsDeduction         =dependentsDeduction         ;}	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	public void setIncomeDeductSum       (Integer incomeDeductSum             ){ this.incomeDeductSum             =incomeDeductSum             ;}	// Tzv
	public void setFinalIncomeTax        (Integer finalIncomeTax              ){ this.finalIncomeTax              =finalIncomeTax              ;}	// NŊz
	public void setHouseLoanDeduction    (Integer houseLoanDeduction          ){ this.houseLoanDeduction          =houseLoanDeduction          ;}	// ZؓʍTz
	public void setTaxGap                (Integer taxGap                      ){ this.taxGap     =taxGap                                        ;}	// Ŋz擾
	public void setCalcTaxedIncome       (Integer calcTaxedIncome             ){ this.calcTaxedIncome             =calcTaxedIncome             ;}	// ېŋ^z
	public void setSpouseSumIncome       (Integer spouseSumIncome             ){ this.spouseSumIncome             =spouseSumIncome             ;}	// z҂̖{N̍vžϊz
	public void setGeneralLifeIns        (Integer generalLifeIns              ){ this.generalLifeIns              =generalLifeIns              ;}	// ʂ̐ی
	public void setPrivatePension        (Integer privatePension              ){ this.privatePension              =privatePension              ;}	// lNی
	public void setEarthquakeIns        (Integer earthquakeIns              ){ this.earthquakeIns              =earthquakeIns              ;}	// nkی
	public void setLongTermDamageIns     (Integer longTermDamageIns           ){ this.longTermDamageIns           =longTermDamageIns           ;}	// Qی
	public void setAllowanceAdjustment   (Integer allowanceAdjustment         ){ this.allowanceAdjustment         =allowanceAdjustment         ;}	// xz
	public void setTaxFreeAdjustment     (Integer taxFreeAdjustment           ){ this.taxFreeAdjustment           =taxFreeAdjustment           ;}	// ېŒz
	public void setTaxIncAdjustment      (Integer taxIncAdjustment            ){ this.taxIncAdjustment            =taxIncAdjustment            ;}	// Œz
	public void setWithholdSlipNotes     (String withholdSlipNotes           ){ this.withholdSlipNotes           =withholdSlipNotes           ;}	// 򒥎[Ev
	public void setCalcIncomeTax         (Integer calcIncomeTax               ){ this.calcIncomeTax               =calcIncomeTax               ;}	// ZoNŊz
	public void setAdjustedIncomeTax     (Integer adjustedIncomeTax           ){ this.adjustedIncomeTax           =adjustedIncomeTax           ;}	// NNŊz
	public void setDeductedIncomeTax     (Integer deductedIncomeTax           ){ this.deductedIncomeTax           =deductedIncomeTax           ;}	// N藦TzŊz
	public void setSocInsAdjustment      (Integer socInsAdjustment            ){ this.socInsAdjustment            =socInsAdjustment            ;}	// Љیz
	
	public void setIncomeTaxType      (String incomeTaxType            ){ this.incomeTaxType            =incomeTaxType            ;}	// ېŋ敪
	public void setAdjustmentType     (String adjustmentType            ){ this.adjustmentType            =adjustmentType            ;}	// N敪
	
	public void setSpHandicap            (String spHandicap                  ){ this.spHandicap                  =spHandicap                  ;}// ʏQ 
	public void setGeHandicap            (String geHandicap                  ){ this.geHandicap                  =geHandicap                  ;}// ʏQ
	public void setGeWidow               (String geWidow                     ){ this.geWidow                     =geWidow                     ;}// ʉǕw
	public void setSpWidow               (String spWidow                     ){ this.spWidow                     =spWidow                     ;}// ʉǕw
	public void setWidow                 (String widow                       ){ this.widow                       =widow                       ;}// Ǖv
	public void setStudentGeneral        (String studentGeneral              ){ this.studentGeneral              =studentGeneral              ;}// ΘJw
	public void setLwSpHandiEl           (String lwSpHandiEl                 ){ this.lwSpHandiEl                 =lwSpHandiEl                 ;}// ʏQҘVl
	public void setLwSpHandicap          (String lwSpHandicap                ){ this.lwSpHandicap                =lwSpHandicap                ;}// ʏQ
	public void setSpouseEl              (String spouseEl                    ){ this.spouseEl                    =spouseEl                    ;}// Vlz
	public void setSpouseGe              (String spouseGe                    ){ this.spouseGe                    =spouseGe                    ;}// ʔz(̑)
	public void setGeneralDependent      (String generalDependent            ){ this.generalDependent          = generalDependent          ;} // ʕ}{e
	public void setSpecificDependent     (String specificDependent           ){ this.specificDependent         = specificDependent         ;} // }{e
	public void setElderlyDependent      (String elderlyDependent            ){ this.elderlyDependent          = elderlyDependent          ;} // Vl}{e
	public void setLiveWithEldRel        (String liveWithEldRel              ){ this.liveWithEldRel            = liveWithEldRel            ;} // Ve
	public void setLiveWithHandiGe       (String liveWithHandiGe             ){ this.liveWithHandiGe           = liveWithHandiGe           ;} // 
	public void setLiveWithHandiSp       (String liveWithHandiSp             ){ this.liveWithHandiSp           = liveWithHandiSp           ;} // 
	public void setLiveWithHandiEl       (String liveWithHandiEl             ){ this.liveWithHandiEl           = liveWithHandiEl           ;} // Vl
	public void setLiveWithHandiEr       (String liveWithHandiEr             ){ this.liveWithHandiEr           = liveWithHandiEr           ;} // Ve
	public void setGeneralHandicap       (String generalHandicap             ){ this.generalHandicap           = generalHandicap           ;} // ʏQ
	public void setSpecificHandicap      (String specificHandicap            ){ this.specificHandicap          = specificHandicap          ;} // ʏQ
	public void setTotallHandicap        (String totallHandicap              ){ this.totallHandicap            = totallHandicap            ;} // QҌv
	public void setTotallDeduction       (String totallDeduction             ){ this.totallDeduction           = totallDeduction           ;} // TΏێҐ
	public void setConsortFlg            (String consortFlg					){ this.consortFlg					= consortFlg				;} // zҗL\("L"E"")
	
	
	public void setCompanyName           (String companyName            ){ this.companyName          =companyName          ;}// Ж
	
	public void setTotalTotalPayTotalAllowance  (Integer totalPayTotalAllowance  ){ this.totalPayTotalAllowance   = totalPayTotalAllowance   ; }	//^xzv
	public void setTotalTotalPayTaxFree         (Integer totalPayTaxFree         ){ this.totalPayTaxFree         = totalPayTaxFree           ; }	//^ېŊzv
	public void setTotalTotalPayTaxation        (Integer totalPayTaxation        ){ this.totalPayTaxation         = totalPayTaxation         ; }	//^ېŎxzv
	public void setTotalTotalPayIncomeTax       (Integer totalPayIncomeTax       ){ this.totalPayIncomeTax        = totalPayIncomeTax        ; }	//^ōv
	public void setTotalTotalPaySocInsDeduction (Integer totalPaySocInsDeduction ){ this.totalPaySocInsDeduction  = totalPaySocInsDeduction  ; }	//^Љیv
	public void setTotalTotalPayPayInsDeduction (Integer totalPayPayInsDeduction ){ this.totalPayPayInsDeduction  = totalPayPayInsDeduction  ; }	//^ЉیT̋^̋zv
	public void setTotalTotalPayVariousDeduction(Integer totalPayVariousDeduction){ this.totalPayVariousDeduction = totalPayVariousDeduction ; }	//^Tv
	public void setTotalTotalPayPaymentTotal    (Integer totalPayPaymentTotal    ){ this.totalPayPaymentTotal     = totalPayPaymentTotal     ; }	//^xzv
	public void setTotalTotalPayAdjCalcGap      (Integer totalPayAdjCalcGap      ){ this.totalPayAdjCalcGap       = totalPayAdjCalcGap       ; }	//^Nɂߕsv

	public void setTotalBonTotalAllowance  	(Integer totalBonTotalAllowance  ){ this.totalBonTotalAllowance   = totalBonTotalAllowance   ; }		//ܗ^xzv
	public void setTotalBonTaxFree         	(Integer totalBonTaxFree         ){ this.totalBonTaxFree         = totalBonTaxFree           ; }		//ܗ^ېŊzv
	public void setTotalBonTaxation        	(Integer totalBonTaxation        ){ this.totalBonTaxation         = totalBonTaxation         ; }		//ܗ^ېŎxzv
	public void setTotalBonIncomeTax       	(Integer totalBonIncomeTax       ){ this.totalBonIncomeTax        = totalBonIncomeTax        ; }		//ܗ^ōv
	public void setTotalBonSocInsDeduction 	(Integer totalBonSocInsDeduction ){ this.totalBonSocInsDeduction  = totalBonSocInsDeduction  ; }		//ܗ^Љیv
	public void setTotalBonPayInsDeduction 	(Integer totalBonPayInsDeduction ){ this.totalBonPayInsDeduction  = totalBonPayInsDeduction  ; }		//ܗ^ЉیT̏ܗ^̋zv
	public void setTotalBonVariousDeduction	(Integer totalBonVariousDeduction){ this.totalBonVariousDeduction = totalBonVariousDeduction ; }		//ܗ^Tv
	public void setTotalBonPaymentTotal    	(Integer totalBonPaymentTotal    ){ this.totalBonPaymentTotal     = totalBonPaymentTotal     ; }		//ܗ^xzv
	public void setTotalBonAdjCalcGap      	(Integer totalBonAdjCalcGap      ){ this.totalBonAdjCalcGap       = totalBonAdjCalcGap       ; }		//ܗ^Nɂߕsv

	public void setMonthType_01      (String monthType_01      ){ this.monthType_01       = monthType_01       ; }// 敪01
	public void setMonthType_02      (String monthType_02      ){ this.monthType_02       = monthType_02       ; }// 敪02
	public void setMonthType_03      (String monthType_03      ){ this.monthType_03       = monthType_03       ; }// 敪03
	public void setMonthType_04      (String monthType_04      ){ this.monthType_04       = monthType_04       ; }// 敪04
	public void setMonthType_05      (String monthType_05      ){ this.monthType_05       = monthType_05       ; }// 敪05
	public void setMonthType_06      (String monthType_06      ){ this.monthType_06       = monthType_06       ; }// 敪06
	public void setMonthType_07      (String monthType_07      ){ this.monthType_07       = monthType_07       ; }// 敪07
	public void setMonthType_08      (String monthType_08      ){ this.monthType_08       = monthType_08       ; }// 敪08
	public void setMonthType_09      (String monthType_09      ){ this.monthType_09       = monthType_09       ; }// 敪09
	public void setMonthType_10      (String monthType_10      ){ this.monthType_10       = monthType_10       ; }// 敪10
	public void setMonthType_11      (String monthType_11      ){ this.monthType_11       = monthType_11       ; }// 敪11
	public void setMonthType_12      (String monthType_12      ){ this.monthType_12       = monthType_12       ; }// 敪12
	
	public String getAdjustYear () { return adjustYear        ; }
	public String getAdjustYear_YY() { return adjustYear_YY   ; }
	public String getStationCode () { return stationCode       ; }
	public String getStationName () { return stationName       ; }
	public String getPositionCode() { return positionCode      ; }
	public String getPositionName() { return positionName      ; }
	public String getTouKyu()       { return touKyu            ; }		

	public String getKCode       () { return kCode             ; }
	public String getKName       () { return kName             ; }
	public String getFName       () { return fName             ; }
	public String getPostalCode  () { return postalCode        ; }
	public String getAddress     () { return address           ; }
	public String getBirthDate     () { return birthDate           ; }
	
	public String getPaymentMonth_01        () { return paymentMonth_01               ; }	// x01
	public String getPaymentMonth_02        () { return paymentMonth_02               ; }	// x02
	public String getPaymentMonth_03        () { return paymentMonth_03               ; }	// x03
	public String getPaymentMonth_04        () { return paymentMonth_04               ; }	// x04
	public String getPaymentMonth_05        () { return paymentMonth_05               ; }	// x05
	public String getPaymentMonth_06        () { return paymentMonth_06               ; }	// x06
	public String getPaymentMonth_07        () { return paymentMonth_07               ; }	// x07
	public String getPaymentMonth_08        () { return paymentMonth_08               ; }	// x08
	public String getPaymentMonth_09        () { return paymentMonth_09               ; }	// x09
	public String getPaymentMonth_10        () { return paymentMonth_10               ; }	// x10
	public String getPaymentMonth_11        () { return paymentMonth_11               ; }	// x11
	public String getPaymentMonth_12        () { return paymentMonth_12               ; }	// x12
	public String getPaymentPayDay_01       () { return paymentPayDay_01              ; }	// x01
	public String getPaymentPayDay_02       () { return paymentPayDay_02              ; }	// x02
	public String getPaymentPayDay_03       () { return paymentPayDay_03              ; }	// x03
	public String getPaymentPayDay_04       () { return paymentPayDay_04              ; }	// x04
	public String getPaymentPayDay_05       () { return paymentPayDay_05              ; }	// x05
	public String getPaymentPayDay_06       () { return paymentPayDay_06              ; }	// x06
	public String getPaymentPayDay_07       () { return paymentPayDay_07              ; }	// x07
	public String getPaymentPayDay_08       () { return paymentPayDay_08              ; }	// x08
	public String getPaymentPayDay_09       () { return paymentPayDay_09              ; }	// x09
	public String getPaymentPayDay_10       () { return paymentPayDay_10              ; }	// x10
	public String getPaymentPayDay_11       () { return paymentPayDay_11              ; }	// x11
	public String getPaymentPayDay_12       () { return paymentPayDay_12              ; }	// x12
	public Integer getPayTotalAllowance_01   () { return payTotalAllowance_01          ; }	// xz01 
	public Integer getPayTotalAllowance_02   () { return payTotalAllowance_02          ; }	// xz02
	public Integer getPayTotalAllowance_03   () { return payTotalAllowance_03          ; }	// xz03
	public Integer getPayTotalAllowance_04   () { return payTotalAllowance_04          ; }	// xz04
	public Integer getPayTotalAllowance_05   () { return payTotalAllowance_05          ; }	// xz05
	public Integer getPayTotalAllowance_06   () { return payTotalAllowance_06          ; }	// xz06
	public Integer getPayTotalAllowance_07   () { return payTotalAllowance_07          ; }	// xz07
	public Integer getPayTotalAllowance_08   () { return payTotalAllowance_08          ; }	// xz08
	public Integer getPayTotalAllowance_09   () { return payTotalAllowance_09          ; }	// xz09
	public Integer getPayTotalAllowance_10   () { return payTotalAllowance_10          ; }	// xz10
	public Integer getPayTotalAllowance_11   () { return payTotalAllowance_11          ; }	// xz11
	public Integer getPayTotalAllowance_12   () { return payTotalAllowance_12          ; }	// xz12
	public Integer getPayTaxFree_01          () { return payTaxFree_01                 ; }	// ېŊz01
	public Integer getPayTaxFree_02          () { return payTaxFree_02                 ; }	// ېŊz02
	public Integer getPayTaxFree_03          () { return payTaxFree_03                 ; }	// ېŊz03
	public Integer getPayTaxFree_04          () { return payTaxFree_04                 ; }	// ېŊz04
	public Integer getPayTaxFree_05          () { return payTaxFree_05                 ; }	// ېŊz05
	public Integer getPayTaxFree_06          () { return payTaxFree_06                 ; }	// ېŊz06
	public Integer getPayTaxFree_07          () { return payTaxFree_07                 ; }	// ېŊz07
	public Integer getPayTaxFree_08          () { return payTaxFree_08                 ; }	// ېŊz08
	public Integer getPayTaxFree_09          () { return payTaxFree_09                 ; }	// ېŊz09
	public Integer getPayTaxFree_10          () { return payTaxFree_10                 ; }	// ېŊz10
	public Integer getPayTaxFree_11          () { return payTaxFree_11                 ; }	// ېŊz11
	public Integer getPayTaxFree_12          () { return payTaxFree_12                 ; }	// ېŊz12
	public Integer getPayTaxation_01         () { return payTaxation_01                ; }	// ېŎxz01
	public Integer getPayTaxation_02         () { return payTaxation_02                ; }	// ېŎxz02
	public Integer getPayTaxation_03         () { return payTaxation_03                ; }	// ېŎxz03
	public Integer getPayTaxation_04         () { return payTaxation_04                ; }	// ېŎxz04
	public Integer getPayTaxation_05         () { return payTaxation_05                ; }	// ېŎxz05
	public Integer getPayTaxation_06         () { return payTaxation_06                ; }	// ېŎxz06
	public Integer getPayTaxation_07         () { return payTaxation_07                ; }	// ېŎxz07
	public Integer getPayTaxation_08         () { return payTaxation_08                ; }	// ېŎxz08
	public Integer getPayTaxation_09         () { return payTaxation_09                ; }	// ېŎxz09
	public Integer getPayTaxation_10         () { return payTaxation_10                ; }	// ېŎxz10
	public Integer getPayTaxation_11         () { return payTaxation_11                ; }	// ېŎxz11
	public Integer getPayTaxation_12         () { return payTaxation_12                ; }	// ېŎxz12
	public Integer getPaySocInsDeduction_01  () { return paySocInsDeduction_01         ; }	// Љی01
	public Integer getPaySocInsDeduction_02  () { return paySocInsDeduction_02         ; }	// Љی02
	public Integer getPaySocInsDeduction_03  () { return paySocInsDeduction_03         ; }	// Љی03
	public Integer getPaySocInsDeduction_04  () { return paySocInsDeduction_04         ; }	// Љی04
	public Integer getPaySocInsDeduction_05  () { return paySocInsDeduction_05         ; }	// Љی05
	public Integer getPaySocInsDeduction_06  () { return paySocInsDeduction_06         ; }	// Љی06
	public Integer getPaySocInsDeduction_07  () { return paySocInsDeduction_07         ; }	// Љی07
	public Integer getPaySocInsDeduction_08  () { return paySocInsDeduction_08         ; }	// Љی08
	public Integer getPaySocInsDeduction_09  () { return paySocInsDeduction_09         ; }	// Љی09
	public Integer getPaySocInsDeduction_10  () { return paySocInsDeduction_10         ; }	// Љی10
	public Integer getPaySocInsDeduction_11  () { return paySocInsDeduction_11         ; }	// Љی11
	public Integer getPaySocInsDeduction_12  () { return paySocInsDeduction_12         ; }	// Љی12
	public Integer getPayPayInsDeduction_01  () { return payPayInsDeduction_01         ; }	// ЉیT̋^̋z01
	public Integer getPayPayInsDeduction_02  () { return payPayInsDeduction_02         ; }	// ЉیT̋^̋z02
	public Integer getPayPayInsDeduction_03  () { return payPayInsDeduction_03         ; }	// ЉیT̋^̋z03
	public Integer getPayPayInsDeduction_04  () { return payPayInsDeduction_04         ; }	// ЉیT̋^̋z04
	public Integer getPayPayInsDeduction_05  () { return payPayInsDeduction_05         ; }	// ЉیT̋^̋z05
	public Integer getPayPayInsDeduction_06  () { return payPayInsDeduction_06         ; }	// ЉیT̋^̋z06
	public Integer getPayPayInsDeduction_07  () { return payPayInsDeduction_07         ; }	// ЉیT̋^̋z07
	public Integer getPayPayInsDeduction_08  () { return payPayInsDeduction_08         ; }	// ЉیT̋^̋z08
	public Integer getPayPayInsDeduction_09  () { return payPayInsDeduction_09         ; }	// ЉیT̋^̋z09
	public Integer getPayPayInsDeduction_10  () { return payPayInsDeduction_10         ; }	// ЉیT̋^̋z10
	public Integer getPayPayInsDeduction_11  () { return payPayInsDeduction_11         ; }	// ЉیT̋^̋z11
	public Integer getPayPayInsDeduction_12  () { return payPayInsDeduction_12         ; }	// ЉیT̋^̋z12
	public Integer getPayDependentCount_01   () { return payDependentCount_01          ; }	// }{e(^)01
	public Integer getPayDependentCount_02   () { return payDependentCount_02          ; }	// }{e(^)02
	public Integer getPayDependentCount_03   () { return payDependentCount_03          ; }	// }{e(^)03
	public Integer getPayDependentCount_04   () { return payDependentCount_04          ; }	// }{e(^)04
	public Integer getPayDependentCount_05   () { return payDependentCount_05          ; }	// }{e(^)05
	public Integer getPayDependentCount_06   () { return payDependentCount_06          ; }	// }{e(^)06
	public Integer getPayDependentCount_07   () { return payDependentCount_07          ; }	// }{e(^)07
	public Integer getPayDependentCount_08   () { return payDependentCount_08          ; }	// }{e(^)08
	public Integer getPayDependentCount_09   () { return payDependentCount_09          ; }	// }{e(^)09
	public Integer getPayDependentCount_10   () { return payDependentCount_10          ; }	// }{e(^)10
	public Integer getPayDependentCount_11   () { return payDependentCount_11          ; }	// }{e(^)11
	public Integer getPayDependentCount_12   () { return payDependentCount_12          ; }	// }{e(^)12
	public Integer getPayIncomeTax_01        () { return payIncomeTax_01               ; }	// 01 
	public Integer getPayIncomeTax_02        () { return payIncomeTax_02               ; }	// 02
	public Integer getPayIncomeTax_03        () { return payIncomeTax_03               ; }	// 03
	public Integer getPayIncomeTax_04        () { return payIncomeTax_04               ; }	// 04
	public Integer getPayIncomeTax_05        () { return payIncomeTax_05               ; }	// 05
	public Integer getPayIncomeTax_06        () { return payIncomeTax_06               ; }	// 06
	public Integer getPayIncomeTax_07        () { return payIncomeTax_07               ; }	// 07
	public Integer getPayIncomeTax_08        () { return payIncomeTax_08               ; }	// 08
	public Integer getPayIncomeTax_09        () { return payIncomeTax_09               ; }	// 09
	public Integer getPayIncomeTax_10        () { return payIncomeTax_10               ; }	// 10
	public Integer getPayIncomeTax_11        () { return payIncomeTax_11               ; }	// 11
	public Integer getPayIncomeTax_12        () { return payIncomeTax_12               ; }	// 12
	public Integer getPayAdjCalcGap_01       () { return payAdjCalcGap_01              ; }	// Nɂߕs01
	public Integer getPayAdjCalcGap_02       () { return payAdjCalcGap_02              ; }	// Nɂߕs02
	public Integer getPayAdjCalcGap_03       () { return payAdjCalcGap_03              ; }	// Nɂߕs03
	public Integer getPayAdjCalcGap_04       () { return payAdjCalcGap_04              ; }	// Nɂߕs04
	public Integer getPayAdjCalcGap_05       () { return payAdjCalcGap_05              ; }	// Nɂߕs05
	public Integer getPayAdjCalcGap_06       () { return payAdjCalcGap_06              ; }	// Nɂߕs06
	public Integer getPayAdjCalcGap_07       () { return payAdjCalcGap_07              ; }	// Nɂߕs07
	public Integer getPayAdjCalcGap_08       () { return payAdjCalcGap_08              ; }	// Nɂߕs08
	public Integer getPayAdjCalcGap_09       () { return payAdjCalcGap_09              ; }	// Nɂߕs09
	public Integer getPayAdjCalcGap_10       () { return payAdjCalcGap_10              ; }	// Nɂߕs10
	public Integer getPayAdjCalcGap_11       () { return payAdjCalcGap_11              ; }	// Nɂߕs11
	public Integer getPayAdjCalcGap_12       () { return payAdjCalcGap_12              ; }	// Nɂߕs12
	public Integer getPayVariousDeduction_01 () { return payVariousDeduction_01        ; }	// T01
	public Integer getPayVariousDeduction_02 () { return payVariousDeduction_02        ; }	// T02
	public Integer getPayVariousDeduction_03 () { return payVariousDeduction_03        ; }	// T03
	public Integer getPayVariousDeduction_04 () { return payVariousDeduction_04        ; }	// T04
	public Integer getPayVariousDeduction_05 () { return payVariousDeduction_05        ; }	// T05
	public Integer getPayVariousDeduction_06 () { return payVariousDeduction_06        ; }	// T06
	public Integer getPayVariousDeduction_07 () { return payVariousDeduction_07        ; }	// T07
	public Integer getPayVariousDeduction_08 () { return payVariousDeduction_08        ; }	// T08
	public Integer getPayVariousDeduction_09 () { return payVariousDeduction_09        ; }	// T09
	public Integer getPayVariousDeduction_10 () { return payVariousDeduction_10        ; }	// T10
	public Integer getPayVariousDeduction_11 () { return payVariousDeduction_11        ; }	// T11
	public Integer getPayVariousDeduction_12 () { return payVariousDeduction_12        ; }	// T12
	public Integer getPayPaymentTotal_01     () { return payPaymentTotal_01            ; }	// xz01
	public Integer getPayPaymentTotal_02     () { return payPaymentTotal_02            ; }	// xz02
	public Integer getPayPaymentTotal_03     () { return payPaymentTotal_03            ; }	// xz03
	public Integer getPayPaymentTotal_04     () { return payPaymentTotal_04            ; }	// xz04
	public Integer getPayPaymentTotal_05     () { return payPaymentTotal_05            ; }	// xz05
	public Integer getPayPaymentTotal_06     () { return payPaymentTotal_06            ; }	// xz06
	public Integer getPayPaymentTotal_07     () { return payPaymentTotal_07            ; }	// xz07
	public Integer getPayPaymentTotal_08     () { return payPaymentTotal_08            ; }	// xz08
	public Integer getPayPaymentTotal_09     () { return payPaymentTotal_09            ; }	// xz09
	public Integer getPayPaymentTotal_10     () { return payPaymentTotal_10            ; }	// xz10
	public Integer getPayPaymentTotal_11     () { return payPaymentTotal_11            ; }	// xz11
	public Integer getPayPaymentTotal_12     () { return payPaymentTotal_12            ; }	// xz12
		
	public Integer getPayPaymentTax_01     () { return payPaymentTax_01            ; }	// Ŋz01
	public Integer getPayPaymentTax_02     () { return payPaymentTax_02            ; }	// Ŋz02
	public Integer getPayPaymentTax_03     () { return payPaymentTax_03            ; }	// Ŋz03
	public Integer getPayPaymentTax_04     () { return payPaymentTax_04            ; }	// Ŋz04
	public Integer getPayPaymentTax_05     () { return payPaymentTax_05            ; }	// Ŋz05
	public Integer getPayPaymentTax_06     () { return payPaymentTax_06            ; }	// Ŋz06
	public Integer getPayPaymentTax_07     () { return payPaymentTax_07            ; }	// Ŋz07
	public Integer getPayPaymentTax_08     () { return payPaymentTax_08            ; }	// Ŋz08
	public Integer getPayPaymentTax_09     () { return payPaymentTax_09            ; }	// Ŋz09
	public Integer getPayPaymentTax_10     () { return payPaymentTax_10            ; }	// Ŋz10
	public Integer getPayPaymentTax_11     () { return payPaymentTax_11            ; }	// Ŋz11
	public Integer getPayPaymentTax_12     () { return payPaymentTax_12            ; }	// Ŋz12
	
	public String getBonusMonth_01          () { return bonusMonth_01                 ; }	// x(ܗ^)01
	public String getBonusMonth_02          () { return bonusMonth_02                 ; }	// x(ܗ^)02
	public String getBonusMonth_03          () { return bonusMonth_03                 ; }	// x(ܗ^)03
	public String getBonusMonth_04          () { return bonusMonth_04                 ; }	// x(ܗ^)04
	public String getBonusMonth_05          () { return bonusMonth_05                 ; }	// x(ܗ^)05
	public String getBonusMonth_06          () { return bonusMonth_06                 ; }	// x(ܗ^)06

	public String getBonusPayDay_01         () { return bonusPayDay_01                ; }	// x(ܗ^)01
	public String getBonusPayDay_02         () { return bonusPayDay_02                ; }	// x(ܗ^)02
	public String getBonusPayDay_03         () { return bonusPayDay_03                ; }	// x(ܗ^)03
	public String getBonusPayDay_04         () { return bonusPayDay_04                ; }	// x(ܗ^)04
	public String getBonusPayDay_05         () { return bonusPayDay_05                ; }	// x(ܗ^)05
	public String getBonusPayDay_06         () { return bonusPayDay_06                ; }	// x(ܗ^)06
	
	public Integer getBonTotalAllowance_01   () { return bonTotalAllowance_01          ; }	// xz(ܗ^01)
	public Integer getBonTotalAllowance_02   () { return bonTotalAllowance_02          ; }	// xz(ܗ^02)
	public Integer getBonTotalAllowance_03   () { return bonTotalAllowance_03          ; }	// xz(ܗ^03)
	public Integer getBonTotalAllowance_04   () { return bonTotalAllowance_04          ; }	// xz(ܗ^04)
	public Integer getBonTotalAllowance_05   () { return bonTotalAllowance_05          ; }	// xz(ܗ^05)
	public Integer getBonTotalAllowance_06   () { return bonTotalAllowance_06          ; }	// xz(ܗ^06)
	
	public Integer getBonTaxFree_01          () { return bonTaxFree_01                 ; }	// ېŊz(ܗ^)01
	public Integer getBonTaxFree_02          () { return bonTaxFree_02                 ; }	// ېŊz(ܗ^)02
	public Integer getBonTaxFree_03          () { return bonTaxFree_03                 ; }	// ېŊz(ܗ^)03
	public Integer getBonTaxFree_04          () { return bonTaxFree_04                 ; }	// ېŊz(ܗ^)04
	public Integer getBonTaxFree_05          () { return bonTaxFree_05                 ; }	// ېŊz(ܗ^)05
	public Integer getBonTaxFree_06          () { return bonTaxFree_06                 ; }	// ېŊz(ܗ^)06
	
	public Integer getBonTaxation_01         () { return bonTaxation_01                ; }	// ېŎxz(ܗ^)01
	public Integer getBonTaxation_02         () { return bonTaxation_02                ; }	// ېŎxz(ܗ^)02
	public Integer getBonTaxation_03         () { return bonTaxation_03                ; }	// ېŎxz(ܗ^)03
	public Integer getBonTaxation_04         () { return bonTaxation_04                ; }	// ېŎxz(ܗ^)04
	public Integer getBonTaxation_05         () { return bonTaxation_05                ; }	// ېŎxz(ܗ^)05
	public Integer getBonTaxation_06         () { return bonTaxation_06                ; }	// ېŎxz(ܗ^)06
	
	public Integer getBonSocInsDeduction_01  () { return bonSocInsDeduction_01         ; }	// Љی(ܗ^)01
	public Integer getBonSocInsDeduction_02  () { return bonSocInsDeduction_02         ; }	// Љی(ܗ^)02
	public Integer getBonSocInsDeduction_03  () { return bonSocInsDeduction_03         ; }	// Љی(ܗ^)03
	public Integer getBonSocInsDeduction_04  () { return bonSocInsDeduction_04         ; }	// Љی(ܗ^)04
	public Integer getBonSocInsDeduction_05  () { return bonSocInsDeduction_05         ; }	// Љی(ܗ^)05
	public Integer getBonSocInsDeduction_06  () { return bonSocInsDeduction_06         ; }	// Љی(ܗ^)06
	
	public Integer getBonPayInsDeduction_01  () { return bonPayInsDeduction_01         ; }	// ЉیT̋^̋z(ܗ^)01
	public Integer getBonPayInsDeduction_02  () { return bonPayInsDeduction_02         ; }	// ЉیT̋^̋z(ܗ^)02
	public Integer getBonPayInsDeduction_03  () { return bonPayInsDeduction_03         ; }	// ЉیT̋^̋z(ܗ^)03
	public Integer getBonPayInsDeduction_04  () { return bonPayInsDeduction_04         ; }	// ЉیT̋^̋z(ܗ^)04
	public Integer getBonPayInsDeduction_05  () { return bonPayInsDeduction_05         ; }	// ЉیT̋^̋z(ܗ^)05
	public Integer getBonPayInsDeduction_06  () { return bonPayInsDeduction_06         ; }	// ЉیT̋^̋z(ܗ^)06
	
	public Integer getBonDependentCount_01   () { return bonDependentCount_01          ; }	// }{e(ܗ^)01
	public Integer getBonDependentCount_02   () { return bonDependentCount_02          ; }	// }{e(ܗ^)02
	public Integer getBonDependentCount_03   () { return bonDependentCount_03          ; }	// }{e(ܗ^)03
	public Integer getBonDependentCount_04   () { return bonDependentCount_04          ; }	// }{e(ܗ^)04
	public Integer getBonDependentCount_05   () { return bonDependentCount_05          ; }	// }{e(ܗ^)05
	public Integer getBonDependentCount_06   () { return bonDependentCount_06          ; }	// }{e(ܗ^)06
		
	public Integer getBonIncomeTax_01        () { return bonIncomeTax_01               ; }	// (ܗ^)01
	public Integer getBonIncomeTax_02        () { return bonIncomeTax_02               ; }	// (ܗ^)02
	public Integer getBonIncomeTax_03        () { return bonIncomeTax_03               ; }	// (ܗ^)03
	public Integer getBonIncomeTax_04        () { return bonIncomeTax_04               ; }	// (ܗ^)04
	public Integer getBonIncomeTax_05        () { return bonIncomeTax_05               ; }	// (ܗ^)05
	public Integer getBonIncomeTax_06        () { return bonIncomeTax_06               ; }	// (ܗ^)06
	
	public Float getBonIncomeTaxRate_01    () { return bonIncomeTaxRate_01           ; }	//ŗ(ܗ^)01
	public Float getBonIncomeTaxRate_02    () { return bonIncomeTaxRate_02           ; }	//ŗ(ܗ^)02
	public Float getBonIncomeTaxRate_03    () { return bonIncomeTaxRate_03           ; }	//ŗ(ܗ^)03
	public Float getBonIncomeTaxRate_04    () { return bonIncomeTaxRate_04           ; }	//ŗ(ܗ^)04
	public Float getBonIncomeTaxRate_05    () { return bonIncomeTaxRate_05           ; }	//ŗ(ܗ^)05
	public Float getBonIncomeTaxRate_06    () { return bonIncomeTaxRate_06           ; }	//ŗ(ܗ^)06

	public Integer getBonAdjCalcGap_01       () { return bonAdjCalcGap_01              ; }	// Nɂߕs(ܗ^)01
	public Integer getBonAdjCalcGap_02       () { return bonAdjCalcGap_02              ; }	// Nɂߕs(ܗ^)02
	public Integer getBonAdjCalcGap_03       () { return bonAdjCalcGap_03              ; }	// Nɂߕs(ܗ^)03
	public Integer getBonAdjCalcGap_04       () { return bonAdjCalcGap_04              ; }	// Nɂߕs(ܗ^)04
	public Integer getBonAdjCalcGap_05       () { return bonAdjCalcGap_05              ; }	// Nɂߕs(ܗ^)05
	public Integer getBonAdjCalcGap_06       () { return bonAdjCalcGap_06              ; }	// Nɂߕs(ܗ^)06
	
	public Integer getBonVariousDeduction_01 () { return bonVariousDeduction_01        ; }	// T(ܗ^)01
	public Integer getBonVariousDeduction_02 () { return bonVariousDeduction_02        ; }	// T(ܗ^)02
	public Integer getBonVariousDeduction_03 () { return bonVariousDeduction_03        ; }	// T(ܗ^)03
	public Integer getBonVariousDeduction_04 () { return bonVariousDeduction_04        ; }	// T(ܗ^)04
	public Integer getBonVariousDeduction_05 () { return bonVariousDeduction_05        ; }	// T(ܗ^)05
	public Integer getBonVariousDeduction_06 () { return bonVariousDeduction_06        ; }	// T(ܗ^)06
	
	public Integer getBonPaymentTotal_01     () { return bonPaymentTotal_01            ; }	// xz(ܗ^)01
	public Integer getBonPaymentTotal_02     () { return bonPaymentTotal_02            ; }	// xz(ܗ^)02
	public Integer getBonPaymentTotal_03     () { return bonPaymentTotal_03            ; }	// xz(ܗ^)03
	public Integer getBonPaymentTotal_04     () { return bonPaymentTotal_04            ; }	// xz(ܗ^)04
	public Integer getBonPaymentTotal_05     () { return bonPaymentTotal_05            ; }	// xz(ܗ^)05
	public Integer getBonPaymentTotal_06     () { return bonPaymentTotal_06            ; }	// xz(ܗ^)06

	public Integer getBonPaymentTax_01(){ return bonPaymentTax_01            ; }	// Ŋz01
	public Integer getBonPaymentTax_02(){ return bonPaymentTax_02            ; }	// Ŋz02
	public Integer getBonPaymentTax_03(){ return bonPaymentTax_03            ; }	// Ŋz03
	public Integer getBonPaymentTax_04(){ return bonPaymentTax_04            ; }	// Ŋz04
	public Integer getBonPaymentTax_05(){ return bonPaymentTax_05            ; }	// Ŋz05
	public Integer getBonPaymentTax_06(){ return bonPaymentTax_06            ; }	// Ŋz06
	
	public Integer getTotalAllowance         () { return totalAllowance                ; }	// xzv
	public Integer getTaxFree                () { return taxFree                       ; }	// ېŊzv
	public Integer getTaxation               () { return taxation                      ; }	// ېŊzv
	public Integer getSocInsDeduction        () { return socInsDeduction               ; }	// Љیv 
	public Integer getTotalPayInsDeduction   () { return totalPayInsDeduction          ; }	// ЉیT̋^̋zv
	public Integer getIncomeTax              () { return incomeTax                     ; }	// ōv
	public Integer getVariousDeduction       () { return variousDeduction              ; }	// Tv
	public Integer getPaymentTotal           () { return paymentTotal                  ; }	// xzv
	
	public Integer getMidwayType             () { return midwayType                    ; }	// rЋ敪
	public Integer getFormerIncome           () { return formerIncome                  ; }	// OΖz
	public Integer getFormerInsurance        () { return formerInsurance               ; }	// OΖЉیz
	public Integer getFormerTax              () { return formerTax                     ; }	// OΖ揊Ŋz

	public Integer getPaymentAllowance       () { return paymentAllowance            ; }	// ^A蓖z
	public Integer getPaymentIncomeTax       () { return paymentIncomeTax            ; }	//^A蓖Ŋz
	public Integer getBonusAllowance         () { return bonusAllowance              ; }	// ܗ^z
	public Integer getBonusIncomeTax         () { return bonusIncomeTax              ; }	// ܗ^Ŋz
	public Integer getMidwayAdjustIncome     () { return midwayAdjustIncome          ; }	// rAz
	public Integer getMidwayAdjustTax        () { return midwayAdjustTax             ; }	// rAŊz
	public Integer getAdjTotalAllowance      () { return adjTotalAllowance           ; }	// xzv
	public Integer getAdjTotalIncome         () { return adjTotalIncome              ; }	// Ŋzv
	public Integer getAfterDeductIncome      () { return afterDeductIncome           ; }	// ^T̋^̋z
	public Integer getPayInsDeduction        () { return payInsDeduction             ; }	// Љی^̍T
	public Integer getSocialInsDeduction     () { return socialInsDeduction          ; }	// ЉیTz
	public Integer getMutualAidDeduction     () { return mutualAidDeduction          ; }	// K͊Ƌϓ|Tz
	public Integer getLifeInsDeduction       () { return lifeInsDeduction            ; }	// یTz
	public Integer getDamageInsDeduction     () { return damageInsDeduction          ; }	// QیTz
	public Integer getSpouseSpDeduction      () { return spouseSpDeduction           ; }	// zғʍTz
	public Integer getDependentsDeduction    () { return dependentsDeduction         ; }	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	public Integer getIncomeDeductSum        () { return incomeDeductSum             ; }	// Tzv
	public Integer getFinalIncomeTax         () { return finalIncomeTax              ; }	// NŊz
	public Integer getHouseLoanDeduction     () { return houseLoanDeduction          ; }	// ZؓʍTz
	public Integer getTaxGap                 () { return taxGap                      ; }	// Ŋz擾
	public Integer getCalcTaxedIncome        () { return calcTaxedIncome             ; }	// ېŋ^z
	public Integer getSpouseSumIncome        () { return spouseSumIncome             ; }	// z҂̖{N̍vžϊz
	public Integer getGeneralLifeIns         () { return generalLifeIns              ; }	// ʂ̐ی
	public Integer getPrivatePension         () { return privatePension              ; }	// lNی
	public Integer getEarthquakeIns          () { return earthquakeIns               ; }	// nkی
	public Integer getLongTermDamageIns      () { return longTermDamageIns           ; }	// Qی
	public Integer getAllowanceAdjustment    () { return allowanceAdjustment         ; }	// xz
	public Integer getTaxFreeAdjustment      () { return taxFreeAdjustment           ; }	// ېŒz
	public Integer getTaxIncAdjustment       () { return taxIncAdjustment            ; }	// Œz
	public String getWithholdSlipNotes      () { return withholdSlipNotes           ; }	// 򒥎[Ev
	public Integer getCalcIncomeTax          () { return calcIncomeTax               ; }	// ZoNŊz
	public Integer getAdjustedIncomeTax      () { return adjustedIncomeTax           ; }	// NNŊz
	public Integer getDeductedIncomeTax      () { return deductedIncomeTax           ; }	// N藦TzŊz
	public Integer getSocInsAdjustment       () { return socInsAdjustment            ; }	// Љیz
	
	public String getIncomeTaxType         () { return incomeTaxType              ; }	// ېŋ敪 
	public String getAdjustmentType        () { return adjustmentType             ; }	// N敪 
	
	public String getSpHandicap             () { return spHandicap                 ; }	// ʏQ 
	public String getGeHandicap             () { return geHandicap                  ; }	// ʏQ
	public String getGeWidow                () { return geWidow                     ; }	// ʉǕw
	public String getSpWidow                () { return spWidow                     ; }	// ʉǕw
	public String getWidow                  () { return widow                       ; }	// Ǖv
	public String getStudentGeneral         () { return studentGeneral              ; }	// ΘJw
	public String getLwSpHandiEl            () { return lwSpHandiEl                 ; }	// ʏQҘVl
	public String getLwSpHandicap           () { return lwSpHandicap                ; }	// ʏQ
	public String getSpouseEl               () { return spouseEl                    ; }	// Vlz
	public String getSpouseGe               () { return spouseGe                    ; }	// ʔz(̑)
	public String getGeneralDependent       () { return generalDependent            ; }	// ʕ}{e
	public String getSpecificDependent      () { return specificDependent           ; }	// }{e
	public String getElderlyDependent       () { return elderlyDependent            ; }	// Vl}{e
	public String getLiveWithEldRel         () { return liveWithEldRel              ; }	// Ve
	public String getLiveWithHandiGe        () { return liveWithHandiGe             ; }	// 
	public String getLiveWithHandiSp        () { return liveWithHandiSp             ; }	// 
	public String getLiveWithHandiEl        () { return liveWithHandiEl           ; }	// Vl
	public String getLiveWithHandiEr        () { return liveWithHandiEr           ; }	// Ve
	public String getGeneralHandicap        () { return generalHandicap           ; }	// ʏQ
	public String getSpecificHandicap       () { return specificHandicap          ; }	// ʏQ
	public String getTotallHandicap         () { return totallHandicap				; } // QҌv
	public String getTotallDeduction        () { return totallDeduction			; }	// TΏێҐ
	public String getConsortFlg             () { return consortFlg					; } // zҗL\
	
	
	public String getCompanyName            () { return companyName                 ; }	// Ж
	
	public Integer getTotalPayTotalAllowance  () { return totalPayTotalAllowance   ; }	//^xzv
	public Integer getTotalPayTaxFree         () { return totalPayTaxFree          ; }	//^ېŊzv
	public Integer getTotalPayTaxation        () { return totalPayTaxation         ; }	//^ېŎxzv
	public Integer getTotalPayIncomeTax       () { return totalPayIncomeTax        ; }	//^ōv
	public Integer getTotalPaySocInsDeduction () { return totalPaySocInsDeduction  ; }	//^Љیv
	public Integer getTotalPayPayInsDeduction () { return totalPayPayInsDeduction  ; }	//^ЉیT̋^̋zv
	public Integer getTotalPayVariousDeduction() { return totalPayVariousDeduction ; }	//^Tv
	public Integer getTotalPayPaymentTotal    () { return totalPayPaymentTotal     ; }	//^xzv
	public Integer getTotalPayAdjCalcGap      () { return totalPayAdjCalcGap       ; }	//^Nɂߕsv

	public Integer getTotalBonTotalAllowance  	(){ return totalBonTotalAllowance  ; }	//ܗ^xzv
	public Integer getTotalBonTaxFree         	(){ return totalBonTaxFree         ; }	//ܗ^ېŊzv
	public Integer getTotalBonTaxation        	(){ return totalBonTaxation        ; }	//ܗ^ېŎxzv
	public Integer getTotalBonIncomeTax       	(){ return totalBonIncomeTax       ; }	//ܗ^ōv
	public Integer getTotalBonSocInsDeduction 	(){ return totalBonSocInsDeduction ; }	//ܗ^Љیv
	public Integer getTotalBonPayInsDeduction 	(){ return totalBonPayInsDeduction ; }	//ܗ^ЉیT̏ܗ^̋zv
	public Integer getTotalBonVariousDeduction	(){ return totalBonVariousDeduction ; }	//ܗ^Tv
	public Integer getTotalBonPaymentTotal    	(){ return totalBonPaymentTotal    ; }	//ܗ^xzv
	public Integer getTotalBonAdjCalcGap      	(){ return totalBonAdjCalcGap      ; }	//ܗ^Nɂߕsv
	
	public String getMonthType_01      (){ return monthType_01      ; }	//敪01
	public String getMonthType_02      (){ return monthType_02      ; }	//敪02
	public String getMonthType_03      (){ return monthType_03      ; }	//敪03
	public String getMonthType_04      (){ return monthType_04      ; }	//敪04
	public String getMonthType_05      (){ return monthType_05      ; }	//敪05
	public String getMonthType_06      (){ return monthType_06      ; }	//敪06
	public String getMonthType_07      (){ return monthType_07      ; }	//敪07
	public String getMonthType_08      (){ return monthType_08      ; }	//敪08
	public String getMonthType_09      (){ return monthType_09      ; }	//敪09
	public String getMonthType_10      (){ return monthType_10      ; }	//敪10
	public String getMonthType_11      (){ return monthType_11      ; }	//敪11
	public String getMonthType_12      (){ return monthType_12      ; }	//敪12
	
	public String getStrMidwayType     (){ return strMidwayType      ; }	// rЋ敪
	
}
