package jp.mosp.payroll.report.dto;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.human.dto.MKojinDto;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.PhPaymentDto;

public class AdjustDataDto extends WithholdingListDto {
	
	private static final long serialVersionUID = 7720406971353362435L;
	
	// tB[h
	private String selfWidowType    ;	// {lǕw敪
	private String selfHandicapType ;	// {lQ敪
	private String selfStudentType  ;	// {lw敪
	private String spouseIntendType ;	// zҋ敪
	
	/**
	 * RXgN^
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	public AdjustDataDto(
			int targetAdjustYear,
			CdAdjustmentDto cdAdjustmentDto,
			MKihonDto mKihonDto,
			MKojinDto mKojinDto,
			CmIncomeTaxDto cmIncomeTaxDto,
			CmMidwayEnterDto cmMidwayEnterDto,
			List<PhPaymentDto> listPaymentData,
			List<PhBounsDto> listBonusData,
			PdPayDeductionDao pdPayDeductionDao,
			CmCompanyDto cmCompanyDto
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		super(
				targetAdjustYear ,
				cdAdjustmentDto  ,
				mKihonDto       ,
				mKojinDto       ,
				cmIncomeTaxDto   ,
				cmMidwayEnterDto ,
				listPaymentData  ,
				listBonusData    ,
				pdPayDeductionDao,
				cmCompanyDto
		);
		if (cmIncomeTaxDto != null) {
			selfWidowType    = cmIncomeTaxDto.getSelfWidowType   ();	// {lǕw敪
			selfHandicapType = cmIncomeTaxDto.getSelfHandicapType();	// {lQ敪
			selfStudentType  = cmIncomeTaxDto.getSelfStudentType ();	// {lw敪
			spouseIntendType = cmIncomeTaxDto.getSpouseIntendType();	// zҋ敪
		} else {
			selfWidowType    = "";	// {lǕw敪
			selfHandicapType = "";	// {lQ敪
			selfStudentType  = "";	// {lw敪
			spouseIntendType = "";	// zҋ敪
		}
	}
	
	// ANZT\bh
	public String getSelfWidowType   () { return selfWidowType   ; }	// {lǕw敪
	public String getSelfHandicapType() { return selfHandicapType; }	// {lQ敪
	public String getSelfStudentType () { return selfStudentType ; }	// {lw敪
	public String getSpouseIntendType() { return spouseIntendType; }	// zҋ敪
	
	public void setSelfWidowType   (String selfWidowType   ) { this.selfWidowType    = selfWidowType   ; }	// {lǕw敪
	public void setSelfHandicapType(String selfHandicapType) { this.selfHandicapType = selfHandicapType; }	// {lQ敪
	public void setSelfStudentType (String selfStudentType ) { this.selfStudentType  = selfStudentType ; }	// {lw敪
	public void setSpouseIntendType(String spouseIntendType) { this.spouseIntendType = spouseIntendType; }	// zҋ敪
	
}
