package jp.mosp.payroll.report.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.legal.LegalConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.common.vo.AdjustmentListVo;
import jp.mosp.payroll.common.vo.AdjustmentReferVo;
import jp.mosp.payroll.dao.CdAdjustmentDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.report.dto.WithholdingVoteDto;
import jp.mosp.system.dao.MYakusyokuDao;
import jp.mosp.system.dto.MYakusyokuDto;

/**
 * 򒥎[̏o͂sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_REPORT}
 * </li></ul>
 */
public class WithholdingVoteAction extends AdjustmentAction{
	
	/**
	 * 򒥎[o̓R}hB<br><br>
	 * ɂA^ׂExcel`ODS`ŏo͂B<br>
	 */
	// R}h
	private static final String CMD_WITHHOLDING_VOTE_ALL = "P3030"; // ꊇo FU3320
	private static final String CMD_WITHHOLDING_VOTE_ONE = "P3031"; // ʏo FU3321
	private static final String CMD_WITHHOLDING_VOTE_ALL2= "P3032"; // ꊇo2FU3322

	public String[][] aryGender  ;
	// ݒe[u
	public List<MosPConfDto> listConf;
	public String[][] aryEra;
	
	/**
	 * RXgN^
	 */
	public WithholdingVoteAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// Ǖw(v) Up
		aryGender  = getCodeArray(PayrollConst.TID_GENDER);
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		aryEra   = getCodeArray(PayrollConst.TID_JAPANESE);
		if (cmd.equals(CMD_WITHHOLDING_VOTE_ALL)) {
			// VO̎擾
			AdjustmentListVo vo = (AdjustmentListVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getPltReportYear();
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			Date date = vo.getDate(String.valueOf(vo.getPltReportYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingVoteDto> list = getWithholdingVote(date, null, vo);
			// [쐬yѐݒ
			for(int i= 0; i < list.size(); i++){
				WithholdingVoteDto dto_tmp = list.get(i);
				if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
//					reportList(vo, dto_tmp);
				} else {
//					reportXlsList(vo, dto_tmp);
				}
			}
		} else if (cmd.equals(CMD_WITHHOLDING_VOTE_ONE)) {
			// VO̎擾
			AdjustmentReferVo vo = (AdjustmentReferVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			// ЈR[hNULL
			vo.setLblChangeKCode(vo.getHidKCode());
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH), String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingVoteDto> list = getWithholdingVoteOne(date, vo.getHidKCode(), vo);
			// [쐬yѐݒ
			for(int i= 0; i < list.size(); i++){
				WithholdingVoteDto dto_tmp = list.get(i);
				if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
					report(vo, dto_tmp);
				} else {
					reportXls(vo, dto_tmp);
				}
			}
		} else if (cmd.equals(CMD_WITHHOLDING_VOTE_ALL2)) {
			// VO̎擾
			AdjustmentCalcVo vo = (AdjustmentCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			adjustYear = vo.getHidAdjustYear();
			// Ώ۔NAΏۃf[^ݒ
			setTargetData();
			// Ώ۔N擾(Ώ۔N12/1)
			Date date = vo.getDate(String.valueOf(vo.getHidAdjustYear()), String.valueOf(PayrollConst.TIME_ADJ_PAY_MONTH),  String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
			// ^׃f[^쐬
			List<WithholdingVoteDto> list = getWithholdingVote(date, null, vo);
			// [쐬
			// [쐬yѐݒ
			for(int i= 0; i < list.size(); i++){
				WithholdingVoteDto dto_tmp = list.get(i);
				if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
//					reportCal(vo, dto_tmp);
				} else {
//					reportXlsCal(vo, dto_tmp);
				}
			}
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);	
		}
	}
	
	/**
	 * 򒥎[f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<WithholdingVoteDto> getWithholdingVote(
			Date targetMonth, String kCode, MosPVo vo
	) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao   dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<WithholdingVoteDto> list = new ArrayList<WithholdingVoteDto>();
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
			// Nf[^ݒ
			WithholdingVoteDto dto = new WithholdingVoteDto(cdAdjustmentDto);
			// ЈǗf[^ݒ
			setHumanInfo(dto);
			// Ѓf[^ݒ
			setCompanyDataInfo(dto);
			// Xgɐݒ
			list.add(dto);
		}
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_ADJUST_REPORT, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		
		return list;
	}
	
	/**
	 * 򒥎[f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ^׃f[^Xg
	 * @throws Exception
	 */
	private List<WithholdingVoteDto> getWithholdingVoteOne(
			Date targetMonth, String kCode, AdjustmentReferVo vo
	) throws Exception {
		// 򒥎[f[^擾
		CdAdjustmentDao   dao = new CdAdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ^ǗҌmF
		confirmPayrollAuth();
		// Nf[^쐬
		List<CdAdjustmentDto> listAdjustment = dao.findForWithholdVote(MospUtility.getYear(targetMonth), kCode);
		// 򒥎[f[^쐬
		List<WithholdingVoteDto> list = new ArrayList<WithholdingVoteDto>();
		// f[^݂ꍇ͐ݒ
		for (Iterator<CdAdjustmentDto> it = listAdjustment.iterator(); it.hasNext();) {
			cdAdjustmentDto = it.next();
		}
		// Xg̏ꍇ̓G[ł͂ȂAVDTO쐬
		if (listAdjustment.size() == 0) {
			cdAdjustmentDto = new CdAdjustmentDto();
			cdAdjustmentDto.setKCode(kCode);
		}
		setVo(vo);
		setUrl(vo.getRetUrl());
		// Nf[^ݒ
		WithholdingVoteDto dto = new WithholdingVoteDto(cdAdjustmentDto);
		// ЈǗf[^ݒ
		setHumanInfo(dto);
		// Ѓf[^ݒ
		setCompanyDataInfo(dto);
		// Xgɐݒ
		list.add(dto);
		return list;
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 * @throws MospException 
	 */
	private void setHumanInfo(
			WithholdingVoteDto dto
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		if (dto != null) {
			// ЈR[hݒ
			kCode = dto.getKCode();
			// NŏI𗚗擾ΏیƂĎgp
			Date targetDate = getLastDateOfYear(adjustYear);
			// l{擾

			mKihonDto = mKihonPayrollDao.findForDate(kCode, DatePart.convDateToInteger(targetDate));
			if (mKihonDto == null) {
				// l{񂪖ꍇ
				String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
				addErrMessage(errMessage);
			}
			// l{ݒ
			setBasisDataInfo(dto);
			// lǗ擾
			mKojinDto =  mKojinDao.findForKey(kCode);
			setExtraDataInfo(dto);
			
			// l^擾
			cmIncomeTaxDto   = cmIncomeTaxDao  .findForEmployeeDate(kCode, targetDate);
			setIncomeTaxDataInfo(dto);
			cmMidwayEnterDto = cmMidwayEnterDao.findForKey         (kCode          );
			setMidWayDataInfo(dto);
		}
	}
	
	/**
	 * l{ݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setBasisDataInfo(WithholdingVoteDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
		MYakusyokuDto mYakusyokuDto; 
		MYakusyokuDao mYakusyokuDao = new MYakusyokuDao(); 
		mYakusyokuDao.initDao(cfg, cmd, aspUser, user, conn);
		if (mKihonDto != null) {
			mYakusyokuDto = mYakusyokuDao.findForKey(mKihonDto.getYCode() , mKihonDto.getTokyu());
			dto.setKName(mKihonDto.getSimei());
			dto.setKKana(mKihonDto.getFurigana());
			if(mYakusyokuDto != null){
				dto.setPositionName( mYakusyokuDto.getYName());
			}else{
				dto.setPositionName("");
			}
		}
	}
	
	/**
	 * lǗݒ
	 * @param dto
	 * @throws MospException 
	 */
	private void setExtraDataInfo(WithholdingVoteDto dto) throws MospException {
		// Ј̊Ǘݒ肷BDTÕANZT\bhgpB
		if (mKojinDto != null) {
			dto.setAddress(getPrefecture(mKojinDto.getPrefectures()) + mKojinDto.getJyuusyo1() + mKojinDto.getJyuusyo2() + mKojinDto.getJyuusyo3());
			if (mKojinDto.getSeinenbi() != 0) {
				String strDate[] = getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKojinDto.getSeinenbi()));
				dto.setBirthYear (strDate[1]);
				dto.setBirthMonth(strDate[2]);
				dto.setBirthDay  (strDate[3]);
			
				// \pN擾(Ώ۔N+1)
				strDate = getJpImperialCal(listConf, targetAffDate);
				strDate[0]       = getCodeName(strDate[0], aryEra);
				
				dto.setIncExpectedDate(strDate[1]);
				
				strDate = getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKojinDto.getSeinenbi()));
				strDate[0]       = getCodeName(strDate[0], aryEra);

				if (strDate[0].equals("")) {
					dto.setBirthHeisei(PayrollConst.ADJ_APPLICABLE);
				} else if (strDate[0].equals("")) {				
					dto.setBirthMeiji(PayrollConst.ADJ_APPLICABLE);
				} else if (strDate[0].equals("a")) {
					dto.setBirthSyouwa(PayrollConst.ADJ_APPLICABLE);
				} else if (strDate[0].equals("吳")) {
					dto.setBirthTaisyou(PayrollConst.ADJ_APPLICABLE);
				}
				// N擾
				int age = getAge(DatePart.convIntegerDateToDate(mKojinDto.getSeinenbi()), targetAffDate);
				if (age < PayrollConst.AGE_ADLUT) {
					// N
					dto.setSelfMinority(PayrollConst.ADJ_APPLICABLE);
				}
			}
		}
	}
	
	/**
	 * Џݒ
	 * @param dto
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	private void setCompanyDataInfo(WithholdingVoteDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException {
		if (dto != null) {
			CmCompanyDao dao = new CmCompanyDao();
			dao.initDao(cfg, cmd, aspUser, user, conn);
			CmCompanyDto cmCompanyDto = dao.findAll();
			if (cmCompanyDto != null) {
				dto.setCompanyAddress(cmCompanyDto.getCompanyAddress());
				dto.setCompanyPhone(cmCompanyDto.getCompanyPhone());
				dto.setCompanyName(cmCompanyDto.getCompanyName());
				// ԍݒ
				setStationNo(dto, cmCompanyDto);
				// ԍݒ
				setDisposeNo(dto, cmCompanyDto);
			}
		}
		// Ђ̏ݒ肷BDTÕANZT\bhgpB
	}
	
	/**
	 * ԍݒ
	 * @param dto
	 * @param cmCompanyDto
	 */
	private void setStationNo(WithholdingVoteDto dto, CmCompanyDto cmCompanyDto) {
		// ԍz쐬()
		String[] aryStationNO = {"","","","","","","","","",""};
		// ԍ擾
		String stationNo = cmCompanyDto.getStationNo();
		// ݒJnݒ
		int start = aryStationNO.length - stationNo.length();
		// ݒ菀
		String repString = "";
		// ŉ
		for (int i = 0; i < stationNo.length(); i++) {
			repString = stationNo.substring(i, i+1);
			// JnɒB當z֐ݒ
				aryStationNO[start + i] = repString;
		}
		dto.setStationNo_01(aryStationNO[0]);
		dto.setStationNo_02(aryStationNO[1]);
		dto.setStationNo_03(aryStationNO[2]);
		dto.setStationNo_04(aryStationNO[3]);
		dto.setStationNo_05(aryStationNO[4]);
	}

	/**
	 * ԍݒ
	 * @param dto
	 * @param cmCompanyDto
	 */
	private void setDisposeNo(WithholdingVoteDto dto, CmCompanyDto cmCompanyDto) {
		// ԍz쐬()
		String[] aryDisposeNO = {"","","","","","","",""};
		// ԍ擾
		String stationNo = cmCompanyDto.getDisposeNo();
		// ݒJnݒ
		int start = aryDisposeNO.length - stationNo.length();
		// ݒ菀
		String repString = "";
		// ŉ
		for (int i = 0; i < stationNo.length(); i++) {
			repString = stationNo.substring(i, i+1);
			// JnɒB當z֐ݒ
			aryDisposeNO[start + i] = repString;
		}
		dto.setDisposeNo_01(aryDisposeNO[0]);
		dto.setDisposeNo_02(aryDisposeNO[1]);
		dto.setDisposeNo_03(aryDisposeNO[2]);
		dto.setDisposeNo_04(aryDisposeNO[3]);
		dto.setDisposeNo_05(aryDisposeNO[4]);
		dto.setDisposeNo_06(aryDisposeNO[5]);
		dto.setDisposeNo_07(aryDisposeNO[6]);
		dto.setDisposeNo_08(aryDisposeNO[7]);
	}

	private void setIncomeTaxDataInfo(WithholdingVoteDto dto) {
		if (cmIncomeTaxDto != null) {
			// TΏ۔zҐݒ
			setDeductionSpouse(dto);
			// }{eݒ
			setDepend(dto);
			// Q҂̐ݒ(z҂)
			setHandicap(dto);
			// {lݒ
			setSelfType(dto);
		}
	}
	
	/**
	 * TΏ۔z҂̗L̐ݒ
	 * @param dto
	 */
	private void setDeductionSpouse(WithholdingVoteDto dto) {
		String incomeTaxType = cmIncomeTaxDto.getIncomeTaxType();
		String spouseIntendType = cmIncomeTaxDto.getSpouseIntendType();
		// L(ېŋ敪bŔzҋ敪ΏۊOȊO)
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_KOU)) {
			// ΏۊO
			if (!spouseIntendType.equals("")) {
				dto.setIsDeductionSpouse(PayrollConst.ADJ_APPLICABLE);
			}
		}
		// (ېŋ敪bŔzҋ敪ΏۊO)
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_KOU)) {
			// ΏۊO
			if (spouseIntendType.equals("")) {
				dto.setNoDeductionSpouse(PayrollConst.ADJ_APPLICABLE);
			}
		}
		// ]L(ېŋ敪Ŕzҋ敪ΏۊOȊO)
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_OTU)) {
			// ΏۊO
			if (!spouseIntendType.equals("")) {
				dto.setIsSubDeducSpouse(PayrollConst.ADJ_APPLICABLE);
			}
		}
		// ](ېŋ敪Ŕzҋ敪ΏۊO)
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_OTU)) {
			// ΏۊO
			if (spouseIntendType.equals("")) {
				dto.setNoSubDeducSpouse(PayrollConst.ADJ_APPLICABLE);
			}
		}
		// Vl(zҋ敪Vlz͓Vl̏ꍇ)
		if (spouseIntendType.equals(LegalConst.SPOUSE_INTEND_ELDERLY)
			||
			spouseIntendType.equals(LegalConst.SPOUSE_INTEND_LWSH_EL)
		) {
			dto.setElderlySpouse(PayrollConst.ADJ_APPLICABLE);
		}
	}
	
	/**
	 * }{e̐(z҂)
	 * @param dto
	 */
	private void setDepend (WithholdingVoteDto dto) {
		String incomeTaxType = cmIncomeTaxDto.getIncomeTaxType();
		// (}{e+)
		String spDependent = String.valueOf(cmIncomeTaxDto.getSpecificDependent() + cmIncomeTaxDto.getLiveWithHandiSp());
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_KOU)) {
			dto.setSpDependent(spDependent);
		} else {
			dto.setSpSubDependent(spDependent);
		}
		// Vl(Vl}{e+Ve+Vl+Ve)
		String spElDependent = String.valueOf(
				cmIncomeTaxDto.getElderlyDependent () + cmIncomeTaxDto.getLiveWithEldRel()
				+ cmIncomeTaxDto.getLiveWithHandiEr() + cmIncomeTaxDto.getLiveWithHandiEl()
		);
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_KOU)) {
			dto.setSpElDependent(spElDependent);
		} else {
			dto.setSpSubElDepend(spElDependent);
		}
		// Vl(Ve+Ve)
		String spElItemDepend = String.valueOf(cmIncomeTaxDto.getLiveWithEldRel()+ cmIncomeTaxDto.getLiveWithHandiEr());
		dto.setSpElItemDepend(spElItemDepend);
		// ̑
		String otherDepend = String.valueOf(cmIncomeTaxDto.getGeneralDependent() + cmIncomeTaxDto.getLiveWithHandiGe());
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_KOU)) {
			dto.setOtherDepend(otherDepend);
		} else {
			dto.setOtherSubDepend(otherDepend);
		}
	}
	
	/**
	 * Q҂̐ݒ(z҂)
	 * @param dto
	 */
	private void setHandicap(WithholdingVoteDto dto) {
		String incomeTaxType    = cmIncomeTaxDto.getIncomeTaxType   ();
		int specificHandicap   = cmIncomeTaxDto.getSpecificHandicap ();
		String spouseIntendType = cmIncomeTaxDto.getSpouseIntendType();
		// ېŋ敪b̂
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_KOU)) {
			// Qғ(ʏQ҂̐)
			dto.setSpHandicap(String.valueOf(specificHandicap));
			// Qғ()(++Vl+Ve)
			int  spItemHandicap = cmIncomeTaxDto.getLiveWithHandiGe() + cmIncomeTaxDto.getLiveWithHandiSp();
			// zҋ敪ᖔ͓Vl̏ꍇ1Z
			if (spouseIntendType.equals(LegalConst.SPOUSE_INTEND_LWSH)
				|| 
				spouseIntendType.equals(LegalConst.SPOUSE_INTEND_LWSH_EL)
				) {
				spItemHandicap += 1;
			}
			dto.setSpItemHandicap(String.valueOf(spItemHandicap));
			// ̑(ʏQҐ)
			dto.setSpHandicapOther(String.valueOf(cmIncomeTaxDto.getGeneralHandicap()));
		}
	}
	
	/**
	 * {lݒ
	 * @param dto
	 */
	private void setSelfType(WithholdingVoteDto dto) {
		String incomeTaxType = cmIncomeTaxDto.getIncomeTaxType();
		String handicapType  = cmIncomeTaxDto.getSelfHandicapType();
		String widowType     = cmIncomeTaxDto.getSelfWidowType();
		String studentType   = cmIncomeTaxDto.getSelfStudentType();
		// 
		if (incomeTaxType.equals(LegalConst.INCOME_TAX_OTU)) {
			dto.setSelfOtu(PayrollConst.ADJ_APPLICABLE);
		}
		if (handicapType.equals(LegalConst.HANDICAP_GENERAL)) {
			// ʏQ
			dto.setSelfGeHandicap(PayrollConst.ADJ_APPLICABLE);
		} else if (handicapType.equals(LegalConst.HANDICAP_SPECIAL)) {
			// ʏQ
			dto.setSelfSpHandicap(PayrollConst.ADJ_APPLICABLE);
		}
		// Ǖw(v)̏ꍇ͐ʂŔfĐݒAݒȂ̏ꍇ͈ʉǕw
		if (widowType.equals(LegalConst.WIDOW_GENERAL)) {
			dto.setWidow(PayrollConst.ADJ_APPLICABLE); // ݂͉Ǖw(v)̂
			// DTOmF
			/*
			if (mKojinDto != null) {
				String gender = mKojinDto.getGender();
				// Ǖv
				if (gender.equals(aryGender[0][0])) {
					dto.setWidow(PayrollConst.ADJ_APPLICABLE);
				}
				// ʉǕw
				if (gender.equals(aryGender[1][0])) {
					dto.setSelfGeWidow(PayrollConst.ADJ_APPLICABLE);
				}
			} else {
				// ʂ̐ݒ肪Ȃꍇ͈ʉǕwɐݒ
				dto.setSelfGeWidow(PayrollConst.ADJ_APPLICABLE);
			}
			*/
		} else if (widowType.equals(LegalConst.WIDOW_SPECIAL)) {
			// ʉǕw
			dto.setSelfSpWidow(PayrollConst.ADJ_APPLICABLE);
		}
		// {l敪ΘJw
		if (studentType.equals(LegalConst.STUDENT_GENERAL)) {
			dto.setStudentGeneral(PayrollConst.ADJ_APPLICABLE);
		}

	}
	
	/**
	 * rЏݒ
	 * @param dto
	 * @throws MospException
	 */
	private void setMidWayDataInfo(WithholdingVoteDto dto) throws MospException {
		// lNULL̏ꍇAݒ
		if (mKihonDto == null) {
			// Ώ۔NłȂ΁Aݒ肵Ȃ
			dto.setEmployment("");
			dto.setRetirement("");
			dto.setRetirementYear ("");
			dto.setRetirementMonth("");
			dto.setRetirementDay  ("");
			return;
		}
		// ГNULLł͂Ȃꍇ
		if (mKihonDto.getNyDate() != 0) {
			// Ώ۔Nɓ
			if ( MospUtility.getYear(DatePart.convIntegerDateToDate(mKihonDto.getNyDate())) == adjustYear){
				// Гݒ
				dto.setEmployment(PayrollConst.ADJ_APPLICABLE);
				// \pN擾(Ώ۔N+1)
				String strDate[] = getJpImperialCal(listConf, DatePart.convIntegerDateToDate(mKihonDto.getNyDate()));
				dto.setRetirementYear (strDate[1]);
				dto.setRetirementMonth(strDate[2]);
				dto.setRetirementDay  (strDate[3]);
			}
			
		}
		// ɑގЍς
		if (mKihonDto.getTsDate() != 0) {
			// Ώ۔Nɑގ
			if (MospUtility.getYear(DatePart.convIntegerDateToDate(mKihonDto.getTsDate())) == adjustYear) {
				dto.setEmployment("");
				dto.setRetirement(PayrollConst.ADJ_APPLICABLE);
				// \pN擾(Ώ۔N+1)
				String strDate[] = getJpImperialCal(listConf,DatePart.convIntegerDateToDate(mKihonDto.getTsDate()));
				dto.setRetirementYear (strDate[1]);
				dto.setRetirementMonth(strDate[2]);
				dto.setRetirementDay  (strDate[3]);
			}
		}
	}

	/**
	 * [o͏sB(Excel)<br><br>
	 * @throws Exception 
	 */
	private void reportXls(AdjustmentReferVo vo , WithholdingVoteDto dto) throws Exception {
		// RlNV擾
		getConnection();
		// [쐬
		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_WITHHOLDING_VOTE_XLS);

		prtItem_chk( poi, 2,  1, dto.getIncExpectedDate());		// ΏۘaNxNx(A^Cg)
		prtItem_chk( poi, 2, 67, dto.getIncExpectedDate());		// ΏۘaNxNx(A^Cg)
		prtItem_chk( poi,22, 87, dto.getIncExpectedDate());		// ΏۘaNxNx(EArސEN)
		prtItem_chk( poi,22, 34, dto.getIncExpectedDate());		// ΏۘaNxNx(ArސEN)
		prtItem_chk( poi,33,  1, dto.getIncExpectedDate());		// ΏۘaNxNx(EA^CgN)
		prtItem_chk( poi,33, 67, dto.getIncExpectedDate());		// ΏۘaNxNx(EA^CgN)
		prtItem_chk( poi,53, 34, dto.getIncExpectedDate());		// ΏۘaNxNx(ArސEN)
		prtItem_chk( poi,53, 87, dto.getIncExpectedDate());		// ΏۘaNxNx(EArސEN)

		prtItem_chk( poi, 4,  7, dto.getAddress());				// 󋋎ҏZ()		
		prtItem_chk( poi, 3, 60, dto.getAddress());				// 󋋎ҏZ(E)		
		prtItem_chk( poi,35,  7, dto.getAddress());				// 󋋎ҏZ()		
		prtItem_chk( poi,34, 60, dto.getAddress());				// 󋋎ҏZ(E)		

		prtItem_chk( poi, 3, 38, dto.getKCode());				// 󋋎Ҕԍ()
		prtItem_chk( poi, 3, 91, dto.getKCode());				// 󋋎Ҕԍ(E)	
		prtItem_chk( poi, 34,38, dto.getKCode());				// 󋋎Ҕԍ()	
		prtItem_chk( poi, 34,91, dto.getKCode());				// 󋋎Ҕԍ(E)

		prtItem_chk( poi, 4, 39, dto.getKKana());				// tKi()		
		prtItem_chk( poi, 4, 92, dto.getKKana());				// tKi(E)		
		prtItem_chk( poi,35, 39, dto.getKKana());				// tKi()		
		prtItem_chk( poi,35, 92, dto.getKKana());				// tKi(E)		
		
		prtItem_chk( poi, 6, 34, dto.getPositionName());			// E()
		prtItem_chk( poi, 6, 87, dto.getPositionName());			// E(E)
		prtItem_chk( poi,37, 34, dto.getPositionName());			// E()
		prtItem_chk( poi,37, 87, dto.getPositionName());			// E(E)

		prtItem_chk( poi, 5, 39, dto.getKName());				// ()
		prtItem_chk( poi, 5, 92, dto.getKName());				// (E)
		prtItem_chk( poi,36, 39, dto.getKName());				// ()
		prtItem_chk( poi,36, 92, dto.getKName());				// (E)

		prtItem_chk( poi, 9, 12, dto.getPaymentAllowance());		// xz()
		prtItem_chk( poi, 9, 65, dto.getPaymentAllowance());		// xz(E)
		prtItem_chk( poi,40, 12, dto.getPaymentAllowance());		// xz()
		prtItem_chk( poi,40, 65, dto.getPaymentAllowance());		// xz(E)

		prtItem_chk( poi, 9, 27, dto.getAfterDeductIncome());	//  ^T̋^̋z()
		prtItem_chk( poi, 9, 80, dto.getAfterDeductIncome());	//  ^T̋^̋z(E)
		prtItem_chk( poi,40, 27, dto.getAfterDeductIncome());	//  ^T̋^̋z()
		prtItem_chk( poi,40, 80, dto.getAfterDeductIncome());	//  ^T̋^̋z(E)
		
		prtItem_chk( poi, 9, 34, dto.getCalcTaxedIncome());		//  T̊z̍vz()
		prtItem_chk( poi, 9, 87, dto.getCalcTaxedIncome());		//  T̊z̍vz(E)
		prtItem_chk( poi,40, 34, dto.getCalcTaxedIncome());		//  T̊z̍vz()
		prtItem_chk( poi,40, 87, dto.getCalcTaxedIncome());		//  T̊z̍vz(E)

		prtItem_chk( poi, 9, 43, dto.getWithholdTax());			// 򒥎()		
		prtItem_chk( poi, 9, 96, dto.getWithholdTax());			// 򒥎(E)		
		prtItem_chk( poi,40, 43, dto.getWithholdTax());			// 򒥎()		
		prtItem_chk( poi,40, 96, dto.getWithholdTax());			// 򒥎(E)		

		prtItem_chk( poi,15,  2, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L()
		prtItem_chk( poi,15, 55, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L(E)	
		prtItem_chk( poi,46,  2, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L()
		prtItem_chk( poi,46, 55, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L(E)	

		prtItem_chk( poi,15,  4, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: ()
		prtItem_chk( poi,15, 57, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: (E)
		prtItem_chk( poi,46,  4, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: ()
		prtItem_chk( poi,46, 57, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: (E)	
		
		prtItem_chk( poi,15,  6, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L()
		prtItem_chk( poi,15, 59, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L(E)
		prtItem_chk( poi,46,  6, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L()
		prtItem_chk( poi,46, 59, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L(E)
		
		prtItem_chk( poi,15,  7, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ]()
		prtItem_chk( poi,15, 60, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ](E)
		prtItem_chk( poi,46,  7, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ]()
		prtItem_chk( poi,46, 60, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ](E)
		
		prtItem_chk( poi,15,  8, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl()
		prtItem_chk( poi,15, 61, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl(E)
		prtItem_chk( poi,46,  8, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl()
		prtItem_chk( poi,46, 61, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl(E)

		prtItem_chk( poi,14, 10, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz()
		prtItem_chk( poi,14, 63, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz(E)
		prtItem_chk( poi,45, 10, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz()
		prtItem_chk( poi,45, 63, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz(E)

		prtItem_chk( poi,14, 16, dto.getSpDependent());			// ()
		prtItem_chk( poi,14, 69, dto.getSpDependent());			// (E)
		prtItem_chk( poi,45, 16, dto.getSpDependent());			// ()
		prtItem_chk( poi,45, 69, dto.getSpDependent());			// (E)

		prtItem_chk( poi,14, 19, dto.getSpSubDependent());		// ]l()
		prtItem_chk( poi,14, 72, dto.getSpSubDependent());		// ]l(E)
		prtItem_chk( poi,45, 19, dto.getSpSubDependent());		// ]l()
		prtItem_chk( poi,45, 72, dto.getSpSubDependent());		// ]l(E)
		
		prtItem_chk( poi,14, 22, dto.getSpElItemDepend());		// Vl()
		prtItem_chk( poi,14, 75, dto.getSpElItemDepend());		// Vl(E)
		prtItem_chk( poi,45, 22, dto.getSpElItemDepend());		// Vl()
		prtItem_chk( poi,45, 75, dto.getSpElItemDepend());		// Vl(E)
		
		prtItem_chk( poi,14, 24, dto.getSpElDependent());		// Vl()
		prtItem_chk( poi,14, 77, dto.getSpElDependent());		// Vl(E)
		prtItem_chk( poi,45, 24, dto.getSpElDependent());		// Vl()
		prtItem_chk( poi,45, 77, dto.getSpElDependent());		// Vl(E)
		
		prtItem_chk( poi,14, 26, dto.getSpSubElDepend());		// ]l()
		prtItem_chk( poi,14, 79, dto.getSpSubElDepend());		// ]l(E)
		prtItem_chk( poi,45, 26, dto.getSpSubElDepend());		// ]l()
		prtItem_chk( poi,45, 79, dto.getSpSubElDepend());		// ]l(E)
		

		prtItem_chk( poi,14, 29, dto.getOtherDepend());			// ̑()		
		prtItem_chk( poi,14, 82, dto.getOtherDepend());			// ̑(E)		
		prtItem_chk( poi,45, 29, dto.getOtherDepend());			// ̑()		
		prtItem_chk( poi,45, 82, dto.getOtherDepend());			// ̑(E)		

		prtItem_chk( poi,14, 30, dto.getOtherSubDepend());		// ̑]l()		
		prtItem_chk( poi,14, 83, dto.getOtherSubDepend());		// ̑]l(E)		
		prtItem_chk( poi,45, 30, dto.getOtherSubDepend());		// ̑]l()		
		prtItem_chk( poi,45, 83, dto.getOtherSubDepend());		// ̑]l(E)		

		prtItem_chk( poi,14, 31, dto.getSpItemHandicap());		// Q҂̐Fʓ()
		prtItem_chk( poi,14, 84, dto.getSpItemHandicap());		// Q҂̐Fʓ(E)
		prtItem_chk( poi,45, 31, dto.getSpItemHandicap());		// Q҂̐Fʓ()
		prtItem_chk( poi,45, 84, dto.getSpItemHandicap());		// Q҂̐Fʓ(E)

		prtItem_chk( poi,14, 32, dto.getSpHandicap());			// Q҂̐F()
		prtItem_chk( poi,14, 85, dto.getSpHandicap());			// Q҂̐F(E)
		prtItem_chk( poi,45, 32, dto.getSpHandicap());			// Q҂̐F()
		prtItem_chk( poi,45, 85, dto.getSpHandicap());			// Q҂̐F(E)
		
		prtItem_chk( poi,14, 33, dto.getSpHandicapOther());		// Q҂̐F̑()
		prtItem_chk( poi,14, 86, dto.getSpHandicapOther());		// Q҂̐F̑(E)
		prtItem_chk( poi,45, 33, dto.getSpHandicapOther());		// Q҂̐F̑()
		prtItem_chk( poi,45, 86, dto.getSpHandicapOther());		// Q҂̐F̑(E)

		prtItem_chk( poi,14, 34, dto.getSocialInsDeduction());	// ЉیTz()
		prtItem_chk( poi,14, 87, dto.getSocialInsDeduction());	// ЉیTz(E)
		prtItem_chk( poi,45, 34, dto.getSocialInsDeduction());	// ЉیTz()
		prtItem_chk( poi,45, 87, dto.getSocialInsDeduction());	// ЉیTz(E)
		
		prtItem_chk( poi,14, 39, dto.getLifeInsDeduction());	// یTz()
		prtItem_chk( poi,14, 92, dto.getLifeInsDeduction());	// یTz(E)
		prtItem_chk( poi,45, 39, dto.getLifeInsDeduction());	// یTz()
		prtItem_chk( poi,45, 92, dto.getLifeInsDeduction());	// یTz(E)

		prtItem_chk( poi,14, 43, dto.getEarthquakeIns());	// nkی()
		prtItem_chk( poi,14, 96, dto.getEarthquakeIns());	// nkی(E)
		prtItem_chk( poi,45, 43, dto.getEarthquakeIns());	// nkی()
		prtItem_chk( poi,45, 96, dto.getEarthquakeIns());	// nkی(E)
		
		prtItem_chk( poi,14, 48, dto.getHouseLoanDeduction());	// ZؓʍTz()
		prtItem_chk( poi,14,102, dto.getHouseLoanDeduction());	// ZؓʍTz(E)
		prtItem_chk( poi,45, 48, dto.getHouseLoanDeduction());	// ZؓʍTz()
		prtItem_chk( poi,45,102, dto.getHouseLoanDeduction());	// ZؓʍTz(E)
	
		prtItem_chk( poi,17,  2, dto.getWithholdSlipNotes());	// 򒥎[Ev()
		prtItem_chk( poi,17, 55, dto.getWithholdSlipNotes());	// 򒥎[Ev(E)
		prtItem_chk( poi,48,  2, dto.getWithholdSlipNotes());	// 򒥎[Ev()
		prtItem_chk( poi,48, 55, dto.getWithholdSlipNotes());	// 򒥎[Ev(E)
		
		prtItem_chk( poi,16, 46, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz()
		prtItem_chk( poi,16, 99, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz(E)
		prtItem_chk( poi,47, 46, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz()
		prtItem_chk( poi,47, 99, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz(E)

		prtItem_chk( poi,17, 46, String.valueOf(dto.getPrivatePension()));	//	lNی()	
		prtItem_chk( poi,17, 99, String.valueOf(dto.getPrivatePension()));	//	lNی(E)	
		prtItem_chk( poi,48, 46, String.valueOf(dto.getPrivatePension()));	//	lNی()	
		prtItem_chk( poi,48, 99, String.valueOf(dto.getPrivatePension()));	//	lNی(E)

		prtItem_chk( poi,18, 46, String.valueOf(dto.getLongTermDamageIns()));	//	Qی()	
		prtItem_chk( poi,18, 99, String.valueOf(dto.getLongTermDamageIns()));	//	Qی(E)	
		prtItem_chk( poi,49, 46, String.valueOf(dto.getLongTermDamageIns()));	//	Qی()	
		prtItem_chk( poi,49, 99, String.valueOf(dto.getLongTermDamageIns()));	//	Qی(E)	
		
		prtItem_chk( poi,23,  2, dto.getSelfMinority());			// }{T{lځFN()	
		prtItem_chk( poi,23, 55, dto.getSelfMinority());			// }{T{lځFN(E)	
		prtItem_chk( poi,54,  2, dto.getSelfMinority());			// }{T{lځFN()	
		prtItem_chk( poi,54, 55, dto.getSelfMinority());			// }{T{lځFN(E)	
		
		prtItem_chk( poi,23,  5, dto.getSelfOtu());				// }{T{lځF()	
		prtItem_chk( poi,23, 58, dto.getSelfOtu());				// }{T{lځF(E)	
		prtItem_chk( poi,54,  5, dto.getSelfOtu());				// }{T{lځF()	
		prtItem_chk( poi,54, 58, dto.getSelfOtu());				// }{T{lځF(E)	

		prtItem_chk( poi,23,  7, dto.getSelfSpHandicap());		// }{T{lځFʏQ()	
		prtItem_chk( poi,23, 60, dto.getSelfSpHandicap());		// }{T{lځFʏQ(E)	
		prtItem_chk( poi,54,  7, dto.getSelfSpHandicap());		// }{T{lځFʏQ()	
		prtItem_chk( poi,54, 60, dto.getSelfSpHandicap());		// }{T{lځFʏQ(E)	

		prtItem_chk( poi,23,  10, dto.getSelfGeHandicap());		// }{T{lځFʏQ()	
		prtItem_chk( poi,23,  63, dto.getSelfGeHandicap());		// }{T{lځFʏQ(E)	
		prtItem_chk( poi,54,  10, dto.getSelfGeHandicap());		// }{T{lځFʏQ()	
		prtItem_chk( poi,54,  63, dto.getSelfGeHandicap());		// }{T{lځFʏQ(E)	
		
		prtItem_chk( poi,23,  13, dto.getSelfGeWidow());			// }{T{lځFʉǕw()	
		prtItem_chk( poi,23,  66, dto.getSelfGeWidow());			// }{T{lځFʉǕw(E)	
		prtItem_chk( poi,54,  13, dto.getSelfGeWidow());			// }{T{lځFʉǕw()	
		prtItem_chk( poi,54,  66, dto.getSelfGeWidow());			// }{T{lځFʉǕw(E)	

		prtItem_chk( poi,23,  16, dto.getSelfSpWidow());			// }{T{lځFʉǕw()	
		prtItem_chk( poi,23,  69, dto.getSelfSpWidow());			// }{T{lځFʉǕw(E)	
		prtItem_chk( poi,54,  16, dto.getSelfSpWidow());			// }{T{lځFʉǕw()
		prtItem_chk( poi,54,  69, dto.getSelfSpWidow());			// }{T{lځFʉǕw(E)
		
		prtItem_chk( poi,23,  20, dto.getWidow());				// }{T{lځFǕv()	
		prtItem_chk( poi,23,  73, dto.getWidow());				// }{T{lځFǕv(E)
		prtItem_chk( poi,54,  20, dto.getWidow());				// }{T{lځFǕv()	
		prtItem_chk( poi,54,  73, dto.getWidow());				// }{T{lځFǕv(E)

		prtItem_chk( poi,23,  24, dto.getStudentGeneral());		// }{T{lځFΘJw()	
		prtItem_chk( poi,23,  77, dto.getStudentGeneral());		// }{T{lځFΘJw(E)	
		prtItem_chk( poi,54,  24, dto.getStudentGeneral());		// }{T{lځFΘJw()	
		prtItem_chk( poi,54,  77, dto.getStudentGeneral());		// }{T{lځFΘJw(E)
		
		prtItem_chk( poi,23,  28, dto.getDeadRetirement());		// }{T{lځFSސE()	
		prtItem_chk( poi,23,  81, dto.getDeadRetirement());		// }{T{lځFSސE(E)	
		prtItem_chk( poi,54,  28, dto.getDeadRetirement());		// }{T{lځFSސE()	
		prtItem_chk( poi,54,  81, dto.getDeadRetirement());		// }{T{lځFSސE(E)
		
		prtItem_chk( poi,23,  30, dto.getSelfDisaster());		// }{T{lځFЊQ()	
		prtItem_chk( poi,23,  83, dto.getSelfDisaster());		// }{T{lځFЊQ(E)
		prtItem_chk( poi,54,  30, dto.getSelfDisaster());		// }{T{lځFЊQ()
		prtItem_chk( poi,54,  83, dto.getSelfDisaster());		// }{T{lځFЊQ(E)

		prtItem_chk( poi,23,  31, dto.getForeigner());			// }{T{lځFOl()	
		prtItem_chk( poi,23,  84, dto.getForeigner());			// }{T{lځFOl(E)
		prtItem_chk( poi,54,  31, dto.getForeigner());			// }{T{lځFOl()
		prtItem_chk( poi,54,  84, dto.getForeigner());			// }{T{lځFOl(E)
		
		prtItem_chk( poi,22,  32, dto.getEmployment());			// AE()
		prtItem_chk( poi,22,  85, dto.getEmployment());			// AE(E)
		prtItem_chk( poi,53,  32, dto.getEmployment());			// AE()
		prtItem_chk( poi,53,  85, dto.getEmployment());			// AE(E)
		
		prtItem_chk( poi,22,  33, dto.getRetirement());			// ސE()
		prtItem_chk( poi,22,  86, dto.getRetirement());			// ސE(E)
		prtItem_chk( poi,53,  33, dto.getRetirement());			// ސE()
		prtItem_chk( poi,53,  86, dto.getRetirement());			// ސE(E)

		prtItem_chk( poi,22,  34, dto.getRetirementYaer());		// ގГ(N)()
		prtItem_chk( poi,22,  87, dto.getRetirementYaer());		// ގГ(N)(E)
		prtItem_chk( poi,53,  34, dto.getRetirementYaer());		// ގГ(N)()
		prtItem_chk( poi,53,  87, dto.getRetirementYaer());		// ގГ(N)(E)

		prtItem_chk( poi,22,  36, dto.getRetirementMonth());		// ގГ()()
		prtItem_chk( poi,22,  89, dto.getRetirementMonth());		// ގГ()(E)
		prtItem_chk( poi,53,  36, dto.getRetirementMonth());		// ގГ()()
		prtItem_chk( poi,53,  89, dto.getRetirementMonth());		// ގГ()(E)
		
		prtItem_chk( poi,22,  37, dto.getRetirementMonth());		// ގГ()()
		prtItem_chk( poi,22,  90, dto.getRetirementMonth());		// ގГ()(E)
		prtItem_chk( poi,53,  37, dto.getRetirementMonth());		// ގГ()()
		prtItem_chk( poi,53,  90, dto.getRetirementMonth());		// ގГ()(E)
		
		prtItem_chk( poi,22,  39, dto.getBirthMeiji());			// Na()()
		prtItem_chk( poi,22,  92, dto.getBirthMeiji());			// Na()(E)
		prtItem_chk( poi,53,  39, dto.getBirthMeiji());			// Na()()
		prtItem_chk( poi,53,  92, dto.getBirthMeiji());			// Na()(E)
		
		prtItem_chk( poi,22,  40, dto.getBirthTaisyou());		// Na(吳)()
		prtItem_chk( poi,22,  93, dto.getBirthTaisyou());		// Na(吳)(E)
		prtItem_chk( poi,53,  40, dto.getBirthTaisyou());		// Na(吳)()
		prtItem_chk( poi,53,  93, dto.getBirthTaisyou());		// Na(吳)(E)

		prtItem_chk( poi,22,  42, dto.getBirthSyouwa());			// Na(a)()
		prtItem_chk( poi,22,  95, dto.getBirthSyouwa());			// Na(a)(E)
		prtItem_chk( poi,53,  42, dto.getBirthSyouwa());			// Na(a)()
		prtItem_chk( poi,53,  95, dto.getBirthSyouwa());			// Na(a)(E)

		prtItem_chk( poi,22,  44, dto.getBirthHeisei());			// Na()()
		prtItem_chk( poi,22,  97, dto.getBirthHeisei());			// Na()(E)
		prtItem_chk( poi,53,  44, dto.getBirthHeisei());			// Na()()
		prtItem_chk( poi,53,  97, dto.getBirthHeisei());			// Na()(E)
		
		prtItem_chk( poi,22,  46, dto.getBirthYear());			// N(N)()
		prtItem_chk( poi,22,  99, dto.getBirthYear());			// N(N)(E)
		prtItem_chk( poi,53,  46, dto.getBirthYear());			// N(N)()
		prtItem_chk( poi,53,  99, dto.getBirthYear());			// N(N)(E)

		prtItem_chk( poi,22,  49, dto.getBirthMonth());			// N()()
		prtItem_chk( poi,22, 102, dto.getBirthMonth());			// N()(E)
		prtItem_chk( poi,53,  49, dto.getBirthMonth());			// N()()
		prtItem_chk( poi,53, 102, dto.getBirthMonth());			// N()(E)
		
		prtItem_chk( poi,22,  50, dto.getBirthDay());			// N()()
		prtItem_chk( poi,22, 103, dto.getBirthDay());			// N()(E)
		prtItem_chk( poi,53,  50, dto.getBirthDay());			// N()()
		prtItem_chk( poi,53, 103, dto.getBirthDay());			// N()(E)
		
		prtItem_chk( poi,24,   9, dto.getCompanyAddress());		// ЏZ()
		prtItem_chk( poi,24,  62, dto.getCompanyAddress());		// ЏZ(E)
		prtItem_chk( poi,55,   9, dto.getCompanyAddress());		// ЏZ()
		prtItem_chk( poi,55,  62, dto.getCompanyAddress());		// ЏZ(E)

		prtItem_chk( poi,26,   9, dto.getCompanyName());			// Ж()
		prtItem_chk( poi,26,  62, dto.getCompanyName());			// Ж(E)
		prtItem_chk( poi,57,   9, dto.getCompanyName());			// Ж()
		prtItem_chk( poi,57,  62, dto.getCompanyName());			// Ж(E)
		
		prtItem_chk( poi,27,  40, dto.getCompanyPhone());		// Гdbԍ()
		prtItem_chk( poi,27,  93, dto.getCompanyPhone());		// Гdbԍ(E)
		prtItem_chk( poi,58,  40, dto.getCompanyPhone());		// Гdbԍ()
		prtItem_chk( poi,58,  93, dto.getCompanyPhone());		// Гdbԍ(E)

		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + 
										PayrollConst.FILE_NAME_SEPARATOR +
										dto.getKCode()	+
										PayrollConst.FILE_NAME_SEPARATOR +
										PayrollConst.FILE_WITHHOLDING_VOTE_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}


	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @throws Exception 
	 */
	private void report(AdjustmentReferVo vo , WithholdingVoteDto dto) throws Exception {
		// RlNV擾
		getConnection();
		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_WITHHOLDING_VOTE_ODS);
		setValue_chk( odsBean,   1,   2, dto.getIncExpectedDate());		// ΏۘaNxNx(A^Cg)
		setValue_chk( odsBean,  67,   2, dto.getIncExpectedDate());		// ΏۘaNxNx(A^Cg)
		setValue_chk( odsBean,  87,  22, dto.getIncExpectedDate());		// ΏۘaNxNx(EArސEN)
		setValue_chk( odsBean,  34,  22, dto.getIncExpectedDate());		// ΏۘaNxNx(ArސEN)
		setValue_chk( odsBean,   1,  33, dto.getIncExpectedDate());		// ΏۘaNxNx(EA^CgN)
		setValue_chk( odsBean,  67,  33, dto.getIncExpectedDate());		// ΏۘaNxNx(EA^CgN)
		setValue_chk( odsBean,  34,  53, dto.getIncExpectedDate());		// ΏۘaNxNx(ArސEN)
		setValue_chk( odsBean,  87,  53, dto.getIncExpectedDate());		// ΏۘaNxNx(EArސEN)

		setValue_chk( odsBean,   7,   4, dto.getAddress());				// 󋋎ҏZ()
		setValue_chk( odsBean,   7,  35, dto.getAddress());				// 󋋎ҏZ()
		setValue_chk( odsBean,  60,   3, dto.getAddress());				// 󋋎ҏZ(E)
		setValue_chk( odsBean,  60,  34, dto.getAddress());				// 󋋎ҏZ(E)

		setValue_chk( odsBean,  38,   3, dto.getKCode());				// 󋋎Ҕԍ()
		setValue_chk( odsBean,  91,   3, dto.getKCode());				// 󋋎Ҕԍ(E)
		setValue_chk( odsBean, 38,   34, dto.getKCode());				// 󋋎Ҕԍ()
		setValue_chk( odsBean, 91,   34, dto.getKCode());				// 󋋎Ҕԍ(E)

		setValue_chk( odsBean,  39,   4, dto.getKKana());				// tKi()
		setValue_chk( odsBean,  92,   4, dto.getKKana());				// tKi(E)
		setValue_chk( odsBean,  39,  35, dto.getKKana());				// tKi()
		setValue_chk( odsBean,  92,  35, dto.getKKana());				// tKi(E)

		setValue_chk( odsBean,  34,   6, dto.getPositionName());			// E()
		setValue_chk( odsBean,  87,   6, dto.getPositionName());			// E(E)
		setValue_chk( odsBean,  34,  37, dto.getPositionName());			// E()
		setValue_chk( odsBean,  87,  37, dto.getPositionName());			// E(E)

		setValue_chk( odsBean,  39,   5, dto.getKName());				// ()
		setValue_chk( odsBean,  92,   5, dto.getKName());				// (E)
		setValue_chk( odsBean,  39,  36, dto.getKName());				// ()
		setValue_chk( odsBean,  92,  36, dto.getKName());				// (E)

		setValue_chk( odsBean,  12,   9, dto.getPaymentAllowance());		// xz()
		setValue_chk( odsBean,  65,   9, dto.getPaymentAllowance());		// xz(E)
		setValue_chk( odsBean,  12,  40, dto.getPaymentAllowance());		// xz()
		setValue_chk( odsBean,  65,  40, dto.getPaymentAllowance());		// xz(E)

		setValue_chk( odsBean,  27,   9, dto.getAfterDeductIncome());	//  ^T̋^̋z()
		setValue_chk( odsBean,  80,   9, dto.getAfterDeductIncome());	//  ^T̋^̋z(E)
		setValue_chk( odsBean,  27,  40, dto.getAfterDeductIncome());	//  ^T̋^̋z()
		setValue_chk( odsBean,  80,  40, dto.getAfterDeductIncome());	//  ^T̋^̋z(E)

		setValue_chk( odsBean,  34,   9, dto.getCalcTaxedIncome());		//  T̊z̍vz()
		setValue_chk( odsBean,  87,   9, dto.getCalcTaxedIncome());		//  T̊z̍vz(E)
		setValue_chk( odsBean,  34,  40, dto.getCalcTaxedIncome());		//  T̊z̍vz()
		setValue_chk( odsBean,  87,  40, dto.getCalcTaxedIncome());		//  T̊z̍vz(E)

		setValue_chk( odsBean,  43,   9, dto.getWithholdTax());			// 򒥎()		
		setValue_chk( odsBean,  96,   9, dto.getWithholdTax());			// 򒥎(E)		
		setValue_chk( odsBean,  43,  40, dto.getWithholdTax());			// 򒥎()		
		setValue_chk( odsBean,  96,  40, dto.getWithholdTax());			// 򒥎(E)		

		setValue_chk( odsBean,   2,  15, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L()
		setValue_chk( odsBean,  55,  15, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L(E)	
		setValue_chk( odsBean,   2,  46, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L()
		setValue_chk( odsBean,  55,  46, dto.getIsDeductionSpouse());	// TΏ۔z҂̗L: L(E)	

		setValue_chk( odsBean,   4,  15, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: ()
		setValue_chk( odsBean,  57,  15, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: (E)
		setValue_chk( odsBean,   4,  46, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: ()
		setValue_chk( odsBean,  57,  46, dto.getNoDeductionSpouse());	// TΏ۔z҂̗L: (E)	

		setValue_chk( odsBean,   6,  15, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L()
		setValue_chk( odsBean,  59,  15, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L(E)
		setValue_chk( odsBean,   6,  46, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L()
		setValue_chk( odsBean,  59,  46, dto.getIsSubDeducSpouse());		// TΏ۔z҂̗L: ]L(E)

		setValue_chk( odsBean,   7,  15, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ]()
		setValue_chk( odsBean,  60,  15, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ](E)
		setValue_chk( odsBean,   7,  46, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ]()
		setValue_chk( odsBean,  60,  46, dto.getNoSubDeducSpouse());		// TΏ۔z҂̗L: ](E)

		setValue_chk( odsBean,   8,  14, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl()
		setValue_chk( odsBean,   8,  45, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl()
		setValue_chk( odsBean,  61,  14, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl(E)
		setValue_chk( odsBean,  61,  45, dto.getElderlySpouse());		// TΏ۔z҂̗L: Vl(E)

		setValue_chk( odsBean,  10,  14, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz()
		setValue_chk( odsBean,  63,  14, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz(E)
		setValue_chk( odsBean,  10,  45, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz()
		setValue_chk( odsBean,  63,  45, String.valueOf(dto.getSpouseSpDeduction()));	// zғʍTz(E)

		setValue_chk( odsBean,  16,  14, dto.getSpDependent());			// ()
		setValue_chk( odsBean,  69,  14, dto.getSpDependent());			// (E)
		setValue_chk( odsBean,  16,  45, dto.getSpDependent());			// ()
		setValue_chk( odsBean,  69,  45, dto.getSpDependent());			// (E)

		setValue_chk( odsBean,  19,  14, dto.getSpSubDependent());		// ]l()
		setValue_chk( odsBean,  72,  14, dto.getSpSubDependent());		// ]l(E)
		setValue_chk( odsBean,  19,  45, dto.getSpSubDependent());		// ]l()
		setValue_chk( odsBean,  72,  45, dto.getSpSubDependent());		// ]l(E)

		setValue_chk( odsBean,  22,  14, dto.getSpElItemDepend());		// Vl()
		setValue_chk( odsBean,  75,  14, dto.getSpElItemDepend());		// Vl(E)
		setValue_chk( odsBean,  22,  45, dto.getSpElItemDepend());		// Vl()
		setValue_chk( odsBean,  75,  45, dto.getSpElItemDepend());		// Vl(E)

		setValue_chk( odsBean,  24,  14, dto.getSpElDependent());		// Vl()
		setValue_chk( odsBean,  77,  14, dto.getSpElDependent());		// Vl(E)
		setValue_chk( odsBean,  24,  45, dto.getSpElDependent());		// Vl()
		setValue_chk( odsBean,  77,  45, dto.getSpElDependent());		// Vl(E)

		setValue_chk( odsBean,  26,  14, dto.getSpSubElDepend());		// ]l()
		setValue_chk( odsBean,  79,  14, dto.getSpSubElDepend());		// ]l(E)
		setValue_chk( odsBean,  26,  45, dto.getSpSubElDepend());		// ]l()
		setValue_chk( odsBean,  79,  45, dto.getSpSubElDepend());		// ]l(E)

		setValue_chk( odsBean,  29,  14, dto.getOtherDepend());			// ̑()		
		setValue_chk( odsBean,  82,  14, dto.getOtherDepend());			// ̑(E)		
		setValue_chk( odsBean,  29,  45, dto.getOtherDepend());			// ̑()		
		setValue_chk( odsBean,  82,  45, dto.getOtherDepend());			// ̑(E)		

		setValue_chk( odsBean,  30,  14, dto.getOtherSubDepend());		// ̑]l()		
		setValue_chk( odsBean,  83,  14, dto.getOtherSubDepend());		// ̑]l(E)		
		setValue_chk( odsBean,  30,  45, dto.getOtherSubDepend());		// ̑]l()		
		setValue_chk( odsBean,  83,  45, dto.getOtherSubDepend());		// ̑]l(E)		

		setValue_chk( odsBean,  31,  14, dto.getSpItemHandicap());		// Q҂̐Fʓ()
		setValue_chk( odsBean,  84,  14, dto.getSpItemHandicap());		// Q҂̐Fʓ(E)
		setValue_chk( odsBean,  31,  45, dto.getSpItemHandicap());		// Q҂̐Fʓ()
		setValue_chk( odsBean,  84,  45, dto.getSpItemHandicap());		// Q҂̐Fʓ(E)

		setValue_chk( odsBean,  32,  14, dto.getSpHandicap());			// Q҂̐F()
		setValue_chk( odsBean,  85,  14, dto.getSpHandicap());			// Q҂̐F(E)
		setValue_chk( odsBean,  32,  45, dto.getSpHandicap());			// Q҂̐F()
		setValue_chk( odsBean,  85,  45, dto.getSpHandicap());			// Q҂̐F(E)

		setValue_chk( odsBean,  33,  14, dto.getSpHandicapOther());		// Q҂̐F̑()
		setValue_chk( odsBean,  86,  14, dto.getSpHandicapOther());		// Q҂̐F̑(E)
		setValue_chk( odsBean,  33,  45, dto.getSpHandicapOther());		// Q҂̐F̑()
		setValue_chk( odsBean,  86,  45, dto.getSpHandicapOther());		// Q҂̐F̑(E)

		setValue_chk( odsBean,  34,  14, dto.getSocialInsDeduction());	// ЉیTz()
		setValue_chk( odsBean,  87,  14, dto.getSocialInsDeduction());	// ЉیTz(E)
		setValue_chk( odsBean,  34,  45, dto.getSocialInsDeduction());	// ЉیTz()
		setValue_chk( odsBean,  87,  45, dto.getSocialInsDeduction());	// ЉیTz(E)

		setValue_chk( odsBean,  39,  14, dto.getLifeInsDeduction());	// یTz()
		setValue_chk( odsBean,  92,  14, dto.getLifeInsDeduction());	// یTz(E)
		setValue_chk( odsBean,  39,  45, dto.getLifeInsDeduction());	// یTz()
		setValue_chk( odsBean,  92,  45, dto.getLifeInsDeduction());	// یTz(E)

		setValue_chk( odsBean,  43,  14, dto.getEarthquakeIns());	// nkی()
		setValue_chk( odsBean,  96,  14, dto.getEarthquakeIns());	// nkی(E)
		setValue_chk( odsBean,  43,  45, dto.getEarthquakeIns());	// nkی()
		setValue_chk( odsBean,  96,  45, dto.getEarthquakeIns());	// nkی(E)

		setValue_chk( odsBean,  48,  14, dto.getHouseLoanDeduction());	// ZؓʍTz()
		setValue_chk( odsBean, 101,  14, dto.getHouseLoanDeduction());	// ZؓʍTz(E)
		setValue_chk( odsBean,  48,  45, dto.getHouseLoanDeduction());	// ZؓʍTz()
		setValue_chk( odsBean, 101,  45, dto.getHouseLoanDeduction());	// ZؓʍTz(E)

		setValue_chk( odsBean,   2,  17, dto.getWithholdSlipNotes());	// 򒥎[Ev()
		setValue_chk( odsBean,  55,  17, dto.getWithholdSlipNotes());	// 򒥎[Ev(E)
		setValue_chk( odsBean,   2,  48, dto.getWithholdSlipNotes());	// 򒥎[Ev()
		setValue_chk( odsBean,  55,  48, dto.getWithholdSlipNotes());	// 򒥎[Ev(E)

		setValue_chk( odsBean,  46,  16, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz()
		setValue_chk( odsBean,  99,  16, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz(E)
		setValue_chk( odsBean,  46,  47, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz()
		setValue_chk( odsBean,  99,  47, String.valueOf(dto.getSpouseSumIncome()));	//  z҂̖{N̍vžϊz(E)

		setValue_chk( odsBean,  46,  17, String.valueOf(dto.getPrivatePension()));	//	lNی()	
		setValue_chk( odsBean,  99,  17, String.valueOf(dto.getPrivatePension()));	//	lNی(E)	
		setValue_chk( odsBean,  46,  48, String.valueOf(dto.getPrivatePension()));	//	lNی()	
		setValue_chk( odsBean,  99,  48, String.valueOf(dto.getPrivatePension()));	//	lNی(E)

		setValue_chk( odsBean,  46,  18, String.valueOf(dto.getLongTermDamageIns()));	//	Qی()	
		setValue_chk( odsBean,  99,  18, String.valueOf(dto.getLongTermDamageIns()));	//	Qی(E)	
		setValue_chk( odsBean,  46,  49, String.valueOf(dto.getLongTermDamageIns()));	//	Qی()	
		setValue_chk( odsBean,  99,  49, String.valueOf(dto.getLongTermDamageIns()));	//	Qی(E)	

		setValue_chk( odsBean,   2,  23, dto.getSelfMinority());			// }{T{lځFN()	
		setValue_chk( odsBean,  55,  23, dto.getSelfMinority());			// }{T{lځFN(E)	
		setValue_chk( odsBean,   2,  54, dto.getSelfMinority());			// }{T{lځFN()	
		setValue_chk( odsBean,  55,  54, dto.getSelfMinority());			// }{T{lځFN(E)	

		setValue_chk( odsBean,   5,  23, dto.getSelfOtu());				// }{T{lځF()	
		setValue_chk( odsBean,  58,  23, dto.getSelfOtu());				// }{T{lځF(E)	
		setValue_chk( odsBean,   5,  54, dto.getSelfOtu());				// }{T{lځF()	
		setValue_chk( odsBean,  58,  54, dto.getSelfOtu());				// }{T{lځF(E)	

		setValue_chk( odsBean,   7,  23, dto.getSelfSpHandicap());		// }{T{lځFʏQ()	
		setValue_chk( odsBean,  60,  23, dto.getSelfSpHandicap());		// }{T{lځFʏQ(E)	
		setValue_chk( odsBean,   7,  54, dto.getSelfSpHandicap());		// }{T{lځFʏQ()	
		setValue_chk( odsBean,  60,  54, dto.getSelfSpHandicap());		// }{T{lځFʏQ(E)	

		setValue_chk( odsBean,  10,  23, dto.getSelfGeHandicap());		// }{T{lځFʏQ()	
		setValue_chk( odsBean,  63,  23, dto.getSelfGeHandicap());		// }{T{lځFʏQ(E)	
		setValue_chk( odsBean,  10,  54, dto.getSelfGeHandicap());		// }{T{lځFʏQ()	
		setValue_chk( odsBean,  63,  54, dto.getSelfGeHandicap());		// }{T{lځFʏQ(E)	

		setValue_chk( odsBean,  13,  23, dto.getSelfGeWidow());			// }{T{lځFʉǕw()	
		setValue_chk( odsBean,  66,  23, dto.getSelfGeWidow());			// }{T{lځFʉǕw(E)	
		setValue_chk( odsBean,  13,  54, dto.getSelfGeWidow());			// }{T{lځFʉǕw()	
		setValue_chk( odsBean,  66,  54, dto.getSelfGeWidow());			// }{T{lځFʉǕw(E)	

		setValue_chk( odsBean,  16,  23, dto.getSelfSpWidow());			// }{T{lځFʉǕw()	
		setValue_chk( odsBean,  69,  23, dto.getSelfSpWidow());			// }{T{lځFʉǕw(E)	
		setValue_chk( odsBean,  16,  54, dto.getSelfSpWidow());			// }{T{lځFʉǕw()
		setValue_chk( odsBean,  69,  54, dto.getSelfSpWidow());			// }{T{lځFʉǕw(E)

		setValue_chk( odsBean,  20,  23, dto.getWidow());				// }{T{lځFǕv()	
		setValue_chk( odsBean,  73,  23, dto.getWidow());				// }{T{lځFǕv(E)
		setValue_chk( odsBean,  20,  54, dto.getWidow());				// }{T{lځFǕv()	
		setValue_chk( odsBean,  73,  54, dto.getWidow());				// }{T{lځFǕv(E)

		setValue_chk( odsBean,  24,  23, dto.getStudentGeneral());		// }{T{lځFΘJw()	
		setValue_chk( odsBean,  77,  23, dto.getStudentGeneral());		// }{T{lځFΘJw(E)	
		setValue_chk( odsBean,  24,  54, dto.getStudentGeneral());		// }{T{lځFΘJw()	
		setValue_chk( odsBean,  77,  54, dto.getStudentGeneral());		// }{T{lځFΘJw(E)

		setValue_chk( odsBean,  28,  23, dto.getDeadRetirement());		// }{T{lځFSސE()	
		setValue_chk( odsBean,  81,  23, dto.getDeadRetirement());		// }{T{lځFSސE(E)	
		setValue_chk( odsBean,  28,  54, dto.getDeadRetirement());		// }{T{lځFSސE()	
		setValue_chk( odsBean,  81,  54, dto.getDeadRetirement());		// }{T{lځFSސE(E)

		setValue_chk( odsBean,  30,  23, dto.getSelfDisaster());		// }{T{lځFЊQ()	
		setValue_chk( odsBean,  83,  23, dto.getSelfDisaster());		// }{T{lځFЊQ(E)
		setValue_chk( odsBean,  30,  54, dto.getSelfDisaster());		// }{T{lځFЊQ()
		setValue_chk( odsBean,  83,  54, dto.getSelfDisaster());		// }{T{lځFЊQ(E)

		setValue_chk( odsBean,  31,  23, dto.getForeigner());			// }{T{lځFOl()	
		setValue_chk( odsBean,  84,  23, dto.getForeigner());			// }{T{lځFOl(E)
		setValue_chk( odsBean,  31,  54, dto.getForeigner());			// }{T{lځFOl()
		setValue_chk( odsBean,  84,  54, dto.getForeigner());			// }{T{lځFOl(E)

		setValue_chk( odsBean,  32,  22, dto.getEmployment());			// AE()
		setValue_chk( odsBean,  85,  22, dto.getEmployment());			// AE(E)
		setValue_chk( odsBean,  32,  53, dto.getEmployment());			// AE()
		setValue_chk( odsBean,  85,  53, dto.getEmployment());			// AE(E)

		setValue_chk( odsBean,  33,  22, dto.getRetirement());			// ސE()
		setValue_chk( odsBean,  86,  22, dto.getRetirement());			// ސE(E)
		setValue_chk( odsBean,  33,  53, dto.getRetirement());			// ސE()
		setValue_chk( odsBean,  86,  53, dto.getRetirement());			// ސE(E)

		setValue_chk( odsBean,  34,  22, dto.getRetirementYaer());		// ގГ(N)()
		setValue_chk( odsBean,  87,  22, dto.getRetirementYaer());		// ގГ(N)(E)
		setValue_chk( odsBean,  34,  53, dto.getRetirementYaer());		// ގГ(N)()
		setValue_chk( odsBean,  87,  53, dto.getRetirementYaer());		// ގГ(N)(E)

		setValue_chk( odsBean,  36,  22, dto.getRetirementMonth());		// ގГ()()
		setValue_chk( odsBean,  89,  22, dto.getRetirementMonth());		// ގГ()(E)
		setValue_chk( odsBean,  36,  53, dto.getRetirementMonth());		// ގГ()()
		setValue_chk( odsBean,  89,  53, dto.getRetirementMonth());		// ގГ()(E)

		setValue_chk( odsBean,  37,  22, dto.getRetirementMonth());		// ގГ()()
		setValue_chk( odsBean,  90,  22, dto.getRetirementMonth());		// ގГ()(E)
		setValue_chk( odsBean,  37,  53, dto.getRetirementMonth());		// ގГ()()
		setValue_chk( odsBean,  90,  53, dto.getRetirementMonth());		// ގГ()(E)

		setValue_chk( odsBean,  39,  22, dto.getBirthMeiji());			// Na()()
		setValue_chk( odsBean,  92,  22, dto.getBirthMeiji());			// Na()(E)
		setValue_chk( odsBean,  39,  53, dto.getBirthMeiji());			// Na()()
		setValue_chk( odsBean,  92,  53, dto.getBirthMeiji());			// Na()(E)

		setValue_chk( odsBean,  40,  22, dto.getBirthTaisyou());		// Na(吳)()
		setValue_chk( odsBean,  93,  22, dto.getBirthTaisyou());		// Na(吳)(E)
		setValue_chk( odsBean,  40,  53, dto.getBirthTaisyou());		// Na(吳)()
		setValue_chk( odsBean,  93,  53, dto.getBirthTaisyou());		// Na(吳)(E)

		setValue_chk( odsBean,  42,  22, dto.getBirthSyouwa());			// Na(a)()
		setValue_chk( odsBean,  95,  22, dto.getBirthSyouwa());			// Na(a)(E)
		setValue_chk( odsBean,  42,  53, dto.getBirthSyouwa());			// Na(a)()
		setValue_chk( odsBean,  95,  53, dto.getBirthSyouwa());			// Na(a)(E)

		setValue_chk( odsBean,  44,  22, dto.getBirthHeisei());			// Na()()
		setValue_chk( odsBean,  97,  22, dto.getBirthHeisei());			// Na()(E)
		setValue_chk( odsBean,  44,  53, dto.getBirthHeisei());			// Na()()
		setValue_chk( odsBean,  97,  53, dto.getBirthHeisei());			// Na()(E)

		setValue_chk( odsBean,  46,  22, dto.getBirthYear());			// N(N)()
		setValue_chk( odsBean,  99,  22, dto.getBirthYear());			// N(N)(E)
		setValue_chk( odsBean,  46,  53, dto.getBirthYear());			// N(N)()
		setValue_chk( odsBean,  99,  53, dto.getBirthYear());			// N(N)(E)

		setValue_chk( odsBean,  49,  22, dto.getBirthMonth());			// N()()
		setValue_chk( odsBean, 102,  22, dto.getBirthMonth());			// N()(E)
		setValue_chk( odsBean,  49,  53, dto.getBirthMonth());			// N()()
		setValue_chk( odsBean, 102,  53, dto.getBirthMonth());			// N()(E)

		setValue_chk( odsBean,  50,  22, dto.getBirthDay());			// N()()
		setValue_chk( odsBean, 103,  22, dto.getBirthDay());			// N()(E)
		setValue_chk( odsBean,  50,  53, dto.getBirthDay());			// N()()
		setValue_chk( odsBean, 103,  53, dto.getBirthDay());			// N()(E)

		setValue_chk( odsBean,   9,  24, dto.getCompanyAddress());		// ЏZ()
		setValue_chk( odsBean,  62,  24, dto.getCompanyAddress());		// ЏZ(E)
		setValue_chk( odsBean,   9,  55, dto.getCompanyAddress());		// ЏZ()
		setValue_chk( odsBean,  62,  55, dto.getCompanyAddress());		// ЏZ(E)

		setValue_chk( odsBean,   9,  26, dto.getCompanyName());			// Ж()
		setValue_chk( odsBean,  62,  26, dto.getCompanyName());			// Ж(E)
		setValue_chk( odsBean,   9,  57, dto.getCompanyName());			// Ж()
		setValue_chk( odsBean,  62,  57, dto.getCompanyName());			// Ж(E)

		setValue_chk( odsBean,  40,  27, dto.getCompanyPhone());		// Гdbԍ()
		setValue_chk( odsBean,  93,  27, dto.getCompanyPhone());		// Гdbԍ(E)
		setValue_chk( odsBean,  40,  58, dto.getCompanyPhone());		// Гdbԍ()
		setValue_chk( odsBean,  93,  58, dto.getCompanyPhone());		// Гdbԍ(E)

		// o͓eݒ
		String fileName = String.valueOf(vo.getHidAdjustYear()) + 
										PayrollConst.FILE_NAME_SEPARATOR +
										dto.getKCode()	+
										PayrollConst.FILE_NAME_SEPARATOR +
										PayrollConst.FILE_WITHHOLDING_VOTE_ODS;

		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}

}
