package jp.mosp.payroll.report.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.bean.OdsBean;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.InsuranceConfSetVo;
import jp.mosp.payroll.dao.CdSocInsuranceDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dto.CdSocInsuranceDto;
import jp.mosp.payroll.dto.CmCompanyDto;
public class InsuranceRepAction extends AdjustmentAction{
	
	
	// R}h
	private static final String CMD_INSURANCEREP_LIST_ALL = "P4010";
	private static final String CMD_INSURANCEREP_LIST_ONE = "P4011";
	private static final String CMD_INSURANCEREP_LIST_ALL2= "P4012";
	
	private	int		nowYear = 0;			// NxvZp
	private	String	strTekiyouDate	=	"";	// KptiNEj
	private	Date    nowDateTmp;				//{t(Date^)
	private	String  nowDateJp;				//{t(a)

	private CmCompanyDao cmCompanyDao;
	private CmCompanyDto cmCompanyDto;
	
	public String[][] aryGender  ;
	// ݒe[u
	public List<MosPConfDto> listConf;
	public String[][] aryEra;
	public String[][] aryStation ;
	
	
	/**
	 * RXgN^
	 */
	public InsuranceRepAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		InsuranceConfSetVo	confVo;
		Date	dateTekiyouDate	=	null;								// KptiNEEj
		int intCalcDate   = 0;
		int intCalcDate_s = 0;

		// DBRlNV擾
		getConnection();
		// DAO
		prepareDao();
		// z擾
		aryStation  = getStationArrayAll() ;
		aryPosition = getPositionArrayAll();
		aryEra      = getCodeArray(PayrollConst.TID_JAPANESE);

		//ݒvo̎擾
		confVo	=	(InsuranceConfSetVo)getStoredVo(PayrollConst.VO_INSURANCECONF_SET); // ZEϏݒVO̎擾
		
		// aݒ擾
		listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);

		nowDateTmp = getSystemDate();					//{t擾
		nowYear	=	MospUtility.getYear(nowDateTmp);	//N擾

		//a{t擾
		nowDateJp = getJapaneseDate( nowDateTmp);

		//KpiNj擾ݒ
		if(confVo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)){	//Zbw̏ꍇ
			intCalcDate = (nowYear * 10000) + (PayrollConst.MONTH_TEKIYOU_DEFAULT * 100) + PayrollConst.TIME_DEFAULT_DAY;
			intCalcDate_s = (nowYear * 100) + PayrollConst.MONTH_TEKIYOU_DEFAULT ;
		}else{
			if((confVo.prmSyoukyuTuki == null) || (confVo.prmSyoukyuTuki.equals("0"))){
				intCalcDate   = (nowYear * 10000) + (PayrollConst.MONTH_TEKIYOU_DEFAULT * 100) + PayrollConst.TIME_DEFAULT_DAY;
				intCalcDate_s = (nowYear * 100)   +  PayrollConst.MONTH_TEKIYOU_DEFAULT;
			}else{
				intCalcDate   = (nowYear * 10000) + ((Integer.valueOf(confVo.prmSyoukyuTuki) + 3 ) * 100 ) + PayrollConst.TIME_DEFAULT_DAY;
				intCalcDate_s = (nowYear * 100)   +  (Integer.valueOf(confVo.prmSyoukyuTuki) + 3 );
			}
		}
		dateTekiyouDate = DatePart.convIntegerDateToDate(intCalcDate);
		strTekiyouDate = String.valueOf(intCalcDate_s);			

		// Џ擾
		cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		cmCompanyDto = cmCompanyDao.findAll();
		
		if (cmd.equals(CMD_INSURANCEREP_LIST_ALL)) {
			startAdjDate = getStartDateOfYear(adjustYear);
			lastDate     = getLastDateOfYear(adjustYear);
			CdSocInsuranceDao cdSocInsuranceDao = new CdSocInsuranceDao();
			cdSocInsuranceDao.initDao(cfg, cmd, aspUser, user, conn);
				
			// ^׃f[^쐬
			List<CdSocInsuranceDto> list = cdSocInsuranceDao.findForCondition( dateTekiyouDate );
			// [쐬
			if (cfg.getProperty(PayrollConst.PPT_PAY_USEXLS) == null) {
				report(confVo, list);
			} else {
				reportXls(confVo, list);
			}
			
		} else if (cmd.equals(CMD_INSURANCEREP_LIST_ONE)) {
			// VO̎擾
		} else if (cmd.equals(CMD_INSURANCEREP_LIST_ALL2)) {
			// VO̎擾
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);	
		}
	}

	/**
	 * [o͏sB(Excel)<br><br>
	 * @throws Exception 
	 */
	private void reportXls(InsuranceConfSetVo vo , List<CdSocInsuranceDto> list ) throws Exception {

		CdSocInsuranceDto	cdSocInsuranceDto;
		
		String tmpTitleSei   = "";	
		String tmpTitleFuk   = "";	
		String tmpRepCode    = "";	
		String tmpWork       = "";	
		int Line;
		int Column;
		int Sum_sheet;
		int Sum_cnt;
		int tmpDate;

		int lK_name						= 14;	// sFЈ
		int cK_name						=  7;	// FЈ
		int lHhealth_no					= 14;	// sFNیԍ
		int cHhealth_no					=  2;	// FNیԍ
		int lBerthdayJpCd				= 14;	// sFR[h
		int cBerthdayJpCd				= 15;	// FR[h
		int lBerthdayY					= 14;	// sFaN
		int cBerthdayY					= 17;	// FaN
		int lBerthdayM					= 14;	// sFa
		int cBerthdaym					= 19;	// Fa
		int lBerthdayD					= 14;	// sFa
		int cBerthdayD					= 21;	// Fa
		int lGender						= 14;	// sFʃR[h
		int cGender						= 23;	// FʃR[h
		int lHealth_bef_premium			= 14;	// sFۏ]Oی
		int cHealth_bef_premium			= 25;	// Fۏ]Oی
		int lPension_bef_premium		= 14;	// sFN]Oی
		int cPension_bef_premium		= 32;	// FN]Oی

		int lPay_basic_month1			= 20;	// sFxb1()
		int cPay_basic_month1			=  1;	// Fxb1()
		int lPay_basic_month2			= 18;	// sFxb2()
		int cPay_basic_month2			=  1;	// Fxb2()
		int lPay_basic_month3			= 16;	// sFxb3()
		int cPay_basic_month3			=  1;	// Fxb3()

		int lPay_basic_day1				= 20;	// sFxb1()
		int cPay_basic_day1				=  3;	// Fxb1()
		int lPay_basic_day2				= 18;	// sFxb2()
		int cPay_basic_day2				=  3;	// Fxb2()
		int lPay_basic_day3				= 16;	// sFxb3()
		int cPay_basic_day3				=  3;	// Fxb3()

		int lPay_amount1				= 20;	// sFK̊z1
		int cPay_amount1				=  6;	// FK̊z1
		int lPay_amount2				= 18;	// sFK̊z2
		int cPay_amount2				=  6;	// FK̊z2
		int lPay_amount3				= 16;	// sFK̊z3
		int cPay_amount3				=  6;	// FK̊z3

		int lGoods_amount1				= 20;	// sF̊z1
		int cGoods_amount1				= 12;	// F̊z1
		int lGoods_amount2				= 18;	// sF̊z2
		int cGoods_amount2				= 12;	// F̊z2
		int lGoods_amount3				= 16;	// sF̊z3
		int cGoods_amount3				= 12;	// F̊z3

		int lReward_total1				= 20;	// sFVv1
		int cReward_total1				= 19;	// FVv1
		int lReward_total2				= 18;	// sFVv2
		int cReward_total2				= 19;	// FVv2
		int lReward_total3				= 16;	// sFVv3
		int cReward_total3				= 19;	// FVv3
		
		int lReward_total_sum			= 16;	// sFVz
		int cReward_total_sum			= 25;	// FVz
		int lAverage_three_months		= 18;	// sFR
		int cAverage_three_months		= 25;	// FR
		int lHealth_dec_premium			= 20;	// sFیی
		int cHealth_dec_premium			= 25;	// Fیی
		int lExpected_dateY				= 16;	// sFKpN:N
		int cExpected_dateY				= 32;	// FKpN:N
		int lExpected_dateM				= 16;	// sFKpN:
		int cExpected_dateM				= 34;	// FKpN:
		int lEdit_average				= 18;	// sFC
		int cEdit_average				= 32;	// FC
		int lPension_dec_premium		= 20;	// sFNی
		int cPension_dec_premium		= 32;	// FNی
		int lRetroactive_payment		= 16;	// sFkyxz
		int cRetroactive_payment		= 39;	// Fkyxz
		int lRaise_down_salary_basis	= 17;	// sF~̌z
		int cRaise_down_salary_basis	= 39;	// F~̌z
		int lRaise_down_salary_date		= 18;	// sF~N
		int cRaise_down_salary_date		= 39;	// F~N
		
		
		
		// RlNV擾
		getConnection();

		if(null == cmCompanyDto){ // Џ񖢎擾
			throw new MospException(MospConst.EX_CM_USER_ILLEGAL);	
		}

		// wb_[^Cg͏oR[h̎擾
		if(vo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)){ //uZbvw̏ꍇ
			tmpTitleSei   = PayrollConst.TTL_REP_SANTEI_SEI;	
			tmpTitleFuk   = PayrollConst.TTL_REP_SANTEI_FUKU;	
			tmpRepCode    = PayrollConst.TTL_REP_CODE_SANTEI;	
		}else{
			tmpTitleSei   = PayrollConst.TTL_REP_GEPPEN_SEI;	
			tmpTitleFuk   = PayrollConst.TTL_REP_GEPPEN_FUKU;	
			tmpRepCode    = PayrollConst.TTL_REP_CODE_GEPPEN;	
		}

		PoiUtility poi = new PoiUtility();
		poi.crtNewDocR(0, cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_GEPPEN_XLS);

		// wb_[
		Line   =   2;
		Column =  12;
		poi.prtItem( Line      , Column     , tmpTitleSei);		// ރ^Cgij
		poi.prtItem( Line +  54, Column +  2, tmpTitleFuk);		// ރ^Cgij

		Line   =   4;
		Column =   0;
		poi.prtItem( Line      , Column     , tmpRepCode);		// ͏oR[h

		Line   =   5;
		Column =   6;
		poi.prtItem( Line      , Column     , cmCompanyDto.getDisposeNo());		// Əԍij
		poi.prtItem( Line +  56, Column     , cmCompanyDto.getDisposeNo());		// Əԍij
		
		Line   =  48;
		Column =   6;
		poi.prtItem( Line      , Column     , PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij
		poi.prtItem( Line +  56, Column     , PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij

		Line   =  49;
		Column =   6;
		poi.prtItem( Line      , Column     , cmCompanyDto.getCompanyAddress()); //Əݒnij
		poi.prtItem( Line +  56, Column     , cmCompanyDto.getCompanyAddress()); //Əݒnij
		

		Line   =  50;
		Column =   6;
		poi.prtItem( Line      , Column     , cmCompanyDto.getCompanyName());	 //Ə́ij
		poi.prtItem( Line +  56, Column     , cmCompanyDto.getCompanyName());	 //Ə́ij

		Line   =  51;
		Column =   6;
		poi.prtItem( Line      , Column     , cmCompanyDto.getEnterpreneur());	//Ǝ厁ij
		poi.prtItem( Line +  56, Column     , cmCompanyDto.getEnterpreneur());	//Ǝ厁ij

		Line   =  52;
		Column =   6;
		poi.prtItem( Line      , Column     , cmCompanyDto.getCompanyPhone());	//dbij
		poi.prtItem( Line +  56, Column     , cmCompanyDto.getCompanyPhone());	//dbij


		Line   =  46;
		Column =   8;
		poi.prtItem( Line      , Column     , nowDateJp);	//a{tij	
		poi.prtItem( Line +  59, Column + 21, nowDateJp);	//a{tij

		Sum_cnt   = 99;
		Sum_sheet = 0;
		
		for(int i = 0 ; i < list.size(); i++){
			if(Sum_cnt >= 4){
				Sum_sheet++;
//				poi.clnSheet(0, Sum_sheet, String.valueOf(Sum_sheet));  //V[g̕
//				poi.crtSheet(Sum_sheet, String.valueOf(Sum_sheet));     //\[g쐬
				Sum_cnt = 0;
			}

			cdSocInsuranceDto = list.get(i);
			kCode = cdSocInsuranceDto.getKCode();
			mKojinDto = mKojinDao.findForKey(kCode);	//l}X^lCX^X擾
			cmSocInsuranceDto = cmSocInsuranceDao.findForEmployee(kCode);	//l}X^ЉیCX^X擾		
			if((null != mKojinDto) && (null != cmSocInsuranceDto)){

				/**** @eЈ̍ڐݒ  ****/
			
				// Nیԍ()
				poi.prtItem( lHhealth_no   + (Sum_cnt * 8)     , cHhealth_no  ,	cmSocInsuranceDto.getHealthNo()+  "\n" + "(" +	cmSocInsuranceDto.getPensionNo() + ")");
				// Nیԍ()
				poi.prtItem( lHhealth_no   + (Sum_cnt * 8) + 56, cHhealth_no  ,	cmSocInsuranceDto.getHealthNo() + "\n" + "(" +	cmSocInsuranceDto.getPensionNo() + ")");

				poi.prtItem( lK_name       + (Sum_cnt * 8)     , cK_name      , cdSocInsuranceDto.getKName());	// Ј()
				poi.prtItem( lK_name       + (Sum_cnt * 8) + 56, cK_name      , cdSocInsuranceDto.getKName());	// Ј()

				poi.prtItem( lBerthdayJpCd + (Sum_cnt * 8)     , cBerthdayJpCd, String.valueOf(getGengouCD(mKojinDto.getSeinenbi())));	// R[h()
				poi.prtItem( lBerthdayJpCd + (Sum_cnt * 8) + 56, cBerthdayJpCd, String.valueOf(getGengouCD(mKojinDto.getSeinenbi())));	// R[h()

				tmpDate = mKojinDto.getSeinenbi();
				String tmpM =  String.valueOf(MospUtility.getMonth(DatePart.convIntegerDateToDate(tmpDate)));
				String tmpD =  String.valueOf(MospUtility.getDay(DatePart.convIntegerDateToDate(tmpDate)));
				poi.prtItem( lBerthdayY    + (Sum_cnt * 8)     , cBerthdayY   , getWaNen(tmpDate));				// aN()
				poi.prtItem( lBerthdayY    + (Sum_cnt * 8) + 56, cBerthdayY   , getWaNen(tmpDate));				// aN()
				poi.prtItem( lBerthdayM    + (Sum_cnt * 8)     , cBerthdaym   , tmpM);							// a()
				poi.prtItem( lBerthdayM    + (Sum_cnt * 8) + 56, cBerthdaym   , tmpM);							// a()
				poi.prtItem( lBerthdayD    + (Sum_cnt * 8)     , cBerthdayD   , tmpD);							// a()
				poi.prtItem( lBerthdayD    + (Sum_cnt * 8) + 56, cBerthdayD   , tmpD);							// a()
				poi.prtItem( lGender       + (Sum_cnt * 8)     , cGender      , mKojinDto.getSeibetu());		// ʃR[h()
				poi.prtItem( lGender       + (Sum_cnt * 8) + 56, cGender      , mKojinDto.getSeibetu());		// ʃR[h()
				poi.prtItem( lHealth_bef_premium   + (Sum_cnt * 8)     , cHealth_bef_premium   , omission1000(cdSocInsuranceDto.getHealthBefPremium()));	// ۏ]Oی()
				poi.prtItem( lHealth_bef_premium   + (Sum_cnt * 8) + 56, cHealth_bef_premium   , omission1000(cdSocInsuranceDto.getHealthBefPremium()));	// ۏ]Oی()
				poi.prtItem( lPension_bef_premium  + (Sum_cnt * 8)     , cPension_bef_premium  , omission1000(cdSocInsuranceDto.getPensionBefPremium()));	// N]Oی()
				poi.prtItem( lPension_bef_premium  + (Sum_cnt * 8) + 56, cPension_bef_premium  , omission1000(cdSocInsuranceDto.getPensionBefPremium()));	// N]Oی()
				poi.prtItem( lPay_basic_month1     + (Sum_cnt * 8)     , cPay_basic_month1     , cdSocInsuranceDto.getPayBasicMonth1());	// xb1:()
				poi.prtItem( lPay_basic_month1     + (Sum_cnt * 8) + 56, cPay_basic_month1     , cdSocInsuranceDto.getPayBasicMonth1());	// xb1:()
				poi.prtItem( lPay_basic_month2     + (Sum_cnt * 8)     , cPay_basic_month2     , cdSocInsuranceDto.getPayBasicMonth2());	// xb2:()
				poi.prtItem( lPay_basic_month2     + (Sum_cnt * 8) + 56, cPay_basic_month2     , cdSocInsuranceDto.getPayBasicMonth2());	// xb2:()
				poi.prtItem( lPay_basic_month3     + (Sum_cnt * 8)     , cPay_basic_month3     , cdSocInsuranceDto.getPayBasicMonth3());	// xb3:()
				poi.prtItem( lPay_basic_month3     + (Sum_cnt * 8) + 56, cPay_basic_month3     , cdSocInsuranceDto.getPayBasicMonth3());	// xb3:()
				poi.prtItem( lPay_basic_day1       + (Sum_cnt * 8)     , cPay_basic_day1       , cdSocInsuranceDto.getPayBasicDay1());		// xb1:()
				poi.prtItem( lPay_basic_day1       + (Sum_cnt * 8) + 56, cPay_basic_day1       , cdSocInsuranceDto.getPayBasicDay1());		// xb1:()
				poi.prtItem( lPay_basic_day2       + (Sum_cnt * 8)     , cPay_basic_day2       , cdSocInsuranceDto.getPayBasicDay2());		// xb2:()
				poi.prtItem( lPay_basic_day2       + (Sum_cnt * 8) + 56, cPay_basic_day2       , cdSocInsuranceDto.getPayBasicDay2());		// xb2:()
				poi.prtItem( lPay_basic_day3       + (Sum_cnt * 8)     , cPay_basic_day3       , cdSocInsuranceDto.getPayBasicDay3());		// xb3:()
				poi.prtItem( lPay_basic_day3       + (Sum_cnt * 8) + 56, cPay_basic_day3       , cdSocInsuranceDto.getPayBasicDay3());		// xb3:()
				poi.prtItem( lPay_amount1          + (Sum_cnt * 8)     , cPay_amount1          , cdSocInsuranceDto.getPayAmount1());		// K̊z1()
				poi.prtItem( lPay_amount1          + (Sum_cnt * 8) + 56, cPay_amount1          , cdSocInsuranceDto.getPayAmount1());		// K̊z1()
				poi.prtItem( lPay_amount2          + (Sum_cnt * 8)     , cPay_amount2          , cdSocInsuranceDto.getPayAmount2());		// K̊z2()
				poi.prtItem( lPay_amount2          + (Sum_cnt * 8) + 56, cPay_amount2          , cdSocInsuranceDto.getPayAmount2());		// K̊z2()
				poi.prtItem( lPay_amount3          + (Sum_cnt * 8)     , cPay_amount3          ,  cdSocInsuranceDto.getPayAmount3());		// K̊z3()
				poi.prtItem( lPay_amount3          + (Sum_cnt * 8) + 56, cPay_amount3          , cdSocInsuranceDto.getPayAmount3());		// K̊z3()
				poi.prtItem( lGoods_amount1        + (Sum_cnt * 8)     , cGoods_amount1        , cdSocInsuranceDto.getGoodsAmount1());		// ̊z1()
				poi.prtItem( lGoods_amount1        + (Sum_cnt * 8) + 56, cGoods_amount1        , cdSocInsuranceDto.getGoodsAmount1());		// ̊z1()
				poi.prtItem( lGoods_amount2        + (Sum_cnt * 8)     , cGoods_amount2        , cdSocInsuranceDto.getGoodsAmount2());		// ̊z2()
				poi.prtItem( lGoods_amount2        + (Sum_cnt * 8) + 56, cGoods_amount2        , cdSocInsuranceDto.getGoodsAmount2());		// ̊z2()
				poi.prtItem( lGoods_amount3        + (Sum_cnt * 8)     , cGoods_amount3        , cdSocInsuranceDto.getGoodsAmount3());		// ̊z3()
				poi.prtItem( lGoods_amount3        + (Sum_cnt * 8) + 56, cGoods_amount3        , cdSocInsuranceDto.getGoodsAmount3());		// ̊z3()
				poi.prtItem( lReward_total1        + (Sum_cnt * 8)     , cReward_total1        , cdSocInsuranceDto.getRewardTotal1());		// Vv1()
				poi.prtItem( lReward_total1        + (Sum_cnt * 8) + 56, cReward_total1        , cdSocInsuranceDto.getRewardTotal1());		// Vv1()
				poi.prtItem( lReward_total2        + (Sum_cnt * 8)     , cReward_total2        , cdSocInsuranceDto.getRewardTotal2());		// Vv2()
				poi.prtItem( lReward_total2        + (Sum_cnt * 8) + 56, cReward_total2        , cdSocInsuranceDto.getRewardTotal2());		// Vv2()
				poi.prtItem( lReward_total3        + (Sum_cnt * 8)     , cReward_total3        , cdSocInsuranceDto.getRewardTotal3());		// Vv3()
				poi.prtItem( lReward_total3        + (Sum_cnt * 8) + 56, cReward_total3        , cdSocInsuranceDto.getRewardTotal3());		// Vv3()
				poi.prtItem( lReward_total_sum     + (Sum_cnt * 8)     , cReward_total_sum     , cdSocInsuranceDto.getRewardTotalSum());	// Vz()
				poi.prtItem( lReward_total_sum     + (Sum_cnt * 8) + 56, cReward_total_sum     , cdSocInsuranceDto.getRewardTotalSum());	// Vz()
				poi.prtItem( lAverage_three_months + (Sum_cnt * 8)     , cAverage_three_months , cdSocInsuranceDto.getAverageThreeMonths()); // R()
				poi.prtItem( lAverage_three_months + (Sum_cnt * 8) + 56, cAverage_three_months , cdSocInsuranceDto.getAverageThreeMonths()); // R()
				poi.prtItem( lHealth_dec_premium   + (Sum_cnt * 8)     , cHealth_dec_premium   , omission1000(cdSocInsuranceDto.getHealthDecPremium()));	// یی()
				poi.prtItem( lHealth_dec_premium   + (Sum_cnt * 8) + 56, cHealth_dec_premium   , omission1000(cdSocInsuranceDto.getHealthDecPremium()));	// یی()

				tmpDate = DatePart.convDateToInteger(cdSocInsuranceDto.getExpectedDate());
				poi.prtItem( lExpected_dateY       + (Sum_cnt * 8)     , cExpected_dateY       , getWaNen(tmpDate));	// KpN:N()
				poi.prtItem( lExpected_dateY       + (Sum_cnt * 8) + 56, cExpected_dateY       , getWaNen(tmpDate));	// KpN:N()
				poi.prtItem( lExpected_dateM       + (Sum_cnt * 8)     , cExpected_dateM       , MospUtility.getMonth(cdSocInsuranceDto.getExpectedDate()));	// KpN:()
				poi.prtItem( lExpected_dateM       + (Sum_cnt * 8) + 56, cExpected_dateM       , MospUtility.getMonth(cdSocInsuranceDto.getExpectedDate()));	// KpN:()
				poi.prtItem( lEdit_average         + (Sum_cnt * 8)     , cEdit_average         , cdSocInsuranceDto.getEditAverage());	// C()
				poi.prtItem( lEdit_average         + (Sum_cnt * 8) + 56, cEdit_average         , cdSocInsuranceDto.getEditAverage());	// C()
				poi.prtItem( lPension_dec_premium  + (Sum_cnt * 8)     , cPension_dec_premium  , omission1000(cdSocInsuranceDto.getPensionDecPremium()));			// Nی()
				poi.prtItem( lPension_dec_premium  + (Sum_cnt * 8) + 56, cPension_dec_premium  , omission1000(cdSocInsuranceDto.getPensionDecPremium()));			// Nی()
				poi.prtItem( lRetroactive_payment  + (Sum_cnt * 8)     , cRetroactive_payment  , cdSocInsuranceDto.getRetroactivePayment  ());		// kyxz()
				poi.prtItem( lRetroactive_payment  + (Sum_cnt * 8) + 56, cRetroactive_payment  , cdSocInsuranceDto.getRetroactivePayment  ());		// kyxz()
				poi.prtItem( lRaise_down_salary_basis + (Sum_cnt * 8)     , cRaise_down_salary_basis, cdSocInsuranceDto.getRaiseDownSalaryBasis());	// ~̌z()
				poi.prtItem( lRaise_down_salary_basis + (Sum_cnt * 8) + 56, cRaise_down_salary_basis, cdSocInsuranceDto.getRaiseDownSalaryBasis());	// ~̌z()

				tmpDate = DatePart.convDateToInteger(cdSocInsuranceDto.getRaiseDownSalaryDate());
				tmpWork = getWaNen(tmpDate) + "N" + MospUtility.getMonth(cdSocInsuranceDto.getRaiseDownSalaryDate()) + "";				
				poi.prtItem( lRaise_down_salary_date  + (Sum_cnt * 8)     , cRaise_down_salary_date , tmpWork);										// ~N()
				poi.prtItem( lRaise_down_salary_date  + (Sum_cnt * 8) + 56, cRaise_down_salary_date , tmpWork);										// ~N()
				
				/**** @eЈ̍ڐݒ  ****/

				Sum_cnt++;			
			}
		}

		//ev[gV[gO̍폜
//		if(Sum_sheet > 0){
//			poi.rmvSheet(0);
//		}
		// o͓eݒ
		String fileName = strTekiyouDate + 
							PayrollConst.FILE_NAME_SEPARATOR +
							PayrollConst.FILE_INSURANCE_XLS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, poi.getWorkbook());
	}


	/**
	 * [o͏sB(OpenOffice Calc)<br><br>
	 * @throws Exception 
	 */
	private void report(InsuranceConfSetVo vo , List<CdSocInsuranceDto> list ) throws Exception {
		CdSocInsuranceDto	cdSocInsuranceDto;

		String tmpTitleSei   = "";	
		String tmpTitleFuk   = "";	
		String tmpRepCode    = "";	
		String tmpWork       = "";	

		int Line;
		int Column;
		int Sum_sheet;
		int Sum_cnt;
		int tmpDate;

		int lK_name						= 14;	// sFЈ
		int cK_name						=  7;	// FЈ
		int lHhealth_no					= 14;	// sFNیԍ
		int cHhealth_no					=  2;	// FNیԍ
		int lBerthdayJpCd				= 14;	// sFR[h
		int cBerthdayJpCd				= 15;	// FR[h
		int lBerthdayY					= 14;	// sFaN
		int cBerthdayY					= 17;	// FaN
		int lBerthdayM					= 14;	// sFa
		int cBerthdaym					= 19;	// Fa
		int lBerthdayD					= 14;	// sFa
		int cBerthdayD					= 21;	// Fa
		int lGender						= 14;	// sFʃR[h
		int cGender						= 23;	// FʃR[h
		int lHealth_bef_premium			= 14;	// sFۏ]Oی
		int cHealth_bef_premium			= 25;	// Fۏ]Oی
		int lPension_bef_premium		= 14;	// sFN]Oی
		int cPension_bef_premium		= 32;	// FN]Oی

		int lPay_basic_month1			= 20;	// sFxb1()
		int cPay_basic_month1			=  1;	// Fxb1()
		int lPay_basic_month2			= 18;	// sFxb2()
		int cPay_basic_month2			=  1;	// Fxb2()
		int lPay_basic_month3			= 16;	// sFxb3()
		int cPay_basic_month3			=  1;	// Fxb3()

		int lPay_basic_day1				= 20;	// sFxb1()
		int cPay_basic_day1				=  3;	// Fxb1()
		int lPay_basic_day2				= 18;	// sFxb2()
		int cPay_basic_day2				=  3;	// Fxb2()
		int lPay_basic_day3				= 16;	// sFxb3()
		int cPay_basic_day3				=  3;	// Fxb3()

		int lPay_amount1				= 20;	// sFK̊z1
		int cPay_amount1				=  6;	// FK̊z1
		int lPay_amount2				= 18;	// sFK̊z2
		int cPay_amount2				=  6;	// FK̊z2
		int lPay_amount3				= 16;	// sFK̊z3
		int cPay_amount3				=  6;	// FK̊z3

		int lGoods_amount1				= 20;	// sF̊z1
		int cGoods_amount1				= 12;	// F̊z1
		int lGoods_amount2				= 18;	// sF̊z2
		int cGoods_amount2				= 12;	// F̊z2
		int lGoods_amount3				= 16;	// sF̊z3
		int cGoods_amount3				= 12;	// F̊z3

		int lReward_total1				= 20;	// sFVv1
		int cReward_total1				= 19;	// FVv1
		int lReward_total2				= 18;	// sFVv2
		int cReward_total2				= 19;	// FVv2
		int lReward_total3				= 16;	// sFVv3
		int cReward_total3				= 19;	// FVv3
		
		int lReward_total_sum			= 16;	// sFVz
		int cReward_total_sum			= 25;	// FVz
		int lAverage_three_months		= 18;	// sFR
		int cAverage_three_months		= 25;	// FR
		int lHealth_dec_premium			= 20;	// sFیی
		int cHealth_dec_premium			= 25;	// Fیی
		int lExpected_dateY				= 16;	// sFKpN:N
		int cExpected_dateY				= 32;	// FKpN:N
		int lExpected_dateM				= 16;	// sFKpN:
		int cExpected_dateM				= 34;	// FKpN:
		int lEdit_average				= 18;	// sFC
		int cEdit_average				= 32;	// FC
		int lPension_dec_premium		= 20;	// sFNی
		int cPension_dec_premium		= 32;	// FNی
		int lRetroactive_payment		= 16;	// sFkyxz
		int cRetroactive_payment		= 39;	// Fkyxz
		int lRaise_down_salary_basis	= 17;	// sF~̌z
		int cRaise_down_salary_basis	= 39;	// F~̌z
		int lRaise_down_salary_date		= 18;	// sF~N
		int cRaise_down_salary_date		= 39;	// F~N


		// RlNV擾
		getConnection();

		// [쐬
		OdsBean odsBean = new OdsBean(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.TEMPLATE_GEPPEN_ODS);

		if(null == cmCompanyDto){ // Џ񖢎擾
			throw new MospException(MospConst.EX_CM_USER_ILLEGAL);	
		}

		// wb_[^Cg͏oR[h̎擾
		if(vo.idButtonSyori.equals(InsuranceConfSetVo.PRM_CKR_SANTEI_KISO)){ //uZbvw̏ꍇ
			tmpTitleSei   = PayrollConst.TTL_REP_SANTEI_SEI;	
			tmpTitleFuk   = PayrollConst.TTL_REP_SANTEI_FUKU;	
			tmpRepCode    = PayrollConst.TTL_REP_CODE_SANTEI;	
		}else{
			tmpTitleSei   = PayrollConst.TTL_REP_GEPPEN_SEI;	
			tmpTitleFuk   = PayrollConst.TTL_REP_GEPPEN_FUKU;	
			tmpRepCode    = PayrollConst.TTL_REP_CODE_GEPPEN;	
		}

		// wb_[
		Line   =   2;
		Column =  12;
		odsBean.setValue( Column     , Line      , tmpTitleSei);		// ރ^Cgij
		odsBean.setValue( Column +  2, Line +  54, tmpTitleFuk);		// ރ^Cgij

		Line   =   4;
		Column =   0;
		odsBean.setValue( Column     , Line      , tmpRepCode);		// ͏oR[h

		Line   =   5;
		Column =   6;
		odsBean.setValue( Column     , Line      , cmCompanyDto.getDisposeNo());		// Əԍij
		odsBean.setValue( Column     , Line +  56, cmCompanyDto.getDisposeNo());		// Əԍij
		
		Line   =  48;
		Column =   6;
		odsBean.setValue( Column     , Line      , PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij
		odsBean.setValue( Column     , Line +  56, PayrollConst.NAM_COMMON_POSTAL + cmCompanyDto.getCompanyPostal()); // ƏX֔ԍij

		Line   =  49;
		Column =   6;
		odsBean.setValue( Column     , Line      , cmCompanyDto.getCompanyAddress()); //Əݒnij
		odsBean.setValue( Column     , Line +  56, cmCompanyDto.getCompanyAddress()); //Əݒnij
		

		Line   =  50;
		Column =   6;
		odsBean.setValue( Column     , Line      , cmCompanyDto.getCompanyName());	 //Ə́ij
		odsBean.setValue( Column     , Line +  56, cmCompanyDto.getCompanyName());	 //Ə́ij

		Line   =  51;
		Column =   6;
		odsBean.setValue( Column     , Line      , cmCompanyDto.getEnterpreneur());	//Ǝ厁ij
		odsBean.setValue( Column     , Line +  56, cmCompanyDto.getEnterpreneur());	//Ǝ厁ij

		Line   =  52;
		Column =   6;
		odsBean.setValue( Column     , Line      , cmCompanyDto.getCompanyPhone());	//dbij
		odsBean.setValue( Column     , Line +  56, cmCompanyDto.getCompanyPhone());	//dbij


		Line   =  46;
		Column =   8;
		odsBean.setValue( Column     , Line      , nowDateJp);	//a{tij	
		odsBean.setValue( Column + 21, Line +  59, nowDateJp);	//a{tij

		Sum_cnt   = 99;
		Sum_sheet = 0;
		
		for(int i = 0 ; i < list.size(); i++){
			if(Sum_cnt >= 4){
				Sum_sheet++;
//				poi.clnSheet(0, Sum_sheet, String.valueOf(Sum_sheet));  //V[g̕
//				poi.crtSheet(Sum_sheet, String.valueOf(Sum_sheet));     //\[g쐬
				Sum_cnt = 0;
			}

			cdSocInsuranceDto = list.get(i);
			kCode = cdSocInsuranceDto.getKCode();
			mKojinDto = mKojinDao.findForKey(kCode);	//l}X^lCX^X擾
			cmSocInsuranceDto = cmSocInsuranceDao.findForEmployee(kCode);	//l}X^ЉیCX^X擾		
			if((null != mKojinDto) && (null != cmSocInsuranceDto)){

				/**** @eЈ̍ڐݒ  ****/
			
				odsBean.setValue( cHhealth_no  , lHhealth_no   + (Sum_cnt * 8)     , cmSocInsuranceDto.getHealthNo()+  "\n" + "(" +	cmSocInsuranceDto.getPensionNo() + ")"); // Nیԍ()
				odsBean.setValue( cHhealth_no  , lHhealth_no   + (Sum_cnt * 8) + 56, cmSocInsuranceDto.getHealthNo() + "\n" + "(" +	cmSocInsuranceDto.getPensionNo() + ")"); // Nیԍ()
				odsBean.setValue( cK_name      , lK_name       + (Sum_cnt * 8)     , cdSocInsuranceDto.getKName());	// Ј()
				odsBean.setValue( cK_name      , lK_name       + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getKName());	// Ј()
				odsBean.setValue( cBerthdayJpCd, lBerthdayJpCd + (Sum_cnt * 8)     , String.valueOf(getGengouCD(mKojinDto.getSeinenbi())));	// R[h()
				odsBean.setValue( cBerthdayJpCd, lBerthdayJpCd + (Sum_cnt * 8) + 56, String.valueOf(getGengouCD(mKojinDto.getSeinenbi())));	// R[h()
				
				tmpDate = mKojinDto.getSeinenbi();
				String tmpM =  String.valueOf(MospUtility.getMonth(DatePart.convIntegerDateToDate(tmpDate)));
				String tmpD =  String.valueOf(MospUtility.getDay(DatePart.convIntegerDateToDate(tmpDate)));

				odsBean.setValue( cBerthdayY            , lBerthdayY            + (Sum_cnt * 8)     , getWaNen(tmpDate));				// aN()
				odsBean.setValue( cBerthdayY            , lBerthdayY            + (Sum_cnt * 8) + 56, getWaNen(tmpDate));				// aN()
				odsBean.setValue( cBerthdaym            , lBerthdayM            + (Sum_cnt * 8)     , tmpM);							// a()
				odsBean.setValue( cBerthdaym            , lBerthdayM            + (Sum_cnt * 8) + 56, tmpM);							// a()
				odsBean.setValue( cBerthdayD            , lBerthdayD            + (Sum_cnt * 8)     , tmpD);							// a()
				odsBean.setValue( cBerthdayD            , lBerthdayD            + (Sum_cnt * 8) + 56, tmpD);							// a()
				odsBean.setValue( cGender               , lGender               + (Sum_cnt * 8)     , mKojinDto.getSeibetu());			// ʃR[h()
				odsBean.setValue( cGender               , lGender               + (Sum_cnt * 8) + 56, mKojinDto.getSeibetu());			// ʃR[h()
				odsBean.setValue( cHealth_bef_premium   , lHealth_bef_premium   + (Sum_cnt * 8)     , omission1000(cdSocInsuranceDto.getHealthBefPremium()));	// ۏ]Oی()
				odsBean.setValue( cHealth_bef_premium   , lHealth_bef_premium   + (Sum_cnt * 8) + 56, omission1000(cdSocInsuranceDto.getHealthBefPremium()));	// ۏ]Oی()
				odsBean.setValue( cPension_bef_premium  , lPension_bef_premium  + (Sum_cnt * 8)     , omission1000(cdSocInsuranceDto.getPensionBefPremium()));	// N]Oی()
				odsBean.setValue( cPension_bef_premium  , lPension_bef_premium  + (Sum_cnt * 8) + 56, omission1000(cdSocInsuranceDto.getPensionBefPremium()));	// N]Oی()
				odsBean.setValue( cPay_basic_month1     , lPay_basic_month1     + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayBasicMonth1());	// xb1:()
				odsBean.setValue( cPay_basic_month1     , lPay_basic_month1     + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayBasicMonth1());	// xb1:()
				odsBean.setValue( cPay_basic_month2     , lPay_basic_month2     + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayBasicMonth2());	// xb2:()
				odsBean.setValue( cPay_basic_month2     , lPay_basic_month2     + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayBasicMonth2());	// xb2:()
				odsBean.setValue( cPay_basic_month3     , lPay_basic_month3     + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayBasicMonth3());	// xb3:()
				odsBean.setValue( cPay_basic_month3     , lPay_basic_month3     + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayBasicMonth3());	// xb3:()
				odsBean.setValue( cPay_basic_day1       , lPay_basic_day1       + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayBasicDay1());		// xb1:()
				odsBean.setValue( cPay_basic_day1       , lPay_basic_day1       + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayBasicDay1());		// xb1:()
				odsBean.setValue( cPay_basic_day2       , lPay_basic_day2       + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayBasicDay2());		// xb2:()
				odsBean.setValue( cPay_basic_day2       , lPay_basic_day2       + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayBasicDay2());		// xb2:()
				odsBean.setValue( cPay_basic_day3       , lPay_basic_day3       + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayBasicDay3());		// xb3:()
				odsBean.setValue( cPay_basic_day3       , lPay_basic_day3       + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayBasicDay3());		// xb3:()
				odsBean.setValue( cPay_amount1          , lPay_amount1          + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayAmount1());		// K̊z1()
				odsBean.setValue( cPay_amount1          , lPay_amount1          + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayAmount1());		// K̊z1()
				odsBean.setValue( cPay_amount2          , lPay_amount2          + (Sum_cnt * 8)     , cdSocInsuranceDto.getPayAmount2());		// K̊z2()
				odsBean.setValue( cPay_amount2          , lPay_amount2          + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayAmount2());		// K̊z2()
				odsBean.setValue( cPay_amount3          , lPay_amount3          + (Sum_cnt * 8)     ,  cdSocInsuranceDto.getPayAmount3());		// K̊z3()
				odsBean.setValue( cPay_amount3          , lPay_amount3          + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getPayAmount3());		// K̊z3()
				odsBean.setValue( cGoods_amount1        , lGoods_amount1        + (Sum_cnt * 8)     , cdSocInsuranceDto.getGoodsAmount1());		// ̊z1()
				odsBean.setValue( cGoods_amount1        , lGoods_amount1        + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getGoodsAmount1());		// ̊z1()
				odsBean.setValue( cGoods_amount2        , lGoods_amount2        + (Sum_cnt * 8)     , cdSocInsuranceDto.getGoodsAmount2());		// ̊z2()
				odsBean.setValue( cGoods_amount2        , lGoods_amount2        + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getGoodsAmount2());		// ̊z2()
				odsBean.setValue( cGoods_amount3        , lGoods_amount3        + (Sum_cnt * 8)     , cdSocInsuranceDto.getGoodsAmount3());		// ̊z3()
				odsBean.setValue( cGoods_amount3        , lGoods_amount3        + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getGoodsAmount3());		// ̊z3()
				odsBean.setValue( cReward_total1        , lReward_total1        + (Sum_cnt * 8)     , cdSocInsuranceDto.getRewardTotal1());		// Vv1()
				odsBean.setValue( cReward_total1        , lReward_total1        + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getRewardTotal1());		// Vv1()
				odsBean.setValue( cReward_total2        , lReward_total2        + (Sum_cnt * 8)     , cdSocInsuranceDto.getRewardTotal2());		// Vv2()
				odsBean.setValue( cReward_total2        , lReward_total2        + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getRewardTotal2());		// Vv2()
				odsBean.setValue( cReward_total3        , lReward_total3        + (Sum_cnt * 8)     , cdSocInsuranceDto.getRewardTotal3());		// Vv3()
				odsBean.setValue( cReward_total3        , lReward_total3        + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getRewardTotal3());		// Vv3()
				odsBean.setValue( cReward_total_sum     , lReward_total_sum     + (Sum_cnt * 8)     , cdSocInsuranceDto.getRewardTotalSum());	// Vz()
				odsBean.setValue( cReward_total_sum     , lReward_total_sum     + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getRewardTotalSum());	// Vz()
				odsBean.setValue( cAverage_three_months , lAverage_three_months + (Sum_cnt * 8)     , cdSocInsuranceDto.getAverageThreeMonths()); // R()
				odsBean.setValue( cAverage_three_months , lAverage_three_months + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getAverageThreeMonths()); // R()
				odsBean.setValue( cHealth_dec_premium   , lHealth_dec_premium   + (Sum_cnt * 8)     , omission1000(cdSocInsuranceDto.getHealthDecPremium()));	// یی()
				odsBean.setValue( cHealth_dec_premium   , lHealth_dec_premium   + (Sum_cnt * 8) + 56, omission1000(cdSocInsuranceDto.getHealthDecPremium()));	// یی()

				tmpDate = DatePart.convDateToInteger(cdSocInsuranceDto.getExpectedDate());
				odsBean.setValue( cExpected_dateY         , lExpected_dateY          + (Sum_cnt * 8)     , getWaNen(tmpDate));	// KpN:N()
				odsBean.setValue( cExpected_dateY         , lExpected_dateY          + (Sum_cnt * 8) + 56, getWaNen(tmpDate));	// KpN:N()
				odsBean.setValue( cExpected_dateM         , lExpected_dateM          + (Sum_cnt * 8)     , MospUtility.getMonth(cdSocInsuranceDto.getExpectedDate()));	// KpN:()
				odsBean.setValue( cExpected_dateM         , lExpected_dateM          + (Sum_cnt * 8) + 56, MospUtility.getMonth(cdSocInsuranceDto.getExpectedDate()));	// KpN:()
				odsBean.setValue( cEdit_average           , lEdit_average            + (Sum_cnt * 8)     , cdSocInsuranceDto.getEditAverage());	// C()
				odsBean.setValue( cEdit_average           , lEdit_average            + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getEditAverage());	// C()
				odsBean.setValue( cPension_dec_premium    , lPension_dec_premium     + (Sum_cnt * 8)     , omission1000(cdSocInsuranceDto.getPensionDecPremium()));	// Nی()
				odsBean.setValue( cPension_dec_premium    , lPension_dec_premium     + (Sum_cnt * 8) + 56, omission1000(cdSocInsuranceDto.getPensionDecPremium()));	// Nی()
				odsBean.setValue( cRetroactive_payment    , lRetroactive_payment     + (Sum_cnt * 8)     , cdSocInsuranceDto.getRetroactivePayment  ());	// kyxz()
				odsBean.setValue( cRetroactive_payment    , lRetroactive_payment     + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getRetroactivePayment  ());	// kyxz()
				odsBean.setValue( cRaise_down_salary_basis, lRaise_down_salary_basis + (Sum_cnt * 8)     , cdSocInsuranceDto.getRaiseDownSalaryBasis());	// ~̌z()
				odsBean.setValue( cRaise_down_salary_basis, lRaise_down_salary_basis + (Sum_cnt * 8) + 56, cdSocInsuranceDto.getRaiseDownSalaryBasis());	// ~̌z()

				tmpDate = DatePart.convDateToInteger(cdSocInsuranceDto.getRaiseDownSalaryDate());
				tmpWork = getWaNen(tmpDate) + "N" + MospUtility.getMonth(cdSocInsuranceDto.getRaiseDownSalaryDate()) + "";				
				odsBean.setValue( cRaise_down_salary_date , lRaise_down_salary_date  + (Sum_cnt * 8)     , tmpWork);										// ~N()
				odsBean.setValue( cRaise_down_salary_date , lRaise_down_salary_date  + (Sum_cnt * 8) + 56, tmpWork);										// ~N()
				
				/**** @eЈ̍ڐݒ  ****/

				Sum_cnt++;			
			}
		}
		
		// o͓eݒ
		String fileName = strTekiyouDate + 
							PayrollConst.FILE_NAME_SEPARATOR +
							PayrollConst.FILE_INSURANCE_ODS;
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
		request.setAttribute(MospConst.ATT_FILE_OBJECT, odsBean.getSpreadSheet());
	}


	/**
	 * R[h擾B<br><br>
	 * @param intDate 擾ΏۂINT
	 * @return R[h
	 */
	private int getGengouCD( int intDate ){
		int outCode = 0;
		//猳R[h擾
		if (intDate >= 19890108)  {
			outCode = 7;
		} else if ((intDate < 19890108) & (intDate >= 19261225))  {
			   outCode = 5;
		} else if ((intDate < 19261225) & (intDate >= 19121110))  {
			   outCode = 3;
		} else if ((intDate < 19121110) & (intDate >= 18680908))  {
			   outCode = 1;
		}
	   return outCode;
	}

	/**
	 * aN擾B<br><br>
	 * @param intDate 擾ΏۂINTN
	 * @return ߊz͕sz
	 */
	private String getWaNen( int intDate ){
		String tmpCode = "";
		int    tmpInt = 0;
		//猳R[h擾
		if (intDate >= 19890108)  {
			tmpCode = String.valueOf(intDate - 19880000);
		} else if ((intDate < 19890108) & (intDate >= 19261225))  {
			tmpCode = String.valueOf(intDate - 19250000);
		} else if ((intDate < 19261225) & (intDate >= 19121110))  {
			tmpCode = String.valueOf(intDate - 19110000);
		} else if ((intDate < 19121110) & (intDate >= 18680908))  {
			tmpCode = String.valueOf(intDate - 18670000);
		}
		tmpInt = tmpCode.length();
		if(tmpInt > 4){
			return tmpCode.substring(0, tmpInt - 4);
		}
		return "0";
	}

	/**
	 * z~PʂɂB(~ȉ؎̂)<br><br>
	 * @param intPay 擾ΏۂINTz
	 * @return ~Pʂ̋z
	 */
	private int omission1000( int intPay ){
		int SumTmp = 0;
		if(1000 <= intPay){
			SumTmp = intPay / 1000;
		}
		return SumTmp;
	}

}
