package jp.mosp.payroll.payment.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.PayrollVo;

public class PaymentReportVo extends PayrollVo {
	
	private static final long serialVersionUID = -8852219595841541463L;
	
	// tB[h
	private int      pltYear       ;
	private int      pltMonth      ;
	private int      pltDay      	;
	private int      pltOutYear ;
	private int      pltOutMonth   ;
	private int      pltOutDay     ;
	private String   txtKCode      ;
	private String   pltOffice     ;
	private String   pltSection    ;
	
	// v_E
	private String[][] pitYear    ;
	private String[][] pitMonth   ;
	private String[][] pitDay     ;
	private String[][] pitOutYear    ;
	private String[][] pitOutMonth   ;
	private String[][] pitOutDay     ;
	private String[][] pitOffice  ;
	private String[][] pitSection ;
	
	/**
	 * p[^(Ώ۔N)B
	 */
	public static final String PRM_PLT_YEAR = "pltYear";
	
	/**
	 * p[^(Ώی)B
	 */
	public static final String PRM_PLT_MONTH = "pltMonth";
	
	/**
	 * p[^(Ώی)B
	 */
	public static final String PRM_PLT_DAY = "pltDay";
	
	/**
	 * p[^(Ώ۔N)B
	 */
	public static final String PRM_PLT_OUT_YEAR = "pltOutYear";
	
	/**
	 * p[^(Ώی)B
	 */
	public static final String PRM_PLT_OUT_MONTH = "pltOutMonth";
	
	/**
	 * p[^(Ώی)B
	 */
	public static final String PRM_PLT_OUT_DAY = "pltOutDay";
	
	/**
	 * p[^(ЈR[h)B
	 */
	public static final String PRM_TXT_K_CODE = "txtKCode";
	
	/**
	 * p[^(Ə)B
	 */
	public static final String PRM_PLT_OFFICE = "pltOffice";
	
	/**
	 * p[^()B
	 */
	public static final String PRM_PLT_SECTION = "pltSection";
	
	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public PaymentReportVo() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYMENT") + getName("C_REPORT") + getName("C_EXPORT");
		addAryMenu("P1001", getName("P_PAYMENT") +
				getName("P_CALCULATE") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltYear     = getIntParam(request.getParameter(PRM_PLT_YEAR ));
		pltMonth    = getIntParam(request.getParameter(PRM_PLT_MONTH));
		pltDay      = getIntParam(request.getParameter(PRM_PLT_DAY));
		pltOutYear  = getIntParam(request.getParameter(PRM_PLT_OUT_YEAR ));
		pltOutMonth = getIntParam(request.getParameter(PRM_PLT_OUT_MONTH ));
		pltOutDay   = getIntParam(request.getParameter(PRM_PLT_OUT_DAY ));
		txtKCode    = request.getParameter(PRM_TXT_K_CODE);
		pltOffice   = request.getParameter(PRM_PLT_OFFICE);
		pltSection  = request.getParameter(PRM_PLT_SECTION);
	}
	
	/**
	 * ^vZJn擾B
	 * @return ^vZJn
	 */
	public int getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * ^vZJnݒ肷B
	 * @param pltMonth ݒ肷鋋^vZJn
	 */
	public void setPltMonth(int pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * ^vZJnN擾B
	 * @return ^vZJnN
	 */
	public int getPltYear() {
		return pltYear;
	}

	/**
	 * ^vZJnNݒ肷B
	 * @param pltYear ݒ肷鋋^vZJnN
	 */
	public void setPltYear(int pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * ^vZJnN擾B
	 * @return ^vZJnN
	 */
	public int getPltDay() {
		return pltDay;
	}

	/**
	 * ^vZJnNݒ肷B
	 * @param pltDay ݒ肷鋋^vZJnN
	 */
	public void setPltDay(int pltDay) {
		this.pltDay = pltDay;
	}
	
	
	
	/**
	 * ^vZJn擾B
	 * @return ^vZJn
	 */
	public int getPltOutMonth() {
		return pltOutMonth;
	}
	
	/**
	 * ^vZJnݒ肷B
	 * @param pltOutMonth ݒ肷鋋^vZJn
	 */
	public void setPltOutMonth(int pltOutMonth) {
		this.pltOutMonth = pltOutMonth;
	}
	
	/**
	 * ^vZJnN擾B
	 * @return ^vZJnN
	 */
	public int getPltOutYear() {
		return pltOutYear;
	}

	/**
	 * ^vZJnNݒ肷B
	 * @param pltOutYear ݒ肷鋋^vZJnN
	 */
	public void setPltOutYear(int pltOutYear) {
		this.pltOutYear = pltOutYear;
	}
	
	/**
	 * ^vZJnN擾B
	 * @return ^vZJnN
	 */
	public int getPltOutDay() {
		return pltOutDay;
	}

	/**
	 * ^vZJnNݒ肷B
	 * @param pltOutDay ݒ肷鋋^vZJnN
	 */
	public void setPltOutDay(int pltOutDay) {
		this.pltOutDay = pltOutDay;
	}
	
	
	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitMonth() {
		return getAryField(pitMonth);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitMonth ݒ肷錎v_EACe
	 */
	public void setPitMonth(String[][] pitMonth) {
		this.pitMonth = getAryField(pitMonth);
	}
	
	/**
	 * Nv_EACe擾B
	 * @return Nv_EACe
	 */
	public String[][] getPitYear() {
		return getAryField(pitYear);
	}
	
	/**
	 * Nv_EACeݒ肷B
	 * @param pitYear ݒ肷Nv_EACe
	 */
	public void setPitYear(String[][] pitYear) {
		this.pitYear = getAryField(pitYear);
	}
	
	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitDay() {
		return getAryField(pitDay);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitYear ݒ肷v_EACe
	 */
	public void setPitDay(String[][] pitDay) {
		this.pitDay = getAryField(pitDay);
	}
	
	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitOutMonth() {
		return getAryField(pitOutMonth);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitOutMonth ݒ肷錎v_EACe
	 */
	public void setPitOutMonth(String[][] pitOutMonth) {
		this.pitOutMonth = getAryField(pitOutMonth);
	}
	
	/**
	 * Nv_EACe擾B
	 * @return Nv_EACe
	 */
	public String[][] getPitOutYear() {
		return getAryField(pitOutYear);
	}
	
	/**
	 * Nv_EACeݒ肷B
	 * @param pitOutYear ݒ肷Nv_EACe
	 */
	public void setPitOutYear(String[][] pitOutYear) {
		this.pitOutYear = getAryField(pitOutYear);
	}
	
	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getOutPitDay() {
		return getAryField(pitOutDay);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitOutYear ݒ肷v_EACe
	 */
	public void setOutPitDay(String[][] pitOutDay) {
		this.pitOutDay = getAryField(pitOutDay);
	}
	
	
	/**
	 * Əv_EACe擾B
	 * @return Əv_EACe
	 */
	public String[][] getPitOffice() {
		return getAryField(pitOffice);
	}
	
	/**
	 * Əv_EACeݒ肷B
	 * @param pitOffice ݒ肷鎖Əv_EACe
	 */
	public void setPitOffice(String[][] pitOffice) {
		this.pitOffice = getAryField(pitOffice);
	}

	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitSection() {
		return getAryField(pitSection);
	}

	/**
	 * v_EACeݒ肷B
	 * @param pitSection ݒ肷鏊v_EACe
	 */
	public void setPitSection(String[][] pitSection) {
		this.pitSection = getAryField(pitSection);
	}
	
	/**
	 * ƏR[h擾B
	 * @return ƏR[h
	 */
	public String getPltOffice() {
		return pltOffice;
	}
	
	/**
	 * ƏR[hݒ肷B
	 * @param pltOffice ݒ肷鎖ƏR[h
	 */
	public void setPltOffice(String pltOffice) {
		this.pltOffice = pltOffice;
	}

	/**
	 * R[h擾B
	 * @return R[h
	 */
	public String getPltSection() {
		return pltSection;
	}

	/**
	 * R[hݒ肷B
	 * @param pltSection ݒ肷鏊R[h
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}

	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getTxtKCode() {
		return txtKCode;
	}

	/**
	 * ЈR[h擾(GXP[v)B
	 * @return ЈR[h
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param txtKCode ݒ肷ЈR[h
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
}
