package jp.mosp.payroll.payment.vo;

import java.util.Date;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;

public class PaymentCardVo extends PayrollVo {
	
	private static final long serialVersionUID = 8936284323960296222L;
	
	// tB[h
	private String lblKName    ;
	private String lblSection  ;
	private String lblCalcMonth;
	
	private String kCode    ;
	private Date   calcMonth;
	
	// ʃ[h
	private int mode;
	
	private String[][] aryTime     ;
	private String[][] aryAllowance;
	private String[][] aryDeduction;
	private String[][] aryBreakdown;
	private String[][] arySum      ;
	
	// 
	public static final int LEN_MONEY    = PayrollConst.LEN_MONEY   ;
	public static final int LEN_TIME_INT = PayrollConst.LEN_TIME_INT;
	public static final int LEN_TIME_DEC = PayrollConst.LEN_TIME_DEC;
	
	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public PaymentCardVo() {
		super();
		
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYMENT") + getName("P_DETAIL");
		addAryMenu("P1001", getName("P_PAYMENT") +
				getName("P_CALCULATE") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		for (Enumeration<?> en = request.getParameterNames(); en.hasMoreElements();) {
			String detailCode = (String)en.nextElement();
			setDetailAmount(detailCode, request.getParameter(detailCode));
		}
	}
	
	/**
	 * tB[hݒ肷B
	 * @param employee Ј
	 * @param payment  ^
	 */
	public void setFields(Employee employee, Payment payment) {
		// lݒ
		this.lblKName     = employee.getKName      ();
		this.lblSection   = employee.getSectionName();
		this.lblCalcMonth = payment.getCalcMonthStr();
		this.kCode        = payment.getKCode       ();
		this.calcMonth    = payment.getCalcMonth   ();
		// ^ݒ
		aryTime      = payment.getTimeArray     (false);
		aryAllowance = payment.getAllowanceArray(false);
		aryDeduction = payment.getDeductionArray(false);
		aryBreakdown = payment.getBreakdownArray(false);
		arySum       = payment.getSumArray      (false);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// ^CvmF
		/*
		checkNumber (txtPresence          , namPresence          , PRM_TXT_PRESENCE            );
		checkNumber (txtWorkOnHoliday     , namWorkOnHoliday     , PRM_TXT_WORK_ON_HOLIDAY     );
		checkNumber (txtParticularHoliday , namParticularHoliday , PRM_TXT_PARTICULAR_HOLIDAY  );
		checkNumber (txtPaidHoliday       , namPaidHoliday       , PRM_TXT_PAID_HOLIDAY        );
		checkNumber (txtAbsence           , namAbsence           , PRM_TXT_ABSENCE             );
		checkNumber (txtPaidHolidayRest   , namPaidHolidayRest   , PRM_TXT_PAID_HOLIDAY_REST   );
		checkDecimal(txtPaymentHours      , LEN_TIME_INT, LEN_TIME_DEC, namPaymentHours, PRM_TXT_PAYMENT_HOURS, false, 0);
		checkNumber (txtArriveLate        , namArriveLate        , PRM_TXT_ARRIVE_LATE         );
		checkDecimal(txtEffortTime        , LEN_TIME_INT, LEN_TIME_DEC, namEffortTime  , PRM_TXT_EFFORT_TIME  , false, 0);
		checkNumber (txtEffortAllowance   , namEffortAllowance   , PRM_TXT_EFFORT_ALLOWANCE    );
		checkDecimal(txtLateNight         , LEN_TIME_INT, LEN_TIME_DEC, namLateNight   , PRM_TXT_LATE_NIGHT   , false, 0);
		checkNumber (txtLateNightAllowance, namLateNightAllowance, PRM_TXT_LATE_NIGHT_ALLOWANCE);
		checkDecimal(txtOverLate          , LEN_TIME_INT, LEN_TIME_DEC, namOverLate    , PRM_TXT_OVER_LATE    , false, 0);
		checkNumber (txtOverLateAllowance , namOverLateAllowance , PRM_TXT_OVER_LATE_ALLOWANCE);
		checkDecimal(txtHolidayTime       , LEN_TIME_INT, LEN_TIME_DEC, namHolidayTime , PRM_TXT_HOLIDAY_TIME , false, 0);
		checkNumber (txtHolidayAllowance  , namHolidayAllowance  , PRM_TXT_HOLIDAY_ALLOWANCE   );
		checkNumber (txtAttendance_13     , namAttendance_13     , PRM_TXT_ATTENDANCE_13       );
		checkNumber (txtAttendance_14     , namAttendance_14     , PRM_TXT_ATTENDANCE_14       );
		checkNumber (txtBasicSalary       , namBasicSalary       , PRM_TXT_BASIC_SALARY        );
		checkNumber (txtAbility1Allowance , namAbility1Allowance , PRM_TXT_ABILITY1_ALLOWANCE  );
		checkNumber (txtAbility2Allowance , namAbility2Allowance , PRM_TXT_ABILITY2_ALLOWANCE  );
		checkNumber (txtFamilyAllowance   , namFamilyAllowance   , PRM_TXT_FAMILY_ALLOWANCE    );
		checkNumber (txtAllowance_05      , namAllowance_05      , PRM_TXT_ALLOWANCE_05        );
		checkNumber (txtAllowance_06      , namAllowance_06      , PRM_TXT_ALLOWANCE_06        );
		checkNumber (txtCutForMissing     , namCutForMissing     , PRM_TXT_CUT_FOR_MISSING     );
		checkNumber (txtCutForShort       , namCutForShort       , PRM_TXT_CUT_FOR_SHORT       );
		checkNumber (txtAllowance_09      , namAllowance_09      , PRM_TXT_ALLOWANCE_09        );
		checkNumber (txtAllowance_10      , namAllowance_10      , PRM_TXT_ALLOWANCE_10        );
		checkNumber (txtAllowance_11      , namAllowance_11      , PRM_TXT_ALLOWANCE_11        );
		checkNumber (txtAllowance_12      , namAllowance_12      , PRM_TXT_ALLOWANCE_12        );
		checkNumber (txtAllowance_13      , namAllowance_13      , PRM_TXT_ALLOWANCE_13        );
		checkNumber (txtDateAllowance     , namDateAllowance     , PRM_TXT_DATE_ALLOWANCE      );
		checkNumber (txtAllowance_15      , namAllowance_15      , PRM_TXT_ALLOWANCE_15        );
		checkNumber (txtAllowance_16      , namAllowance_16      , PRM_TXT_ALLOWANCE_16        );
		checkNumber (txtAllowance_17      , namAllowance_17      , PRM_TXT_ALLOWANCE_17        );
		checkNumber (txtCommutation       , namCommutation       , PRM_TXT_COMMUTATION         );
		checkNumber (txtOvertimeAllowance , namOvertimeAllowance , PRM_TXT_OVERTIME_ALLOWANCE  );
		checkNumber (txtCutFromBasic      , namCutFromBasic      , PRM_TXT_CUT_FROM_BASIC      );
		checkNumber (txtHealthInsurance   , namHealthInsurance   , PRM_TXT_HEALTH_INSURANCE    );
		checkNumber (txtPensionInsurance  , namPensionInsurance  , PRM_TXT_PENSION_INSURANCE   );
		checkNumber (txtPensionFund       , namPensionFund       , PRM_TXT_PENSION_FUND        );
		checkNumber (txtEmployeeInsurance , namEmployeeInsurance , PRM_TXT_EMPLOYEE_INSURANCE  );
		checkNumber (txtIncomeTax         , namIncomeTax         , PRM_TXT_INCOME_TAX          );
		checkNumber (txtResidenceTax      , namResidenceTax      , PRM_TXT_RESIDENCE_TAX       );
		checkNumber (txtNursingInsurance  , namNursingInsurance  , PRM_TXT_NURSING_INSURANCE   );
		checkNumber (txtDeduction_08      , namDeduction_08      , PRM_TXT_DEDUCTION_08        );
		checkNumber (txtDeduction_09      , namDeduction_09      , PRM_TXT_DEDUCTION_09        );
		checkNumber (txtDeduction_10      , namDeduction_10      , PRM_TXT_DEDUCTION_10        );
		checkNumber (txtDeduction_11      , namDeduction_11      , PRM_TXT_DEDUCTION_11        );
		checkNumber (txtDeduction_12      , namDeduction_12      , PRM_TXT_DEDUCTION_12        );
		checkNumber (txtDeduction_13      , namDeduction_13      , PRM_TXT_DEDUCTION_13        );
		checkNumber (txtDeduction_14      , namDeduction_14      , PRM_TXT_DEDUCTION_14        );
		checkNumber (txtDeduction_15      , namDeduction_15      , PRM_TXT_DEDUCTION_15        );
		checkNumber (txtDeduction_16      , namDeduction_16      , PRM_TXT_DEDUCTION_16        );
		checkNumber (txtDeduction_17      , namDeduction_17      , PRM_TXT_DEDUCTION_17        );
		checkNumber (txtDeduction_18      , namDeduction_18      , PRM_TXT_DEDUCTION_18        );
		checkNumber (txtDeduction_19      , namDeduction_19      , PRM_TXT_DEDUCTION_19        );
		checkNumber (txtDeduction_20      , namDeduction_20      , PRM_TXT_DEDUCTION_20        );
		checkNumber (lblAllowanceTotal    , namAllowanceTotal    , PRM_LBL_ALLOWANCE_TOTAL     );
		checkNumber (lblDeductionTotal    , namDeductionTotal    , PRM_LBL_DEDUCTION_TOTAL     );
		checkNumber (lblPaymentTotal      , namPaymentTotal      , PRM_LBL_PAYMENT_TOTAL       );
		checkNumber (lblBank1PayAmount    , namBank1PayAmount    , PRM_LBL_BANK1_PAY_AMOUNT    );
		checkNumber (lblBank2PayAmount    , namBank2PayAmount    , PRM_LBL_BANK2_PAY_AMOUNT    );
		checkNumber (lblCashPayAmount     , namCashPayAmount     , PRM_LBL_CASH_PAY_AMOUNT     );
		*/
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ肷(DTOɑ΂VÕZbg)B
	 * @param payment ^
	 */
	public void setDtoFields(Payment payment) {
		payment.setDetails(aryTime, aryAllowance, aryDeduction, aryBreakdown);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#getDirectJs(Class)
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = " + mode + ";");
		// ΑӍڃp[^Xg쐬
		sb.append("var ARY_TIME = new Array(");
		for (int i = 0; i < aryTime.length; i++) {
			sb.append("\"" + aryTime[i][0] + "\", ");
		}
		if (aryTime.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// xڃp[^Xg쐬
		sb.append("var ARY_ALLOWANCE = new Array(");
		for (int i = 0; i < aryAllowance.length; i++) {
			sb.append("\"" + aryAllowance[i][0] + "\", ");
		}
		if (aryAllowance.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// Tڃp[^Xg쐬
		sb.append("var ARY_DEDUCTION = new Array(");
		for (int i = 0; i < aryDeduction.length; i++) {
			sb.append("\"" + aryDeduction[i][0] + "\", ");
		}
		if (aryDeduction.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// 󍀖ڃp[^Xg쐬
		sb.append("var ARY_BREAKDOWN = new Array(");
		for (int i = 0; i < aryBreakdown.length; i++) {
			sb.append("\"" + aryBreakdown[i][0] + "\", ");
		}
		if (aryBreakdown.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// vڃp[^Xg쐬
		sb.append("var ARY_SUM = new Array(");
		for (int i = 0; i < arySum.length; i++) {
			sb.append("\"" + arySum[i][0] + "\", ");
		}
		if (arySum.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		return sb.toString();
	}
	
	/**
	 * ΑӖ׌擾B<br>
	 * @return ΑӖגl
	 */
	public int getTimeCount() {
		return aryTime.length;
	}
	
	/**
	 * x׌擾B<br>
	 * @return xגl
	 */
	public int getAllowanceCount() {
		return aryAllowance.length;
	}
	
	/**
	 * T׌擾B<br>
	 * @return Tגl
	 */
	public int getDeductionCount() {
		return aryDeduction.length;
	}
	
	/**
	 * 󖾍׌擾B<br>
	 * @return 󖾍גl
	 */
	public int getBreakdownCount() {
		return aryBreakdown.length;
	}
	
	/**
	 * v׌擾B<br>
	 * @return vגl
	 */
	public int getSumCount() {
		return arySum.length;
	}
	
	/**
	 * ΑӖגl擾B<br>
	 * @param idx CfbNX
	 * @return ΑӖגl
	 */
	public String getTimeAmount(int idx) {
		return aryTime[idx][2];
	}
	
	/**
	 * xגl擾B<br>
	 * @param idx CfbNX
	 * @return xגl
	 */
	public String getAllowanceAmount(int idx) {
		return aryAllowance[idx][2];
	}
	
	/**
	 * Tגl擾B<br>
	 * @param idx CfbNX
	 * @return Tגl
	 */
	public String getDeductionAmount(int idx) {
		return aryDeduction[idx][2];
	}
	
	/**
	 * 󖾍גl擾B<br>
	 * @param idx CfbNX
	 * @return 󖾍גl
	 */
	public String getBreakdownAmount(int idx) {
		return aryBreakdown[idx][2];
	}
	
	/**
	 * Tגl擾B<br>
	 * @param idx CfbNX
	 * @return Tגl
	 */
	public String getSumAmount(int idx) {
		return arySum[idx][2];
	}
	
	/**
	 * ΑӖ׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return ΑӖ׃R[h
	 */
	public String getTimeCode(int idx) {
		return aryTime[idx][0];
	}
	
	/**
	 * x׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return x׃R[h
	 */
	public String getAllowanceCode(int idx) {
		return aryAllowance[idx][0];
	}
	
	/**
	 * T׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return T׃R[h
	 */
	public String getDeductionCode(int idx) {
		return aryDeduction[idx][0];
	}
	
	/**
	 * 󖾍׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return 󖾍׃R[h
	 */
	public String getBreakdownCode(int idx) {
		return aryBreakdown[idx][0];
	}
	
	/**
	 * v׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return v׃R[h
	 */
	public String getSumCode(int idx) {
		return arySum[idx][0];
	}
	
	/**
	 * ΑӖז̂擾B<br>
	 * @param idx CfbNX
	 * @return ΑӖז
	 */
	public String getTimeName(int idx) {
		return escapeHTML(aryTime[idx][1]);
	}
	
	/**
	 * xז̂擾B<br>
	 * @param idx CfbNX
	 * @return xז
	 */
	public String getAllowanceName(int idx) {
		return escapeHTML(aryAllowance[idx][1]);
	}
	
	/**
	 * Tז̂擾B<br>
	 * @param idx CfbNX
	 * @return Tז
	 */
	public String getDeductionName(int idx) {
		return escapeHTML(aryDeduction[idx][1]);
	}
	
	/**
	 * 󖾍ז̂擾B<br>
	 * @param idx CfbNX
	 * @return 󖾍ז
	 */
	public String getBreakdownName(int idx) {
		return escapeHTML(aryBreakdown[idx][1]);
	}
	
	/**
	 * vז̂擾B<br>
	 * @param idx CfbNX
	 * @return vז
	 */
	public String getSumName(int idx) {
		return escapeHTML(arySum[idx][1]);
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public Date getCalcMonth() {
		return getDateField(calcMonth);
	}
	
	/**
	 * vZNݒ肷B
	 * @param calcMonth ݒ肷vZN
	 */
	public void setCalcMonth(Date calcMonth) {
		this.calcMonth = getDateField(calcMonth);
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public String getEscLblCalcMonth() {
		return escapeHTML(lblCalcMonth);
	}
	
	/**
	 * vZNݒ肷B
	 * @param lblCalcMonth ݒ肷vZN
	 */
	public void setLblCalcMonth(String lblCalcMonth) {
		this.lblCalcMonth = lblCalcMonth;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getEscKCode() {
		return escapeHTML(kCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param lblKCode ݒ肷ЈR[h
	 */
	public void setKCode(String lblKCode) {
		this.kCode = lblKCode;
	}
	
	/**
	 * Ј擾B
	 * @return Ј
	 */
	public String getLblKName() {
		return lblKName;
	}
	
	/**
	 * Ј擾B
	 * @return Ј
	 */
	public String getEscLblKName() {
		return escapeHTML(lblKName);
	}
	
	/**
	 * Јݒ肷B
	 * @param lblKName ݒ肷Ј
	 */
	public void setLblKName(String lblKName) {
		this.lblKName = lblKName;
	}
	
	/**
	 * 擾B
	 * @return 
	 */
	public String getEscLblSection() {
		return escapeHTML(lblSection);
	}

	/**
	 * ݒ肷B
	 * @param lblSection ݒ肷鏊
	 */
	public void setLblSection(String lblSection) {
		this.lblSection = lblSection;
	}

	/**
	 * גlݒ肷B<br>
	 * @param aryDetail  הz
	 * @param detailCode ׃R[h
	 * @param amount     גl
	 */
	private void setDetailAmount(String detailCode, String amount) {
		for (int i = 0; i < aryTime.length; i++) {
			if (aryTime[i][0].equals(detailCode)) {
				aryTime[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < aryAllowance.length; i++) {
			if (aryAllowance[i][0].equals(detailCode)) {
				aryAllowance[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < aryDeduction.length; i++) {
			if (aryDeduction[i][0].equals(detailCode)) {
				aryDeduction[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < aryBreakdown.length; i++) {
			if (aryBreakdown[i][0].equals(detailCode)) {
				aryBreakdown[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < arySum.length; i++) {
			if (arySum[i][0].equals(detailCode)) {
				arySum[i][2] = amount;
				return;
			}
		}
	}
	
	/**
	 * ʃ[hݒ肷B<br><br>
	 * 0:o^A1Fo^s
	 * @param mode ݒ肷ʃ[h
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
