package jp.mosp.payroll.payment.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.CmCityDto;

public class CityCardVo  extends PayrollVo {
	
	private static final long serialVersionUID = -4243420648713423351L;
	
	public static final String PRM_TXT_CITY_CODE          = "txtCityCode"        ;	// sR[h
	public static final String PRM_TXT_CITY_NAME          = "txtCityName"        ;	// s
	public static final String PRM_TXT_CITY_KANA          = "txtCityKana"        ;	// sJi
	public static final String PRM_TXT_CITY_ACCOUNT       = "txtCityAccount"     ;	// sԍ
	public static final String PRM_TXT_CITY_ACCOUNT_NAME1 = "txtCityAccountName1";	// 1
	public static final String PRM_TXT_CITY_ACCOUNT_NAME2 = "txtCityAccountName2";	// 2
	public static final String PRM_TXT_DESIGNATED_NUMBER  = "txtDesignatedNumber";	// wԍ
	public static final String PRM_PLT_CO_BANK_CODE       = "pltCoBankCode"      ;	// ЋsR[h
	public static final String PRM_TXT_MASTER_OFFICE      = "txtMasterOffice"    ;	// ܂Ƃߋ
	public static final String PRM_TXT_CITY_POSTAL_CODE   = "txtCityPostalCode"  ;	// sX֔ԍ
	public static final String PRM_TXT_CITY_ADDRESS1      = "txtCityAddress1"    ;	// sZ1
	public static final String PRM_TXT_CITY_ADDRESS2      = "txtCityAddress2"    ;	// sZ2
	public static final String PRM_TXT_CITY_OFFICE1       = "txtCityOffice1"     ;	// ꖼ1
	public static final String PRM_TXT_CITY_OFFICE2       = "txtCityOffice2"     ;	// ꖼ2
	public static final String PRM_TXT_CITY_PHONE         = "txtCityPhone"       ;	// sdbԍ



	
	// 萔
	public static final int MODE_INSERT = 0;
	public static final int MODE_UPDATE = 1;
	
	// [h(0FVKo^A1FXV)
	private int mode;

	public static String NAM_CITY_CODE;
	public static String NAM_CITY_NAME;
	public static String NAM_CITY_KANA;
	public static String NAM_DESIGNATED_NUMBER;
	public static String NAM_CO_BANK_CODE;

	
	public static final int LEN_CITY_CODE          = PayrollConst.LEN_CITY_CODE;
	public static final int LEN_CITY_NAME          = PayrollConst.LEN_CITY_NAME;
	public static final int LEN_CITY_KANA          = PayrollConst.LEN_CITY_KANA;
	public static final int LEN_DESIGNATED_NUMBER  = PayrollConst.LEN_DESIGNATED_NUMBER;


	// tB[h


	private String txtCityCode        ;
	private String txtCityName        ;
	private String txtCityKana        ;
	private String txtCityAccount     ;
	private String txtCityAccountName1;
	private String txtCityAccountName2;
	private String txtDesignatedNumber;
	private String pltCoBankCode      ;
	private String txtMasterOffice    ;
	private String txtCityPostalCode  ;
	private String txtCityAddress1    ;
	private String txtCityAddress2    ;
	private String txtCityOffice1     ;
	private String txtCityOffice2     ;
	private String txtCityPhone       ;

	
	//@v_EXg
	public String[][] aryPltCoBankCode  ;

	
	/**
	 * RXgN^
	 */
	public CityCardVo() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_CITY") + getName("P_WARD") + getName("P_TOWN") + getName("P_VILLAGE") + getName("C_MASTER") + getName("P_MAINTENANCE");
		addAryMenu("P1002", getName("P_PAYROLL") + getName("C_MASTER") + getName("C_MENU") + getName("C_TO"));
	}

	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_CITY_CODE			= getName("P_CITY_CODE");
		NAM_CITY_NAME			= getName("P_CITY_NAME");
		NAM_CITY_KANA			= getName("P_CITY_KANA");
		NAM_DESIGNATED_NUMBER	= getName("P_DESIGNATED_NUMBER");
		NAM_CO_BANK_CODE		= getName("P_CO_BANK_CODE");
	}
	
	/**
	 * tB[hݒ
	 * @param cmCityDto sDTO
	 */
	public void setFields(CmCityDto cmCityDto) {
		txtCityCode         = cmCityDto.getCityCode();
		txtCityName         = cmCityDto.getCityName();
		txtCityKana         = cmCityDto.getCityKana();
		txtCityAccount      = cmCityDto.getCityAccount();
		txtCityAccountName1 = cmCityDto.getCityAccountName1();
		txtCityAccountName2 = cmCityDto.getCityAccountName2();
		txtDesignatedNumber = cmCityDto.getDesignatedNumber();
		pltCoBankCode       = cmCityDto.getCoBankCode();
		txtMasterOffice     = cmCityDto.getMasterOffice();
		txtCityPostalCode   = cmCityDto.getCityPostalCode();
		txtCityAddress1     = cmCityDto.getCityAddress1();
		txtCityAddress2     = cmCityDto.getCityAddress2();
		txtCityOffice1      = cmCityDto.getCityOffice1();
		txtCityOffice2      = cmCityDto.getCityOffice2();
		txtCityPhone        = cmCityDto.getCityPhone();
	}
	
	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtCityCode         = request.getParameter(PRM_TXT_CITY_CODE         );
		txtCityName         = request.getParameter(PRM_TXT_CITY_NAME         );
		txtCityKana         = request.getParameter(PRM_TXT_CITY_KANA         );
		txtCityAccount      = request.getParameter(PRM_TXT_CITY_ACCOUNT      );
		txtCityAccountName1 = request.getParameter(PRM_TXT_CITY_ACCOUNT_NAME1);
		txtCityAccountName2 = request.getParameter(PRM_TXT_CITY_ACCOUNT_NAME2);
		txtDesignatedNumber = request.getParameter(PRM_TXT_DESIGNATED_NUMBER );
		pltCoBankCode       = request.getParameter(PRM_PLT_CO_BANK_CODE      );
		txtMasterOffice     = request.getParameter(PRM_TXT_MASTER_OFFICE     );
		txtCityPostalCode   = request.getParameter(PRM_TXT_CITY_POSTAL_CODE  );
		txtCityAddress1     = request.getParameter(PRM_TXT_CITY_ADDRESS1     );
		txtCityAddress2     = request.getParameter(PRM_TXT_CITY_ADDRESS2     );
		txtCityOffice1      = request.getParameter(PRM_TXT_CITY_OFFICE1      );
		txtCityOffice2      = request.getParameter(PRM_TXT_CITY_OFFICE2      );
		txtCityPhone        = request.getParameter(PRM_TXT_CITY_PHONE        );
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CmCityDto dto) {
		dto.setCityCode         (txtCityCode         );
		dto.setCityName         (txtCityName         );
		dto.setCityKana         (txtCityKana         );
		dto.setCityAccount      (txtCityAccount      );
		dto.setCityAccountName1 (txtCityAccountName1 );
		dto.setCityAccountName2 (txtCityAccountName2 );
		dto.setDesignatedNumber (txtDesignatedNumber );
		dto.setCoBankCode       (pltCoBankCode       );
		dto.setMasterOffice     (txtMasterOffice     );
		dto.setCityPostalCode   (txtCityPostalCode   );
		dto.setCityAddress1     (txtCityAddress1     );
		dto.setCityAddress2     (txtCityAddress2     );
		dto.setCityOffice1      (txtCityOffice1      );
		dto.setCityOffice2      (txtCityOffice2      );
		dto.setCityPhone        (txtCityPhone        );
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		checkRequired(txtCityCode      , NAM_CITY_CODE, PRM_TXT_CITY_CODE );
		checkRequired(txtCityName    , NAM_CITY_NAME  , PRM_TXT_CITY_NAME);
		checkRequired(txtCityKana       , NAM_CITY_KANA   , PRM_TXT_CITY_KANA);
		checkRequired(txtDesignatedNumber   , NAM_DESIGNATED_NUMBER, PRM_TXT_DESIGNATED_NUMBER);
		
		checkCode(txtCityCode, NAM_CITY_CODE, PRM_TXT_CITY_CODE);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }
	
	// ANZT\bh

	



	public void setTxtCityCode        (String txtCityCode        ) { this.txtCityCode         = txtCityCode          ; }
	public void setTxtCityName        (String txtCityName        ) { this.txtCityName         = txtCityName          ; }
	public void setTxtCityKana        (String txtCityKana        ) { this.txtCityKana         = txtCityKana          ; }
	public void setTxtCityAccount     (String txtCityAccount     ) { this.txtCityAccount      = txtCityAccount       ; }
	public void setTxtCityAccountName1(String txtCityAccountName1) { this.txtCityAccountName1 = txtCityAccountName1  ; }
	public void setTxtCityAccountName2(String txtCityAccountName2) { this.txtCityAccountName2 = txtCityAccountName2  ; }
	public void setTxtDesignatedNumber(String txtDesignatedNumber) { this.txtDesignatedNumber = txtDesignatedNumber  ; }
	public void setPltCoBankCode      (String pltCoBankCode      ) { this.pltCoBankCode       = pltCoBankCode        ; }
	public void setTxtMasterOffice    (String txtMasterOffice    ) { this.txtMasterOffice     = txtMasterOffice      ; }
	public void setTxtCityPostalCode  (String txtCityPostalCode  ) { this.txtCityPostalCode   = txtCityPostalCode    ; }
	public void setTxtCityAddress1    (String txtCityAddress1    ) { this.txtCityAddress1     = txtCityAddress1      ; }
	public void setTxtCityAddress2    (String txtCityAddress2    ) { this.txtCityAddress2     = txtCityAddress2      ; }
	public void setTxtCityOffice1     (String txtCityOffice1     ) { this.txtCityOffice1      = txtCityOffice1       ; }
	public void setTxtCityOffice2     (String txtCityOffice2     ) { this.txtCityOffice2      = txtCityOffice2       ; }
	public void setTxtCityPhone       (String txtCityPhone       ) { this.txtCityPhone        = txtCityPhone         ; }


	
	public String getTxtCityCode        () { return escapeHTML(txtCityCode        ) ; }
	public String getTxtCityName        () { return escapeHTML(txtCityName        ) ; }
	public String getTxtCityKana        () { return escapeHTML(txtCityKana        ) ; }
	public String getTxtCityAccount     () { return escapeHTML(txtCityAccount     ) ; }
	public String getTxtCityAccountName1() { return escapeHTML(txtCityAccountName1) ; }
	public String getTxtCityAccountName2() { return escapeHTML(txtCityAccountName2) ; }
	public String getTxtDesignatedNumber() { return escapeHTML(txtDesignatedNumber) ; }
	public String getPltCoBankCode      () { return escapeHTML(pltCoBankCode      ) ; }
	public String getTxtMasterOffice    () { return escapeHTML(txtMasterOffice    ) ; }
	public String getTxtCityPostalCode  () { return escapeHTML(txtCityPostalCode  ) ; }
	public String getTxtCityAddress1    () { return escapeHTML(txtCityAddress1    ) ; }
	public String getTxtCityAddress2    () { return escapeHTML(txtCityAddress2    ) ; }
	public String getTxtCityOffice1     () { return escapeHTML(txtCityOffice1     ) ; }
	public String getTxtCityOffice2     () { return escapeHTML(txtCityOffice2     ) ; }
	public String getTxtCityPhone       () { return escapeHTML(txtCityPhone       ) ; }

	

}
