package jp.mosp.payroll.payment.vo;

import java.util.Date;

import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;

public class CalcPaymentVo extends PayrollVo {
	
	private static final long serialVersionUID = 8910443939627425248L;
	
	// tB[h
	Date calcDate;
	
	// ʃ[h
	private int mode;
	
	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public CalcPaymentVo() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAYROLL");
		addAryMenu("P1001", getName("P_PAYMENT") +
				getName("P_CALCULATE") + getName("C_MENU") + getName("C_TO"));
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#getDirectJs(Class)
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = " + mode + ";");
		return sb.toString();
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public Date getCalcDate() {
		return getDateField(calcDate);
	}

	/**
	 * vZNݒ肷B
	 * @param calcDate ݒ肷vZN
	 */
	public void setCalcDate(Date calcDate) {
		this.calcDate = getDateField(calcDate);
	}

	/**
	 * vZN()擾B
	 * @return vZN()
	 */
	public String getStrCalcDate() {
		return MospUtility.getDateString(calcDate, PayrollConst.FORMAT_YEAR_MONTH);
	}
	
	/**
	 * ʃ[hݒ肷B<br><br>
	 * 0:ʏA1FvZ
	 * @param mode ݒ肷ʃ[h
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}

}
