package jp.mosp.payroll.payment.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.payroll.payment.vo.StartCalcVo;

/**
 * ^vZJnʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_EXECUTE}
 * </li><li>
 * {@link #CMD_FORCE}
 * </li></ul>
 */
public class StartCalcAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ŐV̋^vZIϔN擾A̗ftHgŕ\B<br>
	 * ^vZ̔Nꍇ́Ǎ\xB<br>
	 */
	public static final String CMD_SHOW = "P1200";
	
	/**
	 * sR}hB<br><br>
	 * w肳ꂽvZNɑ΂āAvZJnԂŃf[^쐬B<br>
	 * AAw肳ꂽvZNɌvZԂɂꍇ͌xB<br>
	 */
	public static final String CMD_EXECUTE = "P1205";
	
	/**
	 * sR}hB<br><br>
	 * ɌvZIĂvZNɑ΂āAēxvZJnԂɂB<br>
	 */
	public static final String CMD_FORCE = "P1206";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public StartCalcAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new StartCalcVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_EXECUTE)) {
			// s
			execute(false);
		} else if (this.cmd.equals(CMD_FORCE)) {
			// s
			execute(true);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		StartCalcVo vo = (StartCalcVo)getVo();
		// VXet擾
		Date sysDate = new Date();
		// v_EACeݒ
		vo.setPitYear(getYearArray(
				PayrollConst.DEFAULT_CURRENT_YEAR, MospUtility.getYear(sysDate) + 1));
		vo.setPitMonth(getMonthArray());
		// vZJnmF
		checkCalcStrat();
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		// ŐVvZN擾
		PtCurrentDto dto = dao.findLatest(
				PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT, PayrollConst.CURRENT_END);
		// VOtB[hݒ
		if (dto != null) {
			Date calcDate = MospUtility.addMonth(dto.getCalcDate(), 1);
			vo.setPltYear (MospUtility.getYear (calcDate));
			vo.setPltMonth(MospUtility.getMonth(calcDate));
		} else {
			vo.setPltYear (MospUtility.getYear (sysDate));
			vo.setPltMonth(MospUtility.getMonth(sysDate));
		}
		// ʃ[hݒ
		vo.setMode(0);
	}
	
	/**
	 * ^vZJnsB<br>
	 * @param isForce stO
	 * @throws Exception 
	 */
	private void execute(boolean isForce) throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		StartCalcVo vo = (StartCalcVo)getVo();
		// p[^擾
		vo.setParams(request);
		// Ώ۔N擾
		Date targetMonth = getTargetMonth();
		// vZJnmF
		checkCalcStrat();
		// vZԊmF
		if (!isForce) {
			checkCalcState();
		}
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		// ΏۊmF
		PtCurrentDto dto = dao.findForUpdate(
				PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT, targetMonth);
		// Ώۂ݂ꍇ
		if (dto == null) {
			// }f[^쐬
			dto = new PtCurrentDto();
			dto.setOfficeCode   (PayrollConst.OFFICE_ALL   );
			dto.setCalcType     (PayrollConst.CALC_PAYMENT );
			dto.setCalcDate     (targetMonth               );
			dto.setCurrentStatus(PayrollConst.CURRENT_START);
			// }
			dao.insert(dto);
		} else {
			// DTOύX
			dto.setCurrentStatus(PayrollConst.CURRENT_START);
			// XV
			dao.update(dto);
		}
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IP1200",
				MospUtility.getDateString(targetMonth, PayrollConst.FORMAT_YEAR_MONTH)));
		// R}hݒ(ΑӃf[^捞ʂ)
		setNextCmd(ImportTimeAction.CMD_SHOW);
	}
	
	/**
	 * vZmFB<br>
	 * @throws Exception 
	 */
	private void checkCalcStrat() throws Exception {
		// VO擾
		StartCalcVo vo = (StartCalcVo)getVo();
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current != null) {
			// VOtB[hݒ
			vo.setPltYear (MospUtility.getYear (current));
			vo.setPltMonth(MospUtility.getMonth(current));
			// ʃ[hݒ
			vo.setMode(1);
			// xbZ[Wݒ
			String strDate = MospUtility.getDateString(
					current, PayrollConst.FORMAT_YEAR_MONTH);
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1200",	strDate));
			// OX[
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * vZԂmFB<br>
	 * @throws Exception 
	 */
	private void checkCalcState() throws Exception {
		// VO擾
		StartCalcVo vo = (StartCalcVo)getVo();
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		// Ώ۔N擾
		Date targetMonth = getTargetMonth();
		// ΏۊmF
		PtCurrentDto dto = dao.findForKey(
				PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT, targetMonth);
		if (dto == null) {
			return;
		}
		// vZԊmF
		if (dto.getCurrentStatus() == PayrollConst.CURRENT_END) {
			// ʃ[hݒ
			vo.setMode(2);
			// xbZ[Wݒ
			String strDate = MospUtility.getDateString(
					targetMonth, PayrollConst.FORMAT_YEAR_MONTH);
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1201",	strDate));
			// OX[
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * Ώ۔N擾B<br>
	 * @return Ώی
	 */
	private Date getTargetMonth() {
		// VO擾
		StartCalcVo vo = (StartCalcVo)getVo();
		// Ώ۔N擾
		return getDate(vo.getPltYear(), vo.getPltMonth(), PayrollConst.TIME_DEFAULT_DAY);
	}
	
}
