package jp.mosp.payroll.payment.action;

import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.payment.vo.PaymentReportVo;

/**
 * ^[o͉ʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li></ul>
 */
public class PaymentReportAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AVXeN\B<br>
	 */
	public static final String CMD_SHOW = "P1260";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public PaymentReportAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentReportVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentReportVo vo = (PaymentReportVo)getVo();
		// VXet擾
		Date sysDate = new Date();
		// v_EACeݒ
		vo.setPitYear(getYearArray(
				PayrollConst.DEFAULT_CURRENT_YEAR, MospUtility.getYear(sysDate) + 1));
		vo.setPitMonth(getMonthArray());
		vo.setPitOutYear(getYearArray(
				PayrollConst.DEFAULT_CURRENT_YEAR, MospUtility.getYear(sysDate) + 1));
		vo.setPitOutMonth(getMonthArray());
		vo.setPitOffice  (getOfficeArray());
		vo.setPitSection (getSectionArrayAll());
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current == null) {
			// VOtB[hݒ
			vo.setPltYear (MospUtility.getYear (sysDate));
			vo.setPltMonth(MospUtility.getMonth(sysDate));
			vo.setPltOutYear (MospUtility.getYear (sysDate));
			vo.setPltOutMonth(MospUtility.getMonth(sysDate));
			return;
		}
		// VOtB[hݒ
		vo.setPltYear (MospUtility.getYear (current));
		vo.setPltMonth(MospUtility.getMonth(current));
		vo.setPltOutYear (MospUtility.getYear (sysDate));
		vo.setPltOutMonth(MospUtility.getMonth(sysDate));
	}

}
