package jp.mosp.payroll.payment.action;

import java.sql.SQLException;
import java.util.Date;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.Payment;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PdPayAllowanceDao;
import jp.mosp.payroll.dao.PdPayBreakdownDao;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dao.PdPaySumDao;
import jp.mosp.payroll.dao.PdPayTimeDao;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.payment.vo.PaymentCardVo;

/**
 * ^׉ʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_SOC_INS}
 * </li><li>
 * {@link #CMD_INCOME_TAX}
 * </li><li>
 * {@link #CMD_REGIST}
 * </li><li>
 * {@link #CMD_CALC}
 * </li></ul>
 */
public class PaymentCardAction extends PayrollAction {
	/**
	 * ʕ\R}hB<br><br>
	 * ЈR[hAvZNL[ƂA^ׂ擾A\B<br>
	 */
	public static final String CMD_SHOW = "P1250";
	
	/**
	 * ЉیvZR}hB<br><br>
	 * ҏW̎ЈR[hAvZN̋^f[^ɑ΂AЉیvZsB<br>
	 * AAvẐ݂œo^͂ȂB<br>
	 * ^ׂҏWxzςꍇA
	 * ЉیvZ邽߂ɗpB<br>
	 */
	public static final String CMD_SOC_INS = "P1253";
	
	/**
	 * ŌvZR}hB<br><br>
	 * ҏW̎ЈR[hAvZN̋^f[^ɑ΂AŌvZsB<br>
	 * AAvẐ݂œo^͂ȂB<br>
	 * ^ׂҏWxzςꍇA
	 * łvZ邽߂ɗpB<br>
	 */
	public static final String CMD_INCOME_TAX = "P1254";
	
	/**
	 * o^R}hB<br><br>
	 * ҏW̎ЈR[hAvZN̋^f[^ɑ΂Ao^sB<br>
	 * ̍ہAe퍇vsB<br>
	 * ^ׂ̕ҏWA@TvZsꍇA
	 * ҏWeo^ۂɗpB<br>
	 */
	public static final String CMD_REGIST = "P1255";
	
	/**
	 * ʋ^vZR}hB<br><br>
	 * ҏW̎ЈR[hAvZN̋^f[^ɑ΂Aʂɍēx^vZsB<br>
	 * ҏW̋^f[^͏㏑Ă܂߁AӂKvB<br>
	 * ēo^Ă܂̂ɖ߂ꍇɁApB<br>
	 */
	public static final String CMD_CALC = "P1256";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public PaymentCardAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PaymentCardVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_SOC_INS)) {
			// ЉیvZ
			calcSocIns();
		} else if (this.cmd.equals(CMD_INCOME_TAX)) {
			// ŌvZ
			calcIncomeTax();
		} else if (this.cmd.equals(CMD_REGIST)) {
			// o^
			regist();
		} else if (this.cmd.equals(CMD_CALC)) {
			// o^
			calculate();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// ʕ\
		show(key1, MospUtility.getDate(key2));
	}
	
	/**
	 * o^sB<br><br>
	 * @throws Exception 
	 */
	private void regist() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentCardVo vo = (PaymentCardVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcMonth();
		// vZmF
		if (!isCurrent(targetMonth, PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT)) {
			// bZ[Wݒ
			addErrMessage(MospUtility.getMessage(msg, "WP1211", ""));
			return;
		}
		// p[^擾
		vo.setParams(request);
		// ^擾
		Payment payment = getPayment(vo.getKCode(), vo.getCalcMonth());
		// p[^ݒ
		vo.setDtoFields(payment);
		// vvZ
		calcTotal(getEmployee(vo.getKCode()), payment);
		// o^
		registPayment(payment);
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IC0001", ""));
		// ʕ\
		show(vo.getKCode(), targetMonth);
	}
	
	/**
	 * vZsB<br><br>
	 * @throws Exception 
	 */
	private void calculate() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentCardVo vo = (PaymentCardVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcMonth();
		// vZmF
		if (!isCurrent(targetMonth, PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT)) {
			// bZ[Wݒ
			addErrMessage(MospUtility.getMessage(msg, "WP1211", ""));
			return;
		}
		// ^vZ
		calcPayment(vo.getKCode(), targetMonth);
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IP1230",
				MospUtility.getDateString(targetMonth, PayrollConst.FORMAT_YEAR_MONTH)));
		// ʕ\
		show(vo.getKCode(), targetMonth);
	}
	
	/**
	 * ЉیvZsB<br><br>
	 * @throws Exception 
	 */
	private void calcSocIns() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentCardVo vo = (PaymentCardVo)getVo();
		// ^擾
		Payment payment = getPayment(vo.getKCode(), vo.getCalcMonth());
		// p[^擾
		vo.setParams(request);
		// p[^ݒ
		vo.setDtoFields(payment);
		// l擾
		Employee employee = getEmployee(vo.getKCode());
		// ЉیvZ
		calcSocialInsurance(employee, payment);
		// vvZ
		calcTotal(employee, payment);
		// VOtB[hݒ
		vo.setFields(employee, payment);
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IP1253",""));
	}
	
	/**
	 * ŌvZsB<br><br>
	 * @throws Exception 
	 */
	private void calcIncomeTax() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		PaymentCardVo vo = (PaymentCardVo)getVo();
		// ^擾
		Payment payment = getPayment(vo.getKCode(), vo.getCalcMonth());
		// p[^擾
		vo.setParams(request);
		// p[^ݒ
		vo.setDtoFields(payment);
		// l擾
		Employee employee = getEmployee(vo.getKCode());
		// ŌvZ
		calcIncomeTax(employee, payment);
		// vvZ
		calcTotal(employee, payment);
		// VOtB[hݒ
		vo.setFields(employee, payment);
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IP1253",""));
	}
	
	/**
	 * ʕ\sB<br><br>
	 * @param ΏێЈR[h
	 * @param Ώ۔N
	 * @throws Exception 
	 */
	private void show(String kCode, Date targetMonth) throws Exception {
		// VO擾
		PaymentCardVo vo = (PaymentCardVo)getVo();
		// l擾
		Employee employee = getEmployee(kCode);
		// ^擾
		Payment payment = getPayment(kCode, targetMonth);
		// VOtB[hݒ
		vo.setFields(employee, payment);
		// ʃ[hݒ
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		if (current == null) {
			vo.setMode(1);
		} else {
			vo.setMode(targetMonth.compareTo(current) == 0 ? 0 : 1);
		}
	}
	
	/**
	 * ^o^B<br><br>
	 * @param payment ^
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 * @throws MospException 
	 */
	private void registPayment(
			Payment payment
	) throws SQLException, NoSuchFieldException, IllegalAccessException, MospException {
		// DAO
		PhPaymentDao      phPaymentDao      = new PhPaymentDao     (cfg, cmd, aspUser, user, conn);
		PdPayTimeDao      pdPayTimeDao      = new PdPayTimeDao     (cfg, cmd, aspUser, user, conn);
		PdPayAllowanceDao pdPayAllowanceDao = new PdPayAllowanceDao(cfg, cmd, aspUser, user, conn);
		PdPayDeductionDao pdPayDeductionDao = new PdPayDeductionDao(cfg, cmd, aspUser, user, conn);
		PdPayBreakdownDao pdPayBreakdownDao = new PdPayBreakdownDao(cfg, cmd, aspUser, user, conn);
		PdPaySumDao       pdPayTotalDao     = new PdPaySumDao      (cfg, cmd, aspUser, user, conn);
		// ^wb_[XV
		phPaymentDao.update(payment.getHeader(), true);
		// ^׍폜
		pdPayTimeDao     .delete(payment.getKCode(), payment.getCalcMonth());
		pdPayAllowanceDao.delete(payment.getKCode(), payment.getCalcMonth());
		pdPayDeductionDao.delete(payment.getKCode(), payment.getCalcMonth());
		pdPayBreakdownDao.delete(payment.getKCode(), payment.getCalcMonth());
		pdPayTotalDao    .delete(payment.getKCode(), payment.getCalcMonth());
		// ^דo^
		pdPayTimeDao     .insert(payment.getTimeList     ());
		pdPayAllowanceDao.insert(payment.getAllowanceList());
		pdPayDeductionDao.insert(payment.getDeductionList());
		pdPayBreakdownDao.insert(payment.getBreakdownList());
		pdPayTotalDao    .insert(payment.getSumList      ());
	}

	
}
