package jp.mosp.payroll.payment.action;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.CmBankDao;
import jp.mosp.payroll.dao.CmBranchDao;
import jp.mosp.payroll.dao.CmCoBankDao;
import jp.mosp.payroll.dto.CmBankDto;
import jp.mosp.payroll.dto.CmBranchDto;
import jp.mosp.payroll.dto.CmCoBankDto;
import jp.mosp.payroll.payment.vo.CompanyCoBankVo;

/**
 * Ћs}X^̃eiXɕKvȋ@\񋟂B<br>
 * Ћs}X^̈ꗗ\Ayѓo^EXV\B<br>
 */
public class CompanyCoBankAction extends PayrollAction {
	// R}h
	private static final String CMD_CM_CO_BANK_SHOW      = "U5251";
	private static final String CMD_CM_CO_BANK_INSERT    = "U5252";
	private static final String CMD_CM_CO_BANK_SELECT    = "U5253";
	private static final String CMD_CM_CO_BANK_UPDATE    = "U5254";
	private static final String CMD_CM_CO_BANK_RE_SEARCH = "U5255";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public CompanyCoBankAction() {
		super();
	}

	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new CompanyCoBankVo();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO擾yѐݒ
		prepareVo();
		CompanyCoBankVo vo = (CompanyCoBankVo)getVo();
		// DAO
		CmCoBankDao dao;
		// DTO
		CmCoBankDto dto;
		Object obj2 = session.getAttribute(MospConst.ATT_DTO);
		dto = obj2 instanceof CmCoBankDto ? (CmCoBankDto)obj2 : null;
		// s}X^AxX}X^f[^쐬(t@CĂo͂)
		convFinanceData(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.JS_FINANCE, true);
/*		// sR[h擾
		vo.aryPltPaidBankName   = getBankArray  ();
		// xXR[h擾
		vo.aryPltPaidBranchName = getBranchArray();
*/		// R}h̏
		if (cmd.equals(CMD_CM_CO_BANK_SHOW)) {
			// \
			vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
			vo.aryPltAccountType = getCodeArray(PayrollConst.TID_ACCOUNT_TYPE);
			// 
			vo.setInitFields();
			vo.setMode(0);
			// 
			searchCompanyCoBank(vo);
			vo.setFormerKey(vo.KEY_CO_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();	
		} else if (cmd.equals(CMD_CM_CO_BANK_INSERT)) {
			// o^
			vo.setParams(request);
			dto = insert(vo);
			session.setAttribute(MospConst.ATT_DTO, dto);
			// 
			vo.setInitFields();
			// 
			searchCompanyCoBank(vo);
			vo.setFormerKey(vo.KEY_CO_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_CO_BANK_SELECT)) {
			// \()
			// DBRlNV̎擾yDTȌ
			getConnection();
			dao = new CmCoBankDao();
			dao.initDao(cfg, cmd, aspUser, user, conn);
			// f[^̎擾
			dto = dao.findForKey(key1);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			// sxXݒ
			setFinanceName(dto, vo);
			vo.setMode(1);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CM_CO_BANK_UPDATE)) {
			// XV
			vo.setParams(request);
			dto = update(vo, dto);
			session.setAttribute(MospConst.ATT_DTO, dto);
			// 
			vo.setInitFields();
			// 
			searchCompanyCoBank(vo);
			vo.setFormerKey(vo.KEY_CO_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_CM_CO_BANK_RE_SEARCH)) {
			// Č
			vo.setParams(request);
			session.removeAttribute(MospConst.ATT_DTO);
			// 
			vo.setInitFields();
			// 
			vo.setInitFields();
			vo.setMode(0);
			//
			searchCompanyCoBank(vo);
			vo.setFormerKey(vo.KEY_CO_BANK_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		}  else{
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	
	
	/**
	 * Ћs}X^ꗗ擾B<br>
	 * ȉ̗ŏsB<br>
	 * <ol>
	 * <li>Ћs}X^̑S擾B<br>
	 * <li>擾ЋsR[h̃XgVoɃZbgB<br>
	 * <li>Ћs}X^̃R[hɁAs}X^s擾B<br>
	 * <li>Ћs}X^̃R[hɁAxX}X^xX擾B<br>
	 * <li>擾sAxXVoɃZbgB<br>
	 * </ol>
	 * @param vo CompanyCoBankVoCX^X
	 * @throws Exception
	 */
	private void searchCompanyCoBank(CompanyCoBankVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// Daȍ
		CmCoBankDao dao = new CmCoBankDao();
		CmBankDao cmBankDao = new CmBankDao();
		CmBranchDao cmBranchDao = new CmBranchDao();
		// Dao
		dao.initDao(cfg, cmd, aspUser, user, conn);
		cmBankDao.initDao(cfg, cmd, aspUser, user, conn);
		cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
		// Ћs}X^̑S擾B
		List<CmCoBankDto> list = dao.findAll();
		// 擾R[h̃XgVoɃZbgB
		vo.setFields(list);
		// R[hɋsyюxXݒ肷B
		// sݒ肷B
		for (int i = 0; i < list.size(); i++) {
			CmCoBankDto dto = list.get(i);
			CmBankDto cmBankDto = cmBankDao.findForKey(dto.getBankCode());
			if(cmBankDto == null) {
				vo.setBankName(i, "");
			} else {
				vo.setBankName(i, cmBankDto.getBankName());
			}
			// xXݒ肷B
			CmBranchDto cmBranchDto = cmBranchDao.findForKey(dto.getBankCode(), dto.getBranchCode());
			if (cmBranchDto == null) {
				vo.setBranchName(i, "");
			} else {
				vo.setBranchName(i, cmBranchDto.getBranchName());
			}
		}
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @throws Exception
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public CmCoBankDto insert(CompanyCoBankVo vo) throws Exception {
		// VÕ[hݒ		
		vo.setMode(0);
		// p[^̑ÓmF
		vo.validate();
		// RlNV̎擾yDAȌ
		getConnection();
		CmCoBankDao dao = new CmCoBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(dao.findForKey(vo.getTxtCoBankCode()),vo);
		// DTO
		CmCoBankDto dto = new CmCoBankDto();
		vo.setDtoFields(dto);
		// f[^}
		dao.insert(dto);
		// DTOĎ擾
		dto = dao.findForKey(dto.getCoBankCode());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		// s}X^AxX}X^f[^쐬(t@CĂo͂)
		convFinanceData(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.JS_FINANCE, true);
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public CmCoBankDto update(CompanyCoBankVo vo, CmCoBankDto dto) throws Exception {
		// VÕ[hݒ
		vo.setMode(1);
		// p[^̑ÓmF
		vo.validate();
		// RlNV̎擾yDAȌ
		getConnection();
		CmCoBankDao dao = new CmCoBankDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getTxtCoBankCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		dao.update(dto, true);
		// DTO̍Ď擾
		CmCoBankDto retDto = dao.findForKey(dto.getCoBankCode());
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		vo.setMode(0);
		// s}X^AxX}X^f[^쐬(t@CĂo͂)
		convFinanceData(cfg.getProperty(MospConst.PPT_APP_DOCBASE) + PayrollConst.JS_FINANCE, true);
		return retDto;
	}
	
	private void setFinanceName(CmCoBankDto dto, CompanyCoBankVo vo)
		throws SQLException, IllegalAccessException, NoSuchFieldException
	{
		if (dto == null) {
			return;
		}
		// DAȌ
		CmBankDao cmBankDao = new CmBankDao();
		cmBankDao.initDao(cfg, cmd, aspUser, user, conn);
		// DAȌ
		CmBranchDao cmBranchDao = new CmBranchDao();
		cmBranchDao.initDao(cfg, cmd, aspUser, user, conn);
		CmBankDto cmBankDto = cmBankDao.findForKey(dto.getBankCode());
		if (cmBankDto != null) {
			vo.setLblBankName(cmBankDto.getBankName());
		} else {
			vo.setLblBankName(dto.getBankCode());
		}
		CmBranchDto cmBranchDto = cmBranchDao.findForKey(dto.getBankCode(), dto.getBranchCode());
		if (cmBranchDto != null) {
			vo.setLblBranchName(cmBranchDto.getBranchName());
		} else {
			vo.setLblBranchName(dto.getBranchCode());
		}
		
		
	}
}