package jp.mosp.payroll.payment.action;

import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PhPaymentDao;
import jp.mosp.payroll.dto.PhPaymentDto;
import jp.mosp.payroll.payment.vo.CalcPaymentVo;

/**
 * ^vZʂɂ鏈sB<br><br>
 * ȉ̃R}hB
 * <ul><li>
 * {@link #CMD_SHOW}
 * </li><li>
 * {@link #CMD_EXECUTE}
 * </li></ul>
 */
public class CalcPaymentAction extends PayrollAction {
	
	/**
	 * ʕ\R}hB<br><br>
	 * ^vZ̔N擾A\B<br>
	 * ^vZ̔NȂꍇ́AxB<br>
	 * ^vZ̔Nɂ鋋^f[^݂ꍇAxB<br>
	 */
	public static final String CMD_SHOW = "P1230";
	
	/**
	 * sR}hB<br><br>
	 * \ꂽvZNɑ΂āA^vZsB<br>
	 */
	public static final String CMD_EXECUTE = "P1235";
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public CalcPaymentAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new CalcPaymentVo();
	}
	
	/**
	 * ANVB<br>
	 * ڍׂ́ANXQƁB<br>
	 */
	public void action() throws Exception {
		// VO擾yѐݒ
		prepareVo();
		if (this.cmd.equals(CMD_SHOW)) {
			// ʕ\
			show();
		} else if (this.cmd.equals(CMD_EXECUTE)) {
			// s
			execute();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ʕ\sB<br>
	 * @throws Exception 
	 */
	private void show() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		CalcPaymentVo vo = (CalcPaymentVo)getVo();
		// vZ擾
		Date current = getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT);
		// vZmF
		if (current == null) {
			// ʃ[hݒ
			vo.setMode(1);
			// xbZ[Wݒ
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1210",	""));
			// OX[
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		// ^f[^݊mF
		List<PhPaymentDto> list = new PhPaymentDao(cfg, cmd, aspUser, user, conn).find(current);
		if (list.size() > 0) {
			// xbZ[Wݒ
			vo.addErrMessage(MospUtility.getMessage(msg, "WP1220",
					MospUtility.getDateString(current, PayrollConst.FORMAT_YEAR_MONTH) +
					MospConst.DATA_SEPARATOR + vo.getName("P_PAYMENT")));
		}
		// VOtB[hݒ
		vo.setCalcDate(current);
		// ʃ[hݒ
		vo.setMode(0);
	}
	
	/**
	 * ^vZsB<br>
	 * @throws Exception 
	 */
	private void execute() throws Exception {
		// RlNV擾
		getConnection();
		// VO擾
		CalcPaymentVo vo = (CalcPaymentVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcDate();
		// vZmF
		if (!isCurrent(targetMonth, PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT)) {
			// bZ[Wݒ
			addErrMessage(MospUtility.getMessage(msg, "WP1211", ""));
			return;
		}
		// vZΏێҎ擾
		Date startDate = getStartDate(targetMonth);
		String[] aryEmployee = getTargetEmployee(startDate);
		// ^vZ
		for (int i = 0; i < aryEmployee.length; i++) {
			calcPayment(aryEmployee[i], targetMonth);
		}
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(MospUtility.getMessage(msg, "IP1230",
				MospUtility.getDateString(targetMonth, PayrollConst.FORMAT_YEAR_MONTH)));
		// R}hݒ(^vZʂ)
		setNextCmd(PaymentListAction.CMD_SHOW);
	}
	
}
