package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.PtCurrentDto;

/**
 * vZNe[u𑀍@\񋟂B<br><br>
 * {@link PtCurrentDto}pāADBJavavOԂŃR[hLB<br>
 */
public class PtCurrentDao extends PayrollDao {
	
	/**
	 *  e[uB<br>
	 */
	public static final String TABLE = "PT_CURRENT";
	
	/**
	 *  L[1B<br>
	 */
	public static final String KEY_01 = "OFFICE_CDOE";
	
	/**
	 *  L[2B<br>
	 */
	public static final String KEY_02 = "CALC_TYPE";
	
	/**
	 *  L[3B<br>
	 */
	public static final String KEY_03 = "CALC_DATE";
	
	public static final String COL_OFFICE_CDOE    = "OFFICE_CDOE"   ;
	public static final String COL_CALC_TYPE      = "CALC_TYPE"     ;
	public static final String COL_CALC_DATE      = "CALC_DATE"     ;
	public static final String COL_CURRENT_STATUS = "CURRENT_STATUS";
	
	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PtCurrentDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private PtCurrentDto mapping() throws SQLException {
		PtCurrentDto dto = new PtCurrentDto();
		dto.setOfficeCode   (rs.getString(COL_OFFICE_CDOE   ));
		dto.setCalcType     (rs.getByte  (COL_CALC_TYPE     ));
		dto.setCalcDate     (rs.getDate  (COL_CALC_DATE     ));
		dto.setCurrentStatus(rs.getByte  (COL_CURRENT_STATUS));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	private List<PtCurrentDto> mappingAll() throws SQLException {
		List<PtCurrentDto> all = new ArrayList<PtCurrentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * L[ɂf[^擾B<br>
	 * @param officeCode ƏR[h
	 * @param calcType   vZ敪
	 * @param calcDate   vZN
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PtCurrentDto findForKey(
			String officeCode,
			byte   calcType  ,
			Date   calcDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam    (index++, officeCode);
			setParam    (index++, calcType  );
			setDateParam(index++, calcDate  );
			executeQuery();
			if (rs.next()) {
				return mapping();
			}
			return null;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B<br>
	 * @param officeCode ƏR[h
	 * @param calcType   vZ敪
	 * @param calcDate   vZN
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PtCurrentDto findForUpdate(
			String officeCode,
			byte   calcType  ,
			Date   calcDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam    (index++, officeCode);
			setParam    (index++, calcType  );
			setDateParam(index++, calcDate  );
			executeQuery();
			if (rs.next()) {
				return mapping();
			}
			return null;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param officeCode   ƏR[h
	 * @param calcType     vZ敪
	 * @param currentState vZ
	 * @return (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PtCurrentDto> findForState(
			String officeCode  ,
			byte   calcType    ,
			byte   currentState
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_OFFICE_CDOE + " = ? ");
			sb.append("AND ");
			sb.append(COL_CALC_TYPE + " = ? ");
			sb.append("AND ");
			sb.append(COL_CURRENT_STATUS + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, officeCode  );
			setParam(index++, calcType    );
			setParam(index++, currentState);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param officeCode   ƏR[h
	 * @param calcType     vZ敪
	 * @param currentState vZ
	 * @return (DTO)
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	public PtCurrentDto findLatest(
			String officeCode  ,
			byte   calcType    ,
			byte   currentState
	) throws IllegalAccessException, SQLException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass()) + getMaxCalcDateTable());
			setParam(index++, officeCode  );
			setParam(index++, calcType    );
			setParam(index++, currentState);
			executeQuery();
			if (rs.next()) {
				return mapping();
			}
			return null;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * vZNe[uSQL擾B<br>
	 * @return vZNe[uSQL
	 * @throws IllegalAccessException 
	 */
	public String getMaxCalcDateTable() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append(	"SELECT ");
		sb.append(	COL_OFFICE_CDOE    + " AS M_OFFICE_CODE, "   );
		sb.append(	COL_CALC_TYPE      + " AS M_CALC_TYPE, "     );
		sb.append(	COL_CURRENT_STATUS + " AS M_CURRENT_STATUS, ");
		sb.append(	"MAX(" + COL_CALC_DATE + ") AS M_CALC_DATE " );
		sb.append(	"FROM " + TABLE + " ");
		sb.append(	"WHERE ");
		sb.append(	COL_OFFICE_CDOE    + " = ? AND ");
		sb.append(	COL_CALC_TYPE      + " = ? AND ");
		sb.append(	COL_CURRENT_STATUS + " = ? "    );
		sb.append(	"GROUP BY ");
		sb.append(  COL_OFFICE_CDOE    + ", ");
		sb.append(  COL_CALC_TYPE      + ", ");
		sb.append(  COL_CURRENT_STATUS       );
		sb.append(") TEMPVIEW ");
		sb.append("WHERE ");
		sb.append(COL_OFFICE_CDOE    + " = TEMPVIEW.M_OFFICE_CODE AND ");
		sb.append(COL_CALC_TYPE      + " = TEMPVIEW.M_CALC_TYPE AND "  );
		sb.append(COL_CALC_DATE      + " = TEMPVIEW.M_CALC_DATE AND "  );
		sb.append(COL_CURRENT_STATUS + " = TEMPVIEW.M_CURRENT_STATUS " );
		sb.append(") " + TABLE +" ");
		return sb.toString();
	}
	
	/**
	 * f[^}B<br>
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(
			PtCurrentDto dto
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB<br>
	 * @param dto XVΏDTO
	 * @return XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(
			PtCurrentDto dto
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
		
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam    (index++, dto.getOfficeCode());
			setParam    (index++, dto.getCalcType  ());
			setDateParam(index++, dto.getCalcDate  ());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ肷B<br>
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PtCurrentDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getOfficeCode   ());
		setParam(index++, dto.getCalcType     ());
		setParam(index++, dto.getCalcDate     ());
		setParam(index++, dto.getCurrentStatus());
		setCommonParams(isInsert);
	}

	/**
	 * L[ɂf[^擾
	 * @param stationCode R[h(L[)
	 * @return UtCurrentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 * @throws NoSuchFieldException
	 */
	public PtCurrentDto findForKey(
			String officeCode
	) throws IllegalAccessException, SQLException, NoSuchFieldException {
		try {

			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_OFFICE_CDOE);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, officeCode);
			
//			index = 1;
//			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
//			prepareStatement(getSelectStatement(getClass()));
//			setParam(index++, officeCode  );
			executeQuery();
			if (rs.next()) {
				return mapping();
			}
			return null;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
