package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.dto.DetailMoneyDto;

public class PdPayDeductionDao extends DetailMoneyDao {
	/**
	 *  e[uB<br>
	 */
	public static final String TABLE = "PD_PAY_DEDUCTION";
	
	/**
	 * {@link DetailMoneyDao#DetailMoneyDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PdPayDeductionDao(
			Properties   cfg    ,
			String       cmd    ,
			CmAspUserDto aspUser,
			CmUserDto    user   ,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
	}

	/**
	 * ɂf[^擾B<br>
	 * @param kCode      ЈR[h
	 * @param calcDate   vZN
	 * @param calcDetail ׃R[h
	 * @return (DTO)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public DetailMoneyDto findForDetail(
			String kCode, Date calcDate, String calcDetail
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_DETAIL_CODE + " = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam    (index++, kCode    );
			setDateParam(index++, calcDate);
			setParam    (index++, calcDetail);
			executeQuery();
			DetailMoneyDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
