package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CtRetireDetailDto;

public class CtRetireDetailDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "CT_RETIRE_DETAIL";
	public static final String KEY_1 = "CITY_CODE"       ;	// sR[h
	public static final String KEY_2 = "DETAIL_MONTH"    ;	// ސEהN
	
	// 
	public static final String COL_CITY_CODE         = "CITY_CODE"        ;	// sR[h
	public static final String COL_DETAIL_MONTH      = "DETAIL_MONTH"     ;	// ސEהN
	public static final String COL_CITY_CHANGES      = "CITY_CHANGES"     ;	// ٓL
	public static final String COL_RETIRE_COUNT      = "RETIRE_COUNT"     ;	// ސEl
	public static final String COL_CITY_PAY_AMOUNT   = "CITY_PAY_AMOUNT"   ;	// xz
	public static final String COL_CITY_TAX          = "CITY_TAX"         ;	// s
	public static final String COL_PREFECTURE_TAX    = "PREFECTURE_TAX"   ;	// {

	
	/**
	 * RXgN^
	 */
	public CtRetireDetailDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CtRetireDetailDto> mappingAll() throws SQLException {
		List<CtRetireDetailDto> all  =  new ArrayList<CtRetireDetailDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmCityDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private CtRetireDetailDto mapping() throws SQLException {
		CtRetireDetailDto dto  =  new CtRetireDetailDto();
		dto.setCityCode     (rs.getString(COL_CITY_CODE      ));	// sR[h
		dto.setDetailMonth  (rs.getDate  (COL_DETAIL_MONTH   ));	// ސEהN
		dto.setCityChanges  (rs.getString(COL_CITY_CHANGES   ));	// ٓL
		dto.setRetireCount  (rs.getInt   (COL_RETIRE_COUNT   ));	// ސEl
		dto.setCityPayAmount(rs.getLong  (COL_CITY_PAY_AMOUNT));	// xz
		dto.setCityTax      (rs.getInt  (COL_CITY_TAX       ));	// s
		dto.setPrefectureTax(rs.getInt  (COL_PREFECTURE_TAX ));	// {
		mappingCommonInfo(dto);
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CtRetireDetailDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CtRetireDetailDto> all  =  mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param cityCode      s撬R[h(L[)
	 * @param detailMonth   ސEהN(L[)
	 * @return CtRetireDetailDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtRetireDetailDto findForKey(
			String cityCode,
			Date   detailMonth
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index  =  1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, cityCode);
			setParam(index++, detailMonth);
			executeQuery();
			CtRetireDetailDto dto  =  null;
			if (rs.next()) {
				dto  =  mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param cityCode      s撬R[h(L[)
	 * @return CtRetireDetailDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CtRetireDetailDto findForUpdate(
			String cityCode,
			Date detailMonth
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index  =  1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, cityCode);
			setParam(index++, detailMonth);

			executeQuery();
			CtRetireDetailDto dto  =  null;
			if (rs.next()) {
				dto  =  mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	


	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CtRetireDetailDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index  =  1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @param needLog Oo͗v
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CtRetireDetailDto dto, boolean needLog) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index  =  1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CtRetireDetailDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index  =  1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getCityCode());
			setParam(index++, dto.getDetailMonth());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CtRetireDetailDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index  =  1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getCityCode());
			setParam(index++, dto.getDetailMonth());

			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	

	


	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CtRetireDetailDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getCityCode     ());	// sR[h
		setParam(index++, dto.getDetailMonth  ());	// ސEהN
		setParam(index++, dto.getCityChanges  ());	// ٓL
		setParam(index++, dto.getRetireCount  ());	// ސEl
		setParam(index++, dto.getCityPayAmount());	// xz
		setParam(index++, dto.getCityTax      ());	// s
		setParam(index++, dto.getPrefectureTax());	// {
		setCommonParams(isInsert);
	}

}
