package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmSocInsuranceDto;

public class CmSocInsuranceDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "CM_SOC_INSURANCE" ;
	public static final String KEY_1 = "K_CODE"           ;	// ЈR[h
	public static final String KEY_2 = "INS_EXPECTED_DATE";	// ЉیKpN
	
	// 
	public static final String COL_K_CODE             = "K_CODE"            ;	// ЈR[h
	public static final String COL_INS_EXPECTED_DATE  = "INS_EXPECTED_DATE" ;	// ЉیKpN
	public static final String COL_PENSION_TYPE       = "PENSION_TYPE"      ;	// N
	public static final String COL_PARTTIME_TYPE      = "PARTTIME_TYPE"     ;	// p[g敪
	public static final String COL_EMPLOYEE_TYPE      = "EMPLOYEE_TYPE"     ;	// ]ƈ敪
	public static final String COL_CALC_INS_TYPE      = "CALC_INS_TYPE"     ;	// Љی敪
	public static final String COL_NURSING_INS_TYPE   = "NURSING_INS_TYPE"  ;	// ی敪
	public static final String COL_CALC_UNEMPLOY_TYPE = "CALC_UNEMPLOY_TYPE";	// ٗpی敪
	public static final String COL_BONUS_HEALTH_TYPE  = "BONUS_HEALTH_TYPE" ;	// Nیܗ^敪
	public static final String COL_BONUS_PENSION_TYPE = "BONUS_PENSION_TYPE";	// Nܗ^敪
	public static final String COL_HEALTH_NO          = "HEALTH_NO"         ;	// Nیԍ
	public static final String COL_HEALTH_PAYMENT     = "HEALTH_PAYMENT"    ;	// NیWVz
	public static final String COL_HEALTH_GET_DATE    = "HEALTH_GET_DATE"   ;	// Nیi擾
	public static final String COL_HEALTH_LOST_TYPE   = "HEALTH_LOST_TYPE"  ;	// Nیir敪
	public static final String COL_HEALTH_LOST_DATE   = "HEALTH_LOST_DATE"  ;	// Nیir
	public static final String COL_PENSION_NO         = "PENSION_NO"        ;	// Nԍ
	public static final String COL_PENSION_PAYMENT    = "PENSION_PAYMENT"   ;	// NWVz
	public static final String COL_PENSION_GET_DATE   = "PENSION_GET_DATE"  ;	// Ni擾
	public static final String COL_PENSION_LOST_TYPE  = "PENSION_LOST_TYPE" ;	// Nir敪
	public static final String COL_PENSION_LOST_DATE  = "PENSION_LOST_DATE" ;	// Nir
	public static final String COL_FUND_NO            = "FUND_NO"           ;	// Nԍ
	public static final String COL_FUND_GET_DATE      = "FUND_GET_DATE"     ;	// Ni擾
	public static final String COL_UNEMPLOY_NO        = "UNEMPLOY_NO"       ;	// ٗpیԍ
	public static final String COL_UNEMPLOY_GET_DATE  = "UNEMPLOY_GET_DATE" ;	// ٗpیi擾
	public static final String COL_UNEMPLOY_LOST_TYPE = "UNEMPLOY_LOST_TYPE";	// ٗpیir敪
	public static final String COL_UNEMPLOY_LOST_DATE = "UNEMPLOY_LOST_DATE";	// ٗpیir
	
	/**
	 * RXgN^
	 */
	public CmSocInsuranceDao() {
		super();
	}
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String,  CmSocInsuranceDto> mappingAllMap() throws SQLException {
		Map<String, CmSocInsuranceDto> all = new HashMap<String, CmSocInsuranceDto>();
		while (rs.next()) {
			CmSocInsuranceDto dto = mapping();
			all.put(dto.getKCode(), dto);
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmSocInsuranceDto> mappingAll() throws SQLException {
		List<CmSocInsuranceDto> all = new ArrayList<CmSocInsuranceDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmSocInsuranceDto R[h
	 * @throws SQLException
	 */
	private CmSocInsuranceDto mapping() throws SQLException {
		CmSocInsuranceDto dto = new CmSocInsuranceDto();
		dto.setKCode           (rs.getString(COL_K_CODE            ));	// ЈR[h
		dto.setInsExpectedDate (rs.getDate  (COL_INS_EXPECTED_DATE ));	// ЉیKpN
		dto.setPensionType     (rs.getString(COL_PENSION_TYPE      ));	// N
		dto.setParttimeType    (rs.getString(COL_PARTTIME_TYPE     ));	// p[g敪
		dto.setEmployeeType    (rs.getString(COL_EMPLOYEE_TYPE     ));	// ]ƈ敪
		dto.setCalcInsType     (rs.getString(COL_CALC_INS_TYPE     ));	// Љی敪
		dto.setNursingInsType  (rs.getString(COL_NURSING_INS_TYPE  ));	// ی敪
		dto.setCalcUnemployType(rs.getString(COL_CALC_UNEMPLOY_TYPE));	// ٗpی敪
		dto.setBonusHealthType (rs.getString(COL_BONUS_HEALTH_TYPE ));	// Nیܗ^敪
		dto.setBonusPensionType(rs.getString(COL_BONUS_PENSION_TYPE));	// Nܗ^敪
		dto.setHealthNo        (rs.getString(COL_HEALTH_NO         ));	// Nیԍ
		dto.setHealthPayment   (rs.getInt   (COL_HEALTH_PAYMENT    ));	// NیWVz
		dto.setHealthGetDate   (rs.getDate  (COL_HEALTH_GET_DATE   ));	// Nیi擾
		dto.setHealthLostType  (rs.getString(COL_HEALTH_LOST_TYPE  ));	// Nیir敪
		dto.setHealthLostDate  (rs.getDate  (COL_HEALTH_LOST_DATE  ));	// Nیir
		dto.setPensionNo       (rs.getString(COL_PENSION_NO        ));	// Nԍ
		dto.setPensionPayment  (rs.getInt   (COL_PENSION_PAYMENT   ));	// NWVz
		dto.setPensionGetDate  (rs.getDate  (COL_PENSION_GET_DATE  ));	// Ni擾
		dto.setPensionLostType (rs.getString(COL_PENSION_LOST_TYPE ));	// Nir敪
		dto.setPensionLostDate (rs.getDate  (COL_PENSION_LOST_DATE ));	// Nir
		dto.setFundNo          (rs.getString(COL_FUND_NO           ));	// Nԍ
		dto.setFundGetDate     (rs.getDate  (COL_FUND_GET_DATE     ));	// Ni擾
		dto.setUnemployNo      (rs.getString(COL_UNEMPLOY_NO       ));	// ٗpیԍ
		dto.setUnemployGetDate (rs.getDate  (COL_UNEMPLOY_GET_DATE ));	// ٗpیi擾
		dto.setUnemployLostType(rs.getString(COL_UNEMPLOY_LOST_TYPE));	// ٗpیir敪
		dto.setUnemployLostDate(rs.getDate  (COL_UNEMPLOY_LOST_DATE));	// ٗpیir
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param insExpectedDate ЉیKpN(L[)
	 * @return Map (DTOMap)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public Map<String, CmSocInsuranceDto> findForHumanData(
			Date insExpectedDate) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getHistoryTableForHumanData());
			setParam(index++, insExpectedDate);
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param resExpectedDate ZœKpN(L[)
	 * @param kCode Ј(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public CmSocInsuranceDto findForHumanDataOnly(
			String kCode, Date resExpectedDate) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" AND ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getHistoryTableForHumanData() + sb.toString());
			setParam(index++, resExpectedDate);
			setParam(index++, kCode);
			executeQuery();
			CmSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmSocInsuranceDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmSocInsuranceDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode           ЈR[h(L[)
	 * @param insExpectedDate ЉیKpN(L[)
	 * @return CmSocInsuranceDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmSocInsuranceDto findForKey(
			String kCode,
			Date   insExpectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode          );
			setDateParam(index++, insExpectedDate);
			executeQuery();
			CmSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmSocInsuranceDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public CmSocInsuranceDto findForEmployee(
			String kCode
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getHistoryTable());
			setParam(index++, kCode);
			executeQuery();
			CmSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂzf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmSocInsuranceDto (DTO)
	 * @throws SQLException
	 */
	public List<CmSocInsuranceDto> findForEmployeeList(
			String kCode
	) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT * FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeQuery();
			List<CmSocInsuranceDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode           ЈR[h(L[)
	 * @param insExpectedDate ЉیKpN(L[)
	 * @return CmSocInsuranceDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public CmSocInsuranceDto findForEmployee(
			String kCode,
			Date   insExpectedDate
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(getSelectStatement(getClass()));
			sb.append("FROM ");
			sb.append(TABLE + ", ");
			sb.append("(");
			sb.append(	"SELECT ");
			sb.append(	COL_K_CODE + " AS H_K_CODE, ");
			sb.append(	"MAX(" + COL_INS_EXPECTED_DATE + ") AS H_EXPECTED_DATE " );
			sb.append(	"FROM " + TABLE + " ");
			sb.append(	"WHERE ");
			sb.append(	COL_K_CODE + " = ? ");
			sb.append(	"AND ");
			sb.append(	COL_INS_EXPECTED_DATE + " <= ? ");
			sb.append(	"GROUP BY " + COL_K_CODE + " ");
			sb.append(") HISTORY ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
			sb.append("AND ");
			sb.append(COL_INS_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
			prepareStatement(sb.toString());
			setParam(index++, kCode          );
			setParam(index++, insExpectedDate);
			executeQuery();
			CmSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 * @throws NoSuchFieldException
	 */
	public CmSocInsuranceDto findForUpdate(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			CmSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode           ЈR[h(L[)
	 * @param insExpectedDate ЉیKpN(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmSocInsuranceDto findForUpdate(
			String kCode          ,
			Date   insExpectedDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass())
					+ getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode          );
			setParam(index++, insExpectedDate);
			executeQuery();
			CmSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}(Abv[h)
	 * @param aryHeaderNo }Ώۃwb_[
	 * @param aryCsvData  }Ώۃf[^
	 * @param kCode       ЈR[h
	 * @param calcDate    KpN
	 * @return int }()
	 * @throws SQLException
	 */
	public int insertUpload(
			String[] aryHeaderNo,
			String[] aryCsvData,
			String   kCode,
			Date calcDate
	) throws SQLException {
		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append(" ( ");
			sb.append(COL_K_CODE);
			sb.append(", ");
			sb.append(createCol(aryHeaderNo,true));
			sb.append(COL_INS_EXPECTED_DATE);
			sb.append(", ");
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " ");
			}
			sb.append(" ) VALUES ( ");
			sb.append("?, ");
			sb.append(insertRow(aryCsvData));
			sb.append("?, ");
			if (!INSERT_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append("?  ");
			}
			sb.append(" ) ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			for (int i = 0; i < aryCsvData.length; i++) {
				setParam(index++, aryCsvData[i]);
			}
			setParam(index++, calcDate);
			if (!INSERT_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!INSERT_USER.equals("")) {
				setParam(index++, userId);
			}
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * IĴSQL쐬
	 * @param aryHeaderNo
	 * @param isInsert
	 * @return IĴSQL
	 */
	public String createCol(
			String[] aryHeaderNo,
			boolean isInsert
		) {
			index = 1;
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < aryHeaderNo.length; i++) {
				sb.append(getColumn(Integer.parseInt(aryHeaderNo[i])));
				if (!isInsert) {
					sb.append(" = ? ");
				}
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			return sb.toString();
	}
	
	/**
	 * o^p[^
	 * @param aryCsvData
	 * @return o^p[^
	 */
	public String insertRow(
			String[] aryCsvData
	) {
			index = 1;
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < aryCsvData.length; i++) {
				sb.append(" ? ");
				sb.append(PayrollConst.STR_CSV_SEPARATOR);
			}
			return sb.toString();
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param aryHeaderNo XVΏۃwb_[
	 * @param aryCsvData  XVΏۃf[^
	 * @param kCode       ЈR[h
	 * @param calcDate    KpN
	 * @return int XV()
	 * @throws SQLException
	 */
	public int updateUpload(
			String[] aryHeaderNo,
			String[] aryCsvData,
			String   kCode,
			Date   calcDate
	) throws SQLException {
		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(createCol(aryHeaderNo,false));
			sb.append(COL_INS_EXPECTED_DATE + " = ?, ");
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + " = ?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " = ? ");
			}
			sb.append(" WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_INS_EXPECTED_DATE);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			for (int i = 0; i < aryCsvData.length; i++) {
				setParam(index++, aryCsvData[i]);
			}
			setParam(index++, calcDate);
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmSocInsuranceDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmSocInsuranceDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode          ());
			setParam(index++, dto.getInsExpectedDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmSocInsuranceDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode          ());
			setParam(index++, dto.getInsExpectedDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	private String getHistoryTable() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append(	"SELECT ");
		sb.append(	COL_K_CODE + " AS H_K_CODE, ");
		sb.append(	"MAX(" + COL_INS_EXPECTED_DATE + ") AS H_EXPECTED_DATE " );
		sb.append(	"FROM " + TABLE + " ");
		sb.append(	"WHERE ");
		sb.append(	COL_K_CODE + " = ? ");
		sb.append(	"GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_INS_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
		return sb.toString();
	}
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	private String getHistoryTableForHumanData() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append(	"SELECT ");
		sb.append(	COL_K_CODE + " AS H_K_CODE, ");
		sb.append(	"MAX(" + COL_INS_EXPECTED_DATE + ") AS H_EXPECTED_DATE " );
		sb.append(	"FROM " + TABLE + " ");
		sb.append(	"WHERE " + COL_INS_EXPECTED_DATE + " <= ? ");
		sb.append(	"GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_INS_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
		return sb.toString();
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmSocInsuranceDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode           ());	// ЈR[h
		setParam(index++, dto.getInsExpectedDate ());	// ЉیKpN
		setParam(index++, dto.getPensionType     ());	// N
		setParam(index++, dto.getParttimeType    ());	// p[g敪
		setParam(index++, dto.getEmployeeType    ());	// ]ƈ敪
		setParam(index++, dto.getCalcInsType     ());	// Љی敪
		setParam(index++, dto.getNursingInsType  ());	// ی敪
		setParam(index++, dto.getCalcUnemployType());	// ٗpی敪
		setParam(index++, dto.getBonusHealthType ());	// Nیܗ^敪
		setParam(index++, dto.getBonusPensionType());	// Nܗ^敪
		setParam(index++, dto.getHealthNo        ());	// Nیԍ
		setParam(index++, dto.getHealthPayment   ());	// NیWVz
		setParam(index++, dto.getHealthGetDate   ());	// Nیi擾
		setParam(index++, dto.getHealthLostType  ());	// Nیir敪
		setParam(index++, dto.getHealthLostDate  ());	// Nیir
		setParam(index++, dto.getPensionNo       ());	// Nԍ
		setParam(index++, dto.getPensionPayment  ());	// NWVz
		setParam(index++, dto.getPensionGetDate  ());	// Ni擾
		setParam(index++, dto.getPensionLostType ());	// Nir敪
		setParam(index++, dto.getPensionLostDate ());	// Nir
		setParam(index++, dto.getFundNo          ());	// Nԍ
		setParam(index++, dto.getFundGetDate     ());	// Ni擾
		setParam(index++, dto.getUnemployNo      ());	// ٗpیԍ
		setParam(index++, dto.getUnemployGetDate ());	// ٗpیi擾
		setParam(index++, dto.getUnemployLostType());	// ٗpیir敪
		setParam(index++, dto.getUnemployLostDate());	// ٗpیir
		setCommonParams(isInsert);
	}
	
	/**
	 * J擾
	 * @param idx
	 * @return J
	 */
	private String getColumn(int idx) {
		switch (idx) {
		case 1  : return COL_PENSION_TYPE       ;// N
		case 2  : return COL_PARTTIME_TYPE      ;// p[g敪
		case 3  : return COL_EMPLOYEE_TYPE      ;// ]ƈ敪
		case 4  : return COL_CALC_INS_TYPE      ;// Љی敪
		case 5  : return COL_NURSING_INS_TYPE   ;// ی敪
		case 6  : return COL_CALC_UNEMPLOY_TYPE ;// ٗpی敪
		case 7  : return COL_BONUS_HEALTH_TYPE  ;// Nیܗ^敪
		case 8  : return COL_BONUS_PENSION_TYPE ;// Nܗ^敪
		case 9  : return COL_HEALTH_NO          ;// Nیԍ
		case 10  : return COL_HEALTH_PAYMENT     ;// NیWVz
		case 11  : return COL_HEALTH_GET_DATE    ;// Nیi擾
		case 12  : return COL_HEALTH_LOST_TYPE   ;// Nیir敪
		case 13  : return COL_HEALTH_LOST_DATE   ;// Nیir
		case 14  : return COL_PENSION_NO         ;// Nԍ
		case 15  : return COL_PENSION_PAYMENT    ;// NWVz
		case 16  : return COL_PENSION_GET_DATE   ;// Ni擾
		case 17  : return COL_PENSION_LOST_TYPE  ;// Nir敪
		case 18  : return COL_PENSION_LOST_DATE  ;// Nir
		case 19  : return COL_FUND_NO            ;// Nԍ
		case 20  : return COL_FUND_GET_DATE      ;// Ni擾
		case 21  : return COL_UNEMPLOY_NO        ;// ٗpیԍ
		case 22  : return COL_UNEMPLOY_GET_DATE  ;// ٗpیi擾
		case 23  : return COL_UNEMPLOY_LOST_TYPE ;// ٗpیir敪
		case 24  : return COL_UNEMPLOY_LOST_DATE ;// ٗpیir

		default:
			return "";
		}
		
	}
}

