package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmPaymentMeansDto;

public class CmPaymentMeansDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "CM_PAYMENT_MEANS";
	public static final String KEY_1 = "K_CODE"          ;	// ЈR[h
	public static final String KEY_2 = "MEANS_SEQUENCE"  ;	// x@A
	
	// 
	public static final String COL_K_CODE           = "K_CODE"          ;	// ЈR[h
	public static final String COL_MEANS_SEQUENCE  = "MEANS_SEQUENCE"  ;	// x@A
	public static final String COL_ALLOWANCE_TYPE   = "ALLOWANCE_TYPE"  ;	// x敪
	public static final String COL_CO_BANK_CODE     = "CO_BANK_CODE"    ;	// ЋsR[h
	public static final String COL_PAID_BANK_CODE   = "PAID_BANK_CODE"  ;	// UsR[h
	public static final String COL_PAID_BRANCH_CODE = "PAID_BRANCH_CODE";	// UsxXR[h
	public static final String COL_ACCOUNT_TYPE     = "ACCOUNT_TYPE"    ;	// a敪
	public static final String COL_ACCOUNT_NO       = "ACCOUNT_NO"      ;	// ԍ
	public static final String COL_HOLDER_NAME      = "HOLDER_NAME"     ;	// `
	public static final String COL_HOLDER_KANA      = "HOLDER_KANA"     ;	// `ض
	public static final String COL_PAYMENT_MEANS    = "PAYMENT_MEANS"   ;	// x@
	public static final String COL_AMOUNT_TYPE      = "AMOUNT_TYPE"     ;	// z敪
	public static final String COL_FIXED_AMOUNT     = "FIXED_AMOUNT"    ;	// Œz
	public static final String COL_DELETE_FLAG      = "DELETE_FLAG"     ;	// 폜tO
	
	/**
	 * RXgN^
	 */
	public CmPaymentMeansDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmPaymentMeansDto> mappingAll() throws SQLException {
		List<CmPaymentMeansDto> all = new ArrayList<CmPaymentMeansDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmPaymentMeansDto R[h
	 * @throws SQLException
	 */
	private CmPaymentMeansDto mapping() throws SQLException {
		CmPaymentMeansDto dto = new CmPaymentMeansDto();
		dto.setKCode         (rs.getString(COL_K_CODE          ));	// ЈR[h
		dto.setMeansSequence (rs.getInt   (COL_MEANS_SEQUENCE ));	// x@A
		dto.setAllowanceType (rs.getString(COL_ALLOWANCE_TYPE  ));	// x敪
		dto.setCoBankCode    (rs.getString(COL_CO_BANK_CODE    ));	// ЋsR[h
		dto.setPaidBankCode  (rs.getString(COL_PAID_BANK_CODE  ));	// UsR[h
		dto.setPaidBranchCode(rs.getString(COL_PAID_BRANCH_CODE));	// UsxXR[h
		dto.setAccountType   (rs.getString(COL_ACCOUNT_TYPE    ));	// a敪
		dto.setAccountNo     (rs.getString(COL_ACCOUNT_NO      ));	// ԍ
		dto.setHolderName    (rs.getString(COL_HOLDER_NAME     ));	// `
		dto.setHolderKana    (rs.getString(COL_HOLDER_KANA     ));	// `ض
		dto.setPaymentMeans  (rs.getString(COL_PAYMENT_MEANS   ));	// x@
		dto.setAmountType    (rs.getString(COL_AMOUNT_TYPE     ));	// z敪
		dto.setFixedAmount   (rs.getInt   (COL_FIXED_AMOUNT    ));	// Œz
		dto.setDeleteFlag    (rs.getInt   (COL_DELETE_FLAG     ));	// 폜tO
		mappingCommonInfo(dto);
		return dto;
	}
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String,  List<CmPaymentMeansDto>> mappingAllMap() throws SQLException {
		Map<String, List<CmPaymentMeansDto>> map = new HashMap<String, List<CmPaymentMeansDto>>();
		List<CmPaymentMeansDto> list = mappingAll();
		if (list.size() == 0) {
			return map;
		}
		String currentKCode = list.get(0).getKCode();
		int startIndex = 0;
		for (int i = 1; i < list.size(); i++) {
			if (list.get(i).getKCode().equals(currentKCode)) {
				continue;
			}
			map.put(currentKCode, getSubList(list, startIndex, i - 1));
			startIndex = i;
			currentKCode = list.get(i).getKCode();
		}
		map.put(currentKCode, getSubList(list, startIndex, list.size() - 1));
		return map;
	}
	
	/**
	 * TuXg擾
	 * @param list      Xg
	 * @param fromIndex JnCfbNX
	 * @param toIndex   ICfbNX
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CmPaymentMeansDto> getSubList(List<CmPaymentMeansDto> list, int fromIndex, int toIndex) {
		List<CmPaymentMeansDto> subList = new ArrayList<CmPaymentMeansDto>();
		for (int i = fromIndex; i <= toIndex; i++) {
			if (i >= list.size()) {
				break;
			}
			subList.add(list.get(i));
		}
		return subList;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmPaymentMeansDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmPaymentMeansDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmPaymentMeansDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmPaymentMeansDto findForKey(
			String kCode,
			int    meansSequence
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode        );
			setParam(index++, meansSequence);
			executeQuery();
			CmPaymentMeansDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmPaymentMeansDto> findForEmployee(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈAz敪ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmPaymentMeansDto> findForEmployeeAmount(
			String kCode,
			String amountType
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append(" AND ");
			sb.append(COL_AMOUNT_TYPE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, amountType);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈAx敪ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmPaymentMeansDto> findForEmployeeAllowance(
			String kCode,
			String allowanceType
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append(" AND ");
			sb.append(COL_ALLOWANCE_TYPE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, allowanceType);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmPaymentMeansDto> findForUpdate(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmPaymentMeansDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmPaymentMeansDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode        ());
			setParam(index++, dto.getMeansSequence());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmPaymentMeansDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode        ());
			setParam(index++, dto.getMeansSequence());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	/**
	 * ɂf[^擾(lo͗p)
	 * @return Map (DTOListMap)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public Map<String, List<CmPaymentMeansDto>> findForHumanData(
			) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmPaymentMeansDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode         ());	// ЈR[h
		setParam(index++, dto.getMeansSequence ());	// x@A
		setParam(index++, dto.getAllowanceType ());	// x敪
		setParam(index++, dto.getCoBankCode    ());	// ЋsR[h
		setParam(index++, dto.getPaidBankCode  ());	// UsR[h
		setParam(index++, dto.getPaidBranchCode());	// UsxXR[h
		setParam(index++, dto.getAccountType   ());	// a敪
		setParam(index++, dto.getAccountNo     ());	// ԍ
		setParam(index++, dto.getHolderName    ());	// `
		setParam(index++, dto.getHolderKana    ());	// `ض
		setParam(index++, dto.getPaymentMeans  ());	// x@
		setParam(index++, dto.getAmountType    ());	// z敪
		setParam(index++, dto.getFixedAmount   ());	// Œz
		setParam(index++, dto.getDeleteFlag    ());	// 폜tO
		setCommonParams(isInsert);
	}
}

