package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmCommutationDto;

public class CmCommutationDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "CM_COMMUTATION"  ;
	public static final String KEY_1 = "K_CODE"          ;	// ЈR[h
	public static final String KEY_2 = "COMMUTE_SEQUENCE";	// ʋΎ蓖A
	
	// 
	public static final String COL_K_CODE            = "K_CODE"           ;	// ЈR[h
	public static final String COL_COMMUTE_SEQUENCE  = "COMMUTE_SEQUENCE" ;	// ʋΎ蓖A
	public static final String COL_COMMUTE_TYPE      = "COMMUTE_TYPE"     ;	// ʋΎ蓖敪
	public static final String COL_PAYMENT_INTERVAL  = "PAYMENT_INTERVAL" ;	// xԊu
	public static final String COL_LUMP_MONTHLY_TYPE = "LUMP_MONTHLY_TYPE";	// ꊇ敪
	public static final String COL_PAY_START_MONTH   = "PAY_START_MONTH"  ;	// xJn
	public static final String COL_COMMUTE_DISTANCE  = "COMMUTE_DISTANCE" ;	// Г
	public static final String COL_COMMUTE_AMOUNT    = "COMMUTE_AMOUNT"   ;	// ʋΎ蓖xz
	public static final String COL_COMMUTE_TAXED     = "COMMUTE_TAXED"    ;	// ېŒʋΔ
	public static final String COL_DELETE_FLAG       = "DELETE_FLAG"      ;	// 폜tO
	
	/**
	 * RXgN^
	 */
	public CmCommutationDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CmCommutationDto> mappingAll() throws SQLException {
		List<CmCommutationDto> all = new ArrayList<CmCommutationDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String,  List<CmCommutationDto>> mappingAllMap() throws SQLException {
		Map<String, List<CmCommutationDto>> map = new HashMap<String, List<CmCommutationDto>>();
		List<CmCommutationDto> list = mappingAll();
		if (list.size() == 0) {
			return map;
		}
		String currentKCode = list.get(0).getKCode();
		int startIndex = 0;
		for (int i = 1; i < list.size(); i++) {
			if (list.get(i).getKCode().equals(currentKCode)) {
				continue;
			}
			map.put(currentKCode, getSubList(list, startIndex, i - 1));
			startIndex = i;
			currentKCode = list.get(i).getKCode();
		}
		map.put(currentKCode, getSubList(list, startIndex, list.size() - 1));
		return map;
	}
	
	/**
	 * TuXg擾
	 * @param list      Xg
	 * @param fromIndex JnCfbNX
	 * @param toIndex   ICfbNX
	 * @return Xg
	 * @throws SQLException
	 */
	private List<CmCommutationDto> getSubList(List<CmCommutationDto> list, int fromIndex, int toIndex) {
		List<CmCommutationDto> subList = new ArrayList<CmCommutationDto>();
		for (int i = fromIndex; i <= toIndex; i++) {
			if (i >= list.size()) {
				break;
			}
			subList.add(list.get(i));
		}
		return subList;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmCommutationDto R[h
	 * @throws SQLException
	 */
	private CmCommutationDto mapping() throws SQLException {
		CmCommutationDto dto = new CmCommutationDto();
		dto.setKCode          (rs.getString(COL_K_CODE           ));	// ЈR[h
		dto.setCommuteSequence(rs.getInt   (COL_COMMUTE_SEQUENCE ));	// ʋΎ蓖A
		dto.setCommuteType    (rs.getString(COL_COMMUTE_TYPE     ));	// ʋΎ蓖敪
		dto.setPaymentInterval(rs.getString(COL_PAYMENT_INTERVAL ));	// xԊu
		dto.setLumpMonthlyType(rs.getString(COL_LUMP_MONTHLY_TYPE));	// ꊇ敪
		dto.setPayStartMonth  (rs.getDate  (COL_PAY_START_MONTH  ));	// xJn
		dto.setCommuteDistance(rs.getFloat (COL_COMMUTE_DISTANCE ));	// Г
		dto.setCommuteAmount  (rs.getInt   (COL_COMMUTE_AMOUNT   ));	// ʋΎ蓖xz
		dto.setCommuteTaxed   (rs.getInt   (COL_COMMUTE_TAXED    ));	// ېŒʋΔ
		dto.setDeleteFlag     (rs.getInt   (COL_DELETE_FLAG      ));	// 폜tO
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCommutationDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmCommutationDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmCommutationDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CmCommutationDto findForKey(
			String kCode,
			int    commuteSequence
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode        );
			setParam(index++, commuteSequence);
			executeQuery();
			CmCommutationDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCommutationDto> findForEmployee(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^擾(ʗpgpɂʋΎ蓖vZp)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCommutationDto> findForCommuteData(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_COMMUTE_SEQUENCE + " = " + PayrollConst.COMMUTE_SEQ_2);
			sb.append(" AND ");
			sb.append(COL_DELETE_FLAG      + " = " + PayrollConst.DEFAULT_FLAG_OFF);
			sb.append(" AND ");
			sb.append("(");
			sb.append(COL_COMMUTE_DISTANCE + " <> " + PayrollConst.AMOUNT_ZERO);
			sb.append(" OR ");
			sb.append(COL_COMMUTE_AMOUNT   + " <> " + PayrollConst.AMOUNT_ZERO);
			sb.append(" OR ");
			sb.append(COL_COMMUTE_TAXED    + " <> " + PayrollConst.AMOUNT_ZERO);
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CmCommutationDto> findForUpdate(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CmCommutationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CmCommutationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode          ());
			setParam(index++, dto.getCommuteSequence());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CmCommutationDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode        ());
			setParam(index++, dto.getCommuteSequence());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @return Map (DTOListMap)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public Map<String, List<CmCommutationDto>> findForHumanData(
			) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CmCommutationDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode          ());	// ЈR[h
		setParam(index++, dto.getCommuteSequence());	// ʋΎ蓖A
		setParam(index++, dto.getCommuteType    ());	// ʋΎ蓖敪
		setParam(index++, dto.getPaymentInterval());	// xԊu
		setParam(index++, dto.getLumpMonthlyType());	// ꊇ敪
		setParam(index++, dto.getPayStartMonth  ());	// xJn
		setParam(index++, dto.getCommuteDistance());	// Г
		setParam(index++, dto.getCommuteAmount  ());	// ʋΎ蓖xz
		setParam(index++, dto.getCommuteTaxed   ());	// ېŒʋΔ
		setParam(index++, dto.getDeleteFlag     ());	// 폜tO
		setCommonParams(isInsert);
	}
}

