package jp.mosp.payroll.common.vo;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dto.CdSocInsuranceDto;

public class InsuranceMonthlyCardVo extends MosPVo {

	private static final long serialVersionUID = 3074797893724642112L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/payroll/common/insuranceMonthlyCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/common/js/insuranceMonthlyCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/common/css/insuranceMonthlyCard.css";
	
	// ʃTu^Cg
	public final String SUB_TITLE = PayrollConst.TTL_SANTEI_GEPPEN_SYORI;

	// ̎擾pz
	public	String[][] aryStation ;
	public	String[][] aryPosition;
	public	String[][] aryEra;
	public	String[][] aryRelation;
	
	// ݒe[u
	public	String[]	aryKcode;										//ЈR[he[u
	public	String[][]	aryCode;
	public	List<MosPConfDto> listConf;
	
	// tB[hyѐ
	public		int		dbTableFlg			=	0;						//0:@1:VKf[^ 2:f[^
	public		int		kCodeIndx			=	0;						//ЈR[he[uCfbNX

	public		CdSocInsuranceDto cdSocInsuranceDto = null;
	
	public		InsuranceConfSetVo confVo	=	null;
	private	String	kCode				=	"";						//ЈR[h
	private	String	kName				=	"";						//Ј
	private	String	lblStationCode		=	"";						//R[h
	private	String	lblSection			=	"";						//
	private	String	lblJyouken			=	"";						//\
	// p[^
	public static final String PRM_TXT_CHANGE_K_CODE				= "txtChangeKCode";
	public static final String PRM_HID_K_CODE						= "hidKCode";
	public static final String PRM_HID_TARGET_YEAR				= "hidTargetYear";
	public static final String PRM_HID_TARGET_MONTH				= "hidTargetMonth";

	public static final String PRM_HID_CALC_YEAR					= "hidCalcYear";
	public static final String PRM_HID_CALC_MONTH					= "hidCalcMonth";
	
	public static final String PRM_TXT_PAY_BASIC_MONTH1			= "txtPayBasicMonth1";
	public static final String PRM_TXT_PAY_BASIC_MONTH2			= "txtPayBasicMonth2";
	public static final String PRM_TXT_PAY_BASIC_MONTH3       = "txtPayBasicMonth3";
	public static final String PRM_TXT_PAY_BASIC_DAY1         = "txtPayBasicDay1";
	public static final String PRM_TXT_PAY_BASIC_DAY2         = "txtPayBasicDay2";
	public static final String PRM_TXT_PAY_BASIC_DAY3         = "txtPayBasicDay3";
	public static final String PRM_TXT_PAY_AMOUNT1            = "txtPayAmount1";
	public static final String PRM_TXT_PAY_AMOUNT2            = "txtPayAmount2";
	public static final String PRM_TXT_PAY_AMOUNT3            = "txtPayAmount3";
	public static final String PRM_TXT_GOODS_AMOUNT1          = "txtGoodsAmount1";
	public static final String PRM_TXT_GOODS_AMOUNT2          = "txtGoodsAmount2";
	public static final String PRM_TXT_GOODS_AMOUNT3          = "txtGoodsAmount3";
	public static final String PRM_TXT_REWARD_TOTAL1          = "txtRewardTotal1";
	public static final String PRM_TXT_REWARD_TOTAL2           = "txtRewardTotal2";
	public static final String PRM_TXT_REWARD_TOTAL3           = "txtRewardTotal3";
	public static final String PRM_TXT_REWARD_TOTAL_SUM        = "txtRewardTotalSum";
	public static final String PRM_TXT_AVERAGE_THREE_MONTHS    = "txtAverageThreeMonths";
	public static final String PRM_TXT_EDIT_AVERAGE            = "txtEditAverage";
	public static final String PRM_TXT_HEALTH_BEF_GRADE        = "txtHealthBefGrade";
	public static final String PRM_TXT_HEALTH_BEF_PREMIUM      = "txtHealthBefPremium";
	public static final String PRM_TXT_PENSION_BEF_GRADE       = "txtPensionBefGrade";
	public static final String PRM_TXT_PENSION_BEF_PREMIUM     = "txtPensionBefPremium";
	public static final String PRM_TXT_HEALTH_DEC_GRADE        = "txtHealthDecGrade";
	public static final String PRM_TXT_HEALTH_DEC_PREMIUM      = "txtHealthDecPremium";
	public static final String PRM_TXT_PENSION_DEC_GRADE       = "txtPensionDecGrade";
	public static final String PRM_TXT_PENSION_DEC_PREMIUM     = "txtPensionDecPremium";
	public static final String PRM_TXT_RETROACTIVE_PAYMENT     = "txtRetroactivePayment"  ;
	public static final String PRM_PLT_RAISE_DOWN_SALARY_DATE  = "txtRaiseDownSalaryDate" ;
	public static final String PRM_TXT_RAISE_DOWN_SALARY_BASIS = "txtRaiseDownSalaryBasis";
	public static final String PRM_PLT_EXPECTED_DATE           = "pltExpectedDate"        ;
	public static final String PRM_PLT_CALC_RESULT             = "txtCalcResult"          ;
	
	public static final String PRM_PLT_EXPECTED_YEAR  = "pltExpectedYear" ;
	public static final String PRM_PLT_EXPECTED_MONTH = "pltExpectedMonth";

	public static final String PRM_PLT_RAISE_DOWN_SALARY_YEAR  = "pltRaiseDownSalaryYear" ;
	public static final String PRM_PLT_RAISE_DOWN_SALARY_MONTH = "pltRaiseDownSalaryMonth";

	
	public static final int    LEN_AMOUNT                 = PayrollConst.LEN_MONEY_AMOUNT       ;
	
	public static final String NAM_PAY_BASIC_DATE1         = PayrollConst.NAM_PAY_BASIC_DATE1  ;
	public static final String NAM_PAY_BASIC_DATE2         = PayrollConst.NAM_PAY_BASIC_DATE2  ;
	public static final String NAM_PAY_BASIC_DATE3         = PayrollConst.NAM_PAY_BASIC_DATE3  ;
	public static final String NAM_PAY_AMOUNT1             = PayrollConst.NAM_PAY_AMOUNT1  ;
	public static final String NAM_PAY_AMOUNT2             = PayrollConst.NAM_PAY_AMOUNT2  ;
	public static final String NAM_PAY_AMOUNT3             = PayrollConst.NAM_PAY_AMOUNT3  ;
	public static final String NAM_GOODS_AMOUNT1           = PayrollConst.NAM_GOODS_AMOUNT1  ;
	public static final String NAM_GOODS_AMOUNT2           = PayrollConst.NAM_GOODS_AMOUNT2  ;
	public static final String NAM_GOODS_AMOUNT3           = PayrollConst.NAM_GOODS_AMOUNT3  ;
	public static final String NAM_REWARD_TOTAL1           = PayrollConst.NAM_REWARD_TOTAL1  ;
	public static final String NAM_REWARD_TOTAL2           = PayrollConst.NAM_REWARD_TOTAL2  ;
	public static final String NAM_REWARD_TOTAL3           = PayrollConst.NAM_REWARD_TOTAL3  ;
	public static final String NAM_REWARD_TOTAL_SUM        = PayrollConst.NAM_REWARD_TOTAL_SUM  ;
	public static final String NAM_AVERAGE_THREE_MONTHS    = PayrollConst.NAM_AVERAGE_THREE_MONTHS  ;
	public static final String NAM_EDIT_AVERAGE            = PayrollConst.NAM_EDIT_AVERAGE  ;
	public static final String NAM_HEALTH_BEF_GRADE        = PayrollConst.NAM_HEALTH_BEF_GRADE  ;
	public static final String NAM_HEALTH_BEF_PREMIUM      = PayrollConst.NAM_HEALTH_BEF_PREMIUM  ;
	public static final String NAM_PENSION_BEF_GRADE       = PayrollConst.NAM_PENSION_BEF_GRADE  ;
	public static final String NAM_PENSION_BEF_PREMIUM     = PayrollConst.NAM_PENSION_BEF_PREMIUM  ;
	public static final String NAM_HEALTH_DEC_GRADE        = PayrollConst.NAM_HEALTH_DEC_GRADE  ;
	public static final String NAM_HEALTH_DEC_PREMIUM      = PayrollConst.NAM_HEALTH_DEC_PREMIUM  ;
	public static final String NAM_PENSION_DEC_GRADE       = PayrollConst.NAM_PENSION_DEC_GRADE  ;
	public static final String NAM_PENSION_DEC_PREMIUM     = PayrollConst.NAM_PENSION_DEC_PREMIUM  ;
	public static final String NAM_RETROACTIVE_PAYMENT     = PayrollConst.NAM_RETROACTIVE_PAYMENT  ;
	public static final String NAM_RAISE_DOWN_SALARY_DATE  = PayrollConst.NAM_RAISE_DOWN_SALARY_DATE  ;
	public static final String NAM_RAISE_DOWN_SALARY_BASIS = PayrollConst.NAM_RAISE_DOWN_SALARY_BASIS  ;
	public static final String NAM_EXPECTED_DATE           = PayrollConst.NAM_EXPECTED_DATE  ;
	public static final String NAM_CALC_RESULT             = PayrollConst.NAM_DATA_STAT  ;


	
	// tB[h
	private String txtChangeKCode =	""		;	//ʎЈR[h
	private String hidKCode =	""           	;	//ЈR[h
	
	private String hidTargetYear =	""       	;	//ʓKNiNj
	private String hidTargetMonth =	""      ;	//ʓKNi)
	
	private String lblKenpoNo =	""			;	//Nیؔԍ
	private String lblKonenNo =	""			;	//Nԍ
	private String lblGender =	""				;	//
	private String lblBirthDay =	""			;	//aN
	private String lblStationName =	""      ;	//ʕR[h
//	private String lblKCode =	""            	;	//ʎЈR[h
	private String lblKName =	""            	;	//ʎЈ
	private String lblTargetEra =	""        	;	
	private String lblTargetYear =	""       	;
	private String lblTargetMonth =	""      ;
	
	private String   pltExpectedYear =	"" 		;
	private String   pltExpectedMonth =	""	;
	
	private String   pltRaiseDownSalaryYear =	"";
	private String   pltRaiseDownSalaryMonth =	"";

	
	private String txtPayBasicMonth1 =	""		;
	private String txtPayBasicMonth2 =	""		;
	private String txtPayBasicMonth3 =	""		;
	private String txtPayBasicDay1 =	""		;
	private String txtPayBasicDay2 =	""		;
	private String txtPayBasicDay3 =	""		;
	private String txtPayAmount1 =	""			;
	private String txtPayAmount2 =	""			;
	private String txtPayAmount3 =	""			;
	private String txtGoodsAmount1 =	""		;
	private String txtGoodsAmount2 =	""		;
	private String txtGoodsAmount3 =	""		;
	private String txtRewardTotal1 =	""		;
	private String txtRewardTotal2 =	""		;
	private String txtRewardTotal3 =	""		;
	private String txtRewardTotalSum =	""		;
	private String txtAverageThreeMonths =	""	;
	private String txtEditAverage =	""		;
	private String txtHealthBefGrade =	""		;
	private String txtHealthBefPremium =	""	;
	private String txtPensionBefGrade =	""	;
	private String txtPensionBefPremium =	""	;
	private String txtHealthDecGrade =	""		;
	private String txtHealthDecPremium =	""	;
	private String txtPensionDecGrade =	""	;
	private String txtPensionDecPremium =	""	;
	private String txtRetroactivePayment =	""	;
	private String pltRaiseDownSalaryDate =	"";
	private String txtRaiseDownSalaryBasis =	"";
	private String pltExpectedDate =	""		;
	private String pltCalcResult =	""			;

	private Date     expectedDate    			;
	private Date     raiseDownSalaryDate    	;
	private Date     targetMonth    			;
	
	// v_EXg
	public String[][] aryPltYear        = {
			{"2007","2007"},
			{"2008","2008"},
			{"2009","2009"},
			{"2010","2010"},
			{"2011","2011"}	};

	public String[][] aryPltMonth = {
	{ "1", "1"}, { "2", "2"}, { "3", "3"}, { "4", "4"}, { "5", "5"}, { "6", "6"},
	{ "7", "7"}, { "8", "8"}, { "9", "9"}, {"10","10"}, {"11","11"}, {"12","12"}};
	public String[][] aryPltDay  = {
	{ "1", "1"}, { "2", "2"}, { "3", "3"}, { "4", "4"}, { "5", "5"}, { "6", "6"}, { "7", "7"}, { "8", "8"}, { "9", "9"}, {"10","10"},
	{"11","11"}, {"12","12"}, {"13","13"}, {"14","14"}, {"15","15"}, {"16","16"}, {"17","17"}, {"18","18"}, {"19","19"}, {"20","20"},
	{"21","21"}, {"22","22"}, {"23","23"}, {"24","24"}, {"25","25"}, {"26","26"}, {"27","27"}, {"28","28"}, {"29","29"}, {"30","30"},
	{"31","31"}};

	public String[][] aryPltStationCode;
	public String[][] aryPltCalcResult = {
			{ PayrollConst.CODE_SANTEI_GEPPENN_NO_REG, PayrollConst.NAME_SANTEI_GEPPENN_NO_REG },	//ZEϖo^
			{ PayrollConst.CODE_SANTEI_SYORI_WAIT,     PayrollConst.NAME_SANTEI_SYORI_WAIT     },	//ZK
			{ PayrollConst.CODE_SANTEI_SYORI_COMP,     PayrollConst.NAME_SANTEI_SYORI_COMP     },	//ZK
			{ PayrollConst.CODE_GEPPENN_SYORI_WAIT,    PayrollConst.NAME_GEPPENN_SYORI_WAIT    },	//ϓK
			{ PayrollConst.CODE_GEPPENN_SYORI_COMP,    PayrollConst.NAME_GEPPENN_SYORI_COMP    }, 	//ϓK
			{ PayrollConst.CODE_SANTEI_GEPPENN_MUKOU,  PayrollConst.NAME_SANTEI_GEPPENN_MUKOU  } 	//ϓK
	};	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtChangeKCode			= request.getParameter(PRM_TXT_CHANGE_K_CODE		);
//		hidKCode            	= request.getParameter(PRM_HID_K_CODE            	);
		hidTargetYear       	= request.getParameter(PRM_HID_TARGET_YEAR       	);
		hidTargetMonth      	= request.getParameter(PRM_HID_TARGET_MONTH      	);
		
		txtPayBasicMonth1       = request.getParameter(PRM_TXT_PAY_BASIC_MONTH1       );
		txtPayBasicMonth2       = request.getParameter(PRM_TXT_PAY_BASIC_MONTH2       );
		txtPayBasicMonth3       = request.getParameter(PRM_TXT_PAY_BASIC_MONTH3       );
		txtPayBasicDay1         = request.getParameter(PRM_TXT_PAY_BASIC_DAY1         );
		txtPayBasicDay2         = request.getParameter(PRM_TXT_PAY_BASIC_DAY2         );
		txtPayBasicDay3         = request.getParameter(PRM_TXT_PAY_BASIC_DAY3         );
		txtPayAmount1           = request.getParameter(PRM_TXT_PAY_AMOUNT1            );
		txtPayAmount2           = request.getParameter(PRM_TXT_PAY_AMOUNT2            );
		txtPayAmount3           = request.getParameter(PRM_TXT_PAY_AMOUNT3            );
		txtGoodsAmount1         = request.getParameter(PRM_TXT_GOODS_AMOUNT1          );
		txtGoodsAmount2         = request.getParameter(PRM_TXT_GOODS_AMOUNT2          );
		txtGoodsAmount3         = request.getParameter(PRM_TXT_GOODS_AMOUNT3          );
		txtRewardTotal1         = request.getParameter(PRM_TXT_REWARD_TOTAL1          );
		txtRewardTotal2         = request.getParameter(PRM_TXT_REWARD_TOTAL2          );
		txtRewardTotal3         = request.getParameter(PRM_TXT_REWARD_TOTAL3          );
		txtRewardTotalSum       = request.getParameter(PRM_TXT_REWARD_TOTAL_SUM       );
		txtAverageThreeMonths   = request.getParameter(PRM_TXT_AVERAGE_THREE_MONTHS   );
		txtEditAverage          = request.getParameter(PRM_TXT_EDIT_AVERAGE           );
		txtRetroactivePayment   = request.getParameter(PRM_TXT_RETROACTIVE_PAYMENT    );
		txtRaiseDownSalaryBasis = request.getParameter(PRM_TXT_RAISE_DOWN_SALARY_BASIS);
		pltExpectedYear         = request.getParameter(PRM_PLT_EXPECTED_YEAR          );
		pltExpectedMonth        = request.getParameter(PRM_PLT_EXPECTED_MONTH         );
		pltRaiseDownSalaryYear  = request.getParameter(PRM_PLT_RAISE_DOWN_SALARY_YEAR );
		pltRaiseDownSalaryMonth = request.getParameter(PRM_PLT_RAISE_DOWN_SALARY_MONTH);
		
		
		if (pltRaiseDownSalaryYear == null || pltRaiseDownSalaryYear.equals("")) {
			pltRaiseDownSalaryYear  = "1901";
			pltRaiseDownSalaryMonth = "01";
		}

		if(confVo.getIdButtonJyouken().equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_KCODE)){			// WI{^uЈvI
			lblJyouken		=	PayrollConst.NAME_JYUNJYO_KCODE;			//Ј
		} else if(confVo.getIdButtonJyouken().equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_BUSHO)){	// WI{^uvI
			lblJyouken		= 	PayrollConst.NAME_JYUNJYO_BUSHO;			//
		} else if(confVo.getIdButtonJyouken().equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_KENPO)){	// WI{^uۏvI
			lblJyouken		= 	PayrollConst.NAME_JYUNJYO_KENPO;			//ۏ
		} else if(confVo.getIdButtonJyouken().equals(InsuranceConfSetVo.PRM_CKR_JYUNJYO_KOUNEN)){	// WI{^uNvI
			lblJyouken		= 	PayrollConst.NAME_JYUNJYO_KOUNEN;			//N
		}else{
			lblJyouken		= "";
		}
	}	
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		checkLength(txtPayAmount1          , LEN_AMOUNT, NAM_PAY_AMOUNT1            , PRM_TXT_PAY_AMOUNT1            );
		checkLength(txtPayAmount2          , LEN_AMOUNT, NAM_PAY_AMOUNT2            , PRM_TXT_PAY_AMOUNT2            );
		checkLength(txtPayAmount3          , LEN_AMOUNT, NAM_PAY_AMOUNT3            , PRM_TXT_PAY_AMOUNT3            );
		checkLength(txtGoodsAmount1        , LEN_AMOUNT, NAM_GOODS_AMOUNT1          , PRM_TXT_GOODS_AMOUNT1          );
		checkLength(txtGoodsAmount2        , LEN_AMOUNT, NAM_GOODS_AMOUNT2          , PRM_TXT_GOODS_AMOUNT2          );
		checkLength(txtGoodsAmount3        , LEN_AMOUNT, NAM_GOODS_AMOUNT3          , PRM_TXT_GOODS_AMOUNT3          );
		checkLength(txtRewardTotal1        , LEN_AMOUNT, NAM_REWARD_TOTAL1          , PRM_TXT_REWARD_TOTAL1          );
		checkLength(txtRewardTotal2        , LEN_AMOUNT, NAM_REWARD_TOTAL2          , PRM_TXT_REWARD_TOTAL2          );
		checkLength(txtRewardTotal3        , LEN_AMOUNT, NAM_REWARD_TOTAL3          , PRM_TXT_REWARD_TOTAL3          );
		checkLength(txtRewardTotalSum      , LEN_AMOUNT, NAM_REWARD_TOTAL_SUM       , PRM_TXT_REWARD_TOTAL_SUM       );
		checkLength(txtAverageThreeMonths  , LEN_AMOUNT, NAM_AVERAGE_THREE_MONTHS   , PRM_TXT_AVERAGE_THREE_MONTHS   );
		checkLength(txtEditAverage         , LEN_AMOUNT, NAM_EDIT_AVERAGE           , PRM_TXT_EDIT_AVERAGE           );
		checkLength(txtHealthBefGrade      , LEN_AMOUNT, NAM_HEALTH_BEF_GRADE       , PRM_TXT_HEALTH_BEF_GRADE       );
		checkLength(txtHealthBefPremium    , LEN_AMOUNT, NAM_HEALTH_BEF_PREMIUM     , PRM_TXT_HEALTH_BEF_PREMIUM     );
		checkLength(txtPensionBefGrade     , LEN_AMOUNT, NAM_PENSION_BEF_GRADE      , PRM_TXT_PENSION_BEF_GRADE      );
		checkLength(txtPensionBefPremium   , LEN_AMOUNT, NAM_PENSION_BEF_PREMIUM    , PRM_TXT_PENSION_BEF_PREMIUM    );
		checkLength(txtHealthDecGrade      , LEN_AMOUNT, NAM_HEALTH_DEC_GRADE       , PRM_TXT_HEALTH_DEC_GRADE       );
		checkLength(txtHealthDecPremium    , LEN_AMOUNT, NAM_HEALTH_DEC_PREMIUM     , PRM_TXT_HEALTH_DEC_PREMIUM     );
		checkLength(txtPensionDecGrade     , LEN_AMOUNT, NAM_PENSION_DEC_GRADE      , PRM_TXT_PENSION_DEC_GRADE      );
		checkLength(txtPensionDecPremium   , LEN_AMOUNT, NAM_PENSION_DEC_PREMIUM    , PRM_TXT_PENSION_DEC_PREMIUM    );
		checkLength(txtRetroactivePayment  , LEN_AMOUNT, NAM_RETROACTIVE_PAYMENT    , PRM_TXT_RETROACTIVE_PAYMENT    );
		checkLength(txtRaiseDownSalaryBasis, LEN_AMOUNT, NAM_RAISE_DOWN_SALARY_BASIS, PRM_TXT_RAISE_DOWN_SALARY_BASIS);
		
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ
	 * @param dto 
	 * @throws MospException 
	 */
	public void setFields(Employee employee, CdSocInsuranceDto dto) throws MospException {
		this.cdSocInsuranceDto	=	  dto;	//ЉیvZf[^CX^X̑ޔ
		nextKcode(employee);				//VOێ̐lݒ

		txtPayBasicMonth1       = 	String.valueOf(dto.getPayBasicMonth1());
		txtPayBasicMonth2       = 	String.valueOf(dto.getPayBasicMonth2());
		txtPayBasicMonth3       = 	String.valueOf(dto.getPayBasicMonth3());
		txtPayBasicDay1         = 	String.valueOf(dto.getPayBasicDay1	());
		txtPayBasicDay2         = 	String.valueOf(dto.getPayBasicDay2	());
		txtPayBasicDay3         = 	String.valueOf(dto.getPayBasicDay3	());

		txtPayAmount1           = 	String.valueOf(dto.getPayAmount1	());
		txtPayAmount2           = 	String.valueOf(dto.getPayAmount2	());
		txtPayAmount3           = 	String.valueOf(dto.getPayAmount3	());
		txtGoodsAmount1         = 	String.valueOf(dto.getGoodsAmount1	());
		txtGoodsAmount2         = 	String.valueOf(dto.getGoodsAmount2	());
		txtGoodsAmount3         = 	String.valueOf(dto.getGoodsAmount3	());
		txtRewardTotal1         = 	String.valueOf(dto.getRewardTotal1	());
		txtRewardTotal2         = 	String.valueOf(dto.getRewardTotal2	());
		txtRewardTotal3         = 	String.valueOf(dto.getRewardTotal3	());
		txtRewardTotalSum       = 	String.valueOf(dto.getRewardTotalSum	());
		txtAverageThreeMonths   = 	String.valueOf(dto.getAverageThreeMonths	());
		txtEditAverage          = 	String.valueOf(dto.getEditAverage	());
		txtHealthBefGrade       = 	String.valueOf(dto.getHealthBefGrade	());
		txtHealthBefPremium     = 	String.valueOf(dto.getHealthBefPremium	());
		txtPensionBefGrade      = 	String.valueOf(dto.getPensionBefGrade	());
		txtPensionBefPremium    = 	String.valueOf(dto.getPensionBefPremium	());
		txtHealthDecGrade       = 	String.valueOf(dto.getHealthDecGrade	());
		txtHealthDecPremium     = 	String.valueOf(dto.getHealthDecPremium	());
		txtPensionDecGrade      = 	String.valueOf(dto.getPensionDecGrade	());
		txtPensionDecPremium    = 	String.valueOf(dto.getPensionDecPremium	());
		txtRetroactivePayment   = 	String.valueOf(dto.getRetroactivePayment	());
		pltRaiseDownSalaryDate  = 	String.valueOf(dto.getRaiseDownSalaryDate	());
		txtRaiseDownSalaryBasis = 	String.valueOf(dto.getRaiseDownSalaryBasis	());
		pltExpectedDate         = 	String.valueOf(dto.getExpectedDate	());

		if(dto.getCalcResult() == 1){
			pltCalcResult		=  PayrollConst.NAME_SANTEI_SYORI_WAIT;	//ZK
		}else if(dto.getCalcResult() == 2){
			pltCalcResult		=  PayrollConst.NAME_SANTEI_SYORI_COMP;	//ZK
		}else if(dto.getCalcResult() == 3){
			pltCalcResult		=  PayrollConst.NAME_GEPPENN_SYORI_WAIT;	//ϓK
		}else if(dto.getCalcResult() == 4){
			pltCalcResult		=  PayrollConst.NAME_GEPPENN_SYORI_COMP;	//ϓK
		}else{
			pltCalcResult		=  PayrollConst.NAME_SANTEI_GEPPENN_NO_REG;	//o^
		}
		
		pltExpectedYear         =   String.valueOf(MospUtility.getYear(dto.getExpectedDate()));
		pltExpectedMonth        =   String.valueOf(MospUtility.getMonth(dto.getExpectedDate()));

		pltRaiseDownSalaryYear  =   String.valueOf(MospUtility.getYear(dto.getRaiseDownSalaryDate()));
		pltRaiseDownSalaryMonth =   String.valueOf(MospUtility.getMonth(dto.getRaiseDownSalaryDate()));
		if (pltRaiseDownSalaryYear.equals("1901")) {
			pltRaiseDownSalaryYear  =   "";
			pltRaiseDownSalaryMonth =   "";
		}
		lblKenpoNo				=	employee.getKenpoNo();		//Nیؔԍݒ
		lblKonenNo				=	employee.getKohoNo();		//Nԍݒ
		if(employee.getGender().equals(PayrollConst.CODE_GENDER_MAN)){	//ʔ
			lblGender				=	PayrollConst.NAME_GENDER_MAN;	//jݒ
		}else{
			lblGender				=	PayrollConst.NAME_GENDER_WOMAN;	//ݒ
		}
		lblBirthDay	=	getDateString(listConf, aryEra, employee.getBirthDate());
	
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * @throws MospException 
	 */
	public void setDtoFields(CdSocInsuranceDto dto) throws MospException {
		raiseDownSalaryDate = getDate(pltRaiseDownSalaryYear, pltRaiseDownSalaryMonth, String.valueOf(PayrollConst.TIME_DEFAULT_DAY));
		expectedDate = getDate(pltExpectedYear, pltExpectedMonth, String.valueOf(PayrollConst.TIME_DEFAULT_DAY));

		dto.setPayBasicMonth1      (getIntParam(txtPayBasicMonth1    ));
		dto.setPayBasicMonth2      (getIntParam(txtPayBasicMonth2    ));
		dto.setPayBasicMonth3      (getIntParam(txtPayBasicMonth3    ));
		dto.setPayBasicDay1        (getIntParam(txtPayBasicDay1      ));
		dto.setPayBasicDay2        (getIntParam(txtPayBasicDay2      ));
		dto.setPayBasicDay3        (getIntParam(txtPayBasicDay3      ));

		dto.setPayAmount1          (getIntParam(txtPayAmount1        ));
		dto.setPayAmount2          (getIntParam(txtPayAmount2        ));
		dto.setPayAmount3          (getIntParam(txtPayAmount3        ));
		dto.setGoodsAmount1        (getIntParam(txtGoodsAmount1      ));
		dto.setGoodsAmount2        (getIntParam(txtGoodsAmount2      ));
		dto.setGoodsAmount3        (getIntParam(txtGoodsAmount3      ));
		dto.setRewardTotal1        (getIntParam(txtRewardTotal1      ));
		dto.setRewardTotal2        (getIntParam(txtRewardTotal2      ));
		dto.setRewardTotal3        (getIntParam(txtRewardTotal3      ));
		dto.setRewardTotalSum      (getIntParam(txtRewardTotalSum    ));
		dto.setAverageThreeMonths  (getIntParam(txtAverageThreeMonths));
		dto.setEditAverage         (getIntParam(txtEditAverage       ));
		dto.setHealthBefGrade      (getIntParam(txtHealthBefGrade    ));
		dto.setHealthBefPremium    (getIntParam(txtHealthBefPremium  ));
		dto.setPensionBefGrade     (getIntParam(txtPensionBefGrade   ));
		dto.setPensionBefPremium   (getIntParam(txtPensionBefPremium ));
		dto.setHealthDecGrade      (getIntParam(txtHealthDecGrade    ));
		dto.setHealthDecPremium    (getIntParam(txtHealthDecPremium  ));
		dto.setPensionDecGrade     (getIntParam(txtPensionDecGrade   ));
		dto.setPensionDecPremium   (getIntParam(txtPensionDecPremium ));
		dto.setRetroactivePayment  (getIntParam(txtRetroactivePayment));
		dto.setRaiseDownSalaryDate (raiseDownSalaryDate                 );
		dto.setRaiseDownSalaryBasis(getIntParam(txtRaiseDownSalaryBasis));
		dto.setExpectedDate        (expectedDate                        );
		dto.setCalcResult          (getIntParam(pltCalcResult          ));

	}

	/**
	 * Ώ۔Nݒ
	 * @param targetMonth ݒΏ۔N
	 * @param listConf    a
	 * @param aryCode     R[h̔z
	 * @throws MospException
	 */
	public void setTargetMonth( Date targetMonth ) throws MospException {
		String[] strTargetMonth = getJpImperialCal(listConf, targetMonth);
		this.targetMonth    = getDateField(targetMonth);
		this.hidTargetYear  = getStrYear  (targetMonth);
		this.hidTargetMonth = getStrMonth (targetMonth);
		this.lblTargetEra   = getCodeName(strTargetMonth[0], aryCode);
		this.lblTargetYear  = strTargetMonth[1];
		this.lblTargetMonth = strTargetMonth[2];
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}


/*************************************************************************/	
	/**
	 * RXgN^
	 */
	public InsuranceMonthlyCardVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * VOڏݒ
	 */
	public void initAll() {
		
	}

	/**
	 * ЈR[h̐ݒ聕擾
	 */
	public void nextKcode(Employee employee){
		kCode			=	employee.getKCode();			//ЈR[h
		kName			=	employee.getKName();			//Ј
		lblStationCode	=	employee.getSectionCode();		//R[h
		lblSection		=	employee.getSectionName();		//

	}
	

	// ANZT\bhisetj
	public void	setConfVo( InsuranceConfSetVo vo) 		{ this.confVo			=	vo;						}	//ZEϏݒVO̎擾ݒ
	public void	setLblStationCode(String StationCode)	{ this.lblStationCode	=	StationCode;	}	//R[h̐ݒ
	public void	setLblKenpoNo(String lblKenpoNo)		{ this.lblKenpoNo		=	lblKenpoNo; } //Nیؔԍ擾
	public void	setLblKonenNo(String lblKonenNo)		{ this.lblKonenNo		=	lblKonenNo; } //Nԍ擾

	//ANZT\bhisetjbase
	public void setLblStationName      (String lblStationName      ) { this.lblStationName       = lblStationName      ;}
//	public void setLblKCode            (String lblKCode            ) { this.lblKCode             = lblKCode            ;}
	public void setLblKName            (String lblKName            ) { this.lblKName             = lblKName            ;}
	public void setLblTargetEra        (String lblTargetEra        ) { this.lblTargetEra         = lblTargetEra        ;}
	public void setLblTargetYear       (String lblTargetYear       ) { this.lblTargetYear        = lblTargetYear       ;}
	public void setLblTargetMonth      (String lblTargetMonth      ) { this.lblTargetMonth       = lblTargetMonth      ;}

	public void setTxtPayBasicMonth1       (String txtPayBasicMonth1    ) { this.txtPayBasicMonth1        = txtPayBasicMonth1     ; }
	public void setTxtPayBasicMonth2       (String txtPayBasicMonth2    ) { this.txtPayBasicMonth2        = txtPayBasicMonth2     ; }
	public void setTxtPayBasicMonth3       (String txtPayBasicMonth3    ) { this.txtPayBasicMonth3        = txtPayBasicMonth3     ; }
	public void setTxtPayBasicDay1        (String txtPayBasicDay1       ) { this.txtPayBasicDay1          = txtPayBasicDay1       ; }
	public void setTxtPayBasicDay2        (String txtPayBasicDay2       ) { this.txtPayBasicDay2          = txtPayBasicDay2       ; }
	public void setTxtPayBasicDay3        (String txtPayBasicDay3       ) { this.txtPayBasicDay3          = txtPayBasicDay3       ; }

	
	public void setTxtPayAmount1          (String txtPayAmount1          ) { this.txtPayAmount1           = txtPayAmount1          ; }
	public void setTxtPayAmount2          (String txtPayAmount2          ) { this.txtPayAmount2           = txtPayAmount2          ; }
	public void setTxtPayAmount3          (String txtPayAmount3          ) { this.txtPayAmount3           = txtPayAmount3          ; }
	public void setTxtGoodsAmount1        (String txtGoodsAmount1        ) { this.txtGoodsAmount1         = txtGoodsAmount1        ; }
	public void setTxtGoodsAmount2        (String txtGoodsAmount2        ) { this.txtGoodsAmount2         = txtGoodsAmount2        ; }
	public void setTxtGoodsAmount3        (String txtGoodsAmount3        ) { this.txtGoodsAmount3         = txtGoodsAmount3        ; }
	public void setTxtRewardTotal1        (String txtRewardTotal1        ) { this.txtRewardTotal1         = txtRewardTotal1        ; }
	public void setTxtRewardTotal2        (String txtRewardTotal2        ) { this.txtRewardTotal2         = txtRewardTotal2        ; }
	public void setTxtRewardTotal3        (String txtRewardTotal3        ) { this.txtRewardTotal3         = txtRewardTotal3        ; }
	public void setTxtRewardTotalSum      (String txtRewardTotalSum      ) { this.txtRewardTotalSum       = txtRewardTotalSum      ; }
	public void setTxtAverageThreeMonths  (String txtAverageThreeMonths  ) { this.txtAverageThreeMonths   = txtAverageThreeMonths  ; }
	public void setTxtEditAverage         (String txtEditAverage         ) { this.txtEditAverage          = txtEditAverage         ; }
	public void setTxtHealthBefGrade      (String txtHealthBefGrade      ) { this.txtHealthBefGrade       = txtHealthBefGrade      ; }
	public void setTxtHealthBefPremium    (String txtHealthBefPremium    ) { this.txtHealthBefPremium     = txtHealthBefPremium    ; }
	public void setTxtPensionBefGrade     (String txtPensionBefGrade     ) { this.txtPensionBefGrade      = txtPensionBefGrade     ; }
	public void setTxtPensionBefPremium   (String txtPensionBefPremium   ) { this.txtPensionBefPremium    = txtPensionBefPremium   ; }
	public void setTxtHealthDecGrade      (String txtHealthDecGrade      ) { this.txtHealthDecGrade       = txtHealthDecGrade      ; }
	public void setTxtHealthDecPremium    (String txtHealthDecPremium    ) { this.txtHealthDecPremium     = txtHealthDecPremium    ; }
	public void setTxtPensionDecGrade     (String txtPensionDecGrade     ) { this.txtPensionDecGrade      = txtPensionDecGrade     ; }
	public void setTxtPensionDecPremium   (String txtPensionDecPremium   ) { this.txtPensionDecPremium    = txtPensionDecPremium   ; }
	public void setTxtRetroactivePayment  (String txtRetroactivePayment  ) { this.txtRetroactivePayment   = txtRetroactivePayment  ; }
	public void setPltRaiseDownSalaryDate (String pltRaiseDownSalaryDate ) { this.pltRaiseDownSalaryDate  = pltRaiseDownSalaryDate ; }
	public void setTxtRaiseDownSalaryBasis(String txtRaiseDownSalaryBasis) { this.txtRaiseDownSalaryBasis = txtRaiseDownSalaryBasis; }
	public void setPltExpectedDate        (String pltExpectedDate        ) { this.pltExpectedDate         = pltExpectedDate        ; }
	public void setPltCalcResult          (String pltCalcResult          ) { this.pltCalcResult           = pltCalcResult          ; }
	
	public void setPltExpectedYear (String pltExpectedYear ) { this.pltExpectedYear  = pltExpectedYear ; }
	public void setPltExpectedMonth(String pltExpectedMonth) { this.pltExpectedMonth = pltExpectedMonth; }
	public void setPltRaiseDownSalaryYear (String pltRaiseDownSalaryYear ) { this.pltRaiseDownSalaryYear  = pltRaiseDownSalaryYear ; }
	public void setPltRaiseDownSalaryMonth(String pltRaiseDownSalaryMonth) { this.pltRaiseDownSalaryMonth = pltRaiseDownSalaryMonth; }
	
	

	// ANZT\bhigetj
	public String getEscLblKCode				()	{ return escapeHTML(kCode				)	;	}	//ЈR[h̎擾
	public String getEscLblKName				()	{ return escapeHTML(kName				)	;	}	//Ј̎擾
	public String getEscLblStationCode			()	{ return escapeHTML(lblStationCode      )	;	}	//R[h̎擾
	public String getEscLblStationName			()	{ return escapeHTML(lblSection      		);	}	//̎擾
	public String getEscLblTargetEra        	()	{ return escapeHTML(lblTargetEra		)	; }	//ZJnaN
	public String getEscLblTargetYear			()	{ return escapeHTML(lblTargetYear		)	; } //N(N)擾
	public String getEscLblTargetMonth			()	{ return escapeHTML(lblTargetMonth		)	; }	//N()擾
	public String getEscLblJyouken				()	{ return escapeHTML(lblJyouken			)	; } //\擾
	public String getEscLblKenpoNo				()	{ return escapeHTML(lblKenpoNo			)	; } //Nیؔԍ擾
	public String getEscLblKonenNo				()	{ return escapeHTML(lblKonenNo			)	; } //Nԍ擾
	public String getEscLblGender				()	{ return escapeHTML(lblGender			)	; } //ʁij
	public String getEscLblBirthDay				()	{ return escapeHTML(lblBirthDay			)	; }	//aN

	// ANZT\bhigetjbase
	public String getLblStationCode				() { return lblStationCode						; }
	public String getLblStationName				() { return lblStationName						; }
//	public String getLblKCode					() { return lblKCode							; }
	public String getLblKName					() { return lblKName							; }
	public String getLblTargetEra				() { return lblTargetEra						; }
	public String getLblTargetYear				() { return lblTargetYear						; }
	public String getLblTargetMonth				() { return lblTargetMonth						; }
	public Date   getTargetMonth				() { return getDateField(targetMonth)			; }

	public String getEscHidTargetYear			() { return escapeHTML(hidTargetYear       ); }
	public String getEscHidTargetMonth			() { return escapeHTML(hidTargetMonth      ); }
	public String getEscHidKCode               () { return escapeHTML(hidKCode)               ; }
	public String getEscTxtPayBasicMonth1      () { return escapeHTML(txtPayBasicMonth1)      ; }
	public String getEscTxtPayBasicMonth2      () { return escapeHTML(txtPayBasicMonth2)      ; }
	public String getEscTxtPayBasicMonth3      () { return escapeHTML(txtPayBasicMonth3)      ; }
	public String getEscTxtPayBasicDay1        () { return escapeHTML(txtPayBasicDay1  )      ; }
	public String getEscTxtPayBasicDay2        () { return escapeHTML(txtPayBasicDay2  )      ; }
	public String getEscTxtPayBasicDay3        () { return escapeHTML(txtPayBasicDay3  )      ; }
	public String getEscTxtPayAmount1          () { return escapeHTML(txtPayAmount1    )      ; }
	public String getEscTxtPayAmount2          () { return escapeHTML(txtPayAmount2    )      ; }
	public String getEscTxtPayAmount3          () { return escapeHTML(txtPayAmount3    )      ; }
	public String getEscTxtGoodsAmount1        () { return escapeHTML(txtGoodsAmount1  )      ; }
	public String getEscTxtGoodsAmount2        () { return escapeHTML(txtGoodsAmount2  )      ; }
	public String getEscTxtGoodsAmount3        () { return escapeHTML(txtGoodsAmount3  )      ; }
	public String getEscTxtRewardTotal1        () { return escapeHTML(txtRewardTotal1  )      ; }
	public String getEscTxtRewardTotal2        () { return escapeHTML(txtRewardTotal2  )      ; }
	public String getEscTxtRewardTotal3        () { return escapeHTML(txtRewardTotal3  )      ; }
	public String getEscTxtRewardTotalSum      () { return escapeHTML(txtRewardTotalSum)      ; }
	public String getEscTxtAverageThreeMonths  () { return escapeHTML(txtAverageThreeMonths)  ; }
	public String getEscTxtEditAverage         () { return escapeHTML(txtEditAverage  )       ; }
	public String getEscTxtHealthBefGrade      () { return escapeHTML(txtHealthBefGrade)      ; }
	public String getEscTxtHealthBefPremium    () { return escapeHTML(txtHealthBefPremium)    ; }
	public String getEscTxtPensionBefGrade     () { return escapeHTML(txtPensionBefGrade)     ; }
	public String getEscTxtPensionBefPremium   () { return escapeHTML(txtPensionBefPremium)   ; }
	public String getEscTxtHealthDecGrade      () { return escapeHTML(txtHealthDecGrade)      ; }
	public String getEscTxtHealthDecPremium    () { return escapeHTML(txtHealthDecPremium)    ; }
	public String getEscTxtPensionDecGrade     () { return escapeHTML(txtPensionDecGrade)     ; }
	public String getEscTxtPensionDecPremium   () { return escapeHTML(txtPensionDecPremium)   ; }
	public String getEscTxtRetroactivePayment  () { return escapeHTML(txtRetroactivePayment)  ; }
	public String getEscPltRaiseDownSalaryDate () { return escapeHTML(pltRaiseDownSalaryDate) ; }
	public String getEscTxtRaiseDownSalaryBasis() { return escapeHTML(txtRaiseDownSalaryBasis); }
	public String getEscPltExpectedDate        () { return escapeHTML(pltExpectedDate )       ; }
	public String getEscPltCalcResult          () { return escapeHTML(pltCalcResult   )       ; }
	
	public String getTxtChangeKCode				()	{ return txtChangeKCode						; }
	public String getHidTargetYear				()	{ return hidTargetYear						; }
	public String getHidTargetMonth				()	{ return hidTargetMonth						; }
	
	public String getPltExpectedYear			()	{ return pltExpectedYear					; }
	public String getPltExpectedMonth			()	{ return pltExpectedMonth					; }
	public String getPltRaiseDownSalaryYear		()	{ return pltRaiseDownSalaryYear				; }
	public String getPltRaiseDownSalaryMonth	()	{ return pltRaiseDownSalaryMonth			; }
	

}
