package jp.mosp.payroll.common.action;

import java.sql.SQLException;
import java.util.Date;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.FirmBankingOutputVo;
import jp.mosp.payroll.common.vo.RetireDetailCardVo;
import jp.mosp.payroll.dao.CtRetireDetailDao;
import jp.mosp.payroll.dto.CtRetireDetailDto;

public class RetireDetailCardAction extends MosPAction{
	// R}h
	
	private static final String CMD_RETIRE_DETAIL_SHOW   = "P9901";
	private static final String CMD_RETIRE_DETAIL_REGIST = "P9902";
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾yѐݒ
		// VO̎擾
		RetireDetailCardVo vo = new RetireDetailCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		setVo(vo);
		setUrl(vo.getRetUrl());
		// aݒ擾
		vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
		// ٓLz
		vo.aryPltCityChanges = PayrollConst.getCityChangesArray();
		vo.aryEra      = getCodeArray(PayrollConst.TID_JAPANESE);
		// NGXg̐ݒ
		vo.setParams(request);
		// ސEהNݒ
		setDetailMonth(vo);
		// R}h̏
		if (cmd.equals(CMD_RETIRE_DETAIL_SHOW)) {
			
			// VO̎擾yѐݒ
			FirmBankingOutputVo vo1 = new FirmBankingOutputVo();
			vo1 =  (FirmBankingOutputVo)getStoredVo(vo1.getClassName());
			vo1.setParams(request);
			show();
		} else if (cmd.equals(CMD_RETIRE_DETAIL_REGIST)) {
			regist(vo);
			
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * \
	 * @param vo
	 * @throws Exception
	 */
	private void show () throws Exception {
		// 
	}
	
	/**
	 * o^
	 * @param vo
	 * @throws MospException
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	private void regist(RetireDetailCardVo vo) throws MospException, SQLException, IllegalAccessException, NoSuchFieldException {
		// p[^̑ÓmF
		vo.validate();
		// Ώ۔N̐ݒ
		Date targetMonth = vo.getDate(vo.getPltSpecifyYear(), vo.getPltSpecifyMonth(), vo.getPltSpecifyDay());
		// DAO
		CtRetireDetailDao  ctRetireDetailDao = new CtRetireDetailDao();
		ctRetireDetailDao .initDao(cfg, cmd, aspUser, user, conn);
		// ݒÑf[^݊mF
		CtRetireDetailDto ctRetireDetailDto = ctRetireDetailDao.findForKey(vo.getTxtCityCode(), targetMonth);
		if (ctRetireDetailDto == null) {
			ctRetireDetailDto = new CtRetireDetailDto();
			// DTOɐݒ
			vo.setDtoFields(ctRetireDetailDto);
			ctRetireDetailDto.setDetailMonth(targetMonth);
			// o^
			ctRetireDetailDao.insert(ctRetireDetailDto);
		} else {
			// DTOɐݒ
			vo.setDtoFields(ctRetireDetailDto);
			ctRetireDetailDto.setDetailMonth(targetMonth);
			// XV
			ctRetireDetailDao.update(ctRetireDetailDto);

			
		}
		// R~bg
		commit();
		// bZ[W̕\
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		
		
	}
	
	/**
	 * Ώ۔N̐ݒ
	 * @param vo
	 * @throws MospException
	 */
	private void setDetailMonth(RetireDetailCardVo vo) throws MospException {
		// Ώ۔N̐ݒ
		Date targetMonth = vo.getDate(vo.getPltSpecifyYear(), vo.getPltSpecifyMonth(), vo.getPltSpecifyDay());
		// a̐ݒ
		vo.setJpDetailMonth(targetMonth);
	}


}
