package jp.mosp.payroll.common.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAuthorityDto;
import jp.mosp.common.vo.MosPMenuVo;

public class PayrollMenuAction extends PayrollMenuArrangeAction {

	// R}h萔
	public static final String CMD_SHOW = MospConst.CMD_MENU;

	/**
	 * RXgN^
	 */
	public PayrollMenuAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// ۑVO
		initStoredData();
		// VȌ
		MosPMenuVo vo = new MosPMenuVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VO̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		CmAuthorityDto dto = getUserAuthDto();
		String component = "";
		// R}h̏
		if (cmd.equals(CMD_SHOW) || cmd.equals(vo.CMD_MENU_INPUT)) {
			component = getEmployeeComponent(dto);
			// \^Cg̐ݒ
			vo.setTitle(CommonConst.TTL_MENU_INPUT);
		} else if (cmd.equals(vo.CMD_MENU_MAMAGE)) {
			component = getManagerComponent(dto);
			// \^Cg̐ݒ
			vo.setTitle(CommonConst.TTL_MENU_MANAGE);
		} else if (cmd.equals(vo.CMD_MENU_PAYROLL)) {
			component = getPayrollComponent(dto);
			// \^Cg̐ݒ
			vo.setTitle(CommonConst.TTL_MENU_PAYROLL);
		} else if (cmd.equals(vo.CMD_MENU_HUMAN)) {
			component = getHumanComponent(dto);
			// \^Cg̐ݒ
			vo.setTitle(CommonConst.TTL_MENU_HUMAN);
		} else if (cmd.equals(vo.CMD_MENU_SYSTEM2)) {
			component = convAryToComponent(getSystemCmdArray());
			// CSS̐ݒ
			vo.setCommonCss(CommonConst.CSS_ADMIN);
			vo.setMode(MosPMenuVo.MODE_ADMIN);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
		user.setCommonCss(vo.getCommonCss());
		vo.setFields(component, combineAllCmdArray());
	}

}
