package jp.mosp.payroll.common.action;

import java.util.Date;

import jp.mosp.payroll.common.vo.FirmBankingOutputVo;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

public class FirmBankingOutputAction extends PayrollAction{
	// R}h
	
	private static final String CMD_FIRM_BANKING_SHOW         = "P9001";
	private static final String CMD_FIRM_BANKING_SELECT      = "U3181";
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾yѐݒ
		FirmBankingOutputVo vo = new FirmBankingOutputVo();
		vo = (FirmBankingOutputVo)getStoredVo(vo.getClassName());
		if (vo == null || cmd.equals(CMD_FIRM_BANKING_SHOW)) {
			vo = new FirmBankingOutputVo();
			storeVo(vo.getClassName(), vo);
		}
		// VOyуtH[hURL̐ݒ
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();

		
		setVo(vo);
		setUrl(vo.getRetUrl());
		// vZN擾
		java.util.Date calcCurrent = getCalcCurrentYearMonth(); 
		// v_Eyѐݒ擾
		vo.aryPltCoBankCode   = getCoBankArray                ();
		vo.aryPltOutputDetail = PayrollConst.getOutputDetailArray();
		vo.aryPltCodeType     = PayrollConst.getCodeTypeArray    ();
		vo.aryPltRecordType   = PayrollConst.getRecordTypeArray  ();
		vo.aryPltEndRecord    = PayrollConst.getEndRecordArray   ();
		// R}h̏
		if (cmd.equals(CMD_FIRM_BANKING_SHOW)) {
			// Nݒ(vZNݒ)
			setYearMonth(vo, calcCurrent);
			vo.setMode(FirmBankingOutputVo.MODE_SHOW);
			show(vo);
		} else if (cmd.equals(CMD_FIRM_BANKING_SELECT)) {
			vo.setMode(FirmBankingOutputVo.MODE_SELECT);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * \
	 * @param vo
	 * @throws Exception
	 */
	private void show (FirmBankingOutputVo vo) throws Exception {
		// Ж擾
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		// Џݒ
		if (cmCompanyDto != null) {
			vo.setTxtCoAddress  (cmCompanyDto.getCompanyFbAddress());
			vo.setTxtCompanyName(cmCompanyDto.getCompanyFbKana   ());
		}
		// JڑOUIɂo͓eݒ(0:^A1:ܗ^A2:Z)
		vo.setFirmBankOutputType(key1);
		vo.setPltOutputDetail(key1);
		// ݒ
		vo.setPltRecordType(PayrollConst.FB_RECORD_TYPE_NONE);
		vo.setPltEndRecord (PayrollConst.FB_END_RECORD_NONE );
	}
	
	/**
	 * Nݒ
	 * @param vo          ݒΏVO
	 * @param calcCurrent vZ
	 */
	private void setYearMonth(FirmBankingOutputVo vo, Date calcCurrent) {
		// v_E擾
		vo.aryPltSpecifyYear  = util.getYearArray(MospUtility.getYear(calcCurrent));
		vo.aryPltSpecifyMonth = getMonthArray();
		vo.aryPltSpecifyDay   = getDayArray();
		vo.aryPltDeadlineYear = util.getYearArray(MospUtility.getYear(calcCurrent));
		vo.aryPltDeadlineMonth= getMonthArray();
		vo.aryPltDeadlineDay  = getDayArray();
		// vZNݒ
		vo.setPltSpecifyYear (String.valueOf(MospUtility.getYear(calcCurrent )));
		vo.setPltSpecifyMonth(String.valueOf(MospUtility.getMonth(calcCurrent)));
		vo.setPltSpecifyDay  (String.valueOf(MospUtility.getDay(calcCurrent  )));
		// vZNݒ
		vo.setPltDeadlineYear (String.valueOf(MospUtility.getYear(calcCurrent )));
		vo.setPltDeadlineMonth(String.valueOf(MospUtility.getMonth(calcCurrent)));
		vo.setPltDeadlineDay  (String.valueOf(MospUtility.getDay(calcCurrent  )));
	}
	
	/**
	 * vZ擾
	 * @return vZ
	 * @throws Exception
	 */
	private Date getCalcCurrentYearMonth() throws Exception {
		FirmBankingOutputVo vo = (FirmBankingOutputVo)getVo();
		// Ώ۔N擾
		Date targetMonth = vo.getCalcDate();
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		//dao.initDao(cfg, cmd, aspUser, user, conn);
		PtCurrentDto dto = dao.findForKey(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT, targetMonth);
		if (dto != null) {
			return dto.getCalcDate();
		}
		return new Date();
	}

}
