package jp.mosp.payroll.common.action;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.DatePart;
import jp.mosp.human.dto.MKihonDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.AdjustmentAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.common.vo.AdjustmentCalcVo;
import jp.mosp.payroll.dao.AdjustmentDao;
import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dto.AdjustmentDto;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.PtCurrentDto;

public class AdjustmentCalcAction extends AdjustmentAction {

	// R}h
	private static final String CMD_ADJUSTMENT_CALC_SHOW      = "P3001"; /* Q     */
	private static final String CMD_ADJUSTMENT_CALC_SEARCH    = "P3002"; /*      */
	public  static final String CMD_ADJUSTMENT_CALC_RE_SEARCH = "P3003"; /* Č   */
	private static final String CMD_ADJUSTMENT_CALC_SORT      = "P3004"; /* \[g   */
	private static final String CMD_ADJUSTMENT_CALC           = "P3005"; /* vZJn */
	private static final String CMD_ADJUSTMENT_NEXT_YEAR      = "P3006"; /* Nw */
	private static final String CMD_ADJUSTMENT_BACK_YEAR      = "P3007"; /* ONw */
	
	/**
	 * RXgN^
	 */
	public AdjustmentCalcAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		AdjustmentCalcVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof AdjustmentCalcVo) {
			vo = (AdjustmentCalcVo)obj;
		} else {
			vo = new AdjustmentCalcVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(PayrollConst.VO_ADJUSTMENT_CALC, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// R}h̏
		if (cmd.equals(CMD_ADJUSTMENT_CALC_SHOW)) {
			// \
			show(vo);
		} else if (cmd.equals(CMD_ADJUSTMENT_CALC_SEARCH)) {
			// 
			vo.setParams(request);
			serachEmployeeList(vo);
			vo.setFormerKey(vo.KEY_K_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_ADJUSTMENT_CALC_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			if (vo.getList() != null && vo.getList().size() > 0) {
				serachEmployeeList(vo);
				vo.setPageButton();
				sortList(vo);
			} else {
				show(vo);
			}
		} else if (cmd.equals(CMD_ADJUSTMENT_CALC_SORT)) {
			// \[g
			sortList(key1, vo);
		} else if (cmd.equals(CMD_ADJUSTMENT_CALC)) {
			// NvZ
			// p[^擾
			vo.setParams(request);
			// NvZ
			adjust(vo);
		} else if (cmd.equals(CMD_ADJUSTMENT_NEXT_YEAR)) {
			// NNi
			// p[^擾
			vo.setParams(request);
			// NNi
			addAdjustYear(vo, 1);
			// ĕ\
			vo.initFields();
			vo.setHidAdjustYear(getAdjustYear());
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, PayrollConst.MSG_NEXT, PayrollConst.NAM_ADJUST_YEAR));
		} else if (cmd.equals(CMD_ADJUSTMENT_BACK_YEAR)) {
			// NN߂
			// p[^擾
			vo.setParams(request);
			// NN߂
			addAdjustYear(vo, -1);
			// ĕ\
			vo.initFields();
			vo.setHidAdjustYear(getAdjustYear());
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, PayrollConst.MSG_BACK, PayrollConst.NAM_ADJUST_YEAR));
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * \
	 * @param vo ConfirmAttListVoCX^X
	 * @throws Exception
	 */
	private void show(AdjustmentCalcVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		if (vo.aryPltPosition == null) {
			// v_E擾
			vo.aryPltRetirement     = getRetirementFlagArray();
			vo.aryPltPosition       = getPositionArray();
			vo.aryPltAdjustmentType = LegalConst.ADJUSTMENT_ARRAY;
			vo.aryPltMidwayType     = LegalConst.MIDWAY_ENTER_ARRAY;
			vo.aryPltAdjustStatus   = PayrollConst.getAdjuStatusArray();
			vo.aryEra               = getCodeArray(PayrollConst.TID_JAPANESE);
			// aݒ擾
			vo.listConf = getConfList(PayrollConst.CONF_ID_JP_IMP_CAL);
			// ݒ
			vo.setPltRetirement(String.valueOf(PayrollConst.RETIREMENT_FLAG_OFF));
			vo.setPltAdjustmentType(LegalConst.ADJUSTMENT_NEEDED);
		}
		// N擾
		vo.setHidAdjustYear(getAdjustYear());
	}
	
	/**
	 * ЈXg
	 * @param vo AdjustmentCalcVoCX^X
	 * @throws Exception
	 */
	private void serachEmployeeList(AdjustmentCalcVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// N擾
		int adjustYear = getAdjustYear();
		// 
		AdjustmentDao dao = new AdjustmentDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List list = dao.findForCondition(
				adjustYear,
				getLastDateOfYear(adjustYear),
				vo.getTxtKCode         (),
				vo.getTxtKName         (),
				vo.getTxtKKana         (),
				vo.getPltRetirement    (),
				vo.getPltPosition      (),
				vo.getPltAdjustmentType(),
				vo.getPltMidwayType    (),
				vo.getPltAdjustStatus  ()  				
		);
		// VOɐݒ
		vo.setFields(list);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryKCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * NvZ
	 * @param vo     ΏVO
	 * @throws Exception 
	 */
	protected void adjust(
			AdjustmentCalcVo vo
	) throws Exception {
		// vZmF
		boolean isCreateData = true;
		// RlNV̎擾yDAȌ
		getConnection();
		// NNmF
		confirmAdjustYear(vo.getHidAdjustYear());
		// DAO
		prepareDao();
		// ΏۊOf[^폜
		cdAdjustmentDao.deleteAdjustYear(adjustYear, startAdjDate, lastDate);
		// Nf[^쐬ΏێҎ擾
//		List<MKihonDto> listMKihonDto = mKihonDao.findForAdjustData(startAdjDate, lastDate);
		// t
		List<MKihonDto> listMKihonDto =  mKihonPayrollDao.findForSection(
						DatePart.convDateToInteger(lastDate),
						DatePart.convDateToInteger(startAdjDate));
		if (listMKihonDto.size() == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
			return;
		}
		// Ώ۔N
		setTargetData();
		for (int i = 0; i < listMKihonDto.size(); i++) {
			// ЈR[hݒ
			kCode = listMKihonDto.get(i).getKCode();
			// lݒ
			setHumanInfo(vo);
			// ^f[^mF
			setTargetPaymentData();
			// o^DTȌ
			cdAdjustmentDto = cdAdjustmentDao.findForKey(kCode, adjustYear);
			if (cdAdjustmentDto == null) {
				cdAdjustmentDto = new CdAdjustmentDto();
				vo.setDtoFields(cdAdjustmentDto, kCode, adjustYear);
			}
			// NvZΏێҊmF
			if (!confirmAdjustType()) {
				isCreateData = false;
			}
			// L̊mFŃG[ȂЈ͔NvZ
			if (isCreateData) {
				// Ώۃf[^ŌvZ
				calcTargetIncomeTax(true);
				// NɕKvȍڂ̌vZ
				calcNeedAdjust();
				// NvZ
				adjustIncomeTax();
			} else {
				// NɕKvȍڂ̌vZ(ސE҂̎xz擾p)
				calcNeedAdjust();
				// Nf[^͍쐬邪vZΏۊO̎Ј
				setAdjustOotStatus();
			}
			regist();
			// tO
			isCreateData = true;
		}
		// 11^f[^mF
		// Ώێ҂ŁuNv12/31_ōݐEŁA11^̖҂݂邩B
		// NΏێҎ擾
		// 䒠͕KvȂ߁ANf[^͍B1/1`12/31ݐE҂ΏۂɂȂB
		// 12/31_̍ŐVf[^Г擾AΏێ҂B
		// uNv̏ꍇ́A11^K{B
		// mF
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, PayrollConst.MSG_FINISH, PayrollConst.TTL_ADJUSTMENT_CALC));
	}
	
	
	/**
	 * Nf[^o^
	 * @param vo       o^ΏVO
	 * @param storedVo ZbVۑDTO
	 * @throws Exception 
	 */
	private void regist() throws Exception  {
		CdAdjustmentDto currentDto = cdAdjustmentDao.findForKey(kCode, adjustYear);
		// o^DTȌ
		if (currentDto == null) {
			// VKo^
			// f[^̑}
			cdAdjustmentDao.insert(cdAdjustmentDto);
			// R~bg
			commit();
		} else {
			// XVo^
			// f[^̍XV
			cdAdjustmentDao.update(cdAdjustmentDto);
			// R~bg
			commit();
		}
	}
	
	/**
	 * lݒ
	 * @param vo ݒΏVO
	 * @throws Exception 
	 * @throws ClassNotFoundException 
	 */
	private void setHumanInfo(
			AdjustmentCalcVo vo
	) throws Exception {
		// l{擾
		mKihonDto = mKihonPayrollDao.findForKey(kCode);
		if (mKihonDto == null) {
			show(vo);
			String errMessage = MospUtility.getMessage(msg, PayrollConst.MSG_NO_HUMAN_DATA, "");
			addErrMessage(errMessage);
			throw new MospException(PayrollConst.EX_BEFORE_ENTRANCE, errMessage);
		}
		// l^擾
		cmIncomeTaxDto   = cmIncomeTaxDao  .findForEmployeeDate(kCode, lastDate);
		cmMidwayEnterDto = cmMidwayEnterDao.findForKey         (kCode          );
	}
	
	
	/**
	 * NNXV
	 * @param vo     ΏVO
	 * @param amount XVN
	 * @throws MospException 
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 * @throws ClassNotFoundException 
	 */
	protected void addAdjustYear(
			AdjustmentCalcVo vo, int amount
	) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException, ClassNotFoundException {
		PtCurrentDao dao;
		PtCurrentDto dto;
		// RlNV̎擾yDAȌ
		getConnection();
		// NNmF
		confirmAdjustYear(vo.getHidAdjustYear());
		// NNf[^擾
		dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		dto = dao.findForKey(PayrollConst.CURRENT_ADJUST, PayrollConst.CALC_ADJUST, addYear(lastDate, amount));
		if(dto == null){
			dto = new PtCurrentDto();
			// f[^̐ݒ
			dto.setOfficeCode(PayrollConst.CURRENT_ADJUST);
			dto.setCalcType(PayrollConst.CALC_ADJUST);
			dto.setCalcDate(addYear(lastDate, amount));
			dto.setCurrentStatus(PayrollConst.CURRENT_START);
			// f[^̍XV
			dao.insert(dto);
		}else{
			// f[^̐ݒ
			dto.setCurrentStatus(PayrollConst.CURRENT_START);
			// f[^̍XV
			dao.update(dto);
		}
		// R~bg
		//commit();
		dto = dao.findForKey(PayrollConst.CURRENT_ADJUST, PayrollConst.CALC_ADJUST, lastDate);
		if(dto != null){
			// f[^̐ݒ
			if(PayrollConst.CURRENT_END != dto.getCurrentStatus()){
				dto.setCurrentStatus(PayrollConst.CURRENT_BREAK);
				// f[^̍XV
				dao.update(dto);
				// R~bg
				//commit();
			}
		}

		// R~bg
		commit();
	}
	
	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException 
	 */
	private void sortList(String key, AdjustmentCalcVo vo) throws MospException{
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}
	
	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(AdjustmentCalcVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}
	
	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	@SuppressWarnings("unchecked")
	private Comparator<Object> getComparator(String key, AdjustmentCalcVo vo) throws MospException {
		Comparator comp = null;
		if (key.equals(vo.KEY_ADJUST_STATUS)) {
			comp = new CompAdjustStatus();
		} else if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_ENTRANCE)) {
			comp = new CompEntranceDate();
		} else if (key.equals(vo.KEY_RETIREMENT)) {
			comp = new CompRetirementDate();
		} else if (key.equals(vo.KEY_ADJUSTMENT_TYPE)) {
			comp = new CompAdjustmentType();
		} else if (key.equals(vo.KEY_TAX_GAP)) {
			comp = new CompTaxGap();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
		
	/**
	 * NvZԂɂrNX
	 */
	protected static class CompAdjustStatus implements Comparator, Serializable {
		private static final long serialVersionUID = 69327727165636476L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			if (dto1.getAdjustStatus() == null) {
				if (dto2.getAdjustStatus() == null) {
					return 0;
				}
				return -1;
			} else if (dto2.getAdjustStatus() == null) {
				if (dto1.getAdjustStatus() == null) {
					return 0;
				}
				return 1;
			} else {
				return dto1.getAdjustStatus().compareTo(dto2.getAdjustStatus());
			}
		}
	}
	
	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator, Serializable {
		private static final long serialVersionUID = -6394722140439469749L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator, Serializable {
		private static final long serialVersionUID = 4570032874139863533L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			return dto1.getKName().compareTo(dto2.getKName());
		}
	}
	
	/**
	 * ГɂrNX
	 */
	protected static class CompEntranceDate implements Comparator, Serializable {
		private static final long serialVersionUID = -6466289475103366012L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			if (dto1.getEntranceDate() == 0) {
				if (dto2.getEntranceDate() == 0) {
					return 0;
				}
				return -1;
			} else if (dto2.getEntranceDate() == 0) {
				if (dto1.getEntranceDate() == 0) {
					return 0;
				}
				return 1;
			} else {
//				return dto1.getEntranceDate().compareTo(dto2.getEntranceDate());
				return dto1.getEntranceDate() == dto2.getEntranceDate() ? 0:1;
			}
		}
	}
	
	/**
	 * ގГɂrNX
	 */
	protected static class CompRetirementDate implements Comparator, Serializable {
		private static final long serialVersionUID = -592984256197903976L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			if (dto1.getRetirementDate() == 0) {
				if (dto2.getRetirementDate() == 0) {
					return 0;
				}
				return -1;
			} else if (dto2.getRetirementDate() == 0) {
				if (dto1.getRetirementDate() == 0) {
					return 0;
				}
				return 1;
			} else {
//				return dto1.getRetirementDate().compareTo(dto2.getRetirementDate());
				return dto1.getRetirementDate() == dto2.getRetirementDate() ? 0:1;
			}
		}
	}

	/**
	 * NvZԂɂrNX
	 */
	protected static class CompAdjustmentType implements Comparator, Serializable {
		private static final long serialVersionUID = -7043968925070629273L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			if (dto1.getAdjustmentType() == null) {
				if (dto2.getAdjustmentType() == null) {
					return 0;
				}
				return -1;
			} else if (dto2.getAdjustmentType() == null) {
				if (dto1.getAdjustmentType() == null) {
					return 0;
				}
				return 1;
			} else {
				return dto1.getAdjustmentType().compareTo(dto2.getAdjustmentType());
			}
		}
	}
	
	/**
	 * ŊzɂrNX
	 */
	protected static class CompTaxGap implements Comparator, Serializable {
		private static final long serialVersionUID = 5436156253746916682L;
		public int compare(Object obj1, Object obj2) {
			AdjustmentDto dto1 = (AdjustmentDto)obj1;
			AdjustmentDto dto2 = (AdjustmentDto)obj2;
			return dto2.getTaxGap() - dto1.getTaxGap();
		}
	}

	/**
	 * ݐE/ސEXg擾
	 * @return ݐE/ސEXg
	 */
	protected String[][] getRetirementFlagArray() {
		// z̍쐬
		String[][] aryRetirementFlag = new String[3][2];
		aryRetirementFlag[0][0] = "";
		aryRetirementFlag[0][1] = "";
		aryRetirementFlag[1][0] = String.valueOf(PayrollConst.RETIREMENT_FLAG_OFF);
		aryRetirementFlag[1][1] = PayrollConst.NAM_RETIREMENT_OFF;
		aryRetirementFlag[2][0] = String.valueOf(PayrollConst.RETIREMENT_FLAG_ON);
		aryRetirementFlag[2][1] = PayrollConst.NAM_RETIREMENT_ON;
		return aryRetirementFlag;
	}

}
