package jp.mosp.payroll.bonus.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.bonus.action.BonusListAction;
import jp.mosp.payroll.bonus.dto.BonusListDto;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;

public class BonusListVo  extends PayrollVo {

	private static final long serialVersionUID = 3752144327980358655L;
	
	//ʃTu^Cg
	public final String SUB_TITLE = "ܗ^f[^ꗗ";
	public final String CMD_MENU_PAYROLL = "P1910";
	
	// tB[h
	private int      pltYear;
	private int      pltMonth;
	private int      pltDay;
	private String   txtKCode;
	private String   txtKKana;
	private String   pltOffice;
	private String   pltSection;
	private String   pltPosition;
	private String   lblTargetMonth;

	// tB[h(ꗗ)
	private String[] aryKCode;
	private String[] aryKName;
	private String[] aryOffice;
	private String[] arySection;
	private String[] aryPosition;
	private String[] aryPayTotal;

	// v_E
	private String[][] pitYear ;
	private String[][] pitMonth;
	private String[][] pitDay;
	private String[][] pitOffice;
	private String[][] pitSection ;
	private String[][] pitPosition;

	/**
	 * p[^(ܗ^xN)B
	 */
	public static final String PRM_PLT_YEAR = "pltYear";

	/**
	 * p[^(ܗ^x)B
	 */
	public static final String PRM_PLT_MONTH = "pltMonth";

	/**
	 * p[^(ܗ^x)B
	 */
	public static final String PRM_PLT_DAY = "pltDay";

	/**
	 * p[^(ЈR[h)B
	 */
	public static final String PRM_TXT_K_CODE = "txtKCode";

	/**
	 * p[^(ЈJi)B
	 */
	public static final String PRM_TXT_K_KANA = "txtKKana";

	/**
	 * p[^(Ə)B
	 */
	public static final String PRM_PLT_OFFICE = "pltOffice";

	/**
	 * p[^()B
	 */
	public static final String PRM_PLT_SECTION = "pltSection";

	/**
	 * p[^(E)B
	 */
	public static final String PRM_PLT_POSITION = "pltPosition";

	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public BonusListVo() {
		super();
		aryKCode	= new String[0];
		aryKName	= new String[0];
		aryOffice	= new String[0];
		arySection	= new String[0];
		aryPosition	= new String[0];
		aryPayTotal	= new String[0];
		setPageCommand(BonusListAction.CMD_PAGE);
		setSortKey("1");
	}

	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = BonusConst.TTL_BONUS_LIST;
	}


	/**
	 * Tu^Cg擾
	 * @param subTitle Tu^Cg
	 * @param cmdMenu  j[R}h
	 * @return Tu^CgHTML
	 */
	public String getSubTitle(String subTitle, String cmdMenu) {
		StringBuffer sb = new StringBuffer();
		sb.append("<div class=\"Header\">");
		sb.append("<div class=\"MenuButtonBar\">");
		sb.append("<button type=\"button\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append("P2001");
		sb.append("')\">ܗ^vZ</button>");
		sb.append("<button type=\"button\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(cmdMenu);
		sb.append("')\">j[</button>");
		sb.append("<button type=\"button\" id=\"btnLogout\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(MospConst.CMD_LOGOUT);
		sb.append("')\">OAEg</button>");
		sb.append("</div>");
		sb.append("<div class=\"SubTitleBar\">");
		sb.append(subTitle);
		sb.append("</div>");
		sb.append("</div>");
		return sb.toString();
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) throws MospException {
		pltYear     = getIntParam(request.getParameter(PRM_PLT_YEAR));
		pltMonth    = getIntParam(request.getParameter(PRM_PLT_MONTH));
		pltDay      = getIntParam(request.getParameter(PRM_PLT_DAY));
		txtKCode    = request.getParameter(PRM_TXT_K_CODE);
		txtKKana    = request.getParameter(PRM_TXT_K_KANA);
		pltOffice   = request.getParameter(PRM_PLT_OFFICE);
		pltSection  = request.getParameter(PRM_PLT_SECTION);
		pltPosition = request.getParameter(PRM_PLT_POSITION);
	}
	
	/**
	 * tB[hݒ肷B<br>
	 * @param list DTOXg
	 */
	public void setFields(List<BonusListDto> list) {
		// f[^̎擾
		count = list.size();
		// z̏
		aryKCode	= new String[count];
		aryKName	= new String[count];
		aryOffice	= new String[count];
		arySection	= new String[count];
		aryPosition	= new String[count];
		aryPayTotal	= new String[count];
		// f[^̐ݒ
		for (int i = 0; i < list.size(); i++) {
			BonusListDto dto = list.get(i);
			aryKCode	[i] = dto.getKCode();
			aryKName	[i] = dto.getSimei();
			aryOffice	[i] = dto.getOfficeName();
			arySection	[i] = dto.getSectionName();
			aryPosition	[i] = dto.getPositionName();
			aryPayTotal	[i] = String.valueOf(dto.getPaymentTotal());
		}
	}

	/**
	 * ܗ^xN擾B
	 * @return ܗ^xN
	 */
	public int getPltYear() {
		return pltYear;
	}

	/**
	 * ܗ^xNݒ肷B
	 * @param pltYear ݒ肷ܗ^xN
	 */
	public void setPltYear(int pltYear) {
		this.pltYear = pltYear;
	}

	/**
	 * ܗ^x擾B
	 * @return ܗ^x
	 */
	public int getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * ܗ^xݒ肷B
	 * @param pltMonth ݒ肷ܗ^x
	 */
	public void setPltMonth(int pltMonth) {
		this.pltMonth = pltMonth;
	}

	/**
	 * ܗ^x擾B
	 * @return ܗ^x
	 */
	public int getPltDay() {
		return pltDay;
	}
	
	/**
	 * ܗ^xݒ肷B
	 * @param pltMonth ݒ肷ܗ^x
	 */
	public void setPltDay(int pltDay) {
		this.pltDay = pltDay;
	}

	/**
	 * Nv_EACe擾B
	 * @return Nv_EACe
	 */
	public String[][] getPitYear() {
		return getAryField(pitYear);
	}
	
	/**
	 * Nv_EACeݒ肷B
	 * @param pitYear ݒ肷Nv_EACe
	 */
	public void setPitYear(String[][] pitYear) {
		this.pitYear = getAryField(pitYear);
	}

	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitMonth() {
		return getAryField(pitMonth);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitMonth ݒ肷錎v_EACe
	 */
	public void setPitMonth(String[][] pitMonth) {
		this.pitMonth = getAryField(pitMonth);
	}

	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitDay() {
		return getAryField(pitDay);
	}
	
	/**
	 * v_EACeݒ肷B
	 * @param pitMonth ݒ肷錎v_EACe
	 */
	public void setPitDay(String[][] pitDay) {
		this.pitDay = getAryField(pitDay);
	}

	/**
	 * Əv_EACe擾B
	 * @return Əv_EACe
	 */
	public String[][] getPitOffice() {
		return getAryField(pitOffice);
	}
	
	/**
	 * Əv_EACeݒ肷B
	 * @param pitOffice ݒ肷鎖Əv_EACe
	 */
	public void setPitOffice(String[][] pitOffice) {
		this.pitOffice = getAryField(pitOffice);
	}

	/**
	 * Ev_EACe擾B
	 * @return Ev_EACe
	 */
	public String[][] getPitPosition() {
		return getAryField(pitPosition);
	}

	/**
	 * Ev_EACeݒ肷B
	 * @param pitPosition ݒ肷Ev_EACe
	 */
	public void setPitPosition(String[][] pitPosition) {
		this.pitPosition = getAryField(pitPosition);
	}

	/**
	 * v_EACe擾B
	 * @return v_EACe
	 */
	public String[][] getPitSection() {
		return getAryField(pitSection);
	}

	/**
	 * v_EACeݒ肷B
	 * @param pitSection ݒ肷鏊v_EACe
	 */
	public void setPitSection(String[][] pitSection) {
		this.pitSection = getAryField(pitSection);
	}
	
	/**
	 * ƏR[h擾B
	 * @return ƏR[h
	 */
	public String getPltOffice() {
		return pltOffice;
	}
	
	/**
	 * ƏR[hݒ肷B
	 * @param pltOffice ݒ肷鎖ƏR[h
	 */
	public void setPltOffice(String pltOffice) {
		this.pltOffice = pltOffice;
	}

	/**
	 * ER[h擾B
	 * @return ER[h
	 */
	public String getPltPosition() {
		return pltPosition;
	}

	/**
	 * ER[hݒ肷B
	 * @param pltPosition ݒ肷ER[h
	 */
	public void setPltPosition(String pltPosition) {
		this.pltPosition = pltPosition;
	}

	/**
	 * R[h擾B
	 * @return R[h
	 */
	public String getPltSection() {
		return pltSection;
	}

	/**
	 * R[hݒ肷B
	 * @param pltSection ݒ肷鏊R[h
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}

	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getTxtKCode() {
		return txtKCode;
	}

	/**
	 * ЈR[h擾(GXP[v)B
	 * @return ЈR[h
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param txtKCode ݒ肷ЈR[h
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}

	/**
	 * ЈJi擾B
	 * @return ЈJi
	 */
	public String getTxtKKana() {
		return txtKKana;
	}

	/**
	 * ЈJi擾(GXP[v)B
	 * @return ЈJi
	 */
	public String getEscTxtKKana() {
		return escapeHTML(txtKKana);
	}

	/**
	 * ЈJiݒ肷B
	 * @param txtKKana ݒ肷ЈJi
	 */
	public void setTxtKKana(String txtKKana) {
		this.txtKKana = txtKKana;
	}

	/**
	 * Ώ۔N擾B
	 * @return Ώ۔N
	 */
	public String getLblTargetMonth() {
		return lblTargetMonth;
	}

	/**
	 * Ώ۔Nݒ肷B
	 * @param lblTargetMonth ݒ肷Ώ۔N
	 */
	public void setLblTargetMonth(String lblTargetMonth) {
		this.lblTargetMonth = lblTargetMonth;
	}

	/**
	 * ЈR[h(ꗗ)擾B
	 * @param idx CfbNX
	 * @return ЈR[h
	 */
	public String getAryKCode(int idx) {
		return escapeHTML(aryKCode[idx]);
	}

	/**
	 * Ј(ꗗ)擾B
	 * @param idx CfbNX
	 * @return Ј
	 */
	public String getAryKName(int idx) {
		return escapeHTML(aryKName[idx]);
	}

	/**
	 * Ə(ꗗ)擾B
	 * @param idx CfbNX
	 * @return Ə
	 */
	public String getAryOffice(int idx) {
		return escapeHTML(aryOffice[idx]);
	}

	/**
	 * E(ꗗ)擾B
	 * @param idx CfbNX
	 * @return E
	 */
	public String getAryPosition(int idx) {
		return escapeHTML(aryPosition[idx]);
	}

	/**
	 * (ꗗ)擾B
	 * @param idx CfbNX
	 * @return 
	 */
	public String getArySection(int idx) {
		return escapeHTML(arySection[idx]);
	}
	
	/**
	 * xz(ꗗ)擾B
	 * @param idx CfbNX
	 * @return xz
	 */
	public String getAryPayTotal(int idx) {
		return escapeHTML(aryPayTotal[idx]);
	}

}
