package jp.mosp.payroll.bonus.vo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItem;

import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dto.PdBonusDto;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospConst;
public class BonusCalcVo extends PayrollVo {
	
	private static final long serialVersionUID = 3281945937471826907L;
	
	// URLACSS
	private static final String RETURN_URL = "/jsp/payroll/bonus/bonusCalc.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/bonus/js/bonusCalc.js";
	private static final String EXTRA_CSS  = "/pub/payroll/bonus/css/bonusCalc.css";
	
	// ʃTu^Cg
	public final String SUB_TITLE = BonusConst.NAM_BONUS_CALCULATE;
	
	// tB[hyѐ
	public static final String PRM_PLT_YEAR        = "pltYear"    ;
	public static final String PRM_PLT_MONTH       = "pltMonth"   ;
	public static final String PRM_PLT_DAY         = "pltDay"     ;
	public static final String PRM_FIL_PAYMENT     = "filPayment" ;
	public static final String PRM_PLT_STATION_CODE = "pltStationCode"     ;
	
	public static final String PRM_PLT_DETAIL_YEAR  = "pltDetailYear"      ;
	public static final String PRM_PLT_DETAIL_MONTH = "pltDetailMonth"     ;
	public static final String PRM_PLT_DETAIL_DAY = "pltDetailDay"     ;


	
	public static final int    LEN_AMOUNT         = BonusConst.LEN_MONEY_AMOUNT;
	
	public static final String NAM_CSV_AMOUNT     = "z";
	public static final String NAM_CALC_DATE      = "vZN";
	public static final String NAM_CSV_KEY        = "ЈR[h";
	

	public static final String PRM_FIL_UPLOAD_FILE = "filUploadFile";
	
	// tB[h
	private String   pltYear        = "";
	private String   pltMonth       = "";
	private String   pltDay         = "";
	private String   pltStationCode = "";



	private FileItem filUploadFile ;
	
	private int idxKCode    = 0;;
	private int idxCalcDate = 0; ;
	private String kCode     = "";
	private Date calcDate   ;
	private Date payday     ;
	
	// v_EXg
	public String[][] aryPltYear ;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;
	
	private String   pltDetailYear       ;
	private String   pltDetailMonth      ;
	private String   pltDetailDay      ;
	
	// ̎擾pXg
	public String[][] aryPltStationAll;

	
	/**
	 * RXgN^
	 */
	public BonusCalcVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * Tu^Cg擾
	 * @param subTitle Tu^Cg
	 * @param cmdMenu  j[R}h
	 * @return Tu^CgHTML
	 */
	public String getSubTitle(String subTitle, String cmdMenu) {
		StringBuffer sb = new StringBuffer();
		sb.append("<div class=\"Header\">");
		sb.append("<div class=\"MenuButtonBar\">");
		sb.append("<button type=\"button\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(cmdMenu);
		sb.append("')\">j[</button>");
		sb.append("<button type=\"button\" id=\"btnLogout\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(MospConst.CMD_LOGOUT);
		sb.append("')\">OAEg</button>");
		sb.append("</div>");
		sb.append("<div class=\"SubTitleBar\">");
		sb.append(subTitle);
		sb.append("</div>");
		sb.append("</div>");
		return sb.toString();
	}

	

	/**
	 * p[^ݒ
	 * @param list NGXgXg
	 */
	public void setUploadFile(List list)  throws Exception {
		pltYear  = FileUploadUtility.getMultipartField(list,PRM_PLT_YEAR );
		pltMonth = FileUploadUtility.getMultipartField(list,PRM_PLT_MONTH);
		pltDay   = FileUploadUtility.getMultipartField(list,PRM_PLT_DAY);
		pltDetailYear  = FileUploadUtility.getMultipartField(list, PRM_PLT_DETAIL_YEAR );
		pltDetailMonth = FileUploadUtility.getMultipartField(list, PRM_PLT_DETAIL_MONTH);
		pltDetailDay   = FileUploadUtility.getMultipartField(list, PRM_PLT_DETAIL_DAY);
		pltStationCode = FileUploadUtility.getMultipartField(list, PRM_PLT_STATION_CODE);
		filUploadFile = FileUploadUtility.getMultipartFile(list, PRM_FIL_UPLOAD_FILE);

	}
	
	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setYearParams(HttpServletRequest request) {
		pltYear  = request.getParameter(PRM_PLT_YEAR );
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		pltDay   = request.getParameter(PRM_PLT_DAY);
		pltDetailYear  = request.getParameter(PRM_PLT_DETAIL_YEAR );
		pltDetailMonth = request.getParameter(PRM_PLT_DETAIL_MONTH);
		pltDetailDay   = request.getParameter(PRM_PLT_DETAIL_DAY);
		pltStationCode = request.getParameter(PRM_PLT_STATION_CODE);
	}
	
	/**
	 * wb_[NO擾
	 * @throws Exception
	 */
	public String getHeadNo(String code,String[][] aryHeadItem,int idx) throws Exception {
		String retString = "";
		for (int i = 0; i < aryHeadItem.length; i++) {
			if (code.equals(BonusConst.UP_K_CODE)) {
				setIdxKCode(idx);
			}
			if (code.equals(aryHeadItem[i][1])) {
				retString = aryHeadItem[i][0];
				return retString;
			}
		}
		return "";
	}
	
	/**
	 * wb_[f[^Ó`FbN
	 * @throws Exception
	 */
	public boolean checkHeadData(String code,String[][] aryHeadItem) throws Exception {
		for (int i = 0; i < aryHeadItem.length; i++) {
			if (code.equals(aryHeadItem[i][1])) {
				return true;
			}
			if (i != aryHeadItem.length -1) {
				continue;
			}
			return false;
		}
		return true;
	}
	

	
	/**
	 * t̑ÓmF
	 * @throws MospException
	 */
	public boolean checkTargetDate() throws MospException {
		// ÓmFJn
		startValidation();
		checkDate(
				  Integer.parseInt(pltYear )
				, Integer.parseInt(pltMonth)
				, Integer.parseInt(pltDay  )
				, BonusConst.NAM_BONUS_DATE
				, "");
		// ÓmFI
		endValidation();
		return isValid;
	}
	

	/**
	 * csvL[f[^擾
	 * @throws MospException
	 */
	public void setKeyData(String value,int idx) {
		if (idx == getIdxKCode()) {
			setKCode(value);
		}
		
	}
	
	/**
	 * vZNݒ
	 * @throws MospException
	 */
	public void setCalcDate() throws MospException {
		Date calDate = getDate(
				  pltYear
				, pltMonth
				, String.valueOf(BonusConst.TIME_DEFAULT_DAY));
		setCalcDate(calDate);
	}
	
	/**
	 * ܗ^xݒ
	 * @throws MospException
	 */
	public void setPayday() throws MospException {
		Date payday = getDate(
				  pltYear
				, pltMonth
				, pltDay);
		setPayday(payday);
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	/**
	 * xz擾
	 * @param dto
	 */
	public int setAllAllowanceAmount(PdBonusDto dto) {
		int allowanceAmount =
			dto.getBonusAllowance01  ()
		   + dto.getBonusAllowance02 ()
		   + dto.getBonusAllowance03 ()
		   + dto.getBonusAllowance04 ()
		   + dto.getBonusAllowance05 ()
		   + dto.getBonusAllowance06 ()
		   + dto.getBonusAllowance07 ()
		   + dto.getBonusAllowance08 ()
		   + dto.getBonusAllowance09 ()
		   + dto.getBonusAllowance10 ()
		   + dto.getBonusAllowance11 ()
		   + dto.getBonusAllowance12 ()
		   + dto.getBonusAllowance13 ()
		   + dto.getBonusAllowance14 ()
		   + dto.getBonusAllowance15 ()
		   + dto.getBonusAllowance16 ()
		   + dto.getBonusAllowance17 ()
		   + dto.getBonusAllowance18 ()
		   + dto.getBonusAllowance19 ()
		   + dto.getBonusAllowance20 ();
		
		return allowanceAmount;
		
	}

	/**
	 *
	 * @param dto
	 * @return
	 */
	
	@SuppressWarnings("boxing")
	public int[][] setAryBonusData(PdBonusDto dto) {
			ArrayList<Integer> listItem = new ArrayList<Integer>();
			listItem.add(dto.getBonusAllowance01  ());
			listItem.add(dto.getBonusAllowance02  ());
			listItem.add(dto.getBonusAllowance03  ());
			listItem.add(dto.getBonusAllowance04  ());
			listItem.add(dto.getBonusAllowance05  ());
			listItem.add(dto.getBonusAllowance06  ());
			listItem.add(dto.getBonusAllowance07  ());
			listItem.add(dto.getBonusAllowance08  ());
			listItem.add(dto.getBonusAllowance09  ());
			listItem.add(dto.getBonusAllowance10  ());
			listItem.add(dto.getBonusAllowance11  ());
			listItem.add(dto.getBonusAllowance12  ());
			listItem.add(dto.getBonusAllowance13  ());
			listItem.add(dto.getBonusAllowance14  ());
			listItem.add(dto.getBonusAllowance15  ());
			listItem.add(dto.getBonusAllowance16  ());
			listItem.add(dto.getBonusAllowance17  ());
			listItem.add(dto.getBonusAllowance18  ());
			listItem.add(dto.getBonusAllowance19  ());
			listItem.add(dto.getBonusAllowance20  ());


			int[][] aryItem = new int[listItem.size()][2];
			for (int i = 0; i < listItem.size(); i++) {
				aryItem[i][0] = i;
				aryItem[i][1] = listItem.get(i);
			}
		return aryItem;
	}

	// ANZT\bh
	public String getPltYear () { return pltYear       ; }
	public String getPltMonth() { return pltMonth      ; }
	public String getPltDay  () { return pltDay        ; }
	public FileItem getFilUploadFile  () { return filUploadFile ; }
	public int getIdxKCode   () { return idxKCode    ; }
	public int getIdxCalcDate() { return idxCalcDate ; }
	public String getPltDetailYear       () { return pltDetailYear       ; }
	public String getPltDetailMonth      () { return pltDetailMonth      ; }
	public String getPltDetailDay      () { return pltDetailDay      ; }
	public String getPltStationCode      () { return pltStationCode      ; }
	public String getKCode   () { return escapeHTML(kCode     ) ; }
	public Date   getCalcDate() { return getDateField(calcDate) ; }
	public Date   getPayday  () { return getDateField(payday  ) ; }
	public String getEscPltStationCode      () { return escapeHTML(pltStationCode)      ; }
	public void setPltYear    (String pltYear ) { this.pltYear     = pltYear                ; }
	public void setPltMonth   (String pltMonth) { this.pltMonth    = pltMonth               ; }
	public void setPltDay     (String pltDay  ) { this.pltDay      = pltDay                 ; }
	public void setKCode      (String KCode   ) { this.kCode       = KCode                  ; }
	public void setCalcDate   (Date CalcDate  ) { this.calcDate    = getDateField(CalcDate) ; }
	public void setPayday     (Date payday    ) { this.payday      = getDateField(payday  ) ; }
	public void setIdxKCode   (int IdxKcode  )  { this.idxKCode    = IdxKcode               ; }
	public void setIdxCalcDate(int IdxCalcDate) { this.idxCalcDate = IdxCalcDate            ; }
	public void setPltStationCode      (String pltStationCode      ) { this.pltStationCode       = pltStationCode      ; }

	public void setPltDetailYear       (String pltDetailYear       ) { this.pltDetailYear        = pltDetailYear       ; }
	public void setPltDetailMonth      (String pltDetailMonth      ) { this.pltDetailMonth       = pltDetailMonth      ; }
	public void setPltDetailDay      (String pltDetailDay      ) { this.pltDetailDay          = pltDetailDay      ; }

}
