package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class PmBasisDto extends BaseDto {

	private static final long serialVersionUID = 3115468966868261668L;
	
	// tB[h
	private String kCode          ;	// ЈR[h
	private String kName          ;	// Ј
	private String kKana          ;	// Јض
	private String stationCode    ;	// R[h
	private String positionCode   ;	// EʃR[h
	private String employmentType ;	// ٗp敪
	private Date   entranceDate   ;	// Г
	private Date   appointmentDate;	// op
	private Date   retirementDate ;	// ގГ
	
	private String missingInput  ;	// Wv
	private String changing      ;	// ύXe

	
	/**
	 * RXgN^
	 */
	public PmBasisDto(){
		super();
	}
	
	/**
	 * RXgN^
	 */
	public PmBasisDto(PhBasisDto dto) {
		super();
		this.kCode           = dto.getKCode()          ;	// ЈR[h
		this.kName           = dto.getKName()          ;	// Ј
		this.kKana           = dto.getKKana()          ;	// Јض
		this.stationCode     = dto.getStationCode()    ;	// R[h
		this.positionCode    = dto.getPositionCode()   ;	// EʃR[h
		this.employmentType  = dto.getEmploymentType() ;	// ٗp敪
		this.entranceDate    = dto.getEntranceDate()   ;	// Г
		this.appointmentDate = dto.getAppointmentDate();	// op
		this.retirementDate  = dto.getRetirementDate() ;	// ގГ
	}

	// ANZT\bh
	public String getKCode          () { return kCode                        ; }	// ЈR[h
	public String getKName          () { return kName                        ; }	// Ј
	public String getKKana          () { return kKana                        ; }	// Јض
	public String getStationCode    () { return stationCode                  ; }	// R[h
	public String getPositionCode   () { return positionCode                 ; }	// EʃR[h
	public String getEmploymentType () { return employmentType               ; }	// ٗp敪
	public Date   getEntranceDate   () { return getDateField(entranceDate   ); }	// Г
	public Date   getAppointmentDate() { return getDateField(appointmentDate); }	// op
	public Date   getRetirementDate () { return getDateField(retirementDate ); }	// ގГ
	public void setKCode          (String kCode          ) { this.kCode           = kCode                        ; }	// ЈR[h
	public void setKName          (String kName          ) { this.kName           = kName                        ; }	// Ј
	public void setKKana          (String kKana          ) { this.kKana           = kKana                        ; }	// Јض
	public void setStationCode    (String stationCode    ) { this.stationCode     = stationCode                  ; }	// R[h
	public void setPositionCode   (String positionCode   ) { this.positionCode    = positionCode                 ; }	// EʃR[h
	public void setEmploymentType (String employmentType ) { this.employmentType  = employmentType               ; }	// ٗp`
	public void setEntranceDate   (Date   entranceDate   ) { this.entranceDate    = getDateField(entranceDate   ); }	// Г
	public void setAppointmentDate(Date   appointmentDate) { this.appointmentDate = getDateField(appointmentDate); }	// op
	public void setRetirementDate (Date   retirementDate ) { this.retirementDate  = getDateField(retirementDate ); }	// ގГ
	
	public String getMissingInput() { return missingInput; }
	public void setMissingInput(String missingInput) { this.missingInput = missingInput; }
	public String getChanging() { return changing; }	// ύXe
	public void setChanging(String changing) { this.changing = changing; }	// ύXe

}
