package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PsAvailableStaDto;
import jp.mosp.common.common.MospException;

public class PsAvailableStaDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "US_AVAILABLE_STA";
	public static final String KEY_1 = "K_CODE"      ;	// ЈR[h
	public static final String KEY_2 = "STATION_CODE";	// R[h
	
	// 
	public static final String COL_K_CODE           = "K_CODE"          ;	// ЈR[h
	public static final String COL_STATION_CODE     = "STATION_CODE"    ;	// R[h
	
	/**
	 * RXgN^
	 */
	public PsAvailableStaDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PsAvailableStaDto> mappingAll() throws SQLException {
		List<PsAvailableStaDto> all = new ArrayList<PsAvailableStaDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PsAvailableStaDto UsAvailableStaR[h
	 * @throws SQLException
	 */
	private PsAvailableStaDto mapping() throws SQLException {
		PsAvailableStaDto dto = new PsAvailableStaDto();
		dto.setKCode          (rs.getString(COL_K_CODE          ));	// ЈR[h
		dto.setStationCode    (rs.getString(COL_STATION_CODE    ));	// R[h
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PsAvailableStaDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PsAvailableStaDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PsAvailableStaDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PsAvailableStaDto findForKey(
			String  kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			PsAvailableStaDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return PsAvailableStaDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PsAvailableStaDto findForUpdate(
			String kCode
			) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			PsAvailableStaDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(gp)
	 * @param kCode ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PsAvailableStaDto> findForConditaion(
			String kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_STATION_CODE + " IN (");
		sb.append(PmStationDao.getBelongedStationQuery());
		sb.append(") ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// UM_BASIS
			setParam(index++, kCode);
			// s
			executeQuery();
			List<PsAvailableStaDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(ЈR[hA)
	 * @param kCode ЈR[h
	 * @param stationCode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PsAvailableStaDto> findForKCodeStation(
			String kCode,
			String stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		if (!kCode.equals("") || !stationCode.equals("")) {
			sb.append("WHERE ");
		}
		if (!kCode.equals("")) {
			sb.append(COL_K_CODE);
			sb.append(" LIKE ? AND ");
		}
		if (!stationCode.equals("")) {
			sb.append(COL_STATION_CODE);
			sb.append(" =? AND ");
		}
		if (sb.length() != 0) {
			sb.delete(sb.length() - 4, sb.length());
			sb.append(" ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (!kCode.equals("")) {
				setParam(index++, kCode + "%");
			}
			if (!stationCode.equals("")) {
				setParam(index++, stationCode);				
			}
			// s
			executeQuery();
			List<PsAvailableStaDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}		
	}
	
	/**
	 * ɂf[^擾(ЈR[hAЈA)
	 * @param kCode ЈR[h
	 * @param kName Ј
	 * @param stationCode R[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<PsAvailableStaDto> findForKNameStation(
			String kCode,
			String kName,
			String stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " IN");
			sb.append("(");
			sb.append(PmBasisDao.getSelectForSubQuery());
			sb.append(") ");
		if (stationCode != null && !stationCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_STATION_CODE);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode+ "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%");
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);				
			}
			// s
			executeQuery();
			List<PsAvailableStaDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}		
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param stationCode R[h(L[)
	 * @return PsAvailableStaDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PsAvailableStaDto findForKey1Key2(
			String  kCode,
			String  stationCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" =? AND ");
			sb.append(COL_STATION_CODE);
			sb.append(" =? ");
			prepareStatement(getSelectQuery(getClass())+ sb.toString());
			setParam(index++, kCode);
			setParam(index++, stationCode);
			executeQuery();
			PsAvailableStaDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^݃`FbN
	 * @param  targetMode ݊mF[h
	 * @param  targetCode `FbNR[h(L[)
	 * @return UmBasisDto (DTO)
	 * @throws SQLException
	 */
	public int findForExist(
			String   kCode ,
			String   stationCode
	) throws SQLException {
		int count = 0;
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT COUNT(*) FROM " + TABLE );
		sb.append(" WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" =? AND ");
		sb.append(COL_STATION_CODE);
		sb.append(" =? ");
		try {
			index = 1;
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setParam(index++, stationCode);
			executeQuery();
			rs.next();
			count = rs.getInt(1);
		return 	count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
		
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PsAvailableStaDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PsAvailableStaDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PsAvailableStaDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getStationCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PsAvailableStaDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode          ());	// ЈR[h
		setParam(index++, dto.getStationCode    ());	// R[h
		setCommonParams(isInsert);
	}
	
	/**
	 * p\R[h擾SQL
	 * @return p\R[h擾SQL
	 */
	public static final String getAvailableStationQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_STATION_CODE + " ");
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = ? ");
		return sb.toString();
	}
}