package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PmExtraDto;
import jp.mosp.common.common.MospException;

public class PmExtraDao extends PayrollDao {
	
	// e[uyуL[
	public static final String TABLE = "UM_EXTRA";
	public static final String KEY_1 = "K_CODE";	// ЈR[h
	
	// 
	public static final String COL_K_CODE            = "K_CODE"           ;	// ЈR[h
	public static final String COL_GENDER            = "GENDER"           ;	// 
	public static final String COL_BIRTH_DATE        = "BIRTH_DATE"       ;	// N
	public static final String COL_FORMER_NAME       = "FORMER_NAME"      ;	// 
	public static final String COL_POSTAL_CODE       = "POSTAL_CODE"      ;	// X֔ԍ
	public static final String COL_ADDRESS           = "ADDRESS"          ;	// Z
	public static final String COL_FORMER_ADDRESS    = "FORMER_ADDRESS"   ;	// Z
	public static final String COL_PHONE_NUMBER      = "PHONE_NUMBER"     ;	// dbԍ
	public static final String COL_CELLPHONE_NUMBER  = "CELLPHONE_NUMBER" ;	// gєԍ
	public static final String COL_EMERGENCY_NUMBER  = "EMERGENCY_NUMBER" ;	// ً}ԍ
	public static final String COL_APPOINTMENT_DATE  = "APPOINTMENT_DATE" ;	// Јop
	public static final String COL_RETIRE_MONEY_DATE = "RETIRE_MONEY_DATE";	// ސENZ
	public static final String COL_EXTRA_DATE_1      = "EXTRA_DATE_1"     ;	// ǉt1
	public static final String COL_EXTRA_ITEM_1      = "EXTRA_ITEM_1"     ;	// ǉ1
	
	/**
	 * RXgN^
	 */
	public PmExtraDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PmExtraDto> mappingAll() throws SQLException {
		List<PmExtraDto> all = new ArrayList<PmExtraDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PmExtraDto UmBasisR[h
	 * @throws SQLException
	 */
	private PmExtraDto mapping() throws SQLException {
		PmExtraDto dto = new PmExtraDto();
		dto.setKCode          (rs.getString(COL_K_CODE           ));	// ЈR[h
		dto.setGender         (rs.getString(COL_GENDER           ));	// 
		dto.setBirthDate      (rs.getDate  (COL_BIRTH_DATE       ));	// N
		dto.setFormerName     (rs.getString(COL_FORMER_NAME      ));	// 
		dto.setPostalCode     (rs.getString(COL_POSTAL_CODE      ));	// X֔ԍ
		dto.setAddress        (rs.getString(COL_ADDRESS          ));	// Z
		dto.setFormerAddress  (rs.getString(COL_FORMER_ADDRESS   ));	// Z
		dto.setPhoneNumber    (rs.getString(COL_PHONE_NUMBER     ));	// dbԍ
		dto.setCellphoneNumber(rs.getString(COL_CELLPHONE_NUMBER ));	// gєԍ
		dto.setEmergencyNumber(rs.getString(COL_EMERGENCY_NUMBER ));	// ً}ԍ
		dto.setAppointmentDate(rs.getDate  (COL_APPOINTMENT_DATE ));	// Јop
		dto.setRetireMoneyDate(rs.getDate  (COL_RETIRE_MONEY_DATE));	// ސENZ
		dto.setExtraDate1     (rs.getDate  (COL_EXTRA_DATE_1     ));	// ǉt1
		dto.setExtraItem1     (rs.getString(COL_EXTRA_ITEM_1     ));	// ǉ1
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String, PmExtraDto> mappingAllMap() throws SQLException {
		Map<String, PmExtraDto> all = new HashMap<String, PmExtraDto>();
		while (rs.next()) {
			PmExtraDto dto = mapping();
			all.put(dto.getKCode(), dto);
		}
		return all;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmExtraDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PmExtraDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PmExtraDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmExtraDto findForKey(
			String  kCode
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			PmExtraDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾(lo͗p)
	 * @return Map (DTOMap)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public Map<String, PmExtraDto> findForHumanData()
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		try {
			prepareStatement(getSelectQuery(getClass()));
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return PmExtraDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmExtraDto findForUpdate(
			String kCode
			) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			PmExtraDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PmExtraDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PmExtraDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PmExtraDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PmExtraDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode          ());	// ЈR[h
		setParam(index++, dto.getGender         ());	// 
		setParam(index++, dto.getBirthDate      ());	// N
		setParam(index++, dto.getFormerName     ());	// 
		setParam(index++, dto.getPostalCode     ());	// X֔ԍ
		setParam(index++, dto.getAddress        ());	// Z
		setParam(index++, dto.getFormerAddress  ());	// Z
		setParam(index++, dto.getPhoneNumber    ());	// dbԍ
		setParam(index++, dto.getCellphoneNumber());	// gєԍ
		setParam(index++, dto.getEmergencyNumber());	// ً}ԍ
		setParam(index++, dto.getAppointmentDate());	// Јop
		setParam(index++, dto.getRetireMoneyDate());	// ސENZ
		setParam(index++, dto.getExtraDate1     ());	// ǉt1
		setParam(index++, dto.getExtraItem1     ());	// ǉ1
		setCommonParams(isInsert);
	}

}
